/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestIndexHints
extends TestDb {
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("indexhints");
        this.createDb();
        this.testQuotedIdentifier();
        this.testWithSingleIndexName();
        this.testWithEmptyIndexHintsList();
        this.testWithInvalidIndexName();
        this.testWithMultipleIndexNames();
        this.testPlanSqlHasIndexesInCorrectOrder();
        this.testWithTableAlias();
        this.testWithTableAliasCalledUse();
        this.conn.close();
        this.deleteDb("indexhints");
    }

    private void createDb() throws SQLException {
        this.conn = this.getConnection("indexhints");
        Statement stat = this.conn.createStatement();
        stat.execute("create table test (x int, y int)");
        stat.execute("create index idx1 on test (x)");
        stat.execute("create index idx2 on test (x, y)");
        stat.execute("create index \"Idx3\" on test (y, x)");
    }

    private void testQuotedIdentifier() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("explain analyze select * from test use index(\"Idx3\") where x=1 and y=1");
        this.assertTrue(rs.next());
        String plan = rs.getString(1);
        rs.close();
        this.assertTrue(plan.contains("/* PUBLIC.Idx3:"));
        this.assertTrue(plan.contains("USE INDEX (\"Idx3\")"));
        rs = stat.executeQuery("EXPLAIN ANALYZE " + plan);
        this.assertTrue(rs.next());
        plan = rs.getString(1);
        this.assertTrue(plan.contains("/* PUBLIC.Idx3:"));
        this.assertTrue(plan.contains("USE INDEX (\"Idx3\")"));
    }

    private void testWithSingleIndexName() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("explain analyze select * from test use index(idx1) where x=1 and y=1");
        rs.next();
        String result = rs.getString(1);
        this.assertTrue(result.contains("/* PUBLIC.IDX1:"));
    }

    private void testWithTableAlias() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("explain analyze select * from test t use index(idx2) where x=1 and y=1");
        rs.next();
        String result = rs.getString(1);
        this.assertTrue(result.contains("/* PUBLIC.IDX2:"));
    }

    private void testWithTableAliasCalledUse() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.executeQuery("explain analyze select * from test use where use.x=1 and use.y=1");
    }

    private void testWithMultipleIndexNames() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("explain analyze select * from test use index(idx1, idx2) where x=1 and y=1");
        rs.next();
        String result = rs.getString(1);
        this.assertTrue(result.contains("/* PUBLIC.IDX2:"));
    }

    private void testPlanSqlHasIndexesInCorrectOrder() throws SQLException {
        ResultSet rs = this.conn.createStatement().executeQuery("explain analyze select * from test use index(idx1, idx2) where x=1 and y=1");
        rs.next();
        this.assertTrue(rs.getString(1).contains("USE INDEX (\"IDX1\", \"IDX2\")"));
        ResultSet rs2 = this.conn.createStatement().executeQuery("explain analyze select * from test use index(idx2, idx1) where x=1 and y=1");
        rs2.next();
        this.assertTrue(rs2.getString(1).contains("USE INDEX (\"IDX2\", \"IDX1\")"));
    }

    private void testWithEmptyIndexHintsList() throws SQLException {
        Statement stat = this.conn.createStatement();
        ResultSet rs = stat.executeQuery("explain analyze select * from test use index () where x=1 and y=1");
        rs.next();
        String result = rs.getString(1);
        this.assertTrue(result.contains("/* PUBLIC.TEST.tableScan"));
    }

    private void testWithInvalidIndexName() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertThrows(42112, stat).executeQuery("explain analyze select * from test use index(idx_doesnt_exist) where x=1 and y=1");
    }
}

