/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestListener
extends TestDb
implements DatabaseEventListener {
    private long last;
    private int lastState = -1;
    private String databaseUrl;

    public TestListener() {
        this.start = this.last = System.nanoTime();
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked && this.config.cipher == null;
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("listener");
        Connection conn = this.getConnection("listener");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Test' || SPACE(100))");
        int len = this.getSize(100, 100000);
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
        this.crash(conn);
        conn = this.getConnection("listener;database_event_listener='" + this.getClass().getName() + "'");
        conn.close();
        this.deleteDb("listener");
    }

    @Override
    public void exceptionThrown(SQLException e, String sql) {
        TestBase.logError("exceptionThrown sql=" + sql, e);
    }

    @Override
    public void setProgress(int state, String name, long current, long max) {
        Object stateName;
        long time = System.nanoTime();
        if (state == this.lastState && time < this.last + TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        if (state == 5 || state == 6 || state == 7) {
            return;
        }
        if (((String)name).length() > 30) {
            name = "..." + ((String)name).substring(((String)name).length() - 30);
        }
        this.last = time;
        this.lastState = state;
        switch (state) {
            case 0: {
                stateName = "Scan " + (String)name;
                break;
            }
            case 1: {
                stateName = "Create Index " + (String)name;
                break;
            }
            case 2: {
                stateName = "Recover";
                break;
            }
            default: {
                TestBase.logError("unknown state: " + state, null);
                stateName = "? " + (String)name;
            }
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.printTime("state: " + (String)stateName + " " + 100L * current / max + " " + TimeUnit.NANOSECONDS.toMillis(time - this.start));
    }

    @Override
    public void closingDatabase() {
        if (this.databaseUrl.toUpperCase().contains("CIPHER")) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = DriverManager.getConnection(this.databaseUrl, this.getUser(), this.getPassword());){
                conn.createStatement().execute("DROP TABLE TEST2");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init(String url) {
        this.databaseUrl = url;
    }

    @Override
    public void opened() {
        if (this.databaseUrl.toUpperCase().contains("CIPHER")) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = DriverManager.getConnection(this.databaseUrl, this.getUser(), this.getPassword());){
                conn.createStatement().execute("CREATE TABLE IF NOT EXISTS TEST2(ID INT)");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

