/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Utils;

public class TestMemoryUsage
extends TestDb {
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testOpenCloseConnections();
        if (this.getBaseDir().indexOf(58) >= 0) {
            return;
        }
        this.testCreateIndex();
        this.testClob();
        this.testReconnectOften();
        this.deleteDb("memoryUsage");
        this.reconnect();
        this.insertUpdateSelectDelete();
        this.reconnect();
        this.insertUpdateSelectDelete();
        this.conn.close();
        this.deleteDb("memoryUsage");
    }

    private void testOpenCloseConnections() throws SQLException {
        if (!this.config.big) {
            return;
        }
        this.deleteDb("memoryUsage");
        this.conn = this.getConnection("memoryUsage;WRITE_DELAY=0");
        try {
            this.eatMemory(4000);
            int i = 0;
            while (i < 4000) {
                Connection c2 = this.getConnection("memoryUsage");
                c2.createStatement();
                c2.close();
                ++i;
            }
        }
        finally {
            this.freeMemory();
            TestMemoryUsage.closeConnection(this.conn);
        }
    }

    private void testCreateDropLoop() throws SQLException {
        this.deleteDb("memoryUsageCreateDropLoop");
        this.conn = this.getConnection("memoryUsageCreateDropLoop");
        Statement stat = this.conn.createStatement();
        int i = 0;
        while (i < 100) {
            stat.execute("CREATE TABLE TEST(ID INT)");
            stat.execute("DROP TABLE TEST");
            ++i;
        }
        stat.execute("checkpoint");
        long used = Utils.getMemoryUsed();
        int i2 = 0;
        while (i2 < 1000) {
            stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
            stat.execute("DROP TABLE TEST");
            ++i2;
        }
        stat.execute("checkpoint");
        long usedNow = Utils.getMemoryUsed();
        if ((double)usedNow > (double)used * 1.3) {
            int i3 = 1024;
            while (i3 < 0) {
                try {
                    byte[] oome = new byte[0x10000000];
                    oome[0] = (byte)i3;
                }
                catch (OutOfMemoryError e) {
                    break;
                }
                i3 *= 2;
            }
            usedNow = Utils.getMemoryUsed();
            if ((double)usedNow > (double)used * 1.3) {
                this.assertEquals(used, usedNow);
            }
        }
        this.conn.close();
    }

    private void reconnect() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = this.getConnection("memoryUsage");
    }

    private void testClob() throws SQLException {
        if (this.config.memory || !this.config.big) {
            return;
        }
        this.deleteDb("memoryUsageClob");
        this.conn = this.getConnection("memoryUsageClob;WRITE_DELAY=0");
        Statement stat = this.conn.createStatement();
        stat.execute("SET MAX_LENGTH_INPLACE_LOB 8192");
        stat.execute("SET CACHE_SIZE 8000");
        stat.execute("CREATE TABLE TEST(ID IDENTITY, DATA CLOB)");
        try {
            long base = Utils.getMemoryUsed();
            int i = 0;
            while (i < 4) {
                stat.execute("INSERT INTO TEST(DATA) SELECT SPACE(8000) FROM SYSTEM_RANGE(1, 800)");
                long used = Utils.getMemoryUsed();
                if (used - base > 24576L) {
                    this.fail("Used: " + (used - base) + " i: " + i);
                }
                ++i;
            }
        }
        finally {
            this.freeMemory();
            TestMemoryUsage.closeConnection(this.conn);
        }
    }

    private static void closeConnection(Connection conn) throws SQLException {
        block2: {
            try {
                conn.close();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 90108) break block2;
                throw e;
            }
        }
    }

    private void testCreateIndex() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("memoryUsage");
        this.conn = this.getConnection("memoryUsage");
        Statement stat = this.conn.createStatement();
        stat.execute("create table test(id int, name varchar(255))");
        PreparedStatement prep = this.conn.prepareStatement("insert into test values(?, space(200))");
        int len = this.getSize(10000, 100000);
        int i = 0;
        while (i < len) {
            int cfr_ignored_0 = i % 1000;
            prep.setInt(1, i);
            prep.executeUpdate();
            ++i;
        }
        long base = Utils.getMemoryUsed();
        stat.execute("create index idx_test_id on test(id)");
        int i2 = 0;
        while (true) {
            System.gc();
            long used = Utils.getMemoryUsed() - base;
            if (used <= (long)this.getSize(7500, 12000)) break;
            if (i2 >= 16) {
                this.fail("Used: " + used);
            }
            ++i2;
        }
        stat.execute("drop table test");
        this.conn.close();
    }

    private void testReconnectOften() throws SQLException {
        this.deleteDb("memoryUsage");
        Connection conn1 = this.getConnection("memoryUsage");
        int len = this.getSize(1, 2000);
        this.printTimeMemory("start", 0L);
        long time = System.nanoTime();
        int i = 0;
        while (i < len) {
            Connection conn2 = this.getConnection("memoryUsage");
            conn2.close();
            if (i % 10000 == 0) {
                this.printTimeMemory("connect", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
            }
            ++i;
        }
        this.printTimeMemory("connect", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        conn1.close();
    }

    private void insertUpdateSelectDelete() throws SQLException {
        Statement stat = this.conn.createStatement();
        int len = this.getSize(1, 2000);
        long time = System.nanoTime();
        stat.execute("DROP TABLE IF EXISTS TEST");
        this.trace("drop=" + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        stat.execute("CREATE CACHED TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Hello World')");
        this.printTimeMemory("start", 0L);
        time = System.nanoTime();
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.execute();
            if (i % 50000 == 0) {
                this.trace("  " + 100 * i / len + "%");
            }
            ++i;
        }
        this.printTimeMemory("insert", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        time = System.nanoTime();
        prep = this.conn.prepareStatement("UPDATE TEST SET NAME='Hallo Welt' || ID WHERE ID = ?");
        i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.execute();
            if (i % 50000 == 0) {
                this.trace("  " + 100 * i / len + "%");
            }
            ++i;
        }
        this.printTimeMemory("update", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        time = System.nanoTime();
        prep = this.conn.prepareStatement("SELECT * FROM TEST WHERE ID = ?");
        i = 0;
        while (i < len) {
            prep.setInt(1, i);
            ResultSet rs = prep.executeQuery();
            rs.next();
            this.assertFalse(rs.next());
            if (i % 50000 == 0) {
                this.trace("  " + 100 * i / len + "%");
            }
            ++i;
        }
        this.printTimeMemory("select", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        Random random = new Random(1L);
        time = System.nanoTime();
        prep = this.conn.prepareStatement("SELECT * FROM TEST WHERE ID = ?");
        int i2 = 0;
        while (i2 < len) {
            prep.setInt(1, random.nextInt(len));
            ResultSet rs = prep.executeQuery();
            rs.next();
            this.assertFalse(rs.next());
            if (i2 % 50000 == 0) {
                this.trace("  " + 100 * i2 / len + "%");
            }
            ++i2;
        }
        this.printTimeMemory("select randomized", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        time = System.nanoTime();
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE ID = ?");
        i2 = 0;
        while (i2 < len) {
            prep.setInt(1, random.nextInt(len));
            prep.executeUpdate();
            if (i2 % 50000 == 0) {
                this.trace("  " + 100 * i2 / len + "%");
            }
            ++i2;
        }
        this.printTimeMemory("delete", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
    }
}

