/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.Trigger;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMergeUsing
extends TestDb
implements Trigger {
    private static final String GATHER_ORDERED_RESULTS_SQL = "SELECT ID, NAME FROM PARENT ORDER BY ID ASC";
    private static int triggerTestingUpdateCount;
    private String triggerName;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws Exception {
        this.testMergeUsing("CREATE TABLE PARENT(ID INT, NAME VARCHAR, PRIMARY KEY(ID) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) ) AS S ON (P.ID = S.ID AND 1=1 AND S.ID = P.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME WHERE 2 = 2 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2)", 2);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) ) AS S ON (P.ID = S.ID AND 1=1 AND S.ID = P.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID WHERE 1 = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(1,2)", 2);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) ) AS S ON (P.ID = S.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID WHERE 1 = 2", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2)", 0);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) ) AS S ON (P.ID = S.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(1,2)", 2);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) ) AS S ON (P.ID = S.ID) WHEN MATCHED THEN DELETE", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) WHERE 1=0", 2);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3) ) AS S ON (P.ID = S.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID WHERE P.ID = 2 WHEN MATCHED THEN DELETE WHERE P.ID = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(2,2) UNION ALL SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(3,3)", 3);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );CREATE TABLE SOURCE AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3)  );", "MERGE INTO PARENT AS P USING SOURCE AS S ON (P.ID = S.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID WHERE P.ID = 2 WHEN MATCHED THEN DELETE WHERE P.ID = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(2,2) UNION ALL SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(3,3)", 3);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );CREATE TABLE SOURCE AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3)  );", "MERGE INTO PARENT AS P USING SOURCE ON (P.ID = SOURCE.ID) WHEN MATCHED THEN UPDATE SET P.NAME = SOURCE.NAME||SOURCE.ID WHERE P.ID = 2 WHEN MATCHED THEN DELETE WHERE P.ID = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (SOURCE.ID, SOURCE.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(2,2) UNION ALL SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(3,3)", 3);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2) );CREATE TABLE SOURCE AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3)  );", "MERGE INTO PARENT USING SOURCE ON (PARENT.ID = SOURCE.ID) WHEN MATCHED THEN UPDATE SET PARENT.NAME = SOURCE.NAME||SOURCE.ID WHERE PARENT.ID = 2 WHEN MATCHED THEN DELETE WHERE PARENT.ID = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (SOURCE.ID, SOURCE.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X||X AS NAME FROM SYSTEM_RANGE(2,2) UNION ALL SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(3,3)", 3);
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,1) );DELETE FROM PARENT;", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3) ) AS S ON (P.ID = S.ID) WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3)", 3);
        this.testMergeUsingException("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,1) );DELETE FROM PARENT;", "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3) ) AS S ON (P.ID = S.ID)", GATHER_ORDERED_RESULTS_SQL, "SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,3) WHERE X<0", 0, "WHEN\"");
        triggerTestingUpdateCount = 0;
        this.testMergeUsing("CREATE TABLE PARENT AS (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,2));" + this.getCreateTriggerSQL(), "MERGE INTO PARENT AS P USING (SELECT X AS ID, 'Marcy'||X AS NAME FROM SYSTEM_RANGE(1,4) ) AS S ON (P.ID = S.ID) WHEN MATCHED THEN UPDATE SET P.NAME = S.NAME||S.ID WHERE P.ID = 2 WHEN MATCHED THEN DELETE WHERE P.ID = 1 WHEN NOT MATCHED THEN INSERT (ID, NAME) VALUES (S.ID, S.NAME)", GATHER_ORDERED_RESULTS_SQL, "SELECT 2 AS ID, 'Marcy22-updated2' AS NAME UNION ALL SELECT X AS ID, 'Marcy'||X||'-inserted'||X AS NAME FROM SYSTEM_RANGE(3,4)", 4);
        this.testDataChangeDeltaTable();
    }

    private void testMergeUsing(String setupSQL, String statementUnderTest, String gatherResultsSQL, String expectedResultsSQL, int expectedRowUpdateCount) throws Exception {
        this.deleteDb("mergeUsingQueries");
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Connection conn = this.getConnection("mergeUsingQueries;MODE=Oracle");){
                Statement stat = conn.createStatement();
                stat.execute(setupSQL);
                PreparedStatement prep = conn.prepareStatement(statementUnderTest);
                int rowCountUpdate = prep.executeUpdate();
                ResultSet rs = stat.executeQuery("( " + gatherResultsSQL + " ) MINUS ( " + expectedResultsSQL + " )");
                int rowCount = 0;
                StringBuilder diffBuffer = new StringBuilder("");
                while (rs.next()) {
                    ++rowCount;
                    diffBuffer.append("|");
                    int i = 1;
                    while (i <= rs.getMetaData().getColumnCount()) {
                        diffBuffer.append(rs.getObject(i));
                        diffBuffer.append("|\n");
                        ++i;
                    }
                }
                this.assertEquals("Differences between expected and actual output found:" + String.valueOf(diffBuffer), 0, rowCount);
                this.assertEquals("Expected update counts differ", expectedRowUpdateCount, rowCountUpdate);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("mergeUsingQueries");
        }
    }

    private void testMergeUsingException(String setupSQL, String statementUnderTest, String gatherResultsSQL, String expectedResultsSQL, int expectedRowUpdateCount, String exceptionMessage) throws Exception {
        try {
            this.testMergeUsing(setupSQL, statementUnderTest, gatherResultsSQL, expectedResultsSQL, expectedRowUpdateCount);
        }
        catch (RuntimeException | SQLException e) {
            if (!e.getMessage().contains(exceptionMessage)) {
                e.printStackTrace();
            }
            this.assertContains(e.getMessage(), exceptionMessage);
            return;
        }
        this.fail("Failed to see exception with message:" + exceptionMessage);
    }

    @Override
    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        if (conn == null) {
            throw new AssertionError((Object)"connection is null");
        }
        if (this.triggerName.startsWith("INS_BEFORE")) {
            newRow[1] = String.valueOf(newRow[1]) + "-inserted" + ++triggerTestingUpdateCount;
        } else if (this.triggerName.startsWith("UPD_BEFORE")) {
            newRow[1] = String.valueOf(newRow[1]) + "-updated" + ++triggerTestingUpdateCount;
        } else if (this.triggerName.startsWith("DEL_BEFORE")) {
            oldRow[1] = String.valueOf(oldRow[1]) + "-deleted" + ++triggerTestingUpdateCount;
        }
    }

    @Override
    public void init(Connection conn, String schemaName, String trigger, String tableName, boolean before, int type) {
        this.triggerName = trigger;
        if (!"PARENT".equals(tableName)) {
            throw new AssertionError((Object)"supposed to be PARENT");
        }
        if (trigger.endsWith("AFTER") && before || trigger.endsWith("BEFORE") && !before) {
            throw new AssertionError((Object)("triggerName: " + trigger + " before:" + before));
        }
        if (trigger.startsWith("UPD") && type != 2 || trigger.startsWith("INS") && type != 1 || trigger.startsWith("DEL") && type != 4) {
            throw new AssertionError((Object)("triggerName: " + trigger + " type:" + type));
        }
    }

    private String getCreateTriggerSQL() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TRIGGER INS_BEFORE BEFORE INSERT ON PARENT FOR EACH ROW NOWAIT CALL \"" + this.getClass().getName() + "\";");
        buf.append("CREATE TRIGGER UPD_BEFORE BEFORE UPDATE ON PARENT FOR EACH ROW NOWAIT CALL \"" + this.getClass().getName() + "\";");
        buf.append("CREATE TRIGGER DEL_BEFORE BEFORE DELETE ON PARENT FOR EACH ROW NOWAIT CALL \"" + this.getClass().getName() + "\";");
        return buf.toString();
    }

    private void testDataChangeDeltaTable() throws SQLException {
        this.deleteDb("mergeUsingQueries");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection conn = this.getConnection("mergeUsingQueries");){
                Statement stat = conn.createStatement();
                stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, C INTEGER) AS (VALUES (1, 2), (2, 3), (3, 4))");
                PreparedStatement prep = conn.prepareStatement("SELECT TEST.ID FROM FINAL TABLE ( MERGE INTO TEST USING ( SELECT T.ID, T.C FROM (SELECT 1, 3) T(ID, C) ) T ON TEST.ID = T.ID WHEN MATCHED AND TEST.ID = 1 THEN UPDATE SET C = T.C WHEN NOT MATCHED THEN INSERT(ID, C) VALUES (T.ID, T.C) ) TEST");
                ResultSet rs = prep.executeQuery();
                rs.next();
                this.assertEquals(1L, rs.getLong(1));
                rs = prep.executeQuery();
                rs.next();
                this.assertEquals(1L, rs.getLong(1));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("mergeUsingQueries");
        }
    }
}

