/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.MultiDimension;

public class TestMultiDimension
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testHelperMethods();
        this.testPerformance2d();
        this.testPerformance3d();
    }

    private void testHelperMethods() {
        int y;
        int x;
        MultiDimension m = MultiDimension.getInstance();
        this.assertEquals(Integer.MAX_VALUE, m.getMaxValue(2));
        this.assertEquals(0, m.normalize(2, 0.0, 0.0, 100.0));
        this.assertEquals(0x3FFFFFFF, m.normalize(2, 50.0, 0.0, 100.0));
        this.assertEquals(Integer.MAX_VALUE, m.normalize(2, 100.0, 0.0, 100.0));
        this.assertEquals(0xCCCCCCC, m.normalize(2, 0.1, 0.0, 1.0));
        this.assertEquals(0, m.normalize(2, 1.0, 1.0, 1.0));
        this.assertEquals(0, m.normalize(2, 0.0, 0.0, 0.0));
        this.assertEquals(3L, m.interleave(1, 1));
        this.assertEquals(3L, m.interleave(new int[]{1, 1}));
        this.assertEquals(5L, m.interleave(3, 0));
        int[] nArray = new int[2];
        nArray[0] = 3;
        this.assertEquals(5L, m.interleave(nArray));
        this.assertEquals(10L, m.interleave(0, 3));
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        this.assertEquals(10L, m.interleave(nArray2));
        long v = 0x3FFFFFFFFFFFFFFFL;
        this.assertEquals(v, m.interleave(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.assertEquals(v, m.interleave(new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE}));
        Random random = new Random(1L);
        int i = 0;
        while (i < 1000) {
            x = random.nextInt(Integer.MAX_VALUE);
            y = random.nextInt(Integer.MAX_VALUE);
            v = m.interleave(new int[]{x, y});
            long v2 = m.interleave(x, y);
            this.assertEquals(v, v2);
            int x1 = m.deinterleave(2, v, 0);
            int y1 = m.deinterleave(2, v, 1);
            this.assertEquals(x, x1);
            this.assertEquals(y, y1);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            x = random.nextInt(1000);
            y = random.nextInt(1000);
            int z = random.nextInt(1000);
            MultiDimension tool = MultiDimension.getInstance();
            long xyz = tool.interleave(x, y, z);
            this.assertEquals(x, tool.deinterleave(3, xyz, 0));
            this.assertEquals(y, tool.deinterleave(3, xyz, 1));
            this.assertEquals(z, tool.deinterleave(3, xyz, 2));
            ++i;
        }
        this.assertThrows(IllegalArgumentException.class, () -> m.getMaxValue(1));
        this.assertThrows(IllegalArgumentException.class, () -> m.getMaxValue(33));
        this.assertThrows(IllegalArgumentException.class, () -> m.normalize(2, 10.0, 11.0, 12.0));
        this.assertThrows(IllegalArgumentException.class, () -> m.normalize(2, 5.0, 10.0, 0.0));
        this.assertThrows(IllegalArgumentException.class, () -> m.normalize(2, 10.0, 0.0, 9.0));
        this.assertThrows(IllegalArgumentException.class, () -> m.interleave(-1, 5));
        this.assertThrows(IllegalArgumentException.class, () -> m.interleave(5, -1));
        this.assertThrows(IllegalArgumentException.class, () -> m.interleave(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    private void testPerformance2d() throws SQLException {
        this.deleteDb("multiDimension");
        Connection conn = this.getConnection("multiDimension");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS MAP FOR '" + this.getClass().getName() + ".interleave'");
        stat.execute("CREATE TABLE TEST(X INT NOT NULL, Y INT NOT NULL, XY BIGINT AS MAP(X, Y), DATA VARCHAR)");
        stat.execute("CREATE INDEX IDX_X ON TEST(X, Y)");
        stat.execute("CREATE INDEX IDX_XY ON TEST(XY)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(X, Y, DATA) VALUES(?, ?, ?)");
        int max = this.getSize(30, 65);
        long time = System.nanoTime();
        int x = 0;
        while (x < max) {
            int y = 0;
            while (y < max) {
                long t2 = System.nanoTime();
                if (t2 - time > TimeUnit.SECONDS.toNanos(1L)) {
                    int percent = (int)(100.0 * ((double)x * (double)max + (double)y) / ((double)max * (double)max));
                    this.trace(percent + "%");
                    time = t2;
                }
                prep.setInt(1, x);
                prep.setInt(2, y);
                prep.setString(3, "Test data");
                prep.execute();
                ++y;
            }
            ++x;
        }
        stat.execute("ANALYZE SAMPLE_SIZE 10000");
        PreparedStatement prepRegular = conn.prepareStatement("SELECT * FROM TEST WHERE X BETWEEN ? AND ? AND Y BETWEEN ? AND ? ORDER BY X, Y");
        MultiDimension multi = MultiDimension.getInstance();
        Object sql = multi.generatePreparedQuery("TEST", "XY", new String[]{"X", "Y"});
        sql = (String)sql + " ORDER BY X, Y";
        PreparedStatement prepMulti = conn.prepareStatement((String)sql);
        long timeMulti = 0L;
        long timeRegular = 0L;
        int timeMax = this.getSize(500, 2000);
        Random rand = new Random(1L);
        while (timeMulti < (long)timeMax) {
            int size = rand.nextInt(max / 10);
            int minX = rand.nextInt(max - size);
            int minY = rand.nextInt(max - size);
            int maxX = minX + size;
            int maxY = minY + size;
            time = System.nanoTime();
            ResultSet rs1 = multi.getResult(prepMulti, new int[]{minX, minY}, new int[]{maxX, maxY});
            timeMulti += System.nanoTime() - time;
            time = System.nanoTime();
            prepRegular.setInt(1, minX);
            prepRegular.setInt(2, maxX);
            prepRegular.setInt(3, minY);
            prepRegular.setInt(4, maxY);
            ResultSet rs2 = prepRegular.executeQuery();
            timeRegular += System.nanoTime() - time;
            while (rs1.next()) {
                this.assertTrue(rs2.next());
                this.assertEquals(rs1.getInt(1), rs2.getInt(1));
                this.assertEquals(rs1.getInt(2), rs2.getInt(2));
            }
            this.assertFalse(rs2.next());
        }
        conn.close();
        this.deleteDb("multiDimension");
        this.trace("2d: regular: " + TimeUnit.NANOSECONDS.toMillis(timeRegular) + " MultiDimension: " + TimeUnit.NANOSECONDS.toMillis(timeMulti));
    }

    private void testPerformance3d() throws SQLException {
        this.deleteDb("multiDimension");
        Connection conn = this.getConnection("multiDimension");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS MAP FOR '" + this.getClass().getName() + ".interleave'");
        stat.execute("CREATE TABLE TEST(X INT NOT NULL, Y INT NOT NULL, Z INT NOT NULL, XYZ BIGINT AS MAP(X, Y, Z), DATA VARCHAR)");
        stat.execute("CREATE INDEX IDX_X ON TEST(X, Y, Z)");
        stat.execute("CREATE INDEX IDX_XYZ ON TEST(XYZ)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(X, Y, Z, DATA) VALUES(?, ?, ?, ?)");
        int max = this.getSize(10, 20);
        long time = System.nanoTime();
        int x = 0;
        while (x < max) {
            int y = 0;
            while (y < max) {
                int z = 0;
                while (z < max) {
                    long t2 = System.nanoTime();
                    if (t2 - time > TimeUnit.SECONDS.toNanos(1L)) {
                        int percent = (int)(100.0 * ((double)x * (double)max + (double)y) / ((double)max * (double)max));
                        this.trace(percent + "%");
                        time = t2;
                    }
                    prep.setInt(1, x);
                    prep.setInt(2, y);
                    prep.setInt(3, z);
                    prep.setString(4, "Test data");
                    prep.execute();
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        stat.execute("ANALYZE SAMPLE_SIZE 10000");
        PreparedStatement prepRegular = conn.prepareStatement("SELECT * FROM TEST WHERE X BETWEEN ? AND ? AND Y BETWEEN ? AND ? AND Z BETWEEN ? AND ? ORDER BY X, Y, Z");
        MultiDimension multi = MultiDimension.getInstance();
        Object sql = multi.generatePreparedQuery("TEST", "XYZ", new String[]{"X", "Y", "Z"});
        sql = (String)sql + " ORDER BY X, Y, Z";
        PreparedStatement prepMulti = conn.prepareStatement((String)sql);
        long timeMulti = 0L;
        long timeRegular = 0L;
        int timeMax = this.getSize(500, 2000);
        Random rand = new Random(1L);
        while (timeMulti < (long)timeMax) {
            int size = rand.nextInt(max / 10);
            int minX = rand.nextInt(max - size);
            int minY = rand.nextInt(max - size);
            int minZ = rand.nextInt(max - size);
            int maxX = minX + size;
            int maxY = minY + size;
            int maxZ = minZ + size;
            time = System.nanoTime();
            ResultSet rs1 = multi.getResult(prepMulti, new int[]{minX, minY, minZ}, new int[]{maxX, maxY, maxZ});
            timeMulti += System.nanoTime() - time;
            time = System.nanoTime();
            prepRegular.setInt(1, minX);
            prepRegular.setInt(2, maxX);
            prepRegular.setInt(3, minY);
            prepRegular.setInt(4, maxY);
            prepRegular.setInt(5, minZ);
            prepRegular.setInt(6, maxZ);
            ResultSet rs2 = prepRegular.executeQuery();
            timeRegular += System.nanoTime() - time;
            while (rs1.next()) {
                this.assertTrue(rs2.next());
                this.assertEquals(rs1.getInt(1), rs2.getInt(1));
                this.assertEquals(rs1.getInt(2), rs2.getInt(2));
            }
            this.assertFalse(rs2.next());
        }
        conn.close();
        this.deleteDb("multiDimension");
        this.trace("3d: regular: " + TimeUnit.NANOSECONDS.toMillis(timeRegular) + " MultiDimension: " + TimeUnit.NANOSECONDS.toMillis(timeMulti));
    }

    public static long interleave(int x, int y) {
        return MultiDimension.getInstance().interleave(x, y);
    }

    public static long interleave(int x, int y, int z) {
        return MultiDimension.getInstance().interleave(x, y, z);
    }
}

