/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.IOUtils;
import org.h2.util.Task;

public class TestMultiThread
extends TestDb
implements Runnable {
    private boolean stop;
    private TestMultiThread parent;
    private Random random;

    public TestMultiThread() {
    }

    private TestMultiThread(TestAll config, TestMultiThread parent) {
        this.config = config;
        this.parent = parent;
        this.random = new Random();
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testConcurrentSchemaChange();
        this.testConcurrentLobAdd();
        this.testConcurrentAlter();
        this.testConcurrentInsertUpdateSelect();
        this.testViews();
        this.testConcurrentInsert();
        this.testConcurrentUpdate();
        this.testConcurrentUpdate2();
        this.testCheckConstraint();
    }

    private void testConcurrentSchemaChange() throws Exception {
        String db = this.getTestName();
        this.deleteDb(db);
        final String url = this.getURL(db + ";LOCK_TIMEOUT=10000", true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection conn = this.getConnection(url);){
            Task[] tasks = new Task[2];
            int i = 0;
            while (i < tasks.length) {
                Task t;
                final int x = i;
                tasks[i] = t = new Task(){

                    @Override
                    public void call() throws Exception {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (Connection c2 = TestMultiThread.this.getConnection(url);){
                            Statement stat = c2.createStatement();
                            int i = 0;
                            while (!this.stop) {
                                stat.execute("create table test" + x + "_" + i);
                                c2.getMetaData().getTables(null, null, null, null);
                                stat.execute("drop table test" + x + "_" + i);
                                ++i;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                };
                t.execute();
                ++i;
            }
            Thread.sleep(1000L);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                t.get();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentLobAdd() throws Exception {
        String db = this.getTestName();
        this.deleteDb(db);
        final String url = this.getURL(db, true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Connection conn = this.getConnection(url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id identity, data clob)");
            Task[] tasks = new Task[2];
            int i = 0;
            while (i < tasks.length) {
                Task t;
                tasks[i] = t = new Task(){

                    @Override
                    public void call() throws Exception {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (Connection c2 = TestMultiThread.this.getConnection(url);){
                            PreparedStatement p2 = c2.prepareStatement("insert into test(data) values(?)");
                            while (!this.stop) {
                                p2.setCharacterStream(1, new StringReader(new String(new char[10240])));
                                p2.execute();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                };
                t.execute();
                ++i;
            }
            Thread.sleep(500L);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                t.get();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentAlter() throws Exception {
        this.deleteDb(this.getTestName());
        Throwable throwable = null;
        Object var2_3 = null;
        try (final Connection conn = this.getConnection(this.getTestName());){
            Statement stat = conn.createStatement();
            Task t = new Task(){

                @Override
                public void call() throws Exception {
                    while (!this.stop) {
                        conn.prepareStatement("select * from test");
                    }
                }
            };
            stat.execute("create table test(id int)");
            t.execute();
            int i = 0;
            while (i < 200) {
                stat.execute("alter table test add column x int");
                stat.execute("alter table test drop column x");
                ++i;
            }
            t.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentInsertUpdateSelect() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
            int len = this.getSize(10, 200);
            Thread[] threads = new Thread[len];
            int i = 0;
            while (i < len) {
                threads[i] = new Thread(new TestMultiThread(this.config, this));
                ++i;
            }
            i = 0;
            while (i < len) {
                threads[i].start();
                ++i;
            }
            int sleep = this.getSize(400, 10000);
            Thread.sleep(sleep);
            this.stop = true;
            int i2 = 0;
            while (i2 < len) {
                threads[i2].join();
                ++i2;
            }
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM TEST");
            rs.next();
            this.trace("max id=" + rs.getInt(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection("jdbc:h2:mem:" + this.getTestName());
    }

    @Override
    public void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = this.getConnection();){
                Statement stmt = conn.createStatement();
                while (!this.parent.stop) {
                    stmt.execute("SELECT COUNT(*) FROM TEST");
                    stmt.execute("INSERT INTO TEST(NAME) VALUES('Hi')");
                    PreparedStatement prep = conn.prepareStatement("UPDATE TEST SET NAME='Hello' WHERE ID=?");
                    prep.setInt(1, this.random.nextInt(10000));
                    prep.execute();
                    prep = conn.prepareStatement("SELECT * FROM TEST WHERE ID=?");
                    prep.setInt(1, this.random.nextInt(10000));
                    ResultSet rs = prep.executeQuery();
                    while (rs.next()) {
                        rs.getString("NAME");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            TestMultiThread.logError("multi", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testViews() throws Exception {
        this.deleteDb("lockMode");
        String url = this.getURL("lockMode", true);
        ExecutorService executor = Executors.newFixedThreadPool(8);
        Connection conn = this.getConnection(url);
        try {
            void var6_7;
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE INVOICE(INVOICE_ID INT PRIMARY KEY, AMOUNT DECIMAL)");
            stat.execute("CREATE VIEW INVOICE_VIEW as SELECT * FROM INVOICE");
            stat.execute("CREATE TABLE INVOICE_DETAIL(DETAIL_ID INT PRIMARY KEY, INVOICE_ID INT, DESCRIPTION VARCHAR)");
            stat.execute("CREATE VIEW INVOICE_DETAIL_VIEW as SELECT * FROM INVOICE_DETAIL");
            stat.close();
            ArrayList<Future<Void>> jobs = new ArrayList<Future<Void>>();
            boolean bl = false;
            while (var6_7 < 1000) {
                void j = var6_7++;
                jobs.add(executor.submit(() -> this.lambda$0(url, (int)j)));
            }
            for (Future future : jobs) {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() instanceof SQLException && ((SQLException)ex.getCause()).getErrorCode() == 50200) continue;
                    throw ex;
                }
            }
        }
        finally {
            IOUtils.closeSilently(conn);
            executor.shutdown();
            executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        this.deleteDb("lockMode");
    }

    /*
     * WARNING - void declaration
     */
    private void testConcurrentInsert() throws Exception {
        this.deleteDb("lockMode");
        String url = this.getURL("lockMode;LOCK_TIMEOUT=10000", true);
        int threadCount = 25;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        Connection conn = this.getConnection(url);
        try {
            void var7_10;
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS TRAN (ID NUMBER(18,0) not null PRIMARY KEY)");
            ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
            int i = 0;
            while (i < threadCount) {
                long l = (long)i * 1000000L;
                callables.add(() -> {
                    Throwable throwable = null;
                    Object var5_5 = null;
                    try (Connection taskConn = this.getConnection(url);){
                        taskConn.setAutoCommit(false);
                        PreparedStatement insertTranStmt = taskConn.prepareStatement("INSERT INTO tran (id) VALUES(?)");
                        long tranId = initialTransactionId;
                        int j = 0;
                        while (j < 1000) {
                            insertTranStmt.setLong(1, tranId++);
                            insertTranStmt.execute();
                            taskConn.commit();
                            ++j;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    return null;
                });
                ++i;
            }
            ArrayList jobs = new ArrayList();
            boolean bl = false;
            while (var7_10 < threadCount) {
                jobs.add(executor.submit((Callable)callables.get((int)var7_10)));
                ++var7_10;
            }
            for (Future future : jobs) {
                future.get(5L, TimeUnit.MINUTES);
            }
        }
        finally {
            IOUtils.closeSilently(conn);
            executor.shutdown();
            executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        this.deleteDb("lockMode");
    }

    /*
     * WARNING - void declaration
     */
    private void testConcurrentUpdate() throws Exception {
        this.deleteDb("lockMode");
        int objectCount = 10000;
        String url = this.getURL("lockMode;LOCK_TIMEOUT=10000", true);
        int threadCount = 25;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        Connection conn = this.getConnection(url);
        try {
            void var9_12;
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS ACCOUNT(ID NUMBER(18,0) not null PRIMARY KEY, BALANCE NUMBER null)");
            PreparedStatement mergeAcctStmt = conn.prepareStatement("MERGE INTO Account(id, balance) key (id) VALUES (?, ?)");
            int i = 0;
            while (i < 10000) {
                mergeAcctStmt.setLong(1, i);
                mergeAcctStmt.setBigDecimal(2, BigDecimal.ZERO);
                mergeAcctStmt.execute();
                ++i;
            }
            ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
            int i2 = 0;
            while (i2 < threadCount) {
                callables.add(() -> {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (Connection taskConn = this.getConnection(url);){
                        taskConn.setAutoCommit(false);
                        PreparedStatement updateAcctStmt = taskConn.prepareStatement("UPDATE account SET balance = ? WHERE id = ?");
                        int j = 0;
                        while (j < 1000) {
                            updateAcctStmt.setDouble(1, Math.random());
                            updateAcctStmt.setLong(2, (int)(Math.random() * 10000.0));
                            updateAcctStmt.execute();
                            taskConn.commit();
                            ++j;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    return null;
                });
                ++i2;
            }
            ArrayList jobs = new ArrayList();
            boolean bl = false;
            while (var9_12 < threadCount) {
                jobs.add(executor.submit((Callable)callables.get((int)var9_12)));
                ++var9_12;
            }
            for (Future future : jobs) {
                future.get(5L, TimeUnit.MINUTES);
            }
        }
        finally {
            IOUtils.closeSilently(conn);
            executor.shutdown();
            executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        this.deleteDb("lockMode");
    }

    private void testConcurrentUpdate2() throws Exception {
        this.deleteDb("concurrentUpdate2");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection c = this.getConnection("concurrentUpdate2");){
                Statement s = c.createStatement();
                s.execute("CREATE TABLE TEST(A INT, B INT, V INT, PRIMARY KEY(A, B))");
                PreparedStatement ps = c.prepareStatement("INSERT INTO TEST VALUES (?, ?, ?)");
                int i = 0;
                while (i < 16) {
                    int j = 0;
                    while (j < 16) {
                        ps.setInt(1, i);
                        ps.setInt(2, j);
                        ps.setInt(3, 0);
                        ps.executeUpdate();
                        ++j;
                    }
                    ++i;
                }
                ConcurrentUpdate2 a = new ConcurrentUpdate2("A");
                ConcurrentUpdate2 b = new ConcurrentUpdate2("B");
                a.start();
                b.start();
                a.join();
                b.join();
                Throwable e = a.exception;
                if (e == null) {
                    e = b.exception;
                }
                if (e != null) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw (Error)e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("concurrentUpdate2");
        }
    }

    private void testCheckConstraint() throws Exception {
        this.deleteDb("checkConstraint");
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Connection c = this.getConnection("checkConstraint;LOCK_TIMEOUT=10000");){
                Statement s = c.createStatement();
                s.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, A INT, B INT)");
                PreparedStatement ps = c.prepareStatement("INSERT INTO TEST VALUES (?, ?, ?)");
                s.execute("ALTER TABLE TEST ADD CONSTRAINT CHECK_A_B CHECK A = B");
                int numRows = 10;
                int i = 0;
                while (i < 10) {
                    ps.setInt(1, i);
                    ps.setInt(2, 0);
                    ps.setInt(3, 0);
                    ps.executeUpdate();
                    ++i;
                }
                int numThreads = 4;
                Thread[] threads = new Thread[numThreads];
                final AtomicBoolean error = new AtomicBoolean();
                int i2 = 0;
                while (i2 < numThreads) {
                    threads[i2] = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Throwable throwable = null;
                                Object var2_4 = null;
                                try (Connection c = TestMultiThread.this.getConnection("checkConstraint;LOCK_TIMEOUT=10000");){
                                    PreparedStatement ps = c.prepareStatement("UPDATE TEST SET A = ?, B = ? WHERE ID = ?");
                                    Random r = new Random();
                                    int i = 0;
                                    while (i < 1000) {
                                        int v = r.nextInt(1000);
                                        ps.setInt(1, v);
                                        ps.setInt(2, v);
                                        ps.setInt(3, r.nextInt(10));
                                        ps.executeUpdate();
                                        ++i;
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (SQLException e) {
                                error.set(true);
                                TestMultiThread testMultiThread = TestMultiThread.this;
                                synchronized (testMultiThread) {
                                    TestMultiThread.logError("Error in CHECK constraint", e);
                                }
                            }
                        }
                    };
                    ++i2;
                }
                i2 = 0;
                while (i2 < numThreads) {
                    threads[i2].start();
                    ++i2;
                }
                i2 = 0;
                while (i2 < numThreads) {
                    threads[i2].join();
                    ++i2;
                }
                this.assertFalse(error.get());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.deleteDb("checkConstraint");
        }
    }

    private final class ConcurrentUpdate2
    extends Thread {
        private final String column;
        Throwable exception;

        ConcurrentUpdate2(String column) {
            this.column = column;
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Connection c = TestMultiThread.this.getConnection("concurrentUpdate2;LOCK_TIMEOUT=10000");){
                    PreparedStatement ps = c.prepareStatement("UPDATE TEST SET V = ? WHERE " + this.column + " = ?");
                    int test = 0;
                    while (test < 1000) {
                        int i = 0;
                        while (i < 16) {
                            ps.setInt(1, test);
                            ps.setInt(2, i);
                            TestMultiThread.this.assertEquals(16, ps.executeUpdate());
                            ++i;
                        }
                        ++test;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }
    }
}

