/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.JdbcUtils;
import org.h2.util.Task;

public class TestMultiThreadedKernel
extends TestDb {
    volatile boolean stop;
    Exception exception;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("multiThreadedKernel");
        this.testConcurrentRead();
        this.testCache();
        this.deleteDb("multiThreadedKernel");
        final String url = this.getURL("multiThreadedKernel;DB_CLOSE_DELAY=-1", true);
        final String user = this.getUser();
        final String password = this.getPassword();
        int len = 3;
        Thread[] threads = new Thread[len];
        int i = 0;
        while (i < len) {
            threads[i] = new Thread(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Connection conn = null;
                    try {
                        try {
                            int j = 0;
                            while (j < 100) {
                                if (TestMultiThreadedKernel.this.stop) {
                                    return;
                                }
                                conn = DriverManager.getConnection(url, user, password);
                                this.work(conn);
                                ++j;
                            }
                            return;
                        }
                        catch (Exception e) {
                            TestMultiThreadedKernel.this.exception = e;
                            JdbcUtils.closeSilently(conn);
                            return;
                        }
                    }
                    finally {
                        JdbcUtils.closeSilently(conn);
                    }
                }

                private void work(Connection conn) throws SQLException {
                    Statement stat = conn.createStatement();
                    stat.execute("create local temporary table temp(id identity)");
                    stat.execute("insert into temp values(1)");
                    conn.close();
                }
            });
            ++i;
        }
        i = 0;
        while (i < len) {
            threads[i].start();
            ++i;
        }
        Thread.sleep(1000L);
        this.stop = true;
        i = 0;
        while (i < len) {
            threads[i].join();
            ++i;
        }
        Connection conn = DriverManager.getConnection(url, user, password);
        conn.createStatement().execute("shutdown");
        conn.close();
        if (this.exception != null) {
            throw this.exception;
        }
        this.deleteDb("multiThreadedKernel");
    }

    /*
     * WARNING - void declaration
     */
    private void testConcurrentRead() throws Exception {
        void var6_10;
        void var6_7;
        int size = 2;
        int count = 1000;
        ArrayList<2> list = new ArrayList<2>(size);
        Connection[] connections = new Connection[1000];
        String url = this.getURL("multiThreadedKernel;CACHE_SIZE=16", true);
        boolean bl = false;
        while (var6_7 < size) {
            Connection conn;
            connections[var6_7] = conn = DriverManager.getConnection(url, this.getUser(), this.getPassword());
            if (var6_7 == false) {
                Statement stat = conn.createStatement();
                stat.execute("drop table test if exists");
                stat.execute("create table test(id int primary key, name varchar) as select x, x || space(10) from system_range(1, 1000)");
            }
            final Random random = new Random((long)var6_7);
            Task t = new Task(){

                @Override
                public void call() throws Exception {
                    PreparedStatement prep = conn.prepareStatement("select * from test where id = ?");
                    while (!this.stop) {
                        prep.setInt(1, random.nextInt(1000));
                        prep.execute();
                    }
                }
            };
            t.execute();
            list.add(t);
            ++var6_7;
        }
        Thread.sleep(1000L);
        for (Task task : list) {
            task.get();
        }
        boolean bl2 = false;
        while (var6_10 < size) {
            connections[var6_10].close();
            ++var6_10;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testCache() throws Exception {
        void var6_10;
        void var6_7;
        int size = 3;
        int count = 100;
        ArrayList<3> list = new ArrayList<3>(size);
        Connection[] connections = new Connection[100];
        String url = this.getURL("multiThreadedKernel;CACHE_SIZE=1", true);
        boolean bl = false;
        while (var6_7 < size) {
            Connection conn;
            connections[var6_7] = conn = DriverManager.getConnection(url, this.getUser(), this.getPassword());
            if (var6_7 == false) {
                Statement stat = conn.createStatement();
                stat.execute("drop table test if exists");
                stat.execute("create table test(id int primary key, name varchar) as select x, space(3000) from system_range(1, 100)");
            }
            final Random random = new Random((long)var6_7);
            Task t = new Task(){

                @Override
                public void call() throws SQLException {
                    PreparedStatement prep = conn.prepareStatement("select * from test where id = ?");
                    while (!this.stop) {
                        prep.setInt(1, random.nextInt(100));
                        prep.execute();
                    }
                }
            };
            t.execute();
            list.add(t);
            ++var6_7;
        }
        Thread.sleep(1000L);
        for (Task task : list) {
            task.get();
        }
        boolean bl2 = false;
        while (var6_10 < size) {
            connections[var6_10].close();
            ++var6_10;
        }
    }

    @Override
    protected String getURL(String name, boolean admin) {
        return super.getURL(name + ";LOCK_TIMEOUT=2000", admin);
    }
}

