/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Restore;
import org.h2.util.Task;

public class TestOpenClose
extends TestDb {
    private int nextId = 10;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testErrorMessageLocked();
        this.testErrorMessageWrongSplit();
        this.testCloseDelay();
        this.testBackup();
        this.testCase();
        this.testReconnectFast();
        this.test1_1();
        this.deleteDb("openClose");
    }

    private void testErrorMessageLocked() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("openClose");
        Connection conn = this.getConnection("jdbc:h2:" + this.getBaseDir() + "/openClose;FILE_LOCK=FS");
        this.assertThrows(90020, () -> this.getConnection("jdbc:h2:" + this.getBaseDir() + "/openClose;FILE_LOCK=FS;OPEN_NEW=TRUE"));
        conn.close();
    }

    private void testErrorMessageWrongSplit() throws Exception {
        if (this.config.memory || this.config.reopen) {
            return;
        }
        String fn = this.getBaseDir() + "/openClose2.mv.db";
        FileUtils.delete("split:" + fn);
        String url = this.getURL("jdbc:h2:split:18:" + this.getBaseDir() + "/openClose2", true);
        Connection conn = DriverManager.getConnection(url);
        conn.createStatement().execute("create table test(id int, name varchar) as select 1, space(1000000)");
        conn.close();
        FileChannel c = FileUtils.open(fn + ".1.part", "rw");
        c.position(c.size() * 2L - 1L);
        c.write(ByteBuffer.wrap(new byte[1]));
        c.close();
        this.assertThrows(90028, () -> this.getConnection(url));
        FileUtils.delete("split:" + fn);
    }

    private void testCloseDelay() throws Exception {
        this.deleteDb("openClose");
        String url = this.getURL("openClose;DB_CLOSE_DELAY=1", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection conn = DriverManager.getConnection(url, user, password);
        conn.close();
        Thread.sleep(950L);
        long time = System.nanoTime();
        while (System.nanoTime() - time < TimeUnit.MILLISECONDS.toNanos(100L)) {
            conn = DriverManager.getConnection(url, user, password);
            conn.close();
        }
        conn = DriverManager.getConnection(url, user, password);
        conn.createStatement().execute("SHUTDOWN");
        conn.close();
    }

    private void testBackup() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("openClose");
        String url = this.getURL("openClose", true);
        Driver.load();
        Connection conn = DriverManager.getConnection(url, "sa", "abc def");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(C CLOB)");
        stat.execute("INSERT INTO TEST VALUES(SPACE(10000))");
        stat.execute("BACKUP TO '" + this.getBaseDir() + "/test.zip'");
        conn.close();
        this.deleteDb("openClose");
        Restore.execute(this.getBaseDir() + "/test.zip", this.getBaseDir(), null);
        conn = DriverManager.getConnection(url, "sa", "abc def");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals(10000, rs.getString(1).length());
        this.assertFalse(rs.next());
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/test.zip");
    }

    private void testReconnectFast() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("openClose");
        String user = this.getUser();
        String password = this.getPassword();
        String url = this.getURL("openClose;DATABASE_EVENT_LISTENER='" + MyDatabaseEventListener.class.getName() + "'", true);
        Connection conn = DriverManager.getConnection(url, user, password);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        stat.execute("SET MAX_MEMORY_UNDO 100000");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        stat.execute("INSERT INTO TEST SELECT X, X || ' Data' FROM SYSTEM_RANGE(1, 1000)");
        stat.close();
        conn.close();
        conn = DriverManager.getConnection(url, user, password);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM SYSTEM_RANGE(1, 1)");
        if (rs.next()) {
            rs.getString(1);
        }
        rs.close();
        stat.close();
        conn.close();
        conn = DriverManager.getConnection(url, user, password);
        stat = conn.createStatement();
        stat.executeUpdate("SHUTDOWN");
        stat.close();
        conn.close();
    }

    private void testCase() throws Exception {
        if (this.config.memory) {
            return;
        }
        Driver.load();
        this.deleteDb("openClose");
        final String url = this.getURL("openClose;FILE_LOCK=NO", true);
        final String user = this.getUser();
        final String password = this.getPassword();
        Connection conn = DriverManager.getConnection(url, user, password);
        conn.createStatement().execute("drop table employee if exists");
        conn.createStatement().execute("create table employee(id int primary key, name varchar, salary int)");
        conn.close();
        int len = this.getSize(10, 50);
        Task[] tasks = new Task[len];
        int i = 0;
        while (i < len) {
            tasks[i] = new Task(){

                @Override
                public void call() throws SQLException {
                    Connection c = DriverManager.getConnection(url, user, password);
                    PreparedStatement prep = c.prepareStatement("insert into employee values(?, ?, 0)");
                    int id = TestOpenClose.this.getNextId();
                    prep.setInt(1, id);
                    prep.setString(2, "employee " + id);
                    prep.execute();
                    c.close();
                }
            };
            tasks[i].execute();
            ++i;
        }
        i = 0;
        while (i < len) {
            tasks[i].get();
            ++i;
        }
        conn = DriverManager.getConnection(url, user, password);
        ResultSet rs = conn.createStatement().executeQuery("select count(*) from employee");
        rs.next();
        this.assertEquals(len, rs.getInt(1));
        conn.close();
    }

    synchronized int getNextId() {
        return this.nextId++;
    }

    private void test1_1() throws IOException {
        Path old = Paths.get(this.getBaseDir(), new String[0]).resolve("db.data.db");
        Files.createFile(old, new FileAttribute[0]);
        try {
            this.assertThrows(90048, () -> DriverManager.getConnection("jdbc:h2:" + this.getBaseDir() + "/db"));
        }
        finally {
            Files.deleteIfExists(old);
        }
    }

    public static final class MyDatabaseEventListener
    implements DatabaseEventListener {
        @Override
        public void exceptionThrown(SQLException e, String sql) {
            throw new AssertionError((Object)("unexpected: " + String.valueOf(e) + " sql: " + sql));
        }

        @Override
        public void setProgress(int state, String name, long current, long max) {
            switch (state) {
                case 0: {
                    String stateName = "Scan " + name + " " + current + "/" + max;
                    if (current > 0L) {
                        throw new AssertionError((Object)("unexpected: " + stateName));
                    }
                    break;
                }
                case 5: {
                    break;
                }
                case 1: {
                    String stateName = "Create Index " + name + " " + current + "/" + max;
                    if (!"SYS:SYS_ID".equals(name)) {
                        throw new AssertionError((Object)("unexpected: " + stateName));
                    }
                    break;
                }
                case 2: {
                    String stateName = "Recover " + current + "/" + max;
                    break;
                }
                default: {
                    String string = "?";
                }
            }
        }
    }
}

