/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.SimpleResultSet;
import org.h2.util.Task;

public class TestOptimizations
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("optimizations");
        this.testConditionsStackOverflow();
        this.testIdentityIndexUsage();
        this.testFastRowIdCondition();
        this.testExplainRoundTrip();
        this.testOrderByExpression();
        this.testGroupSubquery();
        this.testAnalyzeLob();
        this.testLike();
        this.testExistsSubquery();
        this.testQueryCacheConcurrentUse();
        this.testQueryCacheResetParams();
        this.testRowId();
        this.testSortIndex();
        this.testAutoAnalyze();
        this.testInAndBetween();
        this.testNestedIn();
        this.testConstantIn1();
        this.testConstantIn2();
        this.testConstantTypeConversionToColumnType();
        this.testNestedInSelectAndLike();
        this.testNestedInSelect();
        this.testInSelectJoin();
        this.testMinMaxNullOptimization();
        this.testUseCoveringIndex();
        if (this.config.networked) {
            return;
        }
        this.testOptimizeInJoinSelect();
        this.testOptimizeInJoin();
        this.testMultiColumnRangeQuery();
        this.testDistinctOptimization();
        this.testQueryCacheTimestamp();
        if (!this.config.lazy) {
            this.testQueryCacheSpeed();
        }
        this.testQueryCache(true);
        this.testQueryCache(false);
        this.testIn();
        this.testMinMaxCountOptimization(true);
        this.testMinMaxCountOptimization(false);
        this.testOrderedIndexes();
        this.testIndexUseDespiteNullsFirst();
        this.testConvertOrToIn();
        this.testConditionAndOrDistributiveLaw();
        this.deleteDb("optimizations");
    }

    private void testIdentityIndexUsage() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(a identity)");
        stat.execute("insert into test values()");
        ResultSet rs = stat.executeQuery("explain select * from test where a = 1");
        rs.next();
        this.assertContains(rs.getString(1), "PRIMARY_KEY");
        stat.execute("drop table test");
        conn.close();
    }

    private void testFastRowIdCondition() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.executeUpdate("create table many(id int) as select x from system_range(1, 10000)");
        ResultSet rs = stat.executeQuery("explain analyze select * from many where _rowid_ = 400");
        rs.next();
        this.assertContains(rs.getString(1), "/* scanCount: 2 */");
        conn.close();
    }

    private void testExplainRoundTrip() throws Exception {
        Connection conn = this.getConnection("optimizations");
        this.assertExplainRoundTrip(conn, "SELECT \"X\" FROM SYSTEM_RANGE(1, 1) WHERE \"X\" > ANY(SELECT DISTINCT \"X\" FROM SYSTEM_RANGE(1, 1))");
        conn.close();
    }

    private void assertExplainRoundTrip(Connection conn, String sql) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("explain " + sql);
        rs.next();
        String plan = rs.getString(1);
        plan = plan.replaceAll("\\s+", " ");
        plan = plan.replaceAll("/\\*[^\\*]*\\*/", "");
        plan = plan.replaceAll("\\s+", " ");
        plan = plan.replaceAll("\\( ", "\\(");
        plan = plan.replaceAll(" \\)", "\\)");
        this.assertEquals(sql, plan);
    }

    private void testOrderByExpression() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'Hello'), (3, 'Hello')");
        ResultSet rs = stat.executeQuery("explain select name from test where name='Hello' order by name");
        rs.next();
        String plan = rs.getString(1);
        this.assertContains(plan, "tableScan");
        stat.execute("drop table test");
        conn.close();
    }

    private void testGroupSubquery() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table t1(id int)");
        stat.execute("create table t2(id int)");
        stat.execute("insert into t1 values(2), (2), (3)");
        stat.execute("insert into t2 values(2), (3)");
        stat.execute("create index t1id_index on t1(id)");
        ResultSet rs = stat.executeQuery("select id, (select count(*) from t2 where t2.id = t1.id) cc from t1 group by id order by id");
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(1, rs.getInt(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(1, rs.getInt(2));
        rs.next();
        stat.execute("drop table t1, t2");
        conn.close();
    }

    private void testAnalyzeLob() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(v varchar, b varbinary, cl clob, bl blob) as select ' ', '00', ' ', '00' from system_range(1, 100)");
        stat.execute("analyze");
        ResultSet rs = stat.executeQuery("select column_name, selectivity from information_schema.columns where table_name='TEST'");
        rs.next();
        this.assertEquals("V", rs.getString(1));
        this.assertEquals(1, rs.getInt(2));
        rs.next();
        this.assertEquals("B", rs.getString(1));
        this.assertEquals(1, rs.getInt(2));
        rs.next();
        this.assertEquals("CL", rs.getString(1));
        this.assertEquals(50, rs.getInt(2));
        rs.next();
        this.assertEquals("BL", rs.getString(1));
        this.assertEquals(50, rs.getInt(2));
        stat.execute("drop table test");
        conn.close();
    }

    private void testLike() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(name varchar primary key) as select x from system_range(1, 10)");
        ResultSet rs = stat.executeQuery("explain select * from test where name like ? || '%' {1: 'Hello'}");
        rs.next();
        this.assertContains(rs.getString(1), "PRIMARY_KEY_");
        stat.execute("drop table test");
        conn.close();
    }

    private void testExistsSubquery() throws Exception {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int) as select x from system_range(1, 10)");
        ResultSet rs = stat.executeQuery("explain select * from test where exists(select 1 from test, test, test) and id = 10");
        rs.next();
        this.assertContains(rs.getString(1), "WHERE (\"ID\" = 10)");
        stat.execute("drop table test");
        conn.close();
    }

    private void testQueryCacheConcurrentUse() throws Exception {
        if (this.config.lazy) {
            return;
        }
        final Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, data clob)");
        stat.execute("insert into test values(0, space(10000))");
        stat.execute("insert into test values(1, space(10001))");
        Task[] tasks = new Task[2];
        int i = 0;
        while (i < tasks.length) {
            tasks[i] = new Task(){

                @Override
                public void call() throws Exception {
                    PreparedStatement prep = conn.prepareStatement("select * from test where id = ?");
                    while (!this.stop) {
                        int x = (int)(Math.random() * 2.0);
                        prep.setInt(1, x);
                        ResultSet rs = prep.executeQuery();
                        rs.next();
                        String data = rs.getString(2);
                        if (data.length() != 10000 + x) {
                            throw new Exception(data.length() + " != " + x);
                        }
                        rs.close();
                    }
                }
            };
            tasks[i].execute();
            ++i;
        }
        Thread.sleep(1000L);
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.get();
            ++n2;
        }
        stat.execute("drop table test");
        conn.close();
    }

    private void testQueryCacheResetParams() throws SQLException {
        Connection conn = this.getConnection("optimizations");
        PreparedStatement prep = conn.prepareStatement("select ?");
        prep.setString(1, "Hello");
        prep.execute();
        prep.close();
        prep = conn.prepareStatement("select ?");
        this.assertThrows(90012, prep).execute();
        prep.close();
        conn.close();
    }

    private void testRowId() throws SQLException {
        if (this.config.memory) {
            return;
        }
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(data varchar)");
        stat.execute("select min(_rowid_ + 1) from test");
        stat.execute("insert into test(_rowid_, data) values(10, 'Hello')");
        stat.execute("insert into test(data) values('World')");
        stat.execute("insert into test(_rowid_, data) values(20, 'Hello')");
        stat.execute("merge into test using (values(20, 'Hallo')) s(id, data) on test._rowid_ = s.id when matched then update set data = s.data");
        ResultSet rs = stat.executeQuery("select _rowid_, data from test order by _rowid_");
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(11, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        rs.next();
        this.assertEquals(20, rs.getInt(1));
        this.assertEquals("Hallo", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(0, 'Hello')");
        stat.execute("insert into test values(3, 'Hello')");
        stat.execute("insert into test values(2, 'Hello')");
        rs = stat.executeQuery("explain select * from test where _rowid_ = 2");
        rs.next();
        this.assertContains(rs.getString(1), ".tableScan: _ROWID_ =");
        rs = stat.executeQuery("explain select * from test where _rowid_ > 2");
        rs.next();
        this.assertContains(rs.getString(1), ".tableScan: _ROWID_ >");
        rs = stat.executeQuery("explain select * from test order by _rowid_");
        rs.next();
        this.assertContains(rs.getString(1), "/* index sorted */");
        rs = stat.executeQuery("select _rowid_, * from test order by _rowid_");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertEquals(0, rs.getInt(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(2, rs.getInt(2));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(3, rs.getInt(2));
        stat.execute("drop table test");
        conn.close();
    }

    private void testSortIndex() throws SQLException {
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("drop table test if exists");
        stat.execute("create table test(id int)");
        stat.execute("create index idx_id_asc on test(id)");
        ResultSet rs = stat.executeQuery("explain select * from test where id > 10 order by id");
        rs.next();
        this.assertContains(rs.getString(1), "IDX_ID_ASC");
        rs = stat.executeQuery("explain select * from test where id < 10 order by id desc");
        rs.next();
        this.assertContains(rs.getString(1), "IDX_ID_ASC");
        rs.next();
        stat.execute("drop table test");
        conn.close();
    }

    private void testAutoAnalyze() throws SQLException {
        int auto;
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'analyzeAuto'");
        int n = auto = rs.next() ? rs.getInt(1) : 0;
        if (auto != 0) {
            stat.execute("create table test(id int)");
            stat.execute("create user onlyInsert password ''");
            stat.execute("grant insert on test to onlyInsert");
            Connection conn2 = this.getConnection("optimizations", "onlyInsert", this.getPassword(""));
            Statement stat2 = conn2.createStatement();
            stat2.execute("insert into test select x from system_range(1, " + (auto + 10) + ")");
            conn2.close();
        }
        conn.close();
    }

    private void testInAndBetween() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int, name varchar)");
        stat.execute("create index idx_name on test(id, name)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        ResultSet rs = stat.executeQuery("select * from test where id between 1 and 3 and name in ('World')");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from test where id between 1 and 3 and name in (select 'World')");
        this.assertTrue(rs.next());
        stat.execute("drop table test");
        conn.close();
    }

    private void testNestedIn() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table accounts(id integer primary key, status varchar(255), tag varchar(255))");
        stat.execute("insert into accounts values (31, 'X', 'A')");
        stat.execute("create table parent(id int)");
        stat.execute("insert into parent values(31)");
        stat.execute("create view test_view as select a.status, a.tag from accounts a, parent t where a.id = t.id");
        ResultSet rs = stat.executeQuery("select * from test_view where status='X' and tag in ('A','B')");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from (select a.status, a.tag from accounts a, parent t where a.id = t.id) x where status='X' and tag in ('A','B')");
        this.assertTrue(rs.next());
        stat.execute("create table test(id int primary key, name varchar(255))");
        stat.execute("create unique index idx_name on test(name, id)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        rs = stat.executeQuery("select * from (select * from test) where id=1 and name in('Hello', 'World')");
        this.assertTrue(rs.next());
        stat.execute("drop table test");
        conn.close();
    }

    private void testConstantIn1() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar(255))");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        this.assertSingleValue(stat, "select count(*) from test where name in ('Hello', 'World', '1')", 2);
        this.assertSingleValue(stat, "select count(*) from test where name in ('Hello', 'World')", 2);
        this.assertSingleValue(stat, "select count(*) from test where name in ('Hello', 'Not')", 1);
        stat.execute("drop table test");
        conn.close();
    }

    private void testConstantIn2() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations;IGNORECASE=TRUE");
        Statement stat = conn.createStatement();
        stat.executeUpdate("CREATE TABLE testValues (x VARCHAR(50))");
        stat.executeUpdate("INSERT INTO testValues (x) SELECT 'foo' x");
        ResultSet resultSet = stat.executeQuery("SELECT x FROM testValues WHERE x IN ('foo')");
        this.assertTrue(resultSet.next());
        resultSet = stat.executeQuery("SELECT x FROM testValues WHERE x IN ('FOO')");
        this.assertTrue(resultSet.next());
        resultSet = stat.executeQuery("SELECT x FROM testValues WHERE x IN ('foo','bar')");
        this.assertTrue(resultSet.next());
        resultSet = stat.executeQuery("SELECT x FROM testValues WHERE x IN ('FOO','bar')");
        this.assertTrue(resultSet.next());
        conn.close();
    }

    private void testConstantTypeConversionToColumnType() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations;IGNORECASE=TRUE");
        Statement stat = conn.createStatement();
        stat.executeUpdate("CREATE TABLE test (x int)");
        ResultSet resultSet = stat.executeQuery("EXPLAIN SELECT x FROM test WHERE x = '5'");
        this.assertTrue(resultSet.next());
        this.assertTrue(resultSet.getString(1).endsWith("\"X\" = 5"));
        stat.execute("drop table test");
        conn.close();
    }

    private void testNestedInSelect() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select 1, 'Hello'");
        stat.execute("select * from (select * from test) where id=1 and name in('Hello', 'World')");
        stat.execute("drop table test");
        stat.execute("create table test(id int, name varchar) as select 1, 'Hello'");
        stat.execute("create index idx2 on test(id, name)");
        ResultSet rs = stat.executeQuery("select count(*) from test where id=1 and name in('Hello', 'x')");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
    }

    private void testNestedInSelectAndLike() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(2)");
        ResultSet rs = stat.executeQuery("select * from test where id in(1, 2)");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        stat.execute("create table test2(id int primary key hash)");
        stat.execute("insert into test2 values(2)");
        rs = stat.executeQuery("select * from test where id in(1, 2)");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        PreparedStatement prep = conn.prepareStatement("SELECT * FROM SYSTEM_RANGE(1, 1) A WHERE A.X IN (SELECT B.X FROM SYSTEM_RANGE(1, 1) B WHERE B.X LIKE ?)");
        prep.setString(1, "1");
        prep.execute();
        prep = conn.prepareStatement("SELECT * FROM SYSTEM_RANGE(1, 1) A WHERE A.X IN (SELECT B.X FROM SYSTEM_RANGE(1, 1) B WHERE B.X IN (?, ?))");
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        prep.executeQuery();
        conn.close();
    }

    private void testInSelectJoin() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(a int, b int, c int, d int) as select 1, 1, 1, 1 from dual;");
        PreparedStatement prep = conn.prepareStatement("SELECT 2 FROM TEST A INNER JOIN (SELECT DISTINCT B.C AS X FROM TEST B WHERE B.D = ?2) V ON 1=1 WHERE (A = ?1) AND (B = V.X)");
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select 2 from test a where a=? and b in(select b.c from test b where b.d=?)");
        prep.setInt(1, 1);
        prep.setInt(2, 1);
        rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testOptimizeInJoinSelect() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table item(id int primary key)");
        stat.execute("insert into item values(1)");
        stat.execute("create alias opt for '" + this.getClass().getName() + ".optimizeInJoinSelect'");
        PreparedStatement prep = conn.prepareStatement("select * from item where id in (select x from opt())");
        ResultSet rs = prep.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
    }

    public static ResultSet optimizeInJoinSelect() {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("X", 4, 0, 0);
        rs.addRow(1);
        return rs;
    }

    private void testOptimizeInJoin() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test select x from system_range(1, 1000)");
        ResultSet rs = stat.executeQuery("explain select * from test where id in (400, 300)");
        rs.next();
        String plan = rs.getString(1);
        if (plan.indexOf("/* PUBLIC.PRIMARY_KEY_") < 0) {
            this.fail("Expected using the primary key, got: " + plan);
        }
        conn.close();
    }

    private void testMinMaxNullOptimization() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        Random random = new Random(1L);
        int len = this.getSize(50, 500);
        int i = 0;
        while (i < len) {
            stat.execute("drop table if exists test");
            stat.execute("create table test(x int)");
            if (random.nextBoolean()) {
                int count;
                int n = count = random.nextBoolean() ? 1 : 1 + random.nextInt(len);
                if (count > 0) {
                    stat.execute("insert into test select null from system_range(1, " + count + ")");
                }
            }
            int maxExpected = -1;
            int minExpected = -1;
            if (random.nextInt(10) != 1) {
                minExpected = 1;
                maxExpected = 1 + random.nextInt(len);
                stat.execute("insert into test select x from system_range(1, " + maxExpected + ")");
            }
            Object sql = "create index idx on test(x";
            if (random.nextBoolean()) {
                sql = (String)sql + " desc";
            }
            if (random.nextBoolean()) {
                sql = random.nextBoolean() ? (String)sql + " nulls first" : (String)sql + " nulls last";
            }
            sql = (String)sql + ")";
            stat.execute((String)sql);
            ResultSet rs = stat.executeQuery("explain select min(x), max(x) from test");
            rs.next();
            rs = stat.executeQuery("select min(x), max(x) from test");
            rs.next();
            int min = rs.getInt(1);
            if (rs.wasNull()) {
                min = -1;
            }
            int max = rs.getInt(2);
            if (rs.wasNull()) {
                max = -1;
            }
            this.assertEquals(minExpected, min);
            this.assertEquals(maxExpected, max);
            ++i;
        }
        conn.close();
    }

    private void testMultiColumnRangeQuery() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE Logs(id INT PRIMARY KEY, type INT)");
        stat.execute("CREATE unique INDEX type_index ON Logs(type, id)");
        stat.execute("INSERT INTO Logs SELECT X, MOD(X, 3) FROM SYSTEM_RANGE(1, 1000)");
        stat.execute("ANALYZE SAMPLE_SIZE 0");
        ResultSet rs = stat.executeQuery("EXPLAIN SELECT id FROM Logs WHERE id < 100 and type=2 AND id<100");
        rs.next();
        String plan = rs.getString(1);
        this.assertContains(plan, "TYPE_INDEX");
        conn.close();
    }

    private void testUseIndexWhenAllColumnsNotInOrderBy() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, account int, tx int)");
        stat.execute("insert into test select x, x*100, x from system_range(1, 10000)");
        stat.execute("analyze sample_size 5");
        stat.execute("create unique index idx_test_account_tx on test(account, tx desc)");
        ResultSet rs = stat.executeQuery("explain analyze select tx from test where account=22 and tx<9999999 order by tx desc limit 25");
        rs.next();
        String plan = rs.getString(1);
        this.assertContains(plan, "index sorted");
        conn.close();
    }

    private void testDistinctOptimization() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR, TYPE INT)");
        stat.execute("CREATE INDEX IDX_TEST_TYPE ON TEST(TYPE)");
        Random random = new Random(1L);
        int len = this.getSize(10000, 100000);
        int[] groupCount = new int[10];
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        int i = 0;
        while (i < len) {
            int type;
            prep.setInt(1, i);
            prep.setString(2, "Hello World");
            int n = type = random.nextInt(10);
            groupCount[n] = groupCount[n] + 1;
            prep.setInt(3, type);
            prep.execute();
            ++i;
        }
        ResultSet rs = stat.executeQuery("SELECT TYPE, COUNT(*) FROM TEST GROUP BY TYPE ORDER BY TYPE");
        int i2 = 0;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            this.assertEquals(groupCount[i2], rs.getInt(2));
            ++i2;
        }
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT DISTINCT TYPE FROM TEST ORDER BY TYPE");
        i2 = 0;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT DISTINCT TYPE FROM TEST");
        i2 = 0;
        while (rs.next()) {
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        this.assertFalse(rs.next());
        stat.execute("ANALYZE");
        rs = stat.executeQuery("SELECT DISTINCT TYPE FROM TEST ORDER BY TYPE");
        i2 = 0;
        while (i2 < 10) {
            this.assertTrue(rs.next());
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT DISTINCT TYPE FROM TEST ORDER BY TYPE LIMIT 5 OFFSET 2");
        i2 = 2;
        while (i2 < 7) {
            this.assertTrue(rs.next());
            this.assertEquals(i2, rs.getInt(1));
            ++i2;
        }
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testQueryCacheTimestamp() throws Exception {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        PreparedStatement prep = conn.prepareStatement("SELECT CURRENT_TIMESTAMP()");
        ResultSet rs = prep.executeQuery();
        rs.next();
        String a = rs.getString(1);
        Thread.sleep(50L);
        rs = prep.executeQuery();
        rs.next();
        String b = rs.getString(1);
        this.assertFalse(a.equals(b));
        conn.close();
    }

    private void testQueryCacheSpeed() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        this.testQuerySpeed(stat, "select sum(a.n), sum(b.x) from system_range(1, 100) b, (select sum(x) n from system_range(1, 4000)) a");
        conn.close();
    }

    private void testQuerySpeed(Statement stat, String sql) throws SQLException {
        long totalTime = 0L;
        long totalTimeOptimized = 0L;
        int i = 0;
        while (i < 3) {
            totalTime += TestOptimizations.measureQuerySpeed(stat, sql, false);
            totalTimeOptimized += TestOptimizations.measureQuerySpeed(stat, sql, true);
            ++i;
        }
        if (totalTimeOptimized > totalTime) {
            this.fail("not optimized: " + TimeUnit.NANOSECONDS.toMillis(totalTime) + " optimized: " + TimeUnit.NANOSECONDS.toMillis(totalTimeOptimized) + " sql:" + sql);
        }
    }

    private static long measureQuerySpeed(Statement stat, String sql, boolean optimized) throws SQLException {
        stat.execute("set OPTIMIZE_REUSE_RESULTS " + (optimized ? "1" : "0"));
        stat.execute(sql);
        long time = System.nanoTime();
        stat.execute(sql);
        return System.nanoTime() - time;
    }

    private void testQueryCache(boolean optimize) throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        if (optimize) {
            stat.execute("set OPTIMIZE_REUSE_RESULTS 1");
        } else {
            stat.execute("set OPTIMIZE_REUSE_RESULTS 0");
        }
        stat.execute("create table test(id int)");
        stat.execute("create table test2(id int)");
        stat.execute("insert into test values(1), (1), (2)");
        stat.execute("insert into test2 values(1)");
        PreparedStatement prep = conn.prepareStatement("select * from test where id = (select id from test2)");
        ResultSet rs1 = prep.executeQuery();
        rs1.next();
        this.assertEquals(1, rs1.getInt(1));
        rs1.next();
        this.assertEquals(1, rs1.getInt(1));
        this.assertFalse(rs1.next());
        stat.execute("update test2 set id = 2");
        ResultSet rs2 = prep.executeQuery();
        rs2.next();
        this.assertEquals(2, rs2.getInt(1));
        conn.close();
    }

    private void testMinMaxCountOptimization(boolean memory) throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create " + (memory ? "memory" : "") + " table test(id int primary key, v int)");
        stat.execute("create index idx_v_id on test(v, id);");
        int len = this.getSize(1000, 10000);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        TreeSet<Integer> set = new TreeSet<Integer>();
        Random random = new Random(1L);
        int i = 0;
        while (i < len) {
            if (i == len / 2 && !this.config.memory) {
                conn.close();
                conn = this.getConnection("optimizations");
                stat = conn.createStatement();
            }
            switch (random.nextInt(10)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (random.nextInt(1000) == 1) {
                        stat.execute("insert into test values(" + i + ", null)");
                        map.put(i, null);
                        break;
                    }
                    int value = random.nextInt();
                    stat.execute("insert into test values(" + i + ", " + value + ")");
                    map.put(i, value);
                    set.add(value);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (map.size() <= 0) break;
                    int j = random.nextInt(i);
                    int k = 0;
                    while (k < 10) {
                        if (map.containsKey(j)) {
                            Integer x = (Integer)map.remove(j);
                            if (x != null) {
                                set.remove(x);
                            }
                            stat.execute("delete from test where id=" + j);
                        }
                        ++k;
                        ++j;
                    }
                    break;
                }
                case 9: {
                    ArrayList list = new ArrayList(map.values());
                    int count = list.size();
                    Integer min = null;
                    Integer max = null;
                    if (count > 0) {
                        min = (Integer)set.first();
                        max = (Integer)set.last();
                    }
                    ResultSet rs = stat.executeQuery("select min(v), max(v), count(*) from test");
                    rs.next();
                    Integer minDb = (Integer)rs.getObject(1);
                    Integer maxDb = (Integer)rs.getObject(2);
                    int countDb = rs.getInt(3);
                    this.assertEquals(minDb, min);
                    this.assertEquals(maxDb, max);
                    this.assertEquals(countDb, count);
                }
            }
            ++i;
        }
        conn.close();
    }

    private void testIn() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        this.assertFalse(stat.executeQuery("select * from dual where x in()").next());
        this.assertFalse(stat.executeQuery("select * from dual where null in(1)").next());
        this.assertFalse(stat.executeQuery("select * from dual where null in(null)").next());
        this.assertFalse(stat.executeQuery("select * from dual where null in(null, 1)").next());
        this.assertFalse(stat.executeQuery("select * from system_range(1, 1) where 1+x in(3, 4)").next());
        this.assertFalse(stat.executeQuery("select * from system_range(1, 1) d1, dual d2 where d1.x in(3, 4)").next());
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("insert into test values(2, 'World')");
        PreparedStatement prep = conn.prepareStatement("select * from test t1 where t1.id in(?)");
        prep.setInt(1, 1);
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select * from test t1 where t1.id in(?, ?) order by id");
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select * from test t1 where t1.id in(select t2.id from test t2 where t2.id=?)");
        prep.setInt(1, 2);
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select * from test t1 where t1.id in(select t2.id from test t2 where t2.id=? and t1.id<>t2.id)");
        prep.setInt(1, 2);
        rs = prep.executeQuery();
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select * from test t1 where t1.id in(select t2.id from test t2 where t2.id in(cast(?+10 as varchar)))");
        prep.setInt(1, 2);
        rs = prep.executeQuery();
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testOrderedIndexes() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE my_table(K1 INT, K2 INT, VAL VARCHAR, PRIMARY KEY(K1, K2))");
        stat.execute("CREATE INDEX my_index ON my_table(K1, VAL)");
        ResultSet rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM my_table WHERE K1=7 ORDER BY K1, VAL");
        rs.next();
        this.assertContains(rs.getString(1), "/* PUBLIC.MY_INDEX: K1 = 7 */");
        stat.execute("DROP TABLE my_table");
        stat.execute("CREATE TABLE my_table(K1 INT, K2 INT, VAL VARCHAR)");
        stat.execute("CREATE INDEX my_index1 ON my_table(K1, K2)");
        stat.execute("CREATE INDEX my_index2 ON my_table(K1, K2, VAL)");
        rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM my_table WHERE K1=7 ORDER BY K1, K2, VAL");
        rs.next();
        this.assertContains(rs.getString(1), "/* PUBLIC.MY_INDEX2: K1 = 7 */");
        conn.close();
    }

    private void testIndexUseDespiteNullsFirst() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE my_table(K1 INT)");
        stat.execute("CREATE INDEX my_index ON my_table(K1)");
        stat.execute("INSERT INTO my_table VALUES (NULL)");
        stat.execute("INSERT INTO my_table VALUES (1)");
        stat.execute("INSERT INTO my_table VALUES (2)");
        ResultSet rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM my_table ORDER BY K1 ASC NULLS FIRST");
        rs.next();
        String result = rs.getString(1);
        this.assertContains(result, "/* index sorted */");
        rs = stat.executeQuery("SELECT * FROM my_table ORDER BY K1 ASC NULLS FIRST");
        rs.next();
        this.assertNull(rs.getObject(1));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM my_table ORDER BY K1 DESC NULLS FIRST");
        rs.next();
        result = rs.getString(1);
        if (result.contains("/* index sorted */")) {
            this.fail(result + " does not contain: /* index sorted */");
        }
        rs = stat.executeQuery("SELECT * FROM my_table ORDER BY K1 DESC NULLS FIRST");
        rs.next();
        this.assertNull(rs.getObject(1));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM my_table ORDER BY K1 ASC NULLS LAST");
        rs.next();
        result = rs.getString(1);
        if (result.contains("/* index sorted */")) {
            this.fail(result + " does not contain: /* index sorted */");
        }
        rs = stat.executeQuery("SELECT * FROM my_table ORDER BY K1 ASC NULLS LAST");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        rs.next();
        this.assertNull(rs.getObject(1));
        stat.execute("DROP TABLE my_table");
        conn.close();
    }

    private void testConvertOrToIn() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar(255))");
        stat.execute("insert into test values(1, '1'), (2, '2'), (3, '3'), (4, '4'), (5, '5')");
        ResultSet rs = stat.executeQuery("EXPLAIN PLAN FOR SELECT * FROM test WHERE ID=1 OR ID=2 OR ID=3 OR ID=4 OR ID=5");
        rs.next();
        this.assertContains(rs.getString(1), "\"ID\" IN(1, 2, 3, 4, 5)");
        rs = stat.executeQuery("SELECT COUNT(*) FROM test WHERE ID=1 OR ID=2 OR ID=3 OR ID=4 OR ID=5");
        rs.next();
        this.assertEquals(5, rs.getInt(1));
        conn.close();
    }

    private void testUseCoveringIndex() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TABLE_A(id IDENTITY PRIMARY KEY NOT NULL, name VARCHAR NOT NULL, active BOOLEAN DEFAULT TRUE, CONSTRAINT TABLE_A_UK UNIQUE (name) )");
        stat.execute("CREATE TABLE TABLE_B(id IDENTITY PRIMARY KEY NOT NULL,  TABLE_a_id BIGINT NOT NULL,  createDate TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP, CONSTRAINT TABLE_B_UK UNIQUE (table_a_id, createDate))");
        stat.execute("CREATE INDEX TABLE_B_IDX ON TABLE_B(TABLE_A_ID)");
        stat.execute("ALTER TABLE TABLE_B ADD FOREIGN KEY (table_a_id) REFERENCES TABLE_A(id)");
        stat.execute("INSERT INTO TABLE_A (name)  SELECT 'package_' || CAST(X as VARCHAR) FROM SYSTEM_RANGE(1, 100)  WHERE X <= 100");
        int count = this.config.memory ? 30000 : 50000;
        stat.execute("INSERT INTO TABLE_B (table_a_id, createDate)  SELECT CASE WHEN table_a_id = 0 THEN 1 ELSE table_a_id END, createDate FROM ( SELECT ROUND((RAND() * 100)) AS table_a_id, DATEADD('SECOND', X, CURRENT_TIMESTAMP) as createDate FROM SYSTEM_RANGE(1, " + count + ") WHERE X < " + count + "  )");
        stat.execute("ANALYZE");
        ResultSet rs = stat.executeQuery("EXPLAIN ANALYZE SELECT MAX(b.id) as id FROM table_b b JOIN table_a a ON b.table_a_id = a.id GROUP BY b.table_a_id HAVING A.ACTIVE = TRUE");
        rs.next();
        this.assertContains(rs.getString(1), "/* PUBLIC.TABLE_B_IDX: TABLE_A_ID = A.ID */");
        rs = stat.executeQuery("EXPLAIN ANALYZE SELECT MAX(id) FROM table_b GROUP BY table_a_id");
        rs.next();
        this.assertContains(rs.getString(1), "/* PUBLIC.TABLE_B_IDX");
        conn.close();
    }

    private void testConditionAndOrDistributiveLaw() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS TABLE_A (id int NOT NULL AUTO_INCREMENT, name VARCHAR(30) NOT NULL,occupation VARCHAR(20),age int,salary int,PRIMARY KEY(id))");
        stat.execute("INSERT INTO TABLE_A (name,occupation,age,salary) VALUES('mark', 'doctor',25,5000),('kevin', 'artist',20,4000),('isuru', 'engineer',25,5000),('josaph', 'businessman',30,7000),('sajeewa', 'analyst',24,5000),('randil', 'engineer',25,5000),('ashan', 'developer',24,5000)");
        ResultSet rs = stat.executeQuery("SELECT * FROM TABLE_A WHERE (salary = 5000 AND name = 'isuru') OR(age = 25 AND name = 'isuru') ");
        rs.next();
        this.assertTrue("engineer".equals(rs.getString("occupation")));
        conn.close();
    }

    private void testConditionsStackOverflow() throws SQLException {
        this.deleteDb("optimizations");
        Connection conn = this.getConnection("optimizations");
        Statement stat = conn.createStatement();
        StringBuilder b = new StringBuilder("SELECT 1");
        int i = 0;
        while (i < 10000) {
            b.append(" AND 1");
            ++i;
        }
        ResultSet rs = stat.executeQuery(b.toString());
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        conn.close();
    }
}

