/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import org.h2.test.TestBase;
import org.h2.test.db.AbstractBaseForCommonTableExpressions;

public class TestPersistentCommonTableExpressions
extends AbstractBaseForCommonTableExpressions {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testRecursiveTable();
        this.testPersistentNonRecursiveTableInCreateView();
        this.testPersistentRecursiveTableInCreateView();
        this.testPersistentNonRecursiveTableInCreateViewDropAllObjects();
        this.testPersistentRecursiveTableInCreateViewDropAllObjects();
    }

    private void testRecursiveTable() throws Exception {
        String[] expectedRowData = new String[]{"|meat|null", "|fruit|3", "|veg|2"};
        String[] expectedColumnTypes = new String[]{"CHARACTER VARYING", "NUMERIC"};
        String[] expectedColumnNames = new String[]{"VAL", "SUM((SELECT\n    X\nFROM BB BB\nWHERE BB.A IS NOT DISTINCT FROM A.VAL))"};
        String setupSQL = "DROP TABLE IF EXISTS A;                           DROP TABLE IF EXISTS B;                           DROP TABLE IF EXISTS C;                           CREATE TABLE A(VAL VARCHAR(255));                 CREATE TABLE B(A VARCHAR(255), VAL VARCHAR(255)); CREATE TABLE C(B VARCHAR(255), VAL VARCHAR(255));                                                   INSERT INTO A VALUES('fruit');                    INSERT INTO B VALUES('fruit','apple');            INSERT INTO B VALUES('fruit','banana');           INSERT INTO C VALUES('apple', 'golden delicious');INSERT INTO C VALUES('apple', 'granny smith');    INSERT INTO C VALUES('apple', 'pippin');          INSERT INTO A VALUES('veg');                      INSERT INTO B VALUES('veg', 'carrot');            INSERT INTO C VALUES('carrot', 'nantes');         INSERT INTO C VALUES('carrot', 'imperator');      INSERT INTO C VALUES(null, 'banapple');           INSERT INTO A VALUES('meat');                     ";
        String withQuery = "WITH BB as (SELECT                        \nsum(1) as X,                             \na                                        \nFROM B                                   \nJOIN C ON B.val=C.b                      \nGROUP BY a)                              \nSELECT                                   \nA.val,                                   \nsum((SELECT X FROM BB WHERE BB.a IS NOT DISTINCT FROM A.val))\nFROM A                                   \nGROUP BY A.val";
        int maxRetries = 3;
        int expectedNumberOfRows = expectedRowData.length;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, true);
    }

    private void testPersistentRecursiveTableInCreateView() throws Exception {
        String setupSQL = "--SET TRACE_LEVEL_SYSTEM_OUT 3;\nDROP TABLE IF EXISTS my_tree;                                                                \nDROP VIEW IF EXISTS v_my_tree;                                                               \nCREATE TABLE my_tree (                                                                       \n id INTEGER,                                                                                 \n parent_fk INTEGER                                                                           \n);                                                                                           \n                                                                                             \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 1, NULL );                                     \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 11, 1 );                                       \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 111, 11 );                                     \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 12, 1 );                                       \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 121, 12 );                                     \n                                                                                             \nCREATE OR REPLACE VIEW v_my_tree AS                                                          \nWITH RECURSIVE tree_cte (sub_tree_root_id, tree_level, parent_fk, child_fk) AS (             \n    SELECT mt.ID AS sub_tree_root_id, CAST(0 AS INT) AS tree_level, mt.parent_fk, mt.id      \n      FROM my_tree mt                                                                        \n UNION ALL                                                                                   \n    SELECT sub_tree_root_id, mtc.tree_level + 1 AS tree_level, mtc.parent_fk, mt.id          \n      FROM my_tree mt                                                                        \nINNER JOIN tree_cte mtc ON mtc.child_fk = mt.parent_fk                                       \n),                                                                                           \nunused_cte(unUsedColumn) AS ( SELECT 1 AS unUsedColumn )                                     \nSELECT sub_tree_root_id, tree_level, parent_fk, child_fk FROM tree_cte;                      \n";
        String withQuery = "SELECT * FROM v_my_tree";
        int maxRetries = 4;
        String[] expectedRowData = new String[]{"|1|0|null|1", "|11|0|1|11", "|111|0|11|111", "|12|0|1|12", "|121|0|12|121", "|1|1|null|11", "|11|1|1|111", "|1|1|null|12", "|12|1|1|121", "|1|2|null|111", "|1|2|null|121"};
        String[] expectedColumnNames = new String[]{"SUB_TREE_ROOT_ID", "TREE_LEVEL", "PARENT_FK", "CHILD_FK"};
        String[] expectedColumnTypes = new String[]{"INTEGER", "INTEGER", "INTEGER", "INTEGER"};
        int expectedNumberOfRows = 11;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }

    private void testPersistentNonRecursiveTableInCreateView() throws Exception {
        String setupSQL = "DROP VIEW IF EXISTS v_my_nr_tree;                                                            \nDROP TABLE IF EXISTS my_table;                                                               \nCREATE TABLE my_table (                                                                      \n id INTEGER,                                                                                 \n parent_fk INTEGER                                                                           \n);                                                                                           \n                                                                                             \nINSERT INTO my_table ( id, parent_fk) VALUES ( 1, NULL );                                    \nINSERT INTO my_table ( id, parent_fk) VALUES ( 11, 1 );                                      \nINSERT INTO my_table ( id, parent_fk) VALUES ( 111, 11 );                                    \nINSERT INTO my_table ( id, parent_fk) VALUES ( 12, 1 );                                      \nINSERT INTO my_table ( id, parent_fk) VALUES ( 121, 12 );                                    \n                                                                                             \nCREATE OR REPLACE VIEW v_my_nr_tree AS                                                       \nWITH tree_cte_nr (sub_tree_root_id, tree_level, parent_fk, child_fk) AS (                    \n    SELECT mt.ID AS sub_tree_root_id, CAST(0 AS INT) AS tree_level, mt.parent_fk, mt.id      \n      FROM my_table mt                                                                       \n),                                                                                            \nunused_cte AS ( SELECT 1 AS unUsedColumn )                                                   \nSELECT sub_tree_root_id, tree_level, parent_fk, child_fk FROM tree_cte_nr;                   \n";
        String withQuery = "SELECT * FROM v_my_nr_tree";
        int maxRetries = 6;
        String[] expectedRowData = new String[]{"|1|0|null|1", "|11|0|1|11", "|111|0|11|111", "|12|0|1|12", "|121|0|12|121"};
        String[] expectedColumnNames = new String[]{"SUB_TREE_ROOT_ID", "TREE_LEVEL", "PARENT_FK", "CHILD_FK"};
        String[] expectedColumnTypes = new String[]{"INTEGER", "INTEGER", "INTEGER", "INTEGER"};
        int expectedNumberOfRows = 5;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }

    private void testPersistentNonRecursiveTableInCreateViewDropAllObjects() throws Exception {
        String setupSQL = "DROP ALL OBJECTS;                                                                            \nCREATE TABLE my_table (                                                                      \n id INTEGER,                                                                                 \n parent_fk INTEGER                                                                           \n);                                                                                           \n                                                                                             \nINSERT INTO my_table ( id, parent_fk) VALUES ( 1, NULL );                                    \nINSERT INTO my_table ( id, parent_fk) VALUES ( 11, 1 );                                      \nINSERT INTO my_table ( id, parent_fk) VALUES ( 111, 11 );                                    \nINSERT INTO my_table ( id, parent_fk) VALUES ( 12, 1 );                                      \nINSERT INTO my_table ( id, parent_fk) VALUES ( 121, 12 );                                    \n                                                                                             \nCREATE OR REPLACE VIEW v_my_nr_tree AS                                                       \nWITH tree_cte_nr (sub_tree_root_id, tree_level, parent_fk, child_fk) AS (                    \n    SELECT mt.ID AS sub_tree_root_id, CAST(0 AS INT) AS tree_level, mt.parent_fk, mt.id      \n      FROM my_table mt                                                                       \n),                                                                                            \nunused_cte AS ( SELECT 1 AS unUsedColumn )                                                   \nSELECT sub_tree_root_id, tree_level, parent_fk, child_fk FROM tree_cte_nr;                   \n";
        String withQuery = "SELECT * FROM v_my_nr_tree";
        int maxRetries = 6;
        String[] expectedRowData = new String[]{"|1|0|null|1", "|11|0|1|11", "|111|0|11|111", "|12|0|1|12", "|121|0|12|121"};
        String[] expectedColumnNames = new String[]{"SUB_TREE_ROOT_ID", "TREE_LEVEL", "PARENT_FK", "CHILD_FK"};
        String[] expectedColumnTypes = new String[]{"INTEGER", "INTEGER", "INTEGER", "INTEGER"};
        int expectedNumberOfRows = 5;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }

    private void testPersistentRecursiveTableInCreateViewDropAllObjects() throws Exception {
        String setupSQL = "--SET TRACE_LEVEL_SYSTEM_OUT 3;\nDROP ALL OBJECTS;                                                                            \nCREATE TABLE my_tree (                                                                       \n id INTEGER,                                                                                 \n parent_fk INTEGER                                                                           \n);                                                                                           \n                                                                                             \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 1, NULL );                                     \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 11, 1 );                                       \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 111, 11 );                                     \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 12, 1 );                                       \nINSERT INTO my_tree ( id, parent_fk) VALUES ( 121, 12 );                                     \n                                                                                             \nCREATE OR REPLACE VIEW v_my_tree AS                                                          \nWITH RECURSIVE tree_cte (sub_tree_root_id, tree_level, parent_fk, child_fk) AS (             \n    SELECT mt.ID AS sub_tree_root_id, CAST(0 AS INT) AS tree_level, mt.parent_fk, mt.id      \n      FROM my_tree mt                                                                        \n UNION ALL                                                                                   \n    SELECT sub_tree_root_id, mtc.tree_level + 1 AS tree_level, mtc.parent_fk, mt.id          \n      FROM my_tree mt                                                                        \nINNER JOIN tree_cte mtc ON mtc.child_fk = mt.parent_fk                                       \n),                                                                                           \nunused_cte(unUsedColumn) AS ( SELECT 1 AS unUsedColumn )                                     \nSELECT sub_tree_root_id, tree_level, parent_fk, child_fk FROM tree_cte;                      \n";
        String withQuery = "SELECT * FROM v_my_tree";
        int maxRetries = 4;
        String[] expectedRowData = new String[]{"|1|0|null|1", "|11|0|1|11", "|111|0|11|111", "|12|0|1|12", "|121|0|12|121", "|1|1|null|11", "|11|1|1|111", "|1|1|null|12", "|12|1|1|121", "|1|2|null|111", "|1|2|null|121"};
        String[] expectedColumnNames = new String[]{"SUB_TREE_ROOT_ID", "TREE_LEVEL", "PARENT_FK", "CHILD_FK"};
        String[] expectedColumnTypes = new String[]{"INTEGER", "INTEGER", "INTEGER", "INTEGER"};
        int expectedNumberOfRows = 11;
        this.testRepeatedQueryWithSetup(maxRetries, expectedRowData, expectedColumnNames, expectedNumberOfRows, setupSQL, withQuery, maxRetries - 1, expectedColumnTypes, false);
    }
}

