/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestQueryCache
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("queryCache");
        this.test1();
        this.testClearingCacheWithTableStructureChanges();
        this.deleteDb("queryCache");
    }

    private void test1() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection("queryCache;QUERY_CACHE_SIZE=10");){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int, name varchar)");
            StringBuilder queryBuilder = new StringBuilder("select count(*) from test t1 where \n");
            int i = 0;
            while (i < 1000) {
                if (i != 0) {
                    queryBuilder.append(" and ");
                }
                queryBuilder.append(" TIMESTAMP '2005-12-31 23:59:59' = TIMESTAMP '2005-12-31 23:59:59' ");
                ++i;
            }
            String query = queryBuilder.toString();
            conn.prepareStatement(query);
            int firstGreater = 0;
            int firstSmaller = 0;
            long first = 0L;
            int i2 = 0;
            while (i2 < 1005) {
                long time = System.nanoTime();
                PreparedStatement prep = conn.prepareStatement(query);
                this.execute(prep);
                prep.close();
                ResultSet rs = stat.executeQuery(query);
                rs.next();
                int c = rs.getInt(1);
                rs.close();
                this.assertEquals(0, c);
                time = System.nanoTime() - time;
                if (i2 == 1000) {
                    prep = conn.prepareStatement(query);
                } else if (i2 == 1001) {
                    first = time;
                } else if (i2 > 1001) {
                    if (first > time) {
                        ++firstGreater;
                    } else {
                        ++firstSmaller;
                    }
                }
                ++i2;
            }
            this.assertSmaller(firstSmaller, firstGreater);
            stat.execute("drop table test");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testClearingCacheWithTableStructureChanges() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection("queryCache;QUERY_CACHE_SIZE=10");){
            this.assertThrows(42104, conn).prepareStatement("SELECT * FROM TEST");
            Statement stat = conn.createStatement();
            stat.executeUpdate("CREATE TABLE TEST(col1 bigint, col2 varchar(255))");
            PreparedStatement prep = conn.prepareStatement("SELECT * FROM TEST");
            prep.close();
            stat.executeUpdate("DROP TABLE TEST");
            this.assertThrows(42104, conn).prepareStatement("SELECT * FROM TEST");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

