/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.File;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.dev.fs.FilePathZip2;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Backup;
import org.h2.tools.Server;

public class TestReadOnly
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory;
    }

    @Override
    public void test() throws Exception {
        this.testReadOnlyInZip();
        this.testReadOnlyTempTableResult();
        this.testReadOnlyConnect();
        this.testReadOnlyDbCreate();
        if (!this.config.googleAppEngine) {
            this.testReadOnlyFiles(true);
        }
        this.testReadOnlyFiles(false);
    }

    private void testReadOnlyInZip() throws SQLException {
        if (this.config.cipher != null) {
            return;
        }
        this.deleteDb("readonlyInZip");
        String dir = this.getBaseDir();
        Connection conn = this.getConnection("readonlyInZip");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT) AS SELECT X FROM SYSTEM_RANGE(1, 20)");
        conn.close();
        Backup.execute(dir + "/readonly.zip", dir, "readonlyInZip", true);
        conn = this.getConnection("jdbc:h2:zip:" + dir + "/readonly.zip!/readonlyInZip", this.getUser(), this.getPassword());
        conn.createStatement().execute("select * from test where id=1");
        conn.close();
        Server server = null;
        try {
            server = Server.createTcpServer("-baseDir", dir);
            server.start();
            int port = server.getPort();
            conn = this.getConnection("jdbc:h2:tcp://localhost:" + port + "/zip:readonly.zip!/readonlyInZip", this.getUser(), this.getPassword());
            conn.createStatement().execute("select * from test where id=1");
            conn.close();
            FilePathZip2.register();
            conn = this.getConnection("jdbc:h2:tcp://localhost:" + port + "/zip2:readonly.zip!/readonlyInZip", this.getUser(), this.getPassword());
            conn.createStatement().execute("select * from test where id=1");
            conn.close();
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
        this.deleteDb("readonlyInZip");
    }

    private void testReadOnlyTempTableResult() throws SQLException {
        this.deleteDb("readonlyTemp");
        Connection conn = this.getConnection("readonlyTemp");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT) AS SELECT X FROM SYSTEM_RANGE(1, 20)");
        conn.close();
        conn = this.getConnection("readonlyTemp;ACCESS_MODE_DATA=r;MAX_MEMORY_ROWS=10");
        stat = conn.createStatement();
        stat.execute("SELECT DISTINCT ID FROM TEST");
        conn.close();
        this.deleteDb("readonlyTemp");
    }

    private void testReadOnlyDbCreate() throws SQLException {
        this.deleteDb("readonlyDbCreate");
        Connection conn = this.getConnection("readonlyDbCreate");
        Statement stat = conn.createStatement();
        stat.execute("create table a(id int)");
        stat.execute("create index ai on a(id)");
        conn.close();
        conn = this.getConnection("readonlyDbCreate;ACCESS_MODE_DATA=r");
        stat = conn.createStatement();
        stat.execute("create table if not exists a(id int)");
        stat.execute("create index if not exists ai on a(id)");
        this.assertThrows(90097, stat).execute("CREATE TABLE TEST(ID INT)");
        this.assertThrows(42102, stat).execute("SELECT * FROM TEST");
        stat.execute("create local temporary linked table test(null, 'jdbc:h2:mem:test3', 'sa', 'sa', 'INFORMATION_SCHEMA.TABLES')");
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testReadOnlyFiles(boolean setReadOnly) throws Exception {
        new File(System.getProperty("java.io.tmpdir")).mkdirs();
        File f = File.createTempFile("test", "temp");
        this.assertTrue(f.canWrite());
        f.setReadOnly();
        this.assertFalse(f.canWrite());
        f.delete();
        f = File.createTempFile("test", "temp");
        RandomAccessFile r = new RandomAccessFile(f, "rw");
        r.write(1);
        f.setReadOnly();
        r.close();
        this.assertFalse(f.canWrite());
        f.delete();
        this.deleteDb("readonlyFiles");
        Connection conn = this.getConnection("readonlyFiles");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        this.assertFalse(conn.isReadOnly());
        conn.close();
        if (setReadOnly) {
            this.setReadOnly();
            conn = this.getConnection("readonlyFiles");
        } else {
            conn = this.getConnection("readonlyFiles;ACCESS_MODE_DATA=r");
        }
        this.assertTrue(conn.isReadOnly());
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        this.assertThrows(90097, stat).execute("DELETE FROM TEST");
        conn.close();
        conn = setReadOnly ? this.getConnection("readonlyFiles;DB_CLOSE_DELAY=1") : this.getConnection("readonlyFiles;DB_CLOSE_DELAY=1;ACCESS_MODE_DATA=r");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        this.assertThrows(90097, stat).execute("DELETE FROM TEST");
        stat.execute("SET DB_CLOSE_DELAY=0");
        conn.close();
    }

    private void setReadOnly() {
        ArrayList<String> list = FileLister.getDatabaseFiles(this.getBaseDir(), "readonlyFiles", true);
        for (String fileName : list) {
            FileUtils.setReadOnly(fileName);
        }
    }

    private void testReadOnlyConnect() throws SQLException {
        this.deleteDb("readonlyConnect");
        Connection conn = this.getConnection("readonlyConnect;OPEN_NEW=TRUE");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id identity)");
        stat.execute("insert into test select x from system_range(1, 11)");
        this.assertThrows(90020, () -> this.getConnection("readonlyConnect;ACCESS_MODE_DATA=r;OPEN_NEW=TRUE"));
        conn.close();
        this.deleteDb("readonlyConnect");
    }
}

