/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSelectTableNotFound
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testWithoutAnyCandidate();
        this.testWithOneCandidate();
        this.testWithTwoCandidates();
        this.testWithSchema();
        this.testWithSchemaSearchPath();
        this.testWhenSchemaIsEmpty();
        this.testWithSchemaWhenSchemaIsEmpty();
        this.testWithSchemaSearchPathWhenSchemaIsEmpty();
    }

    private void testWithoutAnyCandidate() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T2 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.executeQuery("SELECT 1 FROM t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found;");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithOneCandidate() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.executeQuery("SELECT 1 FROM t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (candidates are: \"T1\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithTwoCandidates() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE Toast ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        stat.execute("CREATE TABLE TOAST ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.executeQuery("SELECT 1 FROM toast");
            this.fail("Table `toast` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"toast\" not found (candidates are: \"TOAST, Toast\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithSchema() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.executeQuery("SELECT 1 FROM PUBLIC.t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (candidates are: \"T1\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithSchemaSearchPath() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("SET SCHEMA_SEARCH_PATH PUBLIC");
        stat.execute("CREATE TABLE T1 ( ID INT GENERATED BY DEFAULT AS IDENTITY )");
        try {
            stat.executeQuery("SELECT 1 FROM t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (candidates are: \"T1\")");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWhenSchemaIsEmpty() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        try {
            stat.executeQuery("SELECT 1 FROM t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (this database is empty)");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithSchemaWhenSchemaIsEmpty() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        try {
            stat.executeQuery("SELECT 1 FROM PUBLIC.t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (this database is empty)");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testWithSchemaSearchPathWhenSchemaIsEmpty() throws SQLException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("SET SCHEMA_SEARCH_PATH PUBLIC");
        try {
            stat.executeQuery("SELECT 1 FROM t1");
            this.fail("Table `t1` was accessible but should not have been.");
        }
        catch (SQLException e) {
            String message = e.getMessage();
            this.assertContains(message, "Table \"t1\" not found (this database is empty)");
        }
        conn.close();
        this.deleteDb(this.getTestName());
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(this.getTestName() + ";DATABASE_TO_UPPER=FALSE");
    }
}

