/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.h2.api.Trigger;
import org.h2.engine.Constants;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestSequence
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testConcurrentCreate();
        this.testConcurrentNextAndCurrentValue();
        this.testSchemaSearchPath();
        this.testAlterSequenceColumn();
        this.testAlterSequence();
        this.testCache();
        this.testTwo();
        this.testMetaTable();
        this.testCreateWithMinValue();
        this.testCreateWithMaxValue();
        this.testCreationErrors();
        this.testCreateSql();
        this.testDefaultMinMax();
        this.deleteDb("sequence");
    }

    /*
     * Unable to fully structure code
     */
    private void testConcurrentCreate() throws Exception {
        this.deleteDb("sequence");
        url = this.getURL("sequence;LOCK_TIMEOUT=2000", true);
        conn = this.getConnection(url);
        tasks = new Task[2];
        try {
            stat = conn.createStatement();
            stat.execute("create table dummy(id bigint primary key)");
            stat.execute("create table test(id bigint primary key)");
            stat.execute("create sequence test_seq cache 2");
            i = 0;
            while (i < tasks.length) {
                x = i;
                tasks[i] = new Task(){

                    @Override
                    public void call() throws Exception {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (Connection conn = TestSequence.this.getConnection(url);){
                            PreparedStatement prep = conn.prepareStatement("insert into test(id) values(next value for test_seq)");
                            PreparedStatement prep2 = conn.prepareStatement("delete from test");
                            while (!this.stop) {
                                prep.execute();
                                if (Math.random() < 0.01) {
                                    prep2.execute();
                                }
                                if (!(Math.random() < 0.01)) continue;
                                this.createDropTrigger(conn);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }

                    private void createDropTrigger(Connection conn) throws Exception {
                        String triggerName = "t_" + x;
                        Statement stat = conn.createStatement();
                        stat.execute("create trigger " + triggerName + " before insert on dummy call \"" + TriggerTest.class.getName() + "\"");
                        stat.execute("drop trigger " + triggerName);
                    }
                }.execute();
                ++i;
            }
            Thread.sleep(1000L);
            var8_8 = tasks;
            var7_9 = tasks.length;
            var6_7 = 0;
            while (var6_7 < var7_9) {
                t = var8_8[var6_7];
                t.get();
                ++var6_7;
            }
        }
        finally {
            var13_12 = tasks;
            var12_14 = tasks.length;
            var11_16 = 0;
            ** while (var11_16 < var12_14)
        }
lbl-1000:
        // 1 sources

        {
            t = var13_12[var11_16];
            t.join();
            ++var11_16;
            continue;
        }
lbl39:
        // 1 sources

        conn.close();
    }

    /*
     * Unable to fully structure code
     */
    private void testConcurrentNextAndCurrentValue() throws Exception {
        this.deleteDb("sequence");
        url = this.getURL("sequence", true);
        conn = this.getConnection(url);
        tasks = new Task[2];
        try {
            stat = conn.createStatement();
            stat.execute("CREATE SEQUENCE SEQ1");
            stat.execute("CREATE SEQUENCE SEQ2");
            i = 0;
            while (i < tasks.length) {
                tasks[i] = new Task(){

                    @Override
                    public void call() throws Exception {
                        Throwable throwable = null;
                        Object var2_3 = null;
                        try (Connection conn = TestSequence.this.getConnection(url);){
                            PreparedStatement next1 = conn.prepareStatement("CALL NEXT VALUE FOR SEQ1");
                            PreparedStatement next2 = conn.prepareStatement("CALL NEXT VALUE FOR SEQ2");
                            PreparedStatement current1 = conn.prepareStatement("CALL CURRENT VALUE FOR SEQ1");
                            PreparedStatement current2 = conn.prepareStatement("CALL CURRENT VALUE FOR SEQ2");
                            while (!this.stop) {
                                long v2;
                                long v1;
                                ResultSet rs;
                                Throwable throwable2 = null;
                                Object var13_17 = null;
                                try {
                                    rs = next1.executeQuery();
                                    try {
                                        rs.next();
                                        v1 = rs.getLong(1);
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                                throwable2 = null;
                                var13_17 = null;
                                try {
                                    rs = next2.executeQuery();
                                    try {
                                        rs.next();
                                        v2 = rs.getLong(1);
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                    } else if (throwable2 != throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                                throwable2 = null;
                                var13_17 = null;
                                try {
                                    rs = current1.executeQuery();
                                    try {
                                        rs.next();
                                        if (v1 != rs.getLong(1)) {
                                            throw new RuntimeException("Unexpected CURRENT VALUE FOR SEQ1");
                                        }
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                    } else if (throwable2 != throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                    throw throwable2;
                                }
                                throwable2 = null;
                                var13_17 = null;
                                try {
                                    rs = current2.executeQuery();
                                    try {
                                        rs.next();
                                        if (v2 == rs.getLong(1)) continue;
                                        throw new RuntimeException("Unexpected CURRENT VALUE FOR SEQ2");
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable6) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable6;
                                    } else if (throwable2 != throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable == null) {
                                throwable = throwable7;
                            } else if (throwable != throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            throw throwable;
                        }
                    }
                }.execute();
                ++i;
            }
            Thread.sleep(1000L);
            var8_7 = tasks;
            var7_8 = tasks.length;
            var6_9 = 0;
            while (var6_9 < var7_8) {
                t = var8_7[var6_9];
                e = t.getException();
                if (e != null) {
                    throw new AssertionError((Object)e.getMessage());
                }
                ++var6_9;
            }
        }
        finally {
            var14_13 = tasks;
            var13_15 = tasks.length;
            var12_17 = 0;
            ** while (var12_17 < var13_15)
        }
lbl-1000:
        // 1 sources

        {
            t = var14_13[var12_17];
            t.join();
            ++var12_17;
            continue;
        }
lbl37:
        // 1 sources

        conn.close();
    }

    private void testSchemaSearchPath() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA TEST");
        stat.execute("CREATE SEQUENCE TEST.TEST_SEQ");
        stat.execute("SET SCHEMA_SEARCH_PATH PUBLIC, TEST");
        stat.execute("CALL NEXT VALUE FOR TEST_SEQ");
        stat.execute("CALL CURRENT VALUE FOR TEST_SEQ");
        conn.close();
    }

    private void testAlterSequenceColumn() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT , NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("ALTER TABLE TEST ALTER COLUMN ID INT GENERATED BY DEFAULT AS IDENTITY");
        stat.execute("ALTER TABLE test ALTER COLUMN ID RESTART WITH 3");
        stat.execute("INSERT INTO TEST (name) VALUES('Other World')");
        conn.close();
    }

    private void testAlterSequence() throws SQLException {
        this.test("create sequence s; alter sequence s restart with 2", null, 2L, 3L, 4L);
        this.test("create sequence s; alter sequence s restart with 7", null, 7L, 8L, 9L, 10L);
        this.test("create sequence s; alter sequence s start with 3 restart with 11 minvalue 3 maxvalue 12 cycle", null, 11L, 12L, 3L, 4L);
        this.test("create sequence s; alter sequence s restart with 5 cache 2", null, 5L, 6L, 7L, 8L);
        this.test("create sequence s; alter sequence s restart with 9 maxvalue 12 nocycle nocache", "Sequence \"S\" has run out of numbers", 9L, 10L, 11L, 12L);
    }

    private void testCache() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("create sequence test_Sequence");
        stat.execute("create sequence test_Sequence3 cache 3");
        conn.close();
        conn = this.getConnection("sequence");
        stat = conn.createStatement();
        stat.execute("call next value for test_Sequence");
        stat.execute("call next value for test_Sequence3");
        ResultSet rs = stat.executeQuery("select * from information_schema.sequences order by sequence_name");
        rs.next();
        this.assertEquals("TEST_SEQUENCE", rs.getString("SEQUENCE_NAME"));
        this.assertEquals("32", rs.getString("CACHE"));
        rs.next();
        this.assertEquals("TEST_SEQUENCE3", rs.getString("SEQUENCE_NAME"));
        this.assertEquals("3", rs.getString("CACHE"));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testMetaTable() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("create sequence a");
        stat.execute("create sequence b start with 7 minvalue 5 maxvalue 9 cycle increment by 2 nocache");
        stat.execute("create sequence c start with -4 minvalue -9 maxvalue -3 no cycle increment by -2 cache 3");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("sequence");
        }
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from information_schema.sequences order by sequence_name");
        rs.next();
        this.assertEquals("SEQUENCE", rs.getString("SEQUENCE_CATALOG"));
        this.assertEquals("PUBLIC", rs.getString("SEQUENCE_SCHEMA"));
        this.assertEquals("A", rs.getString("SEQUENCE_NAME"));
        this.assertEquals(1L, rs.getLong("BASE_VALUE"));
        this.assertEquals(1L, rs.getLong("INCREMENT"));
        this.assertNull(rs.getString("REMARKS"));
        this.assertEquals(32L, rs.getLong("CACHE"));
        this.assertEquals(1L, rs.getLong("MINIMUM_VALUE"));
        this.assertEquals(Long.MAX_VALUE, rs.getLong("MAXIMUM_VALUE"));
        this.assertEquals("NO", rs.getString("CYCLE_OPTION"));
        rs.next();
        this.assertEquals("SEQUENCE", rs.getString("SEQUENCE_CATALOG"));
        this.assertEquals("PUBLIC", rs.getString("SEQUENCE_SCHEMA"));
        this.assertEquals("B", rs.getString("SEQUENCE_NAME"));
        this.assertEquals(7L, rs.getLong("BASE_VALUE"));
        this.assertEquals(2L, rs.getLong("INCREMENT"));
        this.assertNull(rs.getString("REMARKS"));
        this.assertEquals(1L, rs.getLong("CACHE"));
        this.assertEquals(5L, rs.getLong("MINIMUM_VALUE"));
        this.assertEquals(9L, rs.getLong("MAXIMUM_VALUE"));
        this.assertEquals("YES", rs.getString("CYCLE_OPTION"));
        rs.next();
        this.assertEquals("SEQUENCE", rs.getString("SEQUENCE_CATALOG"));
        this.assertEquals("PUBLIC", rs.getString("SEQUENCE_SCHEMA"));
        this.assertEquals("C", rs.getString("SEQUENCE_NAME"));
        this.assertEquals(-4L, rs.getLong("BASE_VALUE"));
        this.assertEquals(-2L, rs.getLong("INCREMENT"));
        this.assertNull(rs.getString("REMARKS"));
        this.assertEquals(3L, rs.getLong("CACHE"));
        this.assertEquals(-9L, rs.getLong("MINIMUM_VALUE"));
        this.assertEquals(-3L, rs.getLong("MAXIMUM_VALUE"));
        this.assertEquals("NO", rs.getString("CYCLE_OPTION"));
        this.assertFalse(rs.next());
        conn.close();
    }

    private void testCreateWithMinValue() throws SQLException {
        this.test("create sequence s minvalue 3", null, 3L, 4L, 5L, 6L);
        this.test("create sequence s minvalue -3 increment by -1 cycle", null, -1L, -2L, -3L, -1L);
        this.test("create sequence s minvalue -3 increment by -1", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
        this.test("create sequence s minvalue -3 increment by -1 nocycle", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
        this.test("create sequence s minvalue -3 increment by -1 no cycle", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
        this.test("create sequence s minvalue -3 increment by -1 nocache cycle", null, -1L, -2L, -3L, -1L);
        this.test("create sequence s minvalue -3 increment by -1 nocache", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
        this.test("create sequence s minvalue -3 increment by -1 nocache nocycle", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
        this.test("create sequence s minvalue -3 increment by -1 no cache no cycle", "Sequence \"S\" has run out of numbers", -1L, -2L, -3L);
    }

    private void testCreateWithMaxValue() throws SQLException {
        this.test("create sequence s maxvalue -3 increment by -1", null, -3L, -4L, -5L, -6L);
        this.test("create sequence s maxvalue 3 cycle", null, 1L, 2L, 3L, 1L);
        this.test("create sequence s maxvalue 3", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
        this.test("create sequence s maxvalue 3 nocycle", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
        this.test("create sequence s maxvalue 3 no cycle", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
        this.test("create sequence s maxvalue 3 nocache cycle", null, 1L, 2L, 3L, 1L);
        this.test("create sequence s maxvalue 3 nocache", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
        this.test("create sequence s maxvalue 3 nocache nocycle", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
        this.test("create sequence s maxvalue 3 no cache no cycle", "Sequence \"S\" has run out of numbers", 1L, 2L, 3L);
    }

    private void testCreationErrors() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        this.expectError(stat, "create sequence a minvalue 5 start with 2", "Unable to create or alter sequence \"A\" because of invalid attributes (base value \"2\", start value \"2\", min value \"5\", max value \"9223372036854775807\", increment \"1\", cache size \"32\")");
        this.expectError(stat, "create sequence b maxvalue 5 start with 7", "Unable to create or alter sequence \"B\" because of invalid attributes (base value \"7\", start value \"7\", min value \"1\", max value \"5\", increment \"1\", cache size \"32\")");
        this.expectError(stat, "create sequence c minvalue 5 maxvalue 2", "Unable to create or alter sequence \"C\" because of invalid attributes (base value \"5\", start value \"5\", min value \"5\", max value \"2\", increment \"1\", cache size \"32\")");
        this.expectError(stat, "create sequence d increment by 0", "Unable to create or alter sequence \"D\" because of invalid attributes (base value \"1\", start value \"1\", min value \"1\", max value \"9223372036854775807\", increment \"0\", cache size \"32\")");
        this.expectError(stat, "create sequence e minvalue 1 maxvalue 5 increment 99", "Unable to create or alter sequence \"E\" because of invalid attributes (base value \"1\", start value \"1\", min value \"1\", max value \"5\", increment \"99\", cache size \"32\")");
        conn.close();
    }

    private void testCreateSql() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("create sequence a");
        stat.execute("create sequence b start with 5 increment by 2 minvalue 3 maxvalue 7 cycle nocache");
        stat.execute("create sequence c start with 3 increment by 1 minvalue 2 maxvalue 9 nocycle cache 2");
        stat.execute("create sequence d nomaxvalue no minvalue no cache nocycle");
        stat.execute("create sequence e cache 1");
        ArrayList<String> script = new ArrayList<String>();
        ResultSet rs = stat.executeQuery("script nodata");
        while (rs.next()) {
            script.add(rs.getString(1));
        }
        Collections.sort(script);
        this.assertEquals("-- H2 " + Constants.VERSION + ";", (String)script.get(0));
        this.assertEquals("CREATE SEQUENCE \"PUBLIC\".\"A\" START WITH 1;", (String)script.get(1));
        this.assertEquals("CREATE SEQUENCE \"PUBLIC\".\"B\" START WITH 5 INCREMENT BY 2 MINVALUE 3 MAXVALUE 7 CYCLE NO CACHE;", (String)script.get(2));
        this.assertEquals("CREATE SEQUENCE \"PUBLIC\".\"C\" START WITH 3 MINVALUE 2 MAXVALUE 9 CACHE 2;", (String)script.get(3));
        this.assertEquals("CREATE SEQUENCE \"PUBLIC\".\"D\" START WITH 1 NO CACHE;", (String)script.get(4));
        this.assertEquals("CREATE SEQUENCE \"PUBLIC\".\"E\" START WITH 1 NO CACHE;", (String)script.get(5));
        conn.close();
    }

    private void testDefaultMinMax() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("create sequence a START WITH -7320917853639540658");
        stat.execute("create sequence b START WITH 7320917853639540658 INCREMENT -1");
        conn.close();
    }

    private void testTwo() throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute("create sequence s");
        conn.setAutoCommit(false);
        Connection conn2 = this.getConnection("sequence");
        Statement stat2 = conn2.createStatement();
        conn2.setAutoCommit(false);
        long last = 0L;
        int i = 0;
        while (i < 100) {
            long v1 = TestSequence.getNext(stat);
            this.assertTrue(v1 > last);
            last = v1;
            int j = 0;
            while (j < 100) {
                long v2 = TestSequence.getNext(stat2);
                this.assertTrue(v2 > last);
                last = v2;
                ++j;
            }
            ++i;
        }
        conn2.close();
        conn.close();
    }

    private void test(String setupSql, String finalError, long ... values) throws SQLException {
        this.deleteDb("sequence");
        Connection conn = this.getConnection("sequence");
        Statement stat = conn.createStatement();
        stat.execute(setupSql);
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("sequence");
        }
        stat = conn.createStatement();
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            this.assertEquals(value, TestSequence.getNext(stat));
            ++n2;
        }
        if (finalError != null) {
            try {
                TestSequence.getNext(stat);
                this.fail("Expected error: " + finalError);
            }
            catch (SQLException e) {
                this.assertContains(e.getMessage(), finalError);
            }
        }
        conn.close();
    }

    private void expectError(Statement stat, String sql, String error) {
        try {
            stat.execute(sql);
            this.fail("Expected error: " + error);
        }
        catch (SQLException e) {
            this.assertContains(e.getMessage(), error);
        }
    }

    private static long getNext(Statement stat) throws SQLException {
        ResultSet rs = stat.executeQuery("call next value for s");
        rs.next();
        long value = rs.getLong(1);
        return value;
    }

    public static class TriggerTest
    implements Trigger {
        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            conn.createStatement().executeQuery("call next value for test_seq");
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        }
    }
}

