/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSessionsLocks
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws Exception {
        this.testCancelStatement();
        this.testLocks();
        this.testAbortStatement();
        this.deleteDb("sessionsLocks");
    }

    private void testLocks() throws SQLException {
        this.deleteDb("sessionsLocks");
        Connection conn = this.getConnection("sessionsLocks");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from information_schema.locks order by session_id");
        this.assertFalse(rs.next());
        Connection conn2 = this.getConnection("sessionsLocks");
        Statement stat2 = conn2.createStatement();
        stat2.execute("create table test(id int primary key, name varchar)");
        conn2.setAutoCommit(false);
        stat2.execute("insert into test values(1, 'Hello')");
        rs = stat.executeQuery("select * from information_schema.locks order by session_id");
        rs.next();
        this.assertEquals("PUBLIC", rs.getString("TABLE_SCHEMA"));
        this.assertEquals("TEST", rs.getString("TABLE_NAME"));
        rs.getString("SESSION_ID");
        this.assertEquals("READ", rs.getString("LOCK_TYPE"));
        this.assertFalse(rs.next());
        conn2.commit();
        conn2.setTransactionIsolation(8);
        stat2.execute("SELECT * FROM TEST");
        rs = stat.executeQuery("select * from information_schema.locks order by session_id");
        this.assertFalse(rs.next());
        conn2.commit();
        rs = stat.executeQuery("select * from information_schema.locks order by session_id");
        this.assertFalse(rs.next());
        conn.close();
        conn2.close();
    }

    private void testCancelStatement() throws Exception {
        this.deleteDb("sessionsLocks");
        Connection conn = this.getConnection("sessionsLocks");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select * from information_schema.sessions order by SESSION_START, SESSION_ID");
        rs.next();
        int sessionId = rs.getInt("SESSION_ID");
        rs.getString("USER_NAME");
        rs.getTimestamp("SESSION_START");
        rs.getString("EXECUTING_STATEMENT");
        rs.getTimestamp("EXECUTING_STATEMENT_START");
        this.assertFalse(rs.next());
        Connection conn2 = this.getConnection("sessionsLocks");
        Statement stat2 = conn2.createStatement();
        rs = stat.executeQuery("select * from information_schema.sessions order by SESSION_START, SESSION_ID");
        this.assertTrue(rs.next());
        this.assertEquals(sessionId, rs.getInt("SESSION_ID"));
        this.assertTrue(rs.next());
        int otherId = rs.getInt("SESSION_ID");
        this.assertTrue(otherId != sessionId);
        this.assertFalse(rs.next());
        stat2.execute("set throttle 1");
        boolean[] done = new boolean[1];
        Runnable runnable = () -> {
            try {
                stat2.execute("select count(*) from system_range(1, 10000000) t1, system_range(1, 10000000) t2");
                new Error("Unexpected success").printStackTrace();
            }
            catch (SQLException e) {
                blArray[0] = true;
            }
        };
        new Thread(runnable).start();
        do {
            Thread.sleep(100L);
            rs = stat.executeQuery("CALL CANCEL_SESSION(" + otherId + ")");
            rs.next();
        } while (!rs.getBoolean(1));
        int i = 0;
        while (i < 20) {
            Thread.sleep(100L);
            if (done[0]) break;
            ++i;
        }
        this.assertTrue(done[0]);
        conn2.close();
        conn.close();
    }

    private void testAbortStatement() throws Exception {
        this.deleteDb("sessionsLocks");
        Connection conn = this.getConnection("sessionsLocks");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select session_id() as ID");
        rs.next();
        int sessionId = rs.getInt("ID");
        Connection conn2 = this.getConnection("sessionsLocks");
        Statement stat2 = conn2.createStatement();
        stat2.execute("create table test(id int primary key, name varchar)");
        conn2.setAutoCommit(false);
        stat2.execute("insert into test values(1, 'Hello')");
        conn2.commit();
        stat2.executeUpdate("update test set name = 'Again' where id = 1");
        rs = stat2.executeQuery("select session_id() as ID");
        rs.next();
        int otherId = rs.getInt("ID");
        this.assertTrue(otherId != sessionId);
        this.assertFalse(rs.next());
        this.assertEquals(1, this.getLockCountForSession(stat, otherId));
        rs = stat.executeQuery("CALL ABORT_SESSION(" + otherId + ")");
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        this.assertEquals(0, this.getLockCountForSession(stat, otherId));
        rs = stat.executeQuery("CALL ABORT_SESSION(" + otherId + ")");
        rs.next();
        this.assertFalse("Session is expected to be already aborted", rs.getBoolean(1));
        this.assertThrows(this.config.networked ? 90067 : 90121, stat2).executeQuery("select count(*) from test");
        conn2.close();
        conn.close();
    }

    private int getLockCountForSession(Statement stmnt, int otherId) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet rs = stmnt.executeQuery("select count(*) from information_schema.locks where session_id = " + otherId);){
            this.assertTrue(rs.next());
            return rs.getInt(1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

