/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestSynonymForTable
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testSelectFromSynonym();
        this.testInsertIntoSynonym();
        this.testInsertWithColumnNameIntoSynonym();
        this.testUpdate();
        this.testDeleteFromSynonym();
        this.testTruncateSynonym();
        this.testExistingTableName();
        this.testCreateForUnknownTable();
        this.testMetaData();
        this.testCreateOrReplace();
        this.testCreateOrReplaceExistingTable();
        this.testSynonymInDifferentSchema();
        this.testReopenDatabase();
        this.testDropSynonym();
        this.testDropTable();
        this.testDropSchema();
    }

    private void testUpdate() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        TestSynonymForTable.insertIntoSynonym(conn, 25);
        Statement stmnt = conn.createStatement();
        this.assertEquals(1, stmnt.executeUpdate("UPDATE testsynonym set id = 30 WHERE id = 25"));
        this.assertSynonymContains(conn, 30);
        conn.close();
    }

    private void testDropSchema() throws SQLException {
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS s1");
        stat.execute("CREATE TABLE IF NOT EXISTS s1.backingtable(id INT PRIMARY KEY)");
        stat.execute("CREATE OR REPLACE SYNONYM testsynonym FOR s1.backingtable");
        stat.execute("DROP SCHEMA s1 CASCADE");
        this.assertThrows(42104, stat).execute("SELECT id FROM testsynonym");
        conn.close();
    }

    private void testDropTable() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE backingtable");
        this.assertThrows(42104, stat).execute("SELECT id FROM testsynonym");
        ResultSet synonyms = conn.createStatement().executeQuery("SELECT * FROM INFORMATION_SCHEMA.SYNONYMS WHERE SYNONYM_NAME='TESTSYNONYM'");
        this.assertFalse(synonyms.next());
        conn.close();
        Connection conn2 = this.getConnection("synonym");
        this.assertThrows(90007, stat).execute("SELECT id FROM testsynonym");
        conn2.close();
    }

    private void testDropSynonym() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP SYNONYM testsynonym");
        this.assertThrows(42102, stat).execute("SELECT id FROM testsynonym");
        stat.execute("DROP SYNONYM IF EXISTS testsynonym");
        this.assertThrows(42102, stat).execute("DROP SYNONYM testsynonym");
        conn.close();
    }

    private void testSynonymInDifferentSchema() throws SQLException {
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS s1");
        stat.execute("CREATE TABLE IF NOT EXISTS s1.backingtable(id INT PRIMARY KEY)");
        stat.execute("TRUNCATE TABLE s1.backingtable");
        stat.execute("CREATE OR REPLACE SYNONYM testsynonym FOR s1.backingtable");
        stat.execute("INSERT INTO s1.backingtable VALUES(15)");
        this.assertSynonymContains(conn, 15);
        conn.close();
    }

    private void testCreateOrReplaceExistingTable() throws SQLException {
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS backingtable(id INT PRIMARY KEY)");
        this.assertThrows(42101, stat).execute("CREATE OR REPLACE SYNONYM backingtable FOR backingtable");
        conn.close();
    }

    private void testCreateOrReplace() throws SQLException {
        this.deleteDb("synonym");
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS backingtable(id INT PRIMARY KEY)");
        stat.execute("CREATE TABLE IF NOT EXISTS backingtable2(id INT PRIMARY KEY)");
        stat.execute("CREATE OR REPLACE SYNONYM testsynonym FOR backingtable");
        TestSynonymForTable.insertIntoBackingTable(conn, 17);
        ResultSet rs = stat.executeQuery("SELECT id FROM testsynonym");
        this.assertTrue(rs.next());
        this.assertEquals(17, rs.getInt(1));
        stat.execute("CREATE OR REPLACE SYNONYM testsynonym FOR backingtable2");
        ResultSet rs2 = stat.executeQuery("SELECT id FROM testsynonym");
        this.assertFalse(rs2.next());
        conn.close();
        this.deleteDb("synonym");
    }

    private void testMetaData() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        ResultSet tables = conn.getMetaData().getTables(null, "PUBLIC", null, new String[]{"SYNONYM"});
        this.assertTrue(tables.next());
        this.assertEquals(tables.getString("TABLE_NAME"), "TESTSYNONYM");
        this.assertEquals(tables.getString("TABLE_TYPE"), "SYNONYM");
        this.assertFalse(tables.next());
        ResultSet columns = conn.getMetaData().getColumns(null, "PUBLIC", "TESTSYNONYM", null);
        this.assertTrue(columns.next());
        this.assertEquals(columns.getString("TABLE_NAME"), "TESTSYNONYM");
        this.assertEquals(columns.getString("COLUMN_NAME"), "ID");
        this.assertFalse(columns.next());
        ResultSet synonyms = conn.createStatement().executeQuery("SELECT * FROM INFORMATION_SCHEMA.SYNONYMS");
        this.assertTrue(synonyms.next());
        this.assertEquals("SYNONYM", synonyms.getString("SYNONYM_CATALOG"));
        this.assertEquals("PUBLIC", synonyms.getString("SYNONYM_SCHEMA"));
        this.assertEquals("TESTSYNONYM", synonyms.getString("SYNONYM_NAME"));
        this.assertEquals("BACKINGTABLE", synonyms.getString("SYNONYM_FOR"));
        this.assertEquals("VALID", synonyms.getString("STATUS"));
        this.assertNull(synonyms.getString("REMARKS"));
        this.assertFalse(synonyms.next());
        conn.close();
    }

    private void testCreateForUnknownTable() throws SQLException {
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        this.assertThrows(42102, stat).execute("CREATE SYNONYM someSynonym FOR nonexistingTable");
        conn.close();
    }

    private void testExistingTableName() throws SQLException {
        Connection conn = this.getConnection("synonym");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS backingtable(id INT PRIMARY KEY)");
        this.assertThrows(42101, stat).execute("CREATE SYNONYM backingtable FOR backingtable");
        conn.close();
    }

    private void testReopenDatabase() throws SQLException {
        if (!this.config.memory) {
            this.deleteDb("synonym");
            Connection conn = this.getConnection("synonym");
            TestSynonymForTable.createTableWithSynonym(conn);
            TestSynonymForTable.insertIntoBackingTable(conn, 9);
            conn.close();
            Connection conn2 = this.getConnection("synonym");
            this.assertSynonymContains(conn2, 9);
            conn2.close();
        }
    }

    private void testTruncateSynonym() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        TestSynonymForTable.insertIntoBackingTable(conn, 7);
        this.assertBackingTableContains(conn, 7);
        conn.createStatement().execute("TRUNCATE TABLE testsynonym");
        this.assertBackingTableIsEmpty(conn);
        conn.close();
    }

    private void testDeleteFromSynonym() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        TestSynonymForTable.insertIntoBackingTable(conn, 7);
        this.assertBackingTableContains(conn, 7);
        TestSynonymForTable.deleteFromSynonym(conn, 7);
        this.assertBackingTableIsEmpty(conn);
        conn.close();
    }

    private static void deleteFromSynonym(Connection conn, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("DELETE FROM testsynonym WHERE id = ?");
        prep.setInt(1, id);
        prep.execute();
    }

    private void assertBackingTableIsEmpty(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT id FROM backingtable");
        this.assertFalse(rs.next());
    }

    private void testInsertIntoSynonym() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        TestSynonymForTable.insertIntoSynonym(conn, 5);
        this.assertBackingTableContains(conn, 5);
        conn.close();
    }

    private void testInsertWithColumnNameIntoSynonym() throws SQLException {
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO testsynonym (id) VALUES(?)");
        prep.setInt(1, 55);
        prep.execute();
        this.assertBackingTableContains(conn, 55);
        conn.close();
    }

    private void assertBackingTableContains(Connection conn, int testValue) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT id FROM backingtable");
        this.assertTrue(rs.next());
        this.assertEquals(testValue, rs.getInt(1));
        this.assertFalse(rs.next());
    }

    private void testSelectFromSynonym() throws SQLException {
        this.deleteDb("synonym");
        Connection conn = this.getConnection("synonym");
        TestSynonymForTable.createTableWithSynonym(conn);
        TestSynonymForTable.insertIntoBackingTable(conn, 1);
        this.assertSynonymContains(conn, 1);
        conn.close();
    }

    private void assertSynonymContains(Connection conn, int id) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT id FROM testsynonym");
        this.assertTrue(rs.next());
        this.assertEquals(id, rs.getInt(1));
        this.assertFalse(rs.next());
    }

    private static void insertIntoSynonym(Connection conn, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("INSERT INTO testsynonym VALUES(?)");
        prep.setInt(1, id);
        prep.execute();
    }

    private static void insertIntoBackingTable(Connection conn, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("INSERT INTO backingtable VALUES(?)");
        prep.setInt(1, id);
        prep.execute();
    }

    private static void createTableWithSynonym(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS backingtable(id INT PRIMARY KEY)");
        stat.execute("CREATE OR REPLACE SYNONYM testsynonym FOR backingtable");
        stat.execute("TRUNCATE TABLE backingtable");
    }
}

