/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public class TestTableEngines
extends TestDb {
    public static void main(String[] a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testAdminPrivileges();
        this.testQueryExpressionFlag();
        this.testSubQueryInfo();
        this.testEngineParams();
        this.testSchemaEngineParams();
        this.testSimpleQuery();
        this.testMultiColumnTreeSetIndex();
    }

    private void testAdminPrivileges() throws SQLException {
        this.deleteDb("tableEngine");
        Connection conn = this.getConnection("tableEngine");
        Statement stat = conn.createStatement();
        stat.execute("CREATE USER U PASSWORD '1'");
        stat.execute("GRANT ALTER ANY SCHEMA TO U");
        Connection connUser = this.getConnection("tableEngine", "U", this.getPassword("1"));
        Statement statUser = connUser.createStatement();
        this.assertThrows(90040, statUser).execute("CREATE TABLE T(ID INT, NAME VARCHAR) ENGINE \"" + EndlessTableEngine.class.getName() + "\"");
        connUser.close();
        conn.close();
        this.deleteDb("tableEngine");
    }

    private void testEngineParams() throws SQLException {
        this.deleteDb("tableEngine");
        Connection conn = this.getConnection("tableEngine");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE t1(id int, name varchar) ENGINE \"" + EndlessTableEngine.class.getName() + "\" WITH \"param1\", \"param2\"");
        this.assertEquals(2, EndlessTableEngine.createTableData.tableEngineParams.size());
        this.assertEquals("param1", EndlessTableEngine.createTableData.tableEngineParams.get(0));
        this.assertEquals("param2", EndlessTableEngine.createTableData.tableEngineParams.get(1));
        stat.execute("CREATE TABLE t2(id int, name varchar) WITH \"param1\", \"param2\"");
        this.assertEquals(2, EndlessTableEngine.createTableData.tableEngineParams.size());
        this.assertEquals("param1", EndlessTableEngine.createTableData.tableEngineParams.get(0));
        this.assertEquals("param2", EndlessTableEngine.createTableData.tableEngineParams.get(1));
        conn.close();
        if (!this.config.memory) {
            EndlessTableEngine.createTableData.tableEngineParams.clear();
            conn = this.getConnection("tableEngine");
            this.assertEquals(2, EndlessTableEngine.createTableData.tableEngineParams.size());
            this.assertEquals("param1", EndlessTableEngine.createTableData.tableEngineParams.get(0));
            this.assertEquals("param2", EndlessTableEngine.createTableData.tableEngineParams.get(1));
            conn.close();
        }
        EndlessTableEngine.createTableData = null;
        this.deleteDb("tableEngine");
    }

    private void testSchemaEngineParams() throws SQLException {
        this.deleteDb("tableEngine");
        Connection conn = this.getConnection("tableEngine");
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA s1 WITH \"param1\", \"param2\"");
        stat.execute("CREATE TABLE s1.t1(id int, name varchar) ENGINE \"" + EndlessTableEngine.class.getName() + "\"");
        this.assertEquals(2, EndlessTableEngine.createTableData.tableEngineParams.size());
        this.assertEquals("param1", EndlessTableEngine.createTableData.tableEngineParams.get(0));
        this.assertEquals("param2", EndlessTableEngine.createTableData.tableEngineParams.get(1));
        conn.close();
        EndlessTableEngine.createTableData = null;
        this.deleteDb("tableEngine");
    }

    private void testSimpleQuery() throws SQLException {
        this.deleteDb("tableEngine");
        Connection conn = this.getConnection("tableEngine");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE t1(id int, name varchar) ENGINE \"" + OneRowTableEngine.class.getName() + "\"");
        this.testStatements(stat);
        stat.close();
        conn.close();
        if (!this.config.memory) {
            conn = this.getConnection("tableEngine");
            stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("SELECT name FROM t1");
            this.assertFalse(rs.next());
            rs.close();
            this.testStatements(stat);
            stat.close();
            conn.close();
        }
        this.deleteDb("tableEngine");
    }

    private void testStatements(Statement stat) throws SQLException {
        this.assertEquals(stat.executeUpdate("INSERT INTO t1 VALUES(2, 'abc')"), 1);
        this.assertEquals(stat.executeUpdate("UPDATE t1 SET name = 'abcdef' WHERE id=2"), 1);
        this.assertEquals(stat.executeUpdate("INSERT INTO t1 VALUES(3, 'abcdefghi')"), 1);
        this.assertEquals(stat.executeUpdate("DELETE FROM t1 WHERE id=2"), 0);
        this.assertEquals(stat.executeUpdate("DELETE FROM t1 WHERE id=3"), 1);
        ResultSet rs = stat.executeQuery("SELECT name FROM t1");
        this.assertFalse(rs.next());
        rs.close();
        this.assertEquals(stat.executeUpdate("INSERT INTO t1 VALUES(2, 'abc')"), 1);
        this.assertEquals(stat.executeUpdate("UPDATE t1 SET name = 'abcdef' WHERE id=2"), 1);
        this.assertEquals(stat.executeUpdate("INSERT INTO t1 VALUES(3, 'abcdefghi')"), 1);
        rs = stat.executeQuery("SELECT name FROM t1");
        this.assertTrue(rs.next());
        this.assertEquals(rs.getString(1), "abcdefghi");
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testMultiColumnTreeSetIndex() throws SQLException {
        this.deleteDb("tableEngine");
        Connection conn = this.getConnection("tableEngine");
        Statement stat = conn.createStatement();
        stat.executeUpdate("CREATE TABLE T(A INT, B VARCHAR, C BIGINT, D BIGINT DEFAULT 0) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.executeUpdate("CREATE INDEX IDX_C_B_A ON T(C, B, A)");
        stat.executeUpdate("CREATE INDEX IDX_B_A ON T(B, A)");
        ArrayList<List<Object>> dataSet = new ArrayList<List<Object>>();
        dataSet.add(Arrays.asList(1, "1", 1L));
        dataSet.add(Arrays.asList(1, "0", 2L));
        dataSet.add(Arrays.asList(2, "0", -1L));
        dataSet.add(Arrays.asList(0, "0", 1L));
        dataSet.add(Arrays.asList(0, "1", null));
        dataSet.add(Arrays.asList(2, null, 0L));
        PreparedStatement prep = conn.prepareStatement("INSERT INTO T(A,B,C) VALUES(?,?,?)");
        for (List list : dataSet) {
            int i = 0;
            while (i < list.size()) {
                prep.setObject(i + 1, list.get(i));
                ++i;
            }
            this.assertEquals(1, prep.executeUpdate());
        }
        prep.close();
        this.checkPlan(stat, "select max(c) from t", "direct lookup");
        this.checkPlan(stat, "select min(c) from t", "direct lookup");
        this.checkPlan(stat, "select count(*) from t", "direct lookup");
        this.checkPlan(stat, "select * from t", "scan");
        this.checkPlan(stat, "select * from t order by c", "IDX_C_B_A");
        this.checkPlan(stat, "select * from t order by c, b", "IDX_C_B_A");
        this.checkPlan(stat, "select * from t order by b", "IDX_B_A");
        this.checkPlan(stat, "select * from t order by b, a", "IDX_B_A");
        this.checkPlan(stat, "select * from t order by b, c", "IDX_B_A");
        this.checkPlan(stat, "select * from t order by a, b", "scan");
        this.checkPlan(stat, "select * from t order by a, c, b", "scan");
        this.checkPlan(stat, "select * from t where b > ''", "IDX_B_A");
        this.checkPlan(stat, "select * from t where a > 0 and b > ''", "IDX_B_A");
        this.checkPlan(stat, "select * from t where b < ''", "IDX_B_A");
        this.checkPlan(stat, "select * from t where b < '' and c < 1", "IDX_C_B_A");
        this.checkPlan(stat, "select * from t where a = 0", "scan");
        this.checkPlan(stat, "select * from t where a > 0 order by c, b", "IDX_C_B_A");
        this.checkPlan(stat, "select * from t where a = 0 and c > 0", "IDX_C_B_A");
        this.checkPlan(stat, "select * from t where a = 0 and b < '0'", "IDX_B_A");
        this.assertEquals(6, ((Number)TestTableEngines.query(stat, "select count(*) from t").get(0).get(0)).intValue());
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by a");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by b");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by c");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by c, a");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by b, a");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by c, b, a");
        this.checkResultsNoOrder(stat, 6, "select * from t", "select * from t order by a, c, b");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by a");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by b");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by c");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by c, a");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by b, a");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by c, b, a");
        this.checkResultsNoOrder(stat, 4, "select * from t where a > 0", "select * from t where a > 0 order by a, c, b");
        this.checkResults(6, dataSet, stat, "select * from t order by a", null, new RowComparator(0));
        this.checkResults(6, dataSet, stat, "select * from t order by a desc", null, new RowComparator(true, 0));
        this.checkResults(6, dataSet, stat, "select * from t order by b, c", null, new RowComparator(1, 2));
        this.checkResults(6, dataSet, stat, "select * from t order by c, a", null, new RowComparator(2, 0));
        this.checkResults(6, dataSet, stat, "select * from t order by b, a", null, new RowComparator(1, 0));
        this.checkResults(6, dataSet, stat, "select * from t order by c, b, a", null, new RowComparator(2, 1, 0));
        this.checkResults(4, dataSet, stat, "select * from t where a > 0", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                return this.getInt(row, 0) > 0;
            }
        }, null);
        this.checkResults(3, dataSet, stat, "select * from t where b = '0'", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                return "0".equals(this.getString(row, 1));
            }
        }, null);
        this.checkResults(5, dataSet, stat, "select * from t where b >= '0'", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                String b = this.getString(row, 1);
                return b != null && b.compareTo("0") >= 0;
            }
        }, null);
        this.checkResults(2, dataSet, stat, "select * from t where b > '0'", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                String b = this.getString(row, 1);
                return b != null && b.compareTo("0") > 0;
            }
        }, null);
        this.checkResults(1, dataSet, stat, "select * from t where b > '0' and c > 0", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                String b = this.getString(row, 1);
                Long c = this.getLong(row, 2);
                return b != null && b.compareTo("0") > 0 && c != null && c > 0L;
            }
        }, null);
        this.checkResults(1, dataSet, stat, "select * from t where b > '0' and c < 2", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                String b = this.getString(row, 1);
                Long c = this.getLong(row, 2);
                return b != null && b.compareTo("0") > 0 && c != null && c < 2L;
            }
        }, null);
        this.checkResults(2, dataSet, stat, "select * from t where b > '0' and a < 2", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                Integer a = this.getInt(row, 0);
                String b = this.getString(row, 1);
                return b != null && b.compareTo("0") > 0 && a != null && a < 2;
            }
        }, null);
        this.checkResults(1, dataSet, stat, "select * from t where b > '0' and a > 0", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                Integer a = this.getInt(row, 0);
                String b = this.getString(row, 1);
                return b != null && b.compareTo("0") > 0 && a != null && a > 0;
            }
        }, null);
        this.checkResults(2, dataSet, stat, "select * from t where b = '0' and a > 0", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                Integer a = this.getInt(row, 0);
                String b = this.getString(row, 1);
                return "0".equals(b) && a != null && a > 0;
            }
        }, null);
        this.checkResults(2, dataSet, stat, "select * from t where b = '0' and a < 2", new RowFilter(){

            @Override
            protected boolean accept(List<Object> row) {
                Integer a = this.getInt(row, 0);
                String b = this.getString(row, 1);
                return "0".equals(b) && a != null && a < 2;
            }
        }, null);
        conn.close();
        this.deleteDb("tableEngine");
    }

    private void testQueryExpressionFlag() throws SQLException {
        this.deleteDb("testQueryExpressionFlag");
        Connection conn = this.getConnection("testQueryExpressionFlag");
        Statement stat = conn.createStatement();
        stat.execute("create table QUERY_EXPR_TEST(id int) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.execute("create table QUERY_EXPR_TEST_NO(id int) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.executeQuery("select 1 + (select 1 from QUERY_EXPR_TEST)").next();
        stat.executeQuery("select 1 from QUERY_EXPR_TEST_NO where id in (select id from QUERY_EXPR_TEST)");
        stat.executeQuery("select 1 from QUERY_EXPR_TEST_NO n where exists(select 1 from QUERY_EXPR_TEST y where y.id = n.id)");
        conn.close();
        this.deleteDb("testQueryExpressionFlag");
    }

    private void testSubQueryInfo() throws SQLException {
        this.deleteDb("testSubQueryInfo");
        Connection conn = this.getConnection("testSubQueryInfo");
        Statement stat = conn.createStatement();
        stat.execute("create table SUB_QUERY_TEST(id int primary key, name varchar) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.executeQuery("select * from (select t2.id from (select t3.id from sub_query_test t3 where t3.name = '') t4, sub_query_test t2 where t2.id = t4.id) t5").next();
        stat.execute("create view t4 as (select t3.id from sub_query_test t3 where t3.name = '')");
        stat.executeQuery("select * from (select t2.id from t4, sub_query_test t2 where t2.id = t4.id) t5").next();
        stat.execute("create view t5 as (select t2.id from t4, sub_query_test t2 where t2.id = t4.id)");
        stat.executeQuery("select * from t5").next();
        stat.execute("create table EXPR_TEST(id int) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.executeQuery("select * from (select (select id from EXPR_TEST x limit 1) a from dual where 1 = (select id from EXPR_TEST y limit 1)) z").next();
        stat.execute("create table EXPR_TEST2(id int) ENGINE \"" + TreeSetIndexTableEngine.class.getName() + "\"");
        stat.executeQuery("select * from (select (select 1 from (select (select 2 from EXPR_TEST) from EXPR_TEST2) ZZ) from dual)").next();
        stat.execute("create table test_plan(id int primary key, name varchar)");
        stat.execute("create index MY_NAME_INDEX on test_plan(name)");
        this.checkPlan(stat, "select * from (select (select id from test_plan where name = 'z') from dual)", "MY_NAME_INDEX");
        conn.close();
        this.deleteDb("testSubQueryInfo");
    }

    static void assert0(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    private void checkResultsNoOrder(Statement stat, int size, String query1, String query2) throws SQLException {
        List<List<Object>> res1 = TestTableEngines.query(stat, query1);
        List<List<Object>> res2 = TestTableEngines.query(stat, query2);
        if (size != res1.size() || size != res2.size()) {
            this.fail("Wrong size: \n" + String.valueOf(res1) + "\n" + String.valueOf(res2));
        }
        if (size == 0) {
            return;
        }
        int[] cols = new int[res1.get(0).size()];
        int i = 0;
        while (i < cols.length) {
            cols[i] = i;
            ++i;
        }
        RowComparator comp = new RowComparator(cols);
        res1.sort(comp);
        res2.sort(comp);
        this.assertTrue("Wrong data: \n" + String.valueOf(res1) + "\n" + String.valueOf(res2), res1.equals(res2));
    }

    private void checkResults(int size, List<List<Object>> dataSet, Statement stat, String query, RowFilter filter, RowComparator sort) throws SQLException {
        List<List<Object>> res1 = TestTableEngines.query(stat, query);
        List<List<Object>> res2 = TestTableEngines.query(dataSet, filter, sort);
        this.assertTrue("Wrong size: " + size + " \n" + String.valueOf(res1) + "\n" + String.valueOf(res2), res1.size() == size && res2.size() == size);
        this.assertTrue(filter != null || sort != null);
        int i = 0;
        while (i < res1.size()) {
            List<Object> row1 = res1.get(i);
            List<Object> row2 = res2.get(i);
            this.assertTrue("Filter failed on row " + i + " of \n" + String.valueOf(res1) + "\n" + String.valueOf(res2), filter == null || filter.accept(row1));
            this.assertTrue("Sort failed on row " + i + " of \n" + String.valueOf(res1) + "\n" + String.valueOf(res2), sort == null || sort.compare(row1, row2) == 0);
            ++i;
        }
    }

    private static List<List<Object>> query(List<List<Object>> dataSet, RowFilter filter, RowComparator sort) {
        ArrayList<List<Object>> res = new ArrayList<List<Object>>();
        if (filter == null) {
            res.addAll(dataSet);
        } else {
            for (List<Object> row : dataSet) {
                if (!filter.accept(row)) continue;
                res.add(row);
            }
        }
        if (sort != null) {
            res.sort(sort);
        }
        return res;
    }

    private static List<List<Object>> query(Statement stat, String query) throws SQLException {
        ResultSet rs = stat.executeQuery(query);
        int cols = rs.getMetaData().getColumnCount();
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>(cols);
            int i = 1;
            while (i <= cols) {
                row.add(rs.getObject(i));
                ++i;
            }
            list.add(row);
        }
        rs.close();
        return list;
    }

    private void checkPlan(Statement stat, String query, String index) throws SQLException {
        String plan = TestTableEngines.query(stat, "EXPLAIN " + query).get(0).get(0).toString();
        this.assertTrue("Index '" + index + "' is not used in query plan: " + plan, plan.contains(index));
    }

    public static class EndlessTableEngine
    implements TableEngine {
        public static CreateTableData createTableData;

        @Override
        public EndlessTable createTable(CreateTableData data) {
            createTableData = data;
            return new EndlessTable(data);
        }

        private static class EndlessTable
        extends OneRowTableEngine.OneRowTable {
            EndlessTable(CreateTableData data) {
                super(data);
                this.row = Row.get(new Value[]{ValueInteger.get(1), ValueNull.INSTANCE}, 0);
                this.scanIndex = new Auto((Table)this);
            }

            public class Auto
            extends OneRowTableEngine.OneRowTable.Scan {
                Auto(Table table) {
                    super(table);
                }

                @Override
                public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
                    return new SingleRowCursor(EndlessTable.this.row);
                }
            }
        }
    }

    private static class IteratorCursor
    implements Cursor {
        Iterator<SearchRow> it;
        private Row current;

        IteratorCursor(Iterator<SearchRow> it) {
            this.it = it;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("prev");
        }

        @Override
        public boolean next() {
            if (this.it.hasNext()) {
                this.current = (Row)this.it.next();
                return true;
            }
            this.current = null;
            return false;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public Row get() {
            return this.current;
        }

        public String toString() {
            return "IteratorCursor->" + String.valueOf(this.current);
        }
    }

    public static class OneRowTableEngine
    implements TableEngine {
        @Override
        public OneRowTable createTable(CreateTableData data) {
            return new OneRowTable(data);
        }

        private static class OneRowTable
        extends TableBase {
            protected Index scanIndex = new Scan(this);
            volatile Row row;

            OneRowTable(CreateTableData data) {
                super(data);
            }

            @Override
            public Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
                return null;
            }

            @Override
            public void addRow(SessionLocal session, Row r) {
                this.row = r;
            }

            @Override
            public boolean canDrop() {
                return true;
            }

            @Override
            public boolean canGetRowCount(SessionLocal session) {
                return true;
            }

            @Override
            public void checkSupportAlter() {
            }

            @Override
            public void close(SessionLocal session) {
            }

            @Override
            public ArrayList<Index> getIndexes() {
                return null;
            }

            @Override
            public long getMaxDataModificationId() {
                return 0L;
            }

            @Override
            public long getRowCount(SessionLocal session) {
                return this.getRowCountApproximation(session);
            }

            @Override
            public long getRowCountApproximation(SessionLocal session) {
                return this.row == null ? 0 : 1;
            }

            @Override
            public Index getScanIndex(SessionLocal session) {
                return this.scanIndex;
            }

            @Override
            public TableType getTableType() {
                return TableType.EXTERNAL_TABLE_ENGINE;
            }

            @Override
            public boolean isDeterministic() {
                return false;
            }

            @Override
            public void removeRow(SessionLocal session, Row r) {
                this.row = null;
            }

            @Override
            public long truncate(SessionLocal session) {
                long result = this.row != null ? 1L : 0L;
                this.row = null;
                return result;
            }

            public class Scan
            extends Index {
                Scan(Table table) {
                    super(table, table.getId(), table.getName() + "_SCAN", IndexColumn.wrap(table.getColumns()), 0, IndexType.createScan(false));
                }

                @Override
                public long getRowCountApproximation(SessionLocal session) {
                    return this.table.getRowCountApproximation(session);
                }

                @Override
                public long getDiskSpaceUsed() {
                    return this.table.getDiskSpaceUsed(false);
                }

                @Override
                public long getRowCount(SessionLocal session) {
                    return this.table.getRowCount(session);
                }

                @Override
                public void truncate(SessionLocal session) {
                }

                @Override
                public void remove(SessionLocal session) {
                }

                @Override
                public void remove(SessionLocal session, Row r) {
                }

                @Override
                public boolean needRebuild() {
                    return false;
                }

                @Override
                public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
                    return 0.0;
                }

                @Override
                public Cursor findFirstOrLast(SessionLocal session, boolean first) {
                    return new SingleRowCursor(OneRowTable.this.row);
                }

                @Override
                public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
                    return new SingleRowCursor(OneRowTable.this.row);
                }

                @Override
                public void close(SessionLocal session) {
                }

                @Override
                public boolean canGetFirstOrLast() {
                    return true;
                }

                @Override
                public void add(SessionLocal session, Row r) {
                }
            }
        }
    }

    private static class RowComparator
    implements Comparator<List<Object>> {
        private int[] cols;
        private boolean descending;

        RowComparator(int ... cols) {
            this.descending = false;
            this.cols = cols;
        }

        RowComparator(boolean descending, int ... cols) {
            this.descending = descending;
            this.cols = cols;
        }

        @Override
        public int compare(List<Object> row1, List<Object> row2) {
            int i = 0;
            while (i < this.cols.length) {
                int col = this.cols[i];
                Comparable o1 = (Comparable)row1.get(col);
                Comparable o2 = (Comparable)row2.get(col);
                if (o1 == null) {
                    return this.applyDescending(o2 == null ? 0 : -1);
                }
                if (o2 == null) {
                    return this.applyDescending(1);
                }
                int res = o1.compareTo(o2);
                if (res != 0) {
                    return this.applyDescending(res);
                }
                ++i;
            }
            return 0;
        }

        private int applyDescending(int v) {
            if (!this.descending) {
                return v;
            }
            if (v == 0) {
                return v;
            }
            return -v;
        }
    }

    static abstract class RowFilter {
        RowFilter() {
        }

        protected abstract boolean accept(List<Object> var1);

        protected Integer getInt(List<Object> row, int col) {
            return (Integer)row.get(col);
        }

        protected Long getLong(List<Object> row, int col) {
            return (Long)row.get(col);
        }

        protected String getString(List<Object> row, int col) {
            return (String)row.get(col);
        }
    }

    private static class TreeSetIndex
    extends Index
    implements Comparator<SearchRow> {
        final TreeSet<SearchRow> set = new TreeSet<SearchRow>(this);

        TreeSetIndex(Table t, String name, IndexColumn[] cols, IndexType type) {
            super(t, 0, name, cols, 0, type);
        }

        @Override
        public int compare(SearchRow o1, SearchRow o2) {
            int res = this.compareRows(o1, o2);
            if (res == 0) {
                if (o1.getKey() == Long.MAX_VALUE || o2.getKey() == Long.MIN_VALUE) {
                    res = 1;
                } else if (o1.getKey() == Long.MIN_VALUE || o2.getKey() == Long.MAX_VALUE) {
                    res = -1;
                }
            }
            return res;
        }

        @Override
        public void close(SessionLocal session) {
        }

        @Override
        public void add(SessionLocal session, Row row) {
            this.set.add(row);
        }

        @Override
        public void remove(SessionLocal session, Row row) {
            this.set.remove(row);
        }

        private static SearchRow mark(SearchRow row, boolean first) {
            if (row != null) {
                row.setKey(first ? Long.MIN_VALUE : Long.MAX_VALUE);
            }
            return row;
        }

        @Override
        public Cursor find(SessionLocal session, SearchRow first, SearchRow last, boolean reverse) {
            NavigableSet<Object> subSet;
            if (reverse) {
                SearchRow temp = first;
                first = last;
                last = temp;
            }
            if (first != null && last != null && this.compareRows(last, first) < 0) {
                subSet = Collections.emptyNavigableSet();
            } else {
                if (first != null) {
                    first = this.set.floor(TreeSetIndex.mark(first, true));
                }
                if (last != null) {
                    last = this.set.ceiling(TreeSetIndex.mark(last, false));
                }
                if (first == null && last == null) {
                    subSet = this.set;
                } else if (first != null) {
                    subSet = last != null ? this.set.subSet(first, true, last, true) : this.set.tailSet(first, true);
                } else if (last != null) {
                    subSet = this.set.headSet(last, true);
                } else {
                    throw new IllegalStateException();
                }
                if (reverse) {
                    subSet = subSet.descendingSet();
                }
            }
            return new IteratorCursor(subSet.iterator());
        }

        @Override
        public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
            return this.getCostRangeIndex(masks, this.set.size(), filters, filter, sortOrder, false, allColumnsSet);
        }

        @Override
        public void remove(SessionLocal session) {
        }

        @Override
        public void truncate(SessionLocal session) {
            this.set.clear();
        }

        @Override
        public boolean canGetFirstOrLast() {
            return true;
        }

        @Override
        public Cursor findFirstOrLast(SessionLocal session, boolean first) {
            return this.set.isEmpty() ? SingleRowCursor.EMPTY : new SingleRowCursor((Row)(first ? this.set.first() : this.set.last()));
        }

        @Override
        public boolean needRebuild() {
            return true;
        }

        @Override
        public long getRowCount(SessionLocal session) {
            return this.set.size();
        }

        @Override
        public long getRowCountApproximation(SessionLocal session) {
            return this.getRowCount(null);
        }
    }

    public static class TreeSetIndexTableEngine
    implements TableEngine {
        static TreeSetTable created;

        @Override
        public Table createTable(CreateTableData data) {
            created = new TreeSetTable(data);
            return created;
        }
    }

    private static class TreeSetTable
    extends TableBase {
        int dataModificationId;
        ArrayList<Index> indexes;
        TreeSetIndex scan = new TreeSetIndex(this, "scan", IndexColumn.wrap(this.getColumns()), IndexType.createScan(false)){

            @Override
            public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
                return this.getCostRangeIndex(masks, this.getRowCount(session), filters, filter, sortOrder, true, allColumnsSet);
            }
        };

        TreeSetTable(CreateTableData data) {
            super(data);
        }

        @Override
        public long truncate(SessionLocal session) {
            long result = this.getRowCountApproximation(session);
            if (this.indexes != null) {
                for (Index index : this.indexes) {
                    index.truncate(session);
                }
            } else {
                this.scan.truncate(session);
            }
            ++this.dataModificationId;
            return result;
        }

        @Override
        public void removeRow(SessionLocal session, Row row) {
            if (this.indexes != null) {
                for (Index index : this.indexes) {
                    index.remove(session, row);
                }
            } else {
                this.scan.remove(session, row);
            }
            ++this.dataModificationId;
        }

        @Override
        public void addRow(SessionLocal session, Row row) {
            if (this.indexes != null) {
                for (Index index : this.indexes) {
                    index.add(session, row);
                }
            } else {
                this.scan.add(session, row);
            }
            ++this.dataModificationId;
        }

        @Override
        public Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
            if (this.indexes == null) {
                this.indexes = new ArrayList(2);
                this.indexes.add(this.scan);
            }
            TreeSetIndex index = new TreeSetIndex(this, indexName, cols, indexType);
            for (SearchRow row : this.scan.set) {
                ((Index)index).add(session, (Row)row);
            }
            this.indexes.add(index);
            ++this.dataModificationId;
            this.setModified();
            return index;
        }

        @Override
        public boolean isDeterministic() {
            return false;
        }

        @Override
        public TableType getTableType() {
            return TableType.EXTERNAL_TABLE_ENGINE;
        }

        @Override
        public Index getScanIndex(SessionLocal session) {
            return this.scan;
        }

        @Override
        public long getRowCountApproximation(SessionLocal session) {
            return this.getScanIndex(null).getRowCountApproximation(session);
        }

        @Override
        public long getRowCount(SessionLocal session) {
            return this.scan.getRowCount(session);
        }

        @Override
        public long getMaxDataModificationId() {
            return this.dataModificationId;
        }

        @Override
        public ArrayList<Index> getIndexes() {
            return this.indexes;
        }

        @Override
        public void close(SessionLocal session) {
        }

        @Override
        public void checkSupportAlter() {
        }

        @Override
        public boolean canGetRowCount(SessionLocal session) {
            return true;
        }

        @Override
        public boolean canDrop() {
            return true;
        }
    }
}

