/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.engine.Session;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestTempTables
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("tempTables");
        this.testAnalyzeReuseObjectId();
        this.testTempSequence();
        this.testTempFileResultSet();
        this.testTempTableResultSet();
        this.testTransactionalTemp();
        Connection c1 = this.getConnection("tempTables");
        this.testAlter(c1);
        Connection c2 = this.getConnection("tempTables");
        TestTempTables.testConstraints(c1, c2);
        this.testTables(c1, c2);
        TestTempTables.testIndexes(c1, c2);
        c1.close();
        c2.close();
        this.testLotsOfTables();
        this.testCreateAsSelectDistinct();
        this.deleteDb("tempTables");
    }

    private void testAnalyzeReuseObjectId() throws SQLException {
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables");
        Statement stat = conn.createStatement();
        stat.execute("create local temporary table test(id identity)");
        PreparedStatement prep = conn.prepareStatement("insert into test default values");
        int i = 0;
        while (i < 10000) {
            prep.execute();
            ++i;
        }
        stat.execute("create local temporary table test2(id identity) as select x from system_range(1, 10)");
        conn.close();
    }

    private void testTempSequence() throws SQLException {
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables");
        Statement stat = conn.createStatement();
        stat.execute("create local temporary table test(id identity)");
        Session iface = ((JdbcConnection)conn).getSession();
        if (iface instanceof SessionLocal) {
            this.assertEquals(1, ((SessionLocal)iface).getDatabase().getMainSchema().getAllSequences().size());
        }
        stat.execute("insert into test default values");
        stat.execute("shutdown");
        conn.close();
        conn = this.getConnection("tempTables");
        iface = ((JdbcConnection)conn).getSession();
        if (iface instanceof SessionLocal) {
            this.assertEquals(0, ((SessionLocal)iface).getDatabase().getMainSchema().getAllSequences().size());
        }
        conn.close();
    }

    private void testTempFileResultSet() throws SQLException {
        if (this.config.lazy) {
            return;
        }
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables;MAX_MEMORY_ROWS=10");
        Statement stat1 = conn.createStatement(1004, 1007);
        Statement stat2 = conn.createStatement(1004, 1007);
        ResultSet rs1 = stat1.executeQuery("select * from system_range(1, 20)");
        ResultSet rs2 = stat2.executeQuery("select * from system_range(1, 20)");
        int i = 0;
        while (i < 20) {
            this.assertTrue(rs1.next());
            this.assertTrue(rs2.next());
            this.assertEquals(i + 1, rs1.getInt(1));
            this.assertEquals(i + 1, rs2.getInt(1));
            ++i;
        }
        rs2.close();
        rs1.beforeFirst();
        i = 0;
        while (i < 20) {
            rs1.next();
            rs1.getInt(1);
            ++i;
        }
        rs1.close();
        rs1 = stat1.executeQuery("select * from system_range(1, 20) order by x desc");
        rs2 = stat2.executeQuery("select * from system_range(1, 20) order by x desc");
        i = 0;
        while (i < 20) {
            rs1.next();
            rs2.next();
            rs1.getInt(1);
            rs2.getInt(1);
            ++i;
        }
        rs1.close();
        rs2.beforeFirst();
        i = 0;
        while (i < 20) {
            rs2.next();
            rs2.getInt(1);
            ++i;
        }
        rs2.close();
        conn.close();
    }

    private void testTempTableResultSet() throws SQLException {
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables;MAX_MEMORY_ROWS=10");
        Statement stat1 = conn.createStatement(1004, 1007);
        Statement stat2 = conn.createStatement(1004, 1007);
        ResultSet rs1 = stat1.executeQuery("select distinct * from system_range(1, 20)");
        ResultSet rs2 = stat2.executeQuery("select distinct * from system_range(1, 20)");
        int i = 0;
        while (i < 20) {
            rs1.next();
            rs2.next();
            rs1.getInt(1);
            rs2.getInt(1);
            ++i;
        }
        rs2.close();
        rs1.beforeFirst();
        i = 0;
        while (i < 20) {
            rs1.next();
            rs1.getInt(1);
            ++i;
        }
        rs1.close();
        rs1 = stat1.executeQuery("select distinct * from system_range(1, 20)");
        rs2 = stat2.executeQuery("select distinct * from system_range(1, 20)");
        i = 0;
        while (i < 20) {
            rs1.next();
            rs2.next();
            rs1.getInt(1);
            rs2.getInt(1);
            ++i;
        }
        rs1.close();
        rs2.beforeFirst();
        i = 0;
        while (i < 20) {
            rs2.next();
            rs2.getInt(1);
            ++i;
        }
        rs2.close();
        conn.close();
    }

    private void testTransactionalTemp() throws SQLException {
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(1)");
        stat.execute("commit");
        stat.execute("insert into test values(2)");
        stat.execute("create local temporary table temp(id int primary key, name varchar, constraint x unique(name)) transactional");
        stat.execute("insert into temp values(3, 'test')");
        stat.execute("rollback");
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        stat.execute("drop table temp");
        conn.close();
    }

    private void testAlter(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("create temporary table test(id varchar)");
        stat.execute("create index idx1 on test(id)");
        stat.execute("drop index idx1");
        stat.execute("create index idx1 on test(id)");
        stat.execute("insert into test select x from system_range(1, 10)");
        this.assertThrows(50100, stat).execute("alter table test add column x int");
        stat.execute("drop table test");
    }

    private static void testConstraints(Connection conn1, Connection conn2) throws SQLException {
        Statement s1 = conn1.createStatement();
        Statement s2 = conn2.createStatement();
        s1.execute("create local temporary table test(id int unique)");
        s2.execute("create local temporary table test(id int unique)");
        s1.execute("alter table test add constraint a unique(id)");
        s2.execute("alter table test add constraint a unique(id)");
        s1.execute("drop table test");
        s2.execute("drop table test");
    }

    private static void testIndexes(Connection conn1, Connection conn2) throws SQLException {
        conn1.createStatement().executeUpdate("create local temporary table test(id int)");
        conn1.createStatement().executeUpdate("create index idx_id on test(id)");
        conn2.createStatement().executeUpdate("create local temporary table test(id int)");
        conn2.createStatement().executeUpdate("create index idx_id on test(id)");
        conn2.createStatement().executeUpdate("drop index idx_id");
        conn2.createStatement().executeUpdate("drop table test");
        conn2.createStatement().executeUpdate("create table test(id int)");
        conn2.createStatement().executeUpdate("create index idx_id on test(id)");
        conn1.createStatement().executeUpdate("drop table test");
        conn1.createStatement().executeUpdate("drop table test");
    }

    private void testTables(Connection c1, Connection c2) throws SQLException {
        Statement s1 = c1.createStatement();
        Statement s2 = c2.createStatement();
        s1.execute("CREATE LOCAL TEMPORARY TABLE LT(A INT)");
        s1.execute("CREATE GLOBAL TEMPORARY TABLE GT1(ID INT)");
        s2.execute("CREATE GLOBAL TEMPORARY TABLE GT2(ID INT)");
        s2.execute("CREATE LOCAL TEMPORARY TABLE LT(B INT)");
        s2.execute("SELECT B FROM LT");
        s1.execute("SELECT A FROM LT");
        s1.execute("SELECT * FROM GT1");
        s2.execute("SELECT * FROM GT1");
        s1.execute("SELECT * FROM GT2");
        s2.execute("SELECT * FROM GT2");
        s2.execute("DROP TABLE GT1");
        s2.execute("DROP TABLE GT2");
        s2.execute("DROP TABLE LT");
        s1.execute("DROP TABLE LT");
        c1.setAutoCommit(false);
        s1.execute("create local temporary table test_temp(id int) on commit delete rows");
        s1.execute("insert into test_temp values(1)");
        ResultSet rs = s1.executeQuery("select * from test_temp");
        this.assertResultRowCount(1, rs);
        c1.commit();
        rs = s1.executeQuery("select * from test_temp");
        this.assertResultRowCount(0, rs);
        s1.execute("drop table test_temp");
        s1.execute("create local temporary table test_temp(id int) on commit drop");
        s1.execute("insert into test_temp values(1)");
        rs = s1.executeQuery("select * from test_temp");
        this.assertResultRowCount(1, rs);
        c1.commit();
        this.assertThrows(42104, s1).executeQuery("select * from test_temp");
    }

    private void testLotsOfTables() throws SQLException {
        if (this.config.networked || this.config.throttle > 0) {
            return;
        }
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables");
        Statement stat = conn.createStatement();
        int i = 0;
        while (i < 100000) {
            stat.executeUpdate("create local temporary table t(id int)");
            stat.executeUpdate("drop table t");
            ++i;
        }
        conn.close();
    }

    private void testCreateAsSelectDistinct() throws SQLException {
        this.deleteDb("tempTables");
        Connection conn = this.getConnection("tempTables;MAX_MEMORY_ROWS=1000");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE ONE(S1 VARCHAR(255), S2 VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("insert into one values(?,?)");
        int row = 0;
        while (row < 10000) {
            prep.setString(1, "abc");
            prep.setString(2, "def" + row);
            prep.execute();
            ++row;
        }
        stat.execute("CREATE TABLE TWO AS SELECT DISTINCT * FROM ONE ORDER BY S1");
        conn.close();
    }
}

