/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestTransaction
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase init = TestBase.createCaller().init();
        init.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testClosingConnectionWithSessionTempTable();
        this.testClosingConnectionWithLockedTable();
        this.testConstraintCreationRollback();
        this.testCommitOnAutoCommitChange();
        this.testConcurrentSelectForUpdate();
        this.testRollback();
        this.testRollback2();
        this.testForUpdate();
        this.testForUpdate2();
        this.testForUpdate3();
        this.testForUpdate4();
        this.testUpdate();
        this.testMergeUsing();
        this.testDelete();
        this.testSetTransaction();
        this.testReferential();
        this.testSavepoint();
        this.testIsolation();
        this.testIsolationLevels();
        this.testIsolationLevels2();
        this.testIsolationLevels3();
        this.testIsolationLevels4();
        this.testIsolationLevelsCountAggregate();
        this.testIsolationLevelsCountAggregate2();
        this.testIsolationLevelsMetadata();
        this.deleteDb("transaction");
    }

    private void testConstraintCreationRollback() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int unique, p int)");
        stat.execute("insert into test values(1, 2)");
        this.assertThrows(23506, stat).execute("alter table test add constraint fail foreign key(p) references test(id)");
        stat.execute("insert into test values(2, 3)");
        stat.execute("drop table test");
        conn.close();
    }

    private void testCommitOnAutoCommitChange() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key)");
        Connection conn2 = this.getConnection("transaction");
        Statement stat2 = conn2.createStatement();
        conn.setAutoCommit(false);
        stat.execute("insert into test values(1)");
        conn.setAutoCommit(false);
        ResultSet rs = stat2.executeQuery("select count(*) from test");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        conn.setAutoCommit(true);
        rs = stat2.executeQuery("select * from test");
        this.assertTrue(rs.next());
        stat.execute("drop table test");
        conn2.close();
        conn.close();
    }

    private void testConcurrentSelectForUpdate() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create table test2(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        stat.execute("insert into test2 values(1, 'A'), (2, 'B')");
        conn.commit();
        this.testConcurrentSelectForUpdateImpl(conn, "*");
        this.testConcurrentSelectForUpdateImpl(conn, "*, count(*) over ()");
        conn.close();
    }

    private void testConcurrentSelectForUpdateImpl(Connection conn, String expressions) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("select * from test for update");
        prep.execute();
        Connection conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        this.assertThrows(50200, conn2.createStatement()).execute("select " + expressions + " from test for update");
        conn2.close();
        conn.commit();
        prep = conn.prepareStatement("select " + expressions + " from test join test2 on test.id = test2.id for update");
        prep.execute();
        conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        this.assertThrows(50200, conn2.createStatement()).execute("select * from test for update");
        this.assertThrows(50200, conn2.createStatement()).execute("select * from test2 for update");
        conn2.close();
        conn.commit();
    }

    private void testForUpdate() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test values(1, 'Hello'), (2, 'World')");
        conn.commit();
        PreparedStatement prep = conn.prepareStatement("select * from test where id = 1 for update");
        prep.execute();
        conn.commit();
        prep.execute();
        Connection conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        Statement stat2 = conn2.createStatement();
        stat2.execute("update test set name = 'Welt' where id = 2");
        this.assertThrows(50200, stat2).execute("update test set name = 'Hallo' where id = 1");
        conn2.close();
        conn.close();
    }

    private void testForUpdate2() throws Exception {
        if (this.config.networked || this.config.cipher != null) {
            return;
        }
        this.deleteDb("transaction");
        Connection conn1 = this.getConnection("transaction");
        Connection conn2 = this.getConnection("transaction");
        Statement stat1 = conn1.createStatement();
        stat1.execute("CREATE TABLE TEST (ID INT PRIMARY KEY, V INT)");
        conn1.setAutoCommit(false);
        conn2.createStatement().execute("SET LOCK_TIMEOUT 2000");
        this.testForUpdate2(conn1, stat1, conn2, false);
        this.testForUpdate2(conn1, stat1, conn2, true);
        conn1.close();
        conn2.close();
    }

    private void testForUpdate2(Connection conn1, Statement stat1, Connection conn2, boolean forUpdate) throws Exception {
        this.testForUpdate2(conn1, stat1, conn2, forUpdate, false);
        this.testForUpdate2(conn1, stat1, conn2, forUpdate, true);
    }

    private void testForUpdate2(Connection conn1, Statement stat1, Connection conn2, boolean forUpdate, boolean window) throws Exception {
        this.testForUpdate2(conn1, stat1, conn2, forUpdate, window, false, false);
        this.testForUpdate2(conn1, stat1, conn2, forUpdate, window, false, true);
        this.testForUpdate2(conn1, stat1, conn2, forUpdate, window, true, false);
    }

    private void testForUpdate2(Connection conn1, Statement stat1, final Connection conn2, boolean forUpdate, boolean window, boolean deleted, boolean excluded) throws Exception {
        stat1.execute("MERGE INTO TEST KEY(ID) VALUES (1, 1)");
        conn1.commit();
        stat1.execute(deleted ? "DELETE FROM TEST WHERE ID = 1" : "UPDATE TEST SET V = 2 WHERE ID = 1");
        final int[] res = new int[1];
        final Exception[] ex = new Exception[1];
        StringBuilder builder = new StringBuilder("SELECT V");
        if (window) {
            builder.append(", RANK() OVER (ORDER BY ID)");
        }
        builder.append(" FROM TEST WHERE ID = 1");
        if (excluded) {
            builder.append(" AND V = 1");
        }
        if (forUpdate) {
            builder.append(" FOR UPDATE");
        }
        String query = builder.toString();
        final PreparedStatement prep2 = conn2.prepareStatement(query);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet resultSet = prep2.executeQuery();
                    res[0] = resultSet.next() ? resultSet.getInt(1) : -1;
                    conn2.commit();
                }
                catch (SQLException e) {
                    ex[0] = e;
                }
            }
        };
        t.start();
        Thread.sleep(500L);
        conn1.commit();
        t.join();
        if (ex[0] != null) {
            throw ex[0];
        }
        this.assertEquals(forUpdate ? (deleted || excluded ? -1 : 2) : 1, res[0]);
    }

    private void testForUpdate3() throws Exception {
        if (this.config.networked || this.config.cipher != null) {
            return;
        }
        this.deleteDb("transaction");
        Connection conn1 = this.getConnection("transaction");
        final Connection conn2 = this.getConnection("transaction");
        Statement stat1 = conn1.createStatement();
        stat1.execute("CREATE TABLE TEST (ID INT PRIMARY KEY, V INT UNIQUE)");
        conn1.setAutoCommit(false);
        conn2.createStatement().execute("SET LOCK_TIMEOUT 2000");
        stat1.execute("MERGE INTO TEST KEY(ID) VALUES (1, 1), (2, 2), (3, 3), (4, 4)");
        conn1.commit();
        stat1.execute("UPDATE TEST SET V = 10 - V");
        final Exception[] ex = new Exception[1];
        StringBuilder builder = new StringBuilder("SELECT V FROM TEST ORDER BY V FOR UPDATE");
        String query = builder.toString();
        final PreparedStatement prep2 = conn2.prepareStatement(query);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet resultSet = prep2.executeQuery();
                    int previous = -1;
                    while (resultSet.next()) {
                        int value = resultSet.getInt(1);
                        TestTransaction.this.assertTrue(previous + ">=" + value, previous < value);
                        previous = value;
                    }
                    conn2.commit();
                }
                catch (SQLException e) {
                    ex[0] = e;
                }
            }
        };
        t.start();
        Thread.sleep(500L);
        conn1.commit();
        t.join();
        if (ex[0] != null) {
            throw ex[0];
        }
        conn1.close();
        conn2.close();
    }

    private void testForUpdate4() throws Exception {
        this.deleteDb("transaction");
        Connection conn1 = this.getConnection("transaction");
        Connection conn2 = this.getConnection("transaction");
        Statement stat1 = conn1.createStatement();
        Statement stat2 = conn2.createStatement();
        stat1.execute("CREATE TABLE TEST(ID BIGINT GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V INT)");
        stat1.execute("INSERT INTO TEST(V) VALUES 1, 2, 3");
        conn1.setAutoCommit(false);
        conn2.setAutoCommit(false);
        stat1.execute("SET LOCK_TIMEOUT 10000");
        long n1 = System.nanoTime();
        stat2.execute("SELECT * FROM TEST WHERE ID = 1 FOR UPDATE");
        ResultSet rs = stat1.executeQuery("SELECT * FROM TEST ORDER BY ID FOR UPDATE SKIP LOCKED");
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertFalse(rs.next());
        long n2 = System.nanoTime();
        if (n2 - n1 > 5000000000L) {
            this.fail("FOR UPDATE SKIP LOCKED is too slow");
        }
        conn1.commit();
        n1 = System.nanoTime();
        this.assertThrows(50200, stat1).executeQuery("SELECT * FROM TEST FOR UPDATE NOWAIT");
        n2 = System.nanoTime();
        if (n2 - n1 > 5000000000L) {
            this.fail("FOR UPDATE NOWAIT is too slow");
        }
        this.assertThrows(50200, stat1).executeQuery("SELECT * FROM TEST FOR UPDATE WAIT 0.001");
        n1 = System.nanoTime();
        if (n1 - n2 > 5000000000L) {
            this.fail("FOR UPDATE WAIT 0.001 is too slow");
        }
        conn1.close();
        conn2.close();
    }

    private void testUpdate() throws Exception {
        int[] a;
        int count = 50;
        this.deleteDb("transaction");
        final Connection conn1 = this.getConnection("transaction");
        conn1.setAutoCommit(false);
        Connection conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        Statement stat1 = conn1.createStatement();
        Statement stat2 = conn2.createStatement();
        stat1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, \"VALUE\" BOOLEAN) AS SELECT X, FALSE FROM GENERATE_SERIES(1, 50)");
        conn1.commit();
        stat1.executeQuery("SELECT * FROM TEST").close();
        stat2.executeQuery("SELECT * FROM TEST").close();
        final int[] r = new int[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                int sum = 0;
                try {
                    int[] a;
                    PreparedStatement prep = conn1.prepareStatement("UPDATE TEST SET \"VALUE\" = TRUE WHERE ID = ? AND NOT \"VALUE\"");
                    int i = 1;
                    while (i <= 50) {
                        prep.setInt(1, i);
                        prep.addBatch();
                        ++i;
                    }
                    int[] nArray = a = prep.executeBatch();
                    int n = a.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i2 = nArray[n2];
                        sum += i2;
                        ++n2;
                    }
                    conn1.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                r[0] = sum;
            }
        };
        t.start();
        int sum = 0;
        PreparedStatement prep = conn2.prepareStatement("UPDATE TEST SET \"VALUE\" = TRUE WHERE ID = ? AND NOT \"VALUE\"");
        int i = 1;
        while (i <= 50) {
            prep.setInt(1, i);
            prep.addBatch();
            ++i;
        }
        int[] nArray = a = prep.executeBatch();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            sum += i2;
            ++n2;
        }
        conn2.commit();
        t.join();
        this.assertEquals(50, sum + r[0]);
        conn2.close();
        conn1.close();
    }

    private void testMergeUsing() throws Exception {
        int[] a;
        int count = 50;
        this.deleteDb("transaction");
        final Connection conn1 = this.getConnection("transaction");
        conn1.setAutoCommit(false);
        Connection conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        Statement stat1 = conn1.createStatement();
        Statement stat2 = conn2.createStatement();
        stat1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, \"VALUE\" BOOLEAN) AS SELECT X, FALSE FROM GENERATE_SERIES(1, 50)");
        conn1.commit();
        stat1.executeQuery("SELECT * FROM TEST").close();
        stat2.executeQuery("SELECT * FROM TEST").close();
        final int[] r = new int[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                int sum = 0;
                try {
                    int[] a;
                    PreparedStatement prep = conn1.prepareStatement("MERGE INTO TEST T USING (SELECT ?1::INT X) S ON T.ID = S.X AND NOT T.\"VALUE\" WHEN MATCHED THEN UPDATE SET T.\"VALUE\" = TRUE WHEN NOT MATCHED THEN INSERT VALUES (10000 + ?1, FALSE)");
                    int i = 1;
                    while (i <= 50) {
                        prep.setInt(1, i);
                        prep.addBatch();
                        ++i;
                    }
                    int[] nArray = a = prep.executeBatch();
                    int n = a.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i2 = nArray[n2];
                        sum += i2;
                        ++n2;
                    }
                    conn1.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                r[0] = sum;
            }
        };
        t.start();
        int sum = 0;
        PreparedStatement prep = conn2.prepareStatement("MERGE INTO TEST T USING (SELECT ?1::INT X) S ON T.ID = S.X AND NOT T.\"VALUE\" WHEN MATCHED THEN UPDATE SET T.\"VALUE\" = TRUE WHEN NOT MATCHED THEN INSERT VALUES (10000 + ?1, FALSE)");
        int i = 1;
        while (i <= 50) {
            prep.setInt(1, i);
            prep.addBatch();
            ++i;
        }
        int[] nArray = a = prep.executeBatch();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            sum += i2;
            ++n2;
        }
        conn2.commit();
        t.join();
        this.assertEquals(100, sum + r[0]);
        conn2.close();
        conn1.close();
    }

    private void testDelete() throws Exception {
        String sql1 = "DELETE FROM TEST WHERE ID = ? AND NOT \"VALUE\"";
        String sql2 = "UPDATE TEST SET \"VALUE\" = TRUE WHERE ID = ? AND NOT \"VALUE\"";
        this.testDeleteImpl(sql1, sql2);
        this.testDeleteImpl(sql2, sql1);
    }

    private void testDeleteImpl(final String sql1, String sql2) throws Exception {
        int[] a;
        int count = 50;
        this.deleteDb("transaction");
        final Connection conn1 = this.getConnection("transaction");
        conn1.setAutoCommit(false);
        Connection conn2 = this.getConnection("transaction");
        conn2.setAutoCommit(false);
        Statement stat1 = conn1.createStatement();
        Statement stat2 = conn2.createStatement();
        stat1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, \"VALUE\" BOOLEAN) AS SELECT X, FALSE FROM GENERATE_SERIES(1, 50)");
        conn1.commit();
        stat1.executeQuery("SELECT * FROM TEST").close();
        stat2.executeQuery("SELECT * FROM TEST").close();
        final int[] r = new int[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                int sum = 0;
                try {
                    int[] a;
                    PreparedStatement prep = conn1.prepareStatement(sql1);
                    int i = 1;
                    while (i <= 50) {
                        prep.setInt(1, i);
                        prep.addBatch();
                        ++i;
                    }
                    int[] nArray = a = prep.executeBatch();
                    int n = a.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i2 = nArray[n2];
                        sum += i2;
                        ++n2;
                    }
                    conn1.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                r[0] = sum;
            }
        };
        t.start();
        int sum = 0;
        PreparedStatement prep = conn2.prepareStatement(sql2);
        int i = 1;
        while (i <= 50) {
            prep.setInt(1, i);
            prep.addBatch();
            ++i;
        }
        int[] nArray = a = prep.executeBatch();
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int i2 = nArray[n2];
            sum += i2;
            ++n2;
        }
        conn2.commit();
        t.join();
        this.assertEquals(50, sum + r[0]);
        conn2.close();
        conn1.close();
    }

    private void testRollback() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("create index idx_id on test(id)");
        stat.execute("insert into test values(1), (1), (1)");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("transaction");
            stat = conn.createStatement();
        }
        conn.setAutoCommit(false);
        stat.execute("delete from test");
        conn.rollback();
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertResultRowCount(3, rs);
        rs = stat.executeQuery("select * from test where id = 1");
        this.assertResultRowCount(3, rs);
        conn.close();
        conn = this.getConnection("transaction");
        stat = conn.createStatement();
        stat.execute("create table master(id int primary key) as select 1");
        stat.execute("create table child1(id int references master(id) on delete cascade)");
        stat.execute("insert into child1 values(1), (1), (1)");
        stat.execute("create table child2(id int references master(id)) as select 1");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("transaction");
        }
        stat = conn.createStatement();
        this.assertThrows(23503, stat).execute("delete from master");
        conn.rollback();
        rs = stat.executeQuery("select * from master where id=1");
        this.assertResultRowCount(1, rs);
        rs = stat.executeQuery("select * from child1");
        this.assertResultRowCount(3, rs);
        rs = stat.executeQuery("select * from child1 where id=1");
        this.assertResultRowCount(3, rs);
        conn.close();
    }

    private void testRollback2() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("create index idx_id on test(id)");
        stat.execute("insert into test values(1), (1)");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("transaction");
            stat = conn.createStatement();
        }
        conn.setAutoCommit(false);
        stat.execute("delete from test");
        conn.rollback();
        ResultSet rs = stat.executeQuery("select * from test where id = 1");
        this.assertResultRowCount(2, rs);
        conn.close();
        conn = this.getConnection("transaction");
        stat = conn.createStatement();
        stat.execute("create table master(id int primary key) as select 1");
        stat.execute("create table child1(id int references master(id) on delete cascade)");
        stat.execute("insert into child1 values(1), (1)");
        stat.execute("create table child2(id int references master(id)) as select 1");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("transaction");
        }
        stat = conn.createStatement();
        this.assertThrows(23503, stat).execute("delete from master");
        rs = stat.executeQuery("select * from master where id=1");
        this.assertResultRowCount(1, rs);
        rs = stat.executeQuery("select * from child1 where id=1");
        this.assertResultRowCount(2, rs);
        conn.close();
    }

    private void testSetTransaction() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int)");
        stat.execute("insert into test values(1)");
        stat.execute("set @x = 1");
        conn.commit();
        this.assertSingleValue(stat, "select id from test", 1);
        this.assertSingleValue(stat, "call @x", 1);
        stat.execute("update test set id=2");
        stat.execute("set @x = 2");
        conn.rollback();
        this.assertSingleValue(stat, "select id from test", 1);
        this.assertSingleValue(stat, "call @x", 2);
        conn.close();
    }

    private void testReferential() throws SQLException {
        this.deleteDb("transaction");
        Connection c1 = this.getConnection("transaction");
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.execute("drop table if exists a");
        s1.execute("drop table if exists b");
        s1.execute("create table a (id integer generated by default as identity, code varchar(10) not null, primary key(id))");
        s1.execute("create table b (name varchar(100) not null, a integer, primary key(name), foreign key(a) references a(id))");
        Connection c2 = this.getConnection("transaction");
        c2.setAutoCommit(false);
        s1.executeUpdate("insert into A(code) values('one')");
        Statement s2 = c2.createStatement();
        this.assertThrows(23506, s2).executeUpdate("insert into B values('two', 1)");
        c2.commit();
        c1.rollback();
        c1.close();
        c2.close();
    }

    private void testClosingConnectionWithLockedTable() throws SQLException {
        this.deleteDb("transaction");
        Connection c1 = this.getConnection("transaction");
        Connection c2 = this.getConnection("transaction");
        c1.setAutoCommit(false);
        c2.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.execute("create table a (id integer generated by default as identity, code varchar(10) not null, primary key(id))");
        s1.executeUpdate("insert into a(code) values('one')");
        c1.commit();
        s1.executeQuery("select * from a for update");
        c1.close();
        Statement s2 = c2.createStatement();
        s2.executeQuery("select * from a for update");
        c2.close();
    }

    private void testClosingConnectionWithSessionTempTable() throws SQLException {
        this.deleteDb("transaction");
        Connection c1 = this.getConnection("transaction");
        Connection c2 = this.getConnection("transaction");
        c1.setAutoCommit(false);
        c2.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.execute("create local temporary table a (id int, x BLOB)");
        c1.commit();
        c1.close();
        Statement s2 = c2.createStatement();
        s2.execute("create table c (id int)");
        c2.close();
    }

    private void testSavepoint() throws SQLException {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST0(ID IDENTITY, NAME VARCHAR)");
        stat.execute("CREATE TABLE TEST1(NAME VARCHAR, ID IDENTITY, X TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        conn.setAutoCommit(false);
        int[] count = new int[2];
        int[] countCommitted = new int[2];
        int[] countSave = new int[2];
        int len = this.getSize(2000, 10000);
        Random random = new Random(10L);
        Savepoint sp = null;
        int i = 0;
        while (i < len) {
            int tableId = random.nextInt(2);
            String table = "TEST" + tableId;
            int op = random.nextInt(6);
            switch (op) {
                case 0: {
                    stat.execute("INSERT INTO " + table + "(NAME) VALUES('op" + i + "')");
                    int n = tableId;
                    count[n] = count[n] + 1;
                    break;
                }
                case 1: {
                    if (count[tableId] <= 0) break;
                    int updateCount = stat.executeUpdate("DELETE FROM " + table + " WHERE ID=SELECT MIN(ID) FROM " + table);
                    this.assertEquals(1, updateCount);
                    int n = tableId;
                    count[n] = count[n] - 1;
                    break;
                }
                case 2: {
                    sp = conn.setSavepoint();
                    countSave[0] = count[0];
                    countSave[1] = count[1];
                    break;
                }
                case 3: {
                    if (sp == null) break;
                    conn.rollback(sp);
                    count[0] = countSave[0];
                    count[1] = countSave[1];
                    break;
                }
                case 4: {
                    conn.commit();
                    sp = null;
                    countCommitted[0] = count[0];
                    countCommitted[1] = count[1];
                    break;
                }
                case 5: {
                    conn.rollback();
                    sp = null;
                    count[0] = countCommitted[0];
                    count[1] = countCommitted[1];
                }
            }
            this.checkTableCount(stat, "TEST0", count[0]);
            this.checkTableCount(stat, "TEST1", count[1]);
            ++i;
        }
        conn.close();
    }

    private void checkTableCount(Statement stat, String tableName, int count) throws SQLException {
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
        this.assertEquals(count, rs.getInt(1));
    }

    private void testIsolation() throws SQLException {
        Connection conn = this.getConnection("transaction");
        this.trace("default TransactionIsolation=" + conn.getTransactionIsolation());
        conn.setTransactionIsolation(2);
        this.assertEquals(2, conn.getTransactionIsolation());
        conn.setTransactionIsolation(8);
        this.assertEquals(8, conn.getTransactionIsolation());
        Statement stat = conn.createStatement();
        this.assertTrue(conn.getAutoCommit());
        conn.setAutoCommit(false);
        this.assertFalse(conn.getAutoCommit());
        conn.setAutoCommit(true);
        this.assertTrue(conn.getAutoCommit());
        this.test(stat, "CREATE TABLE TEST(ID INT PRIMARY KEY)");
        conn.commit();
        this.test(stat, "INSERT INTO TEST VALUES(0)");
        conn.rollback();
        this.testValue(stat, "SELECT COUNT(*) FROM TEST", "1");
        conn.setAutoCommit(false);
        this.test(stat, "DELETE FROM TEST");
        conn.rollback();
        this.testValue(stat, "SELECT COUNT(*) FROM TEST", "1");
        conn.commit();
        conn.setAutoCommit(true);
        this.testNestedResultSets(conn);
        conn.setAutoCommit(false);
        this.testNestedResultSets(conn);
        conn.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIsolationLevels() throws SQLException {
        int[] nArray = new int[]{4, 6, 8};
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block52: {
                if (n2 >= n) {
                    this.deleteDb("transaction");
                    return;
                }
                int isolationLevel = nArray[n2];
                this.deleteDb("transaction");
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    Connection conn1 = this.getConnection("transaction");
                    try {
                        block51: {
                            Connection conn2 = this.getConnection("transaction");
                            try {
                                try (Connection conn3 = this.getConnection("transaction");){
                                    ResultSet rs;
                                    conn3.setTransactionIsolation(1);
                                    Statement stat1 = conn1.createStatement();
                                    Statement stat2 = conn2.createStatement();
                                    Statement stat3 = conn3.createStatement();
                                    stat1.execute("CREATE TABLE TEST1(ID INT PRIMARY KEY) AS VALUES 1, 2");
                                    stat1.execute("CREATE TABLE TEST2(ID INT PRIMARY KEY, V INT) AS VALUES (1, 10), (2, 20)");
                                    conn2.setAutoCommit(false);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 2);
                                    stat1.execute("INSERT INTO TEST1 VALUES 3");
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 3);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 2);
                                    stat1.execute("INSERT INTO TEST2 VALUES (3, 30)");
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 3);
                                    conn2.setTransactionIsolation(isolationLevel);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 3);
                                    stat1.execute("INSERT INTO TEST1 VALUES 4");
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 3);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 3);
                                    stat1.execute("INSERT INTO TEST2 VALUES (4, 40)");
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 3);
                                    conn2.commit();
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 4);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 4);
                                    stat1.execute("ALTER TABLE TEST2 ADD CONSTRAINT FK FOREIGN KEY(ID) REFERENCES TEST1(ID)");
                                    conn2.commit();
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 4);
                                    stat1.execute("INSERT INTO TEST1 VALUES 5");
                                    stat1.execute("INSERT INTO TEST2 VALUES (5, 50)");
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 4);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 4);
                                    conn2.commit();
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 1, 5);
                                    this.testIsolationLevelsCheckRowsAndCount(stat2, 2, 5);
                                    stat2.execute("INSERT INTO TEST1 VALUES 6");
                                    stat2.execute("INSERT INTO TEST2 VALUES (6, 60)");
                                    stat2.execute("DELETE FROM TEST2 WHERE ID IN (1, 3)");
                                    stat2.execute("UPDATE TEST2 SET V = 45 WHERE ID = 4");
                                    stat1.execute("INSERT INTO TEST1 VALUES 7");
                                    stat1.execute("INSERT INTO TEST2 VALUES (7, 70)");
                                    stat2.execute("INSERT INTO TEST1 VALUES 8");
                                    stat2.execute("INSERT INTO TEST2 VALUES (8, 80)");
                                    stat2.execute("INSERT INTO TEST1 VALUES 9");
                                    stat2.execute("INSERT INTO TEST2 VALUES (9, 90)");
                                    stat2.execute("DELETE FROM TEST2 WHERE ID = 9");
                                    this.testIsolationLevelsCheckRowsAndCount2(stat2, 1, 1, 2, 3, 4, 5, 6, 8, 9);
                                    this.testIsolationLevelsCheckRowsAndCount2(stat3, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9);
                                    Throwable throwable2 = null;
                                    Object var14_22 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT COUNT(*) FROM TEST2");
                                        try {
                                            rs.next();
                                            this.assertEquals(5L, rs.getLong(1));
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                    throwable2 = null;
                                    var14_22 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT ID, V FROM TEST2 ORDER BY ID");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(2, rs.getInt(1));
                                            this.assertEquals(20, rs.getInt(2));
                                            this.assertTrue(rs.next());
                                            this.assertEquals(4, rs.getInt(1));
                                            this.assertEquals(45, rs.getInt(2));
                                            this.assertTrue(rs.next());
                                            this.assertEquals(5, rs.getInt(1));
                                            this.assertEquals(50, rs.getInt(2));
                                            this.assertTrue(rs.next());
                                            this.assertEquals(6, rs.getInt(1));
                                            this.assertEquals(60, rs.getInt(2));
                                            this.assertTrue(rs.next());
                                            this.assertEquals(8, rs.getInt(1));
                                            this.assertEquals(80, rs.getInt(2));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable4;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable4) throw throwable2;
                                        throwable2.addSuppressed(throwable4);
                                        throw throwable2;
                                    }
                                    stat1.execute("INSERT INTO TEST1 VALUES 11");
                                    stat1.execute("INSERT INTO TEST2 VALUES (11, 110)");
                                    conn2.commit();
                                    this.testIsolationLevelsCheckRowsAndCount2(stat1, 2, 2, 4, 5, 6, 7, 8, 11);
                                    this.testIsolationLevelsCheckRowsAndCount2(stat2, 2, 2, 4, 5, 6, 7, 8, 11);
                                    stat2.execute("INSERT INTO TEST1 VALUES 10");
                                    stat2.execute("INSERT INTO TEST2 VALUES (9, 90), (10, 100)");
                                    stat2.execute("DELETE FROM TEST2 WHERE ID = 9");
                                    this.testIsolationLevelsCheckRowsAndCount2(stat2, 2, 2, 4, 5, 6, 7, 8, 10, 11);
                                    stat1.execute("ALTER TABLE TEST2 DROP CONSTRAINT FK");
                                    conn2.commit();
                                    throwable2 = null;
                                    var14_22 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT COUNT(*) FROM TEST1");
                                        try {
                                            rs.next();
                                            this.assertEquals(11L, rs.getLong(1));
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable5;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable5) throw throwable2;
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable2;
                                    }
                                    stat1.execute("INSERT INTO TEST2 VALUES (20, 200)");
                                    throwable2 = null;
                                    var14_22 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT COUNT(*) FROM TEST2");
                                        try {
                                            rs.next();
                                            this.assertEquals((long)(isolationLevel != 4 ? 8 : 9), rs.getLong(1));
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable6) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable6;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable6) throw throwable2;
                                        throwable2.addSuppressed(throwable6);
                                        throw throwable2;
                                    }
                                }
                                if (conn2 == null) break block51;
                            }
                            catch (Throwable throwable7) {
                                if (throwable == null) {
                                    throwable = throwable7;
                                } else if (throwable != throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                                if (conn2 == null) throw throwable;
                                conn2.close();
                                throw throwable;
                            }
                            conn2.close();
                        }
                        if (conn1 == null) break block52;
                    }
                    catch (Throwable throwable8) {
                        if (throwable == null) {
                            throwable = throwable8;
                        } else if (throwable != throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        if (conn1 == null) throw throwable;
                        conn1.close();
                        throw throwable;
                    }
                    conn1.close();
                }
                catch (Throwable throwable9) {
                    if (throwable == null) {
                        throwable = throwable9;
                        throw throwable;
                    }
                    if (throwable == throwable9) throw throwable;
                    throwable.addSuppressed(throwable9);
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    private void testIsolationLevelsCheckRowsAndCount(Statement stat, int table, int expected) throws SQLException {
        ResultSet rs;
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            rs = stat.executeQuery("SELECT COUNT(*) FROM TEST" + table);
            try {
                rs.next();
                this.assertEquals((long)expected, rs.getLong(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            rs = stat.executeQuery("SELECT ID FROM TEST" + table + " ORDER BY ID");
            try {
                int i = 0;
                while (++i <= expected) {
                    this.assertTrue(rs.next());
                    this.assertEquals(i, rs.getInt(1));
                }
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIsolationLevelsCheckRowsAndCount2(Statement stat, int table, int ... values) throws SQLException {
        ResultSet rs;
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            rs = stat.executeQuery("SELECT COUNT(*) FROM TEST" + table);
            try {
                rs.next();
                this.assertEquals((long)values.length, rs.getLong(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            rs = stat.executeQuery("SELECT ID FROM TEST" + table + " ORDER BY ID");
            try {
                int[] nArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    int expected = nArray[n2];
                    this.assertTrue(rs.next());
                    this.assertEquals(expected, rs.getInt(1));
                    ++n2;
                }
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testNestedResultSets(Connection conn) throws SQLException {
        String v1;
        ResultSet rs2;
        Statement stat = conn.createStatement();
        this.test(stat, "CREATE TABLE NEST1(ID INT PRIMARY KEY,\"VALUE\" VARCHAR(255))");
        this.test(stat, "CREATE TABLE NEST2(ID INT PRIMARY KEY,\"VALUE\" VARCHAR(255))");
        DatabaseMetaData meta = conn.getMetaData();
        ArrayList<Object> result = new ArrayList<Object>();
        ResultSet rs1 = meta.getTables(null, null, "NEST%", null);
        while (rs1.next()) {
            String table = rs1.getString("TABLE_NAME");
            rs2 = meta.getColumns(null, null, table, null);
            while (rs2.next()) {
                String column = rs2.getString("COLUMN_NAME");
                this.trace("Table: " + table + " Column: " + column);
                result.add(table + "." + column);
            }
        }
        this.assertEquals(result.toString(), 4, result.size());
        result = new ArrayList();
        this.test(stat, "INSERT INTO NEST1 VALUES(1,'A')");
        this.test(stat, "INSERT INTO NEST1 VALUES(2,'B')");
        this.test(stat, "INSERT INTO NEST2 VALUES(1,'1')");
        this.test(stat, "INSERT INTO NEST2 VALUES(2,'2')");
        Statement s1 = conn.createStatement();
        Statement s2 = conn.createStatement();
        rs1 = s1.executeQuery("SELECT * FROM NEST1 ORDER BY ID");
        while (rs1.next()) {
            rs2 = s2.executeQuery("SELECT * FROM NEST2 ORDER BY ID");
            while (rs2.next()) {
                v1 = rs1.getString("VALUE");
                String v2 = rs2.getString("VALUE");
                result.add(v1 + "/" + v2);
            }
        }
        this.assertEquals(result.toString(), 4, result.size());
        result = new ArrayList();
        rs1 = s1.executeQuery("SELECT * FROM NEST1 ORDER BY ID");
        rs2 = s1.executeQuery("SELECT * FROM NEST2 ORDER BY ID");
        this.assertThrows(90007, rs1).next();
        rs1.close();
        while (rs2.next()) {
            v1 = rs2.getString("VALUE");
            result.add(v1);
        }
        this.assertEquals(result.toString(), 2, result.size());
        this.test(stat, "DROP TABLE NEST1");
        this.test(stat, "DROP TABLE NEST2");
    }

    private void testValue(Statement stat, String sql, String data) throws SQLException {
        ResultSet rs = stat.executeQuery(sql);
        rs.next();
        String s = rs.getString(1);
        this.assertEquals(data, s);
    }

    private void test(Statement stat, String sql) throws SQLException {
        this.trace(sql);
        stat.execute(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIsolationLevels2() throws SQLException {
        int[] nArray = new int[]{1, 2, 4, 6, 8};
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block55: {
                if (n2 >= n) {
                    this.deleteDb("transaction");
                    return;
                }
                int isolationLevel = nArray[n2];
                this.deleteDb("transaction");
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    Connection conn1 = this.getConnection("transaction");
                    try {
                        block52: {
                            try (Connection conn2 = this.getConnection("transaction");){
                                ResultSet rs;
                                conn1.setTransactionIsolation(isolationLevel);
                                conn2.setTransactionIsolation(isolationLevel);
                                conn1.setAutoCommit(false);
                                conn2.setAutoCommit(false);
                                Statement stat1 = conn1.createStatement();
                                Statement stat2 = conn2.createStatement();
                                stat1.execute("CREATE TABLE TEST(\"VALUE\" INT)");
                                stat1.executeQuery("TABLE TEST").close();
                                stat1.execute("DROP TABLE TEST");
                                stat1.execute("CREATE TABLE TEST(ID VARCHAR PRIMARY KEY, \"VALUE\" INT)");
                                stat1.execute("INSERT INTO TEST VALUES ('1', 1)");
                                conn1.commit();
                                Throwable throwable2 = null;
                                Object var12_20 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID = '1'");
                                    try {
                                        rs.next();
                                        this.assertEquals(1, rs.getInt(2));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                                stat2.executeUpdate("UPDATE TEST SET \"VALUE\" = \"VALUE\" + 1");
                                throwable2 = null;
                                var12_20 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID = '1'");
                                    try {
                                        rs.next();
                                        this.assertEquals(isolationLevel == 1 ? 2 : 1, rs.getInt(2));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                    throw throwable2;
                                }
                                this.assertThrows(50200, stat1).executeQuery("SELECT * FROM TEST WHERE ID = '1' FOR UPDATE");
                                conn2.commit();
                                if (isolationLevel >= 4) {
                                    this.assertThrows(40001, stat1).executeQuery("SELECT * FROM TEST WHERE ID = '1' FOR UPDATE");
                                    break block52;
                                }
                                throwable2 = null;
                                var12_20 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID = '1' FOR UPDATE");
                                    try {
                                        rs.next();
                                        this.assertEquals(2, rs.getInt(2));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable5) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable5;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable5) throw throwable2;
                                    throwable2.addSuppressed(throwable5);
                                    throw throwable2;
                                }
                                throwable2 = null;
                                var12_20 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST");
                                    try {
                                        rs.next();
                                        this.assertEquals(2, rs.getInt(2));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable6) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable6;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable6) throw throwable2;
                                    throwable2.addSuppressed(throwable6);
                                    throw throwable2;
                                }
                                throwable2 = null;
                                var12_20 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID = '1'");
                                    try {
                                        rs.next();
                                        this.assertEquals(2, rs.getInt(2));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable7) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable7;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable7) throw throwable2;
                                    throwable2.addSuppressed(throwable7);
                                    throw throwable2;
                                }
                            }
                        }
                        if (conn1 == null) break block55;
                    }
                    catch (Throwable throwable8) {
                        if (throwable == null) {
                            throwable = throwable8;
                        } else if (throwable != throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        if (conn1 == null) throw throwable;
                        conn1.close();
                        throw throwable;
                    }
                    conn1.close();
                }
                catch (Throwable throwable9) {
                    if (throwable == null) {
                        throwable = throwable9;
                        throw throwable;
                    }
                    if (throwable == throwable9) throw throwable;
                    throwable.addSuppressed(throwable9);
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIsolationLevels3() throws SQLException {
        int[] nArray = new int[]{1, 2, 4, 6, 8};
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block67: {
                if (n2 >= n) {
                    this.deleteDb("transaction");
                    return;
                }
                int isolationLevel = nArray[n2];
                this.deleteDb("transaction");
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    Connection conn1 = this.getConnection("transaction");
                    try {
                        block65: {
                            try (Connection conn2 = this.getConnection("transaction");){
                                ResultSet rs;
                                conn1.setTransactionIsolation(isolationLevel);
                                conn2.setTransactionIsolation(isolationLevel);
                                conn1.setAutoCommit(false);
                                conn2.setAutoCommit(false);
                                Statement stat1 = conn1.createStatement();
                                Statement stat2 = conn2.createStatement();
                                stat1.execute("CREATE TABLE TEST(ID BIGINT PRIMARY KEY, ID2 INT UNIQUE, \"VALUE\" INT)");
                                stat1.execute("INSERT INTO TEST VALUES (1, 1, 1), (2, 2, 2), (3, 3, 3)");
                                conn1.commit();
                                Throwable throwable2 = null;
                                Object var12_21 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID2 IN (1, 2)");
                                    try {
                                        rs.next();
                                        this.assertEquals(1, rs.getInt(3));
                                        rs.next();
                                        this.assertEquals(2, rs.getInt(3));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                                stat2.executeUpdate("UPDATE TEST SET ID2 = 4, \"VALUE\" = 5 WHERE ID2 = 2");
                                throwable2 = null;
                                var12_21 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID2 IN (1, 2)");
                                    try {
                                        rs.next();
                                        this.assertEquals(1, rs.getInt(3));
                                        if (isolationLevel == 1) {
                                            this.assertFalse(rs.next());
                                        } else {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(2, rs.getInt(3));
                                        }
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable4) throw throwable2;
                                    throwable2.addSuppressed(throwable4);
                                    throw throwable2;
                                }
                                if (isolationLevel == 1) {
                                    this.assertFalse(stat1.executeQuery("SELECT * FROM TEST WHERE ID2 = 2 FOR UPDATE").next());
                                    this.assertThrows(50200, stat1).executeQuery("SELECT * FROM TEST WHERE ID2 = 4 FOR UPDATE");
                                } else {
                                    this.assertThrows(50200, stat1).executeQuery("SELECT * FROM TEST WHERE ID2 = 2 FOR UPDATE");
                                    this.assertFalse(stat1.executeQuery("SELECT * FROM TEST WHERE ID2 = 4 FOR UPDATE").next());
                                }
                                stat2.executeUpdate("UPDATE TEST SET \"VALUE\" = 6 WHERE ID2 = 3");
                                conn2.commit();
                                if (isolationLevel == 1 || isolationLevel == 2) {
                                    throwable2 = null;
                                    var12_21 = null;
                                    try {
                                        rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID2 = 4 FOR UPDATE");
                                        try {
                                            rs.next();
                                            this.assertEquals(5, rs.getInt(3));
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable5;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable5) throw throwable2;
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable2;
                                    }
                                    throwable2 = null;
                                    var12_21 = null;
                                    try {
                                        rs = stat1.executeQuery("SELECT * FROM TEST");
                                        try {
                                            rs.next();
                                            this.assertEquals(1, rs.getInt(3));
                                            rs.next();
                                            this.assertEquals(5, rs.getInt(3));
                                            rs.next();
                                            this.assertEquals(6, rs.getInt(3));
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable6) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable6;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable6) throw throwable2;
                                        throwable2.addSuppressed(throwable6);
                                        throw throwable2;
                                    }
                                    throwable2 = null;
                                    var12_21 = null;
                                    try {
                                        rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID2 = 4");
                                        try {
                                            rs.next();
                                            this.assertEquals(5, rs.getInt(3));
                                            break block65;
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable7) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable7;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable7) throw throwable2;
                                        throwable2.addSuppressed(throwable7);
                                        throw throwable2;
                                    }
                                }
                                throwable2 = null;
                                var12_21 = null;
                                try {
                                    rs = stat1.executeQuery("SELECT * FROM TEST WHERE ID2 = 3");
                                    try {
                                        rs.next();
                                        this.assertEquals(3, rs.getInt(3));
                                    }
                                    finally {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable8) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable8;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable8) throw throwable2;
                                    throwable2.addSuppressed(throwable8);
                                    throw throwable2;
                                }
                                this.assertThrows(40001, stat1).executeQuery("SELECT * FROM TEST WHERE ID2 = 3 FOR UPDATE");
                            }
                        }
                        if (conn1 == null) break block67;
                    }
                    catch (Throwable throwable9) {
                        if (throwable == null) {
                            throwable = throwable9;
                        } else if (throwable != throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        if (conn1 == null) throw throwable;
                        conn1.close();
                        throw throwable;
                    }
                    conn1.close();
                }
                catch (Throwable throwable10) {
                    if (throwable == null) {
                        throwable = throwable10;
                        throw throwable;
                    }
                    if (throwable == throwable10) throw throwable;
                    throwable.addSuppressed(throwable10);
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    private void testIsolationLevels4() throws SQLException {
        this.testIsolationLevels4(true);
        this.testIsolationLevels4(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIsolationLevels4(boolean primaryKey) throws SQLException {
        int[] nArray = new int[]{1, 2, 4, 6, 8};
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block71: {
                if (n2 >= n) {
                    this.deleteDb("transaction");
                    return;
                }
                int isolationLevel = nArray[n2];
                this.deleteDb("transaction");
                Throwable throwable = null;
                Object var7_8 = null;
                try {
                    Connection conn1 = this.getConnection("transaction");
                    try {
                        block66: {
                            try (Connection conn2 = this.getConnection("transaction");){
                                Statement stat2;
                                Statement stat1;
                                block70: {
                                    ResultSet rs;
                                    stat1 = conn1.createStatement();
                                    stat1.execute("CREATE TABLE TEST(ID INT " + (primaryKey ? "PRIMARY KEY" : "UNIQUE") + ", V INT) AS VALUES (1, 2)");
                                    conn2.setAutoCommit(false);
                                    conn2.setTransactionIsolation(isolationLevel);
                                    stat2 = conn2.createStatement();
                                    Throwable throwable2 = null;
                                    Object var13_23 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(2, rs.getInt(1));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                    stat1.execute("UPDATE TEST SET V = V + 1");
                                    throwable2 = null;
                                    var13_23 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(isolationLevel >= 4 ? 2 : 3, rs.getInt(1));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable4;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable4) throw throwable2;
                                        throwable2.addSuppressed(throwable4);
                                        throw throwable2;
                                    }
                                    if (isolationLevel < 4) break block66;
                                    this.assertThrows(40001, stat2).executeUpdate("UPDATE TEST SET V = V + 2");
                                    throwable2 = null;
                                    var13_23 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(3, rs.getInt(1));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable5;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable5) throw throwable2;
                                        throwable2.addSuppressed(throwable5);
                                        throw throwable2;
                                    }
                                    stat1.execute("DELETE FROM TEST");
                                    this.assertThrows(40001, stat2).executeUpdate("UPDATE TEST SET V = V + 2");
                                    stat1.execute("INSERT INTO TEST VALUES (1, 2)");
                                    throwable2 = null;
                                    var13_23 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(2, rs.getInt(1));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable6) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable6;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable6) throw throwable2;
                                        throwable2.addSuppressed(throwable6);
                                        throw throwable2;
                                    }
                                    stat1.execute("DELETE FROM TEST");
                                    stat1.execute("INSERT INTO TEST VALUES (1, 2)");
                                    if (primaryKey) {
                                        this.assertEquals(1, stat2.executeUpdate("UPDATE TEST SET V = V + 2"));
                                        throwable2 = null;
                                        var13_23 = null;
                                        try {
                                            rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                            try {
                                                this.assertTrue(rs.next());
                                                this.assertEquals(4, rs.getInt(1));
                                                this.assertFalse(rs.next());
                                            }
                                            finally {
                                                if (rs != null) {
                                                    rs.close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable7) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable7;
                                                throw throwable2;
                                            }
                                            if (throwable2 == throwable7) throw throwable2;
                                            throwable2.addSuppressed(throwable7);
                                            throw throwable2;
                                        }
                                        conn2.commit();
                                        throwable2 = null;
                                        var13_23 = null;
                                        try {
                                            rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                            try {
                                                this.assertTrue(rs.next());
                                                this.assertEquals(4, rs.getInt(1));
                                                this.assertFalse(rs.next());
                                                break block70;
                                            }
                                            finally {
                                                if (rs != null) {
                                                    rs.close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable8) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable8;
                                                throw throwable2;
                                            }
                                            if (throwable2 == throwable8) throw throwable2;
                                            throwable2.addSuppressed(throwable8);
                                            throw throwable2;
                                        }
                                    }
                                    this.assertThrows(40001, stat2).executeUpdate("UPDATE TEST SET V = V + 2");
                                    throwable2 = null;
                                    var13_23 = null;
                                    try {
                                        rs = stat2.executeQuery("SELECT V FROM TEST WHERE ID = 1");
                                        try {
                                            this.assertTrue(rs.next());
                                            this.assertEquals(2, rs.getInt(1));
                                            this.assertFalse(rs.next());
                                        }
                                        finally {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable9) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable9;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable9) throw throwable2;
                                        throwable2.addSuppressed(throwable9);
                                        throw throwable2;
                                    }
                                }
                                stat1.execute("DELETE FROM TEST");
                                this.assertThrows(23505, stat2).execute("INSERT INTO TEST VALUES (1, 3)");
                            }
                        }
                        if (conn1 == null) break block71;
                    }
                    catch (Throwable throwable10) {
                        if (throwable == null) {
                            throwable = throwable10;
                        } else if (throwable != throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                        if (conn1 == null) throw throwable;
                        conn1.close();
                        throw throwable;
                    }
                    conn1.close();
                }
                catch (Throwable throwable11) {
                    if (throwable == null) {
                        throwable = throwable11;
                        throw throwable;
                    }
                    if (throwable == throwable11) throw throwable;
                    throwable.addSuppressed(throwable11);
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    private void testIsolationLevelsCountAggregate() throws SQLException {
        this.testIsolationLevelsCountAggregate(1, 12L, 15L, 15L, 16L);
        this.testIsolationLevelsCountAggregate(2, 6L, 9L, 15L, 16L);
        this.testIsolationLevelsCountAggregate(4, 6L, 9L, 9L, 15L);
        this.testIsolationLevelsCountAggregate(6, 6L, 9L, 9L, 15L);
        this.testIsolationLevelsCountAggregate(8, 6L, 9L, 9L, 15L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testIsolationLevelsCountAggregate(int isolationLevel, long uncommitted1, long uncommitted2, long committed, long committedOther) throws SQLException {
        this.deleteDb("transaction");
        Throwable throwable = null;
        Object var11_8 = null;
        try {
            Connection conn1 = this.getConnection("transaction");
            try {
                try (Connection conn2 = this.getConnection("transaction");){
                    Statement stat1 = conn1.createStatement();
                    stat1.execute("CREATE TABLE TEST(V BIGINT) AS VALUES 1, 2, 3, 4, 5, 18");
                    conn1.setTransactionIsolation(isolationLevel);
                    conn1.setAutoCommit(false);
                    PreparedStatement all = conn1.prepareStatement("SELECT COUNT(*) FROM TEST");
                    PreparedStatement simple = conn1.prepareStatement("SELECT COUNT(V) FROM TEST");
                    conn2.setAutoCommit(false);
                    Statement stat2 = conn2.createStatement();
                    this.testIsolationLevelsCountAggregate(all, simple, 6L);
                    stat2.executeUpdate("DELETE FROM TEST WHERE V IN(3, 4)");
                    stat2.executeUpdate("INSERT INTO TEST SELECT * FROM SYSTEM_RANGE(10, 17)");
                    this.testIsolationLevelsCountAggregate(all, simple, uncommitted1);
                    stat1.executeUpdate("DELETE FROM TEST WHERE V = 2");
                    stat1.executeUpdate("INSERT INTO TEST SELECT * FROM SYSTEM_RANGE(6, 9)");
                    this.testIsolationLevelsCountAggregate(all, simple, uncommitted2);
                    conn2.commit();
                    this.testIsolationLevelsCountAggregate(all, simple, committed);
                    conn1.commit();
                    this.testIsolationLevelsCountAggregate(all, simple, 15L);
                    stat2.executeUpdate("DELETE FROM TEST WHERE V = 17");
                    stat2.executeUpdate("INSERT INTO TEST VALUES 19, 20");
                    conn2.commit();
                    this.testIsolationLevelsCountAggregate(all, simple, committedOther);
                }
                if (conn1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (conn1 == null) throw throwable;
                conn1.close();
                throw throwable;
            }
            conn1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIsolationLevelsCountAggregate(PreparedStatement all, PreparedStatement simple, long expected) throws SQLException {
        ResultSet rs;
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            rs = all.executeQuery();
            try {
                rs.next();
                this.assertEquals(expected, rs.getLong(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_7 = null;
        try {
            rs = simple.executeQuery();
            try {
                rs.next();
                this.assertEquals(expected, rs.getLong(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIsolationLevelsCountAggregate2() throws SQLException {
        this.testIsolationLevelsCountAggregate2(1);
        this.testIsolationLevelsCountAggregate2(2);
        this.testIsolationLevelsCountAggregate2(4);
        this.testIsolationLevelsCountAggregate2(6);
        this.testIsolationLevelsCountAggregate2(8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testIsolationLevelsCountAggregate2(int isolationLevel) throws SQLException {
        this.deleteDb("transaction");
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Connection conn1 = this.getConnection("transaction");
            try {
                try (Connection conn2 = this.getConnection("transaction");){
                    conn1.setTransactionIsolation(isolationLevel);
                    conn1.setAutoCommit(false);
                    Statement stat1 = conn1.createStatement();
                    Statement stat2 = conn2.createStatement();
                    stat1.executeUpdate("CREATE TABLE TEST(X INTEGER PRIMARY KEY, Y INTEGER) AS SELECT X, 1 FROM SYSTEM_RANGE(1, 100)");
                    conn1.commit();
                    conn2.setTransactionIsolation(isolationLevel);
                    conn2.setAutoCommit(false);
                    PreparedStatement prep = conn1.prepareStatement("SELECT COUNT(*) FROM TEST");
                    this.testIsolationLevelCountAggregate2(prep, 100L);
                    stat1.executeUpdate("INSERT INTO TEST VALUES (101, 2)");
                    stat1.executeUpdate("DELETE FROM TEST WHERE X BETWEEN 2 AND 3");
                    stat1.executeUpdate("UPDATE TEST SET Y = 2 WHERE X BETWEEN 4 AND 7");
                    this.testIsolationLevelCountAggregate2(prep, 99L);
                    stat2.executeUpdate("INSERT INTO TEST VALUES (102, 2)");
                    stat2.executeUpdate("DELETE FROM TEST WHERE X BETWEEN 12 AND 13");
                    stat2.executeUpdate("UPDATE TEST SET Y = 2 WHERE X BETWEEN 14 AND 17");
                    this.testIsolationLevelCountAggregate2(prep, isolationLevel == 1 ? 98L : 99L);
                    conn2.commit();
                    this.testIsolationLevelCountAggregate2(prep, isolationLevel <= 2 ? 98L : 99L);
                    conn1.commit();
                    this.testIsolationLevelCountAggregate2(prep, 98L);
                    stat2.executeUpdate("INSERT INTO TEST VALUES (103, 2)");
                    stat2.executeUpdate("DELETE FROM TEST WHERE X BETWEEN 22 AND 23");
                    stat2.executeUpdate("UPDATE TEST SET Y = 2 WHERE X BETWEEN 24 AND 27");
                    this.testIsolationLevelCountAggregate2(prep, isolationLevel == 1 ? 97L : 98L);
                    conn2.commit();
                    this.testIsolationLevelCountAggregate2(prep, isolationLevel <= 2 ? 97L : 98L);
                    conn1.commit();
                    this.testIsolationLevelCountAggregate2(prep, 97L);
                    stat2.executeUpdate("INSERT INTO TEST VALUES (104, 2)");
                    conn1.commit();
                    this.testIsolationLevelCountAggregate2(prep, isolationLevel == 1 ? 98L : 97L);
                }
                if (conn1 == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (conn1 == null) throw throwable;
                conn1.close();
                throw throwable;
            }
            conn1.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIsolationLevelCountAggregate2(PreparedStatement prep, long expected) throws SQLException {
        ResultSet rs = prep.executeQuery();
        rs.next();
        this.assertEquals(expected, rs.getLong(1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testIsolationLevelsMetadata() throws SQLException {
        block26: {
            this.deleteDb("transaction");
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                Connection conn1 = this.getConnection("transaction");
                try {
                    try (Connection conn2 = this.getConnection("transaction");){
                        PreparedStatement prep1 = conn1.prepareStatement("SELECT ISOLATION_LEVEL, SESSION_ID = SESSION_ID() FROM INFORMATION_SCHEMA.SESSIONS");
                        PreparedStatement prep2 = conn2.prepareStatement("SELECT ISOLATION_LEVEL, SESSION_ID = SESSION_ID() FROM INFORMATION_SCHEMA.SESSIONS");
                        int[] nArray = new int[]{1, 2, 4, 6, 8};
                        int n = nArray.length;
                        int n2 = 0;
                        block14: while (n2 < n) {
                            String level;
                            int isolationLevel = nArray[n2];
                            conn2.setTransactionIsolation(isolationLevel);
                            switch (isolationLevel) {
                                case 1: {
                                    level = "READ UNCOMMITTED";
                                    break;
                                }
                                case 2: {
                                    level = "READ COMMITTED";
                                    break;
                                }
                                case 4: {
                                    level = "REPEATABLE READ";
                                    break;
                                }
                                case 6: {
                                    level = "SNAPSHOT";
                                    break;
                                }
                                case 8: {
                                    level = "SERIALIZABLE";
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                            ResultSet rs = prep1.executeQuery();
                            while (true) {
                                if (!rs.next()) break;
                                if (rs.getBoolean(2)) {
                                    this.assertEquals("READ COMMITTED", rs.getString(1));
                                    continue;
                                }
                                this.assertEquals(level, rs.getString(1));
                            }
                            rs = prep2.executeQuery();
                            while (true) {
                                if (!rs.next()) {
                                    ++n2;
                                    continue block14;
                                }
                                if (rs.getBoolean(2)) {
                                    this.assertEquals(level, rs.getString(1));
                                    continue;
                                }
                                this.assertEquals("READ COMMITTED", rs.getString(1));
                            }
                        }
                    }
                    if (conn1 == null) break block26;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn1 == null) throw throwable;
                    conn1.close();
                    throw throwable;
                }
                conn1.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.deleteDb("transaction");
    }
}

