/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.script.ScriptEngineManager;
import org.h2.api.Trigger;
import org.h2.message.DbException;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.TriggerAdapter;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.value.ValueBigint;

public class TestTriggersConstraints
extends TestDb
implements Trigger {
    private static boolean mustNotCallTrigger;
    private String triggerName;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("trigger");
        this.testWrongDataType();
        this.testTriggerDeadlock();
        this.testTriggerAdapter();
        this.testTriggerSelectEachRow();
        this.testViewTrigger();
        this.testViewTriggerGeneratedKeys();
        this.testTriggerBeforeSelect();
        this.testTriggerAlterTable();
        this.testTriggerAsSource();
        this.testTriggerAsJavascript();
        this.testTriggers();
        this.testConstraints();
        this.testCheckConstraintErrorMessage();
        this.testMultiPartForeignKeys();
        this.testConcurrent();
        this.deleteDb("trigger");
    }

    private void testWrongDataType() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Connection conn = this.getConnection("trigger");){
            Statement stat = conn.createStatement();
            stat.executeUpdate("CREATE TABLE TEST(A INTEGER, B INTEGER NOT NULL)");
            PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES (1, 2)");
            stat.executeUpdate("CREATE TRIGGER TEST_TRIGGER BEFORE INSERT ON TEST FOR EACH ROW CALL '" + WrongTrigger.class.getName() + "'");
            this.assertThrows(22018, prep).executeUpdate();
            stat.executeUpdate("DROP TRIGGER TEST_TRIGGER");
            stat.executeUpdate("CREATE TRIGGER TEST_TRIGGER BEFORE INSERT ON TEST FOR EACH ROW CALL '" + WrongTriggerAdapter.class.getName() + "'");
            this.assertThrows(22018, prep).executeUpdate();
            stat.executeUpdate("DROP TRIGGER TEST_TRIGGER");
            stat.executeUpdate("CREATE TRIGGER TEST_TRIGGER BEFORE INSERT ON TEST FOR EACH ROW CALL '" + NullTrigger.class.getName() + "'");
            this.assertThrows(23502, prep).executeUpdate();
            stat.executeUpdate("DROP TRIGGER TEST_TRIGGER");
            stat.executeUpdate("CREATE TRIGGER TEST_TRIGGER BEFORE INSERT ON TEST FOR EACH ROW CALL '" + NullTriggerAdapter.class.getName() + "'");
            this.assertThrows(23502, prep).executeUpdate();
            stat.executeUpdate("DROP TRIGGER TEST_TRIGGER");
            stat.executeUpdate("DROP TABLE TEST");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testTriggerDeadlock() throws Exception {
        final CountDownLatch latch = new CountDownLatch(2);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection("trigger");){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int) as select 1");
            stat.execute("create table test2(id int) as select 1");
            stat.execute("create trigger test_u before update on test2 for each row call \"" + DeleteTrigger.class.getName() + "\"");
            conn.setAutoCommit(false);
            stat.execute("update test set id = 2");
            Task task = new Task(){

                @Override
                public void call() throws Exception {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (Connection conn2 = TestTriggersConstraints.this.getConnection("trigger");){
                            conn2.setAutoCommit(false);
                            Throwable throwable2 = null;
                            Object var5_10 = null;
                            try (Statement stat2 = conn2.createStatement();){
                                latch.countDown();
                                latch.await();
                                stat2.execute("update test2 set id = 4");
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            conn2.rollback();
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        int errorCode = e.getErrorCode();
                        TestTriggersConstraints.this.assertTrue(String.valueOf(errorCode), 50200 == errorCode || 40001 == errorCode);
                    }
                }
            };
            task.execute();
            latch.countDown();
            latch.await();
            try {
                stat.execute("update test2 set id = 3");
            }
            catch (SQLException e) {
                int errorCode = e.getErrorCode();
                this.assertTrue(String.valueOf(errorCode), 50200 == errorCode || 40001 == errorCode);
            }
            task.get();
            conn.rollback();
            stat.execute("drop table test");
            stat.execute("drop table test2");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testTriggerAdapter() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists test");
        stat.execute("create table test(id int, c clob, b blob)");
        stat.execute("create table message(name varchar)");
        stat.execute("create trigger test_insert before insert, update, delete on test for each row call \"" + TestTriggerAdapter.class.getName() + "\"");
        stat.execute("insert into test values(1, 'hello', 'abcd')");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        stat.execute("update test set id = 2");
        rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(20, rs.getInt(1));
        stat.execute("delete from test");
        rs = stat.executeQuery("select * from message");
        this.assertTrue(rs.next());
        this.assertEquals("+1;", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("-10;+2;", rs.getString(1));
        this.assertTrue(rs.next());
        this.assertEquals("-20;", rs.getString(1));
        this.assertFalse(rs.next());
        stat.execute("drop table test, message");
        conn.close();
    }

    private void testTriggerSelectEachRow() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists test");
        stat.execute("create table test(id int)");
        this.assertThrows(90005, stat).execute("create trigger test_insert before select on test for each row call \"" + TestTriggerAdapter.class.getName() + "\"");
        conn.close();
    }

    private void testViewTrigger() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists test");
        stat.execute("create table test(id int)");
        stat.execute("create view test_view as select * from test");
        stat.execute("create trigger test_view_insert instead of insert on test_view for each row call \"" + TestView.class.getName() + "\"");
        stat.execute("create trigger test_view_delete instead of delete on test_view for each row call \"" + TestView.class.getName() + "\"");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("trigger");
            stat = conn.createStatement();
        }
        int count = stat.executeUpdate("insert into test_view values(1)");
        this.assertEquals(1, count);
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        count = stat.executeUpdate("delete from test_view");
        this.assertEquals(1, count);
        stat.execute("drop view test_view");
        stat.execute("drop table test");
        conn.close();
    }

    private void testViewTriggerGeneratedKeys() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists test");
        stat.execute("create table test(id int generated by default as identity)");
        stat.execute("create view test_view as select * from test");
        stat.execute("create trigger test_view_insert instead of insert on test_view for each row call \"" + TestViewGeneratedKeys.class.getName() + "\"");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("trigger");
            stat = conn.createStatement();
        }
        PreparedStatement pstat = conn.prepareStatement("insert into test_view values()", new int[]{1});
        int count = pstat.executeUpdate();
        this.assertEquals(1, count);
        ResultSet gkRs = pstat.getGeneratedKeys();
        this.assertTrue(gkRs.next());
        this.assertEquals(1, gkRs.getInt(1));
        this.assertFalse(gkRs.next());
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        stat.execute("drop view test_view");
        stat.execute("drop table test");
        conn.close();
    }

    private void testTriggerBeforeSelect() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("drop table if exists meta_tables");
        stat.execute("create table meta_tables(name varchar)");
        stat.execute("create trigger meta_tables_select before select on meta_tables call \"" + TestSelect.class.getName() + "\"");
        ResultSet rs = stat.executeQuery("select * from meta_tables");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        stat.execute("create table test(id int)");
        rs = stat.executeQuery("select * from meta_tables");
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        conn.close();
        if (!this.config.memory) {
            conn = this.getConnection("trigger");
            stat = conn.createStatement();
            stat.execute("create table test2(id int)");
            rs = stat.executeQuery("select * from meta_tables");
            this.assertTrue(rs.next());
            this.assertTrue(rs.next());
            this.assertTrue(rs.next());
            this.assertFalse(rs.next());
            conn.close();
        }
    }

    private void testTriggerAlterTable() throws SQLException {
        this.deleteDb("trigger");
        this.testTrigger(null);
    }

    private void testTriggerAsSource() throws SQLException {
        this.deleteDb("trigger");
        this.testTrigger("java");
    }

    private void testTriggerAsJavascript() throws SQLException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        if (scriptEngineManager.getEngineByName("javascript") == null) {
            return;
        }
        this.deleteDb("trigger");
        this.testTrigger("javascript");
    }

    private void testTrigger(String sourceLang) throws SQLException {
        String callSeq = "call next value for seq";
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("create sequence seq");
        stat.execute("create table test(id int primary key)");
        this.assertSingleValue(stat, "call next value for seq", 1);
        conn.setAutoCommit(false);
        TestTriggerAlterTable t = new TestTriggerAlterTable();
        t.close();
        if ("java".equals(sourceLang)) {
            String triggerClassName = this.getClass().getName() + "." + TestTriggerAlterTable.class.getSimpleName();
            stat.execute("create trigger test_upd before insert on test as $$org.h2.api.Trigger create() { return new " + triggerClassName + "(); } $$");
        } else if ("javascript".equals(sourceLang)) {
            String triggerClassName = this.getClass().getName() + "." + TestTriggerAlterTable.class.getSimpleName();
            String body = "//javascript\nnew (Java.type(\"" + triggerClassName + "\"))();";
            stat.execute("create trigger test_upd before insert on test as $$" + body + " $$");
        } else {
            stat.execute("create trigger test_upd before insert on test call \"" + TestTriggerAlterTable.class.getName() + "\"");
        }
        stat.execute("insert into test values(1)");
        this.assertSingleValue(stat, "call next value for seq", 3);
        stat.execute("alter table test add column name varchar");
        this.assertSingleValue(stat, "call next value for seq", 4);
        stat.execute("drop sequence seq");
        stat.execute("drop table test");
        conn.close();
    }

    private void testConstraints() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("create table test(id int primary key, parent int)");
        stat.execute("alter table test add constraint test_parent_id foreign key(parent) references test (id) on delete cascade");
        stat.execute("insert into test select x, x/2 from system_range(0, 100)");
        stat.execute("delete from test");
        this.assertSingleValue(stat, "select count(*) from test", 0);
        stat.execute("drop table test");
        conn.close();
    }

    private void testCheckConstraintErrorMessage() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("create table companies(id identity)");
        stat.execute("create table departments(id identity, company_id int not null, foreign key(company_id) references companies(id))");
        stat.execute("create table connections (id identity, company_id int not null, first int not null, `second` int not null, foreign key (company_id) references companies(id), foreign key (first) references departments(id), foreign key (`second`) references departments(id), check (select departments.company_id from departments, companies where        departments.id in (first, `second`)) = company_id)");
        stat.execute("insert into companies(id) values(1)");
        stat.execute("insert into departments(id, company_id) values(10, 1)");
        stat.execute("insert into departments(id, company_id) values(20, 1)");
        this.assertThrows(23514, stat).execute("insert into connections(id, company_id, first, `second`) values(100, 1, 10, 20)");
        stat.execute("drop table connections");
        stat.execute("drop table departments");
        stat.execute("drop table companies");
        conn.close();
    }

    private void testMultiPartForeignKeys() throws SQLException {
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST1");
        stat.execute("DROP TABLE IF EXISTS TEST2");
        stat.execute("create table test1(id int primary key, col1 int)");
        stat.execute("alter table test1 add constraint unique_test1 unique (id,col1)");
        stat.execute("create table test2(id int primary key, col1 int)");
        stat.execute("alter table test2 add constraint fk_test2 foreign key(id,col1) references test1 (id,col1)");
        stat.execute("insert into test1 values (1,1)");
        stat.execute("insert into test1 values (2,2)");
        stat.execute("insert into test1 values (3,3)");
        stat.execute("insert into test2 values (1,1)");
        this.assertThrows(23506, stat).execute("insert into test2 values (2,1)");
        this.assertSingleValue(stat, "select count(*) from test1", 3);
        this.assertSingleValue(stat, "select count(*) from test2", 1);
        stat.execute("drop table test1, test2");
        conn.close();
    }

    private void testTriggers() throws SQLException {
        mustNotCallTrigger = false;
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("CREATE TRIGGER IF NOT EXISTS INS_BEFORE BEFORE INSERT ON TEST FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "'");
        stat.execute("CREATE TRIGGER IF NOT EXISTS INS_BEFORE BEFORE INSERT ON TEST FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "'");
        stat.execute("CREATE TRIGGER INS_AFTER AFTER INSERT ON TEST FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "'");
        stat.execute("CREATE TRIGGER UPD_BEFORE BEFORE UPDATE ON TEST FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "'");
        stat.execute("CREATE TRIGGER INS_AFTER_ROLLBACK AFTER INSERT, ROLLBACK ON TEST FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "'");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        ResultSet rs = stat.executeQuery("SCRIPT");
        this.checkRows(rs, new String[]{"CREATE FORCE TRIGGER \"PUBLIC\".\"INS_BEFORE\" BEFORE INSERT ON \"PUBLIC\".\"TEST\" FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "';", "CREATE FORCE TRIGGER \"PUBLIC\".\"INS_AFTER\" AFTER INSERT ON \"PUBLIC\".\"TEST\" FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "';", "CREATE FORCE TRIGGER \"PUBLIC\".\"UPD_BEFORE\" BEFORE UPDATE ON \"PUBLIC\".\"TEST\" FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "';", "CREATE FORCE TRIGGER \"PUBLIC\".\"INS_AFTER_ROLLBACK\" AFTER INSERT, ROLLBACK ON \"PUBLIC\".\"TEST\" FOR EACH ROW NOWAIT CALL '" + this.getClass().getName() + "';"});
        while (rs.next()) {
            String sql = rs.getString(1);
            if (!sql.startsWith("CREATE TRIGGER")) continue;
            System.out.println(sql);
        }
        rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals("Hello-updated", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("UPDATE TEST SET NAME=NAME||'-upd'");
        rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.assertEquals("Hello-updated-upd-updated2", rs.getString(2));
        this.assertFalse(rs.next());
        mustNotCallTrigger = true;
        stat.execute("DROP TRIGGER IF EXISTS INS_BEFORE");
        stat.execute("DROP TRIGGER IF EXISTS INS_BEFORE");
        stat.execute("DROP TRIGGER IF EXISTS INS_AFTER_ROLLBACK");
        this.assertThrows(90042, stat).execute("DROP TRIGGER INS_BEFORE");
        stat.execute("DROP TRIGGER  INS_AFTER");
        stat.execute("DROP TRIGGER  UPD_BEFORE");
        stat.execute("UPDATE TEST SET NAME=NAME||'-upd-no_trigger'");
        stat.execute("INSERT INTO TEST VALUES(100, 'Insert-no_trigger')");
        conn.close();
        conn = this.getConnection("trigger");
        mustNotCallTrigger = false;
        conn.close();
    }

    private void checkRows(ResultSet rs, String[] expected) throws SQLException {
        HashSet<String> set = new HashSet<String>(Arrays.asList(expected));
        while (rs.next()) {
            set.remove(rs.getString(1));
        }
        if (set.size() > 0) {
            this.fail("set should be empty: " + String.valueOf(set));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrent() throws Exception {
        this.deleteDb("trigger");
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(A INT)");
        stat.execute("CREATE TRIGGER TEST_BEFORE BEFORE INSERT, UPDATE ON TEST FOR EACH ROW CALL " + StringUtils.quoteStringSQL(ConcurrentTrigger.class.getName()));
        Thread[] threads = new Thread[4];
        final AtomicInteger a = new AtomicInteger();
        int i = 0;
        while (i < 4) {
            Thread thread;
            threads[i] = thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (Connection conn = TestTriggersConstraints.this.getConnection("trigger");){
                            PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(A) VALUES ?");
                            int j = 0;
                            while (j < 250) {
                                prep.setInt(1, a.getAndIncrement());
                                prep.executeUpdate();
                                ++j;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw DbException.convert(e);
                    }
                }
            };
            ++i;
        }
        Class<TestTriggersConstraints> clazz = TestTriggersConstraints.class;
        synchronized (TestTriggersConstraints.class) {
            AtomicIntegerArray array = ConcurrentTrigger.array;
            int l = array.length();
            int i2 = 0;
            while (i2 < l) {
                array.set(i2, 0);
                ++i2;
            }
            Thread[] threadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                thread.start();
                ++n2;
            }
            threadArray = threads;
            n = threads.length;
            n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                thread.join();
                ++n2;
            }
            i = 0;
            while (i < l) {
                this.assertEquals(1, array.get(i));
                ++i;
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            conn.close();
            return;
        }
    }

    @Override
    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        if (mustNotCallTrigger) {
            throw new AssertionError((Object)"must not be called now");
        }
        if (conn == null) {
            throw new AssertionError((Object)"connection is null");
        }
        if (this.triggerName.startsWith("INS_BEFORE")) {
            newRow[1] = String.valueOf(newRow[1]) + "-updated";
        } else if (this.triggerName.startsWith("INS_AFTER")) {
            if (!newRow[1].toString().endsWith("-updated")) {
                throw new AssertionError((Object)"supposed to be updated");
            }
            this.checkCommit(conn);
        } else if (this.triggerName.startsWith("UPD_BEFORE")) {
            newRow[1] = String.valueOf(newRow[1]) + "-updated2";
        } else if (this.triggerName.startsWith("UPD_AFTER")) {
            if (!newRow[1].toString().endsWith("-updated2")) {
                throw new AssertionError((Object)"supposed to be updated2");
            }
            this.checkCommit(conn);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void remove() {
    }

    private void checkCommit(Connection conn) throws SQLException {
        this.assertThrows(90058, conn).commit();
        this.assertThrows(90058, conn.createStatement()).execute("CREATE TABLE X(ID INT)");
    }

    @Override
    public void init(Connection conn, String schemaName, String trigger, String tableName, boolean before, int type) {
        this.triggerName = trigger;
        if (!"TEST".equals(tableName)) {
            throw new AssertionError((Object)"supposed to be TEST");
        }
        if (trigger.endsWith("AFTER") && before || trigger.endsWith("BEFORE") && !before) {
            throw new AssertionError((Object)("triggerName: " + trigger + " before:" + before));
        }
        if (trigger.startsWith("UPD") && type != 2 || trigger.startsWith("INS") && type != 1 || trigger.startsWith("DEL") && type != 4) {
            throw new AssertionError((Object)("triggerName: " + trigger + " type:" + type));
        }
    }

    public static final class ConcurrentTrigger
    extends TriggerAdapter {
        static final int N_T = 4;
        static final int N_R = 250;
        static final AtomicIntegerArray array = new AtomicIntegerArray(1000);

        @Override
        public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
            array.set(newRow.getInt(1), 1);
        }
    }

    public static class DeleteTrigger
    extends TriggerAdapter {
        @Override
        public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
            conn.createStatement().execute("delete from test");
        }
    }

    public static class NullTrigger
    implements Trigger {
        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            newRow[1] = null;
        }
    }

    public static class NullTriggerAdapter
    extends TriggerAdapter {
        @Override
        public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
            newRow.updateNull(2);
        }
    }

    public static class TestSelect
    implements Trigger {
        PreparedStatement prepMeta;

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            this.prepMeta = conn.prepareStatement("insert into meta_tables select table_name from information_schema.tables where table_schema='PUBLIC'");
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (oldRow != null || newRow != null) {
                throw new SQLException("old and new must be null");
            }
            conn.createStatement().execute("delete from meta_tables");
            this.prepMeta.execute();
        }
    }

    public static class TestTriggerAdapter
    extends TriggerAdapter {
        @Override
        public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
            StringBuilder buff = new StringBuilder();
            if (oldRow != null) {
                buff.append("-").append(oldRow.getString("id")).append(';');
            }
            if (newRow != null) {
                buff.append("+").append(newRow.getString("id")).append(';');
            }
            if (!"TEST_INSERT".equals(this.triggerName)) {
                throw new RuntimeException("Wrong trigger name: " + this.triggerName);
            }
            if (!"TEST".equals(this.tableName)) {
                throw new RuntimeException("Wrong table name: " + this.tableName);
            }
            if (!"PUBLIC".equals(this.schemaName)) {
                throw new RuntimeException("Wrong schema name: " + this.schemaName);
            }
            if (this.type != 7) {
                throw new RuntimeException("Wrong type: " + this.type);
            }
            if (newRow != null) {
                if (oldRow == null) {
                    if (newRow.getInt(1) != 1) {
                        throw new RuntimeException("Expected: 1 got: " + newRow.getString(1));
                    }
                } else if (newRow.getInt(1) != 2) {
                    throw new RuntimeException("Expected: 2 got: " + newRow.getString(1));
                }
                newRow.getCharacterStream(2);
                newRow.getBinaryStream(3);
                newRow.updateInt(1, newRow.getInt(1) * 10);
            }
            conn.createStatement().execute("insert into message values('" + buff.toString() + "')");
        }
    }

    public static class TestTriggerAlterTable
    implements Trigger {
        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            conn.createStatement().execute("call next value for seq");
        }

        @Override
        public void close() {
        }

        @Override
        public void remove() {
        }
    }

    public static class TestView
    implements Trigger {
        PreparedStatement prepInsert;

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            this.prepInsert = conn.prepareStatement("insert into test values(?)");
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (newRow != null) {
                this.prepInsert.setInt(1, (Integer)newRow[0]);
                this.prepInsert.execute();
            }
        }
    }

    public static class TestViewGeneratedKeys
    implements Trigger {
        PreparedStatement prepInsert;

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            this.prepInsert = conn.prepareStatement("insert into test values()", 1);
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (newRow != null) {
                this.prepInsert.execute();
                ResultSet rs = this.prepInsert.getGeneratedKeys();
                if (rs.next()) {
                    newRow[0] = ValueBigint.get(rs.getLong(1));
                }
            }
        }
    }

    public static class WrongTrigger
    implements Trigger {
        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            newRow[1] = "Wrong value";
        }
    }

    public static class WrongTriggerAdapter
    extends TriggerAdapter {
        @Override
        public void fire(Connection conn, ResultSet oldRow, ResultSet newRow) throws SQLException {
            newRow.updateString(2, "Wrong value");
        }
    }
}

