/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestTwoPhaseCommit
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory && !this.config.networked;
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("twoPhaseCommit");
        this.prepare();
        this.openWith(true);
        this.test(true);
        this.prepare();
        this.openWith(false);
        this.test(false);
        this.testInDoubtAfterShutdown();
        this.deleteDb("twoPhaseCommit");
    }

    private void test(boolean rolledBack) throws SQLException {
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        if (!rolledBack) {
            rs.next();
            this.assertEquals(2, rs.getInt(1));
            this.assertEquals("World", rs.getString(2));
        }
        this.assertFalse(rs.next());
        conn.close();
    }

    private void openWith(boolean rollback) throws SQLException {
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT");
        while (rs.next()) {
            list.add(rs.getString("TRANSACTION_NAME"));
        }
        for (String s : list) {
            if (rollback) {
                stat.execute("ROLLBACK TRANSACTION " + s);
                continue;
            }
            stat.execute("COMMIT TRANSACTION " + s);
        }
        conn.close();
    }

    private void prepare() throws SQLException {
        this.deleteDb("twoPhaseCommit");
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("SET WRITE_DELAY 0");
        conn.setAutoCommit(false);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        conn.commit();
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        stat.execute("PREPARE COMMIT XID_TEST_TRANSACTION_WITH_LONG_NAME");
        this.crash(conn);
    }

    private void testInDoubtAfterShutdown() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("twoPhaseCommit");
        Connection conn = this.getConnection("twoPhaseCommit");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID INT PRIMARY KEY)");
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES (1)");
        stat.execute("PREPARE COMMIT \"#1\"");
        conn.commit();
        stat.execute("SHUTDOWN IMMEDIATELY");
        conn = this.getConnection("twoPhaseCommit");
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT TRANSACTION_NAME, TRANSACTION_STATE FROM INFORMATION_SCHEMA.IN_DOUBT");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT ID FROM TEST");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES (2)");
        stat.execute("PREPARE COMMIT \"#2\"");
        conn.rollback();
        stat.execute("SHUTDOWN IMMEDIATELY");
        conn = this.getConnection("twoPhaseCommit");
        stat = conn.createStatement();
        rs = stat.executeQuery("SELECT TRANSACTION_NAME, TRANSACTION_STATE FROM INFORMATION_SCHEMA.IN_DOUBT");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT ID FROM TEST");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES (3)");
        stat.execute("PREPARE COMMIT \"#3\"");
        stat.execute("SHUTDOWN IMMEDIATELY");
        conn = this.getConnection("twoPhaseCommit");
        stat = conn.createStatement();
        rs = stat.executeQuery("SELECT TRANSACTION_NAME, TRANSACTION_STATE FROM INFORMATION_SCHEMA.IN_DOUBT");
        this.assertTrue(rs.next());
        this.assertEquals("#3", rs.getString("TRANSACTION_NAME"));
        this.assertEquals("IN_DOUBT", rs.getString("TRANSACTION_STATE"));
        rs = stat.executeQuery("SELECT ID FROM TEST");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        conn.close();
        this.deleteDb("twoPhaseCommit");
    }
}

