/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestViewDropView
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = this.getConnection(this.getTestName());
        this.stat = this.conn.createStatement();
        this.testDropViewDefaultBehaviour();
        this.testDropViewRestrict();
        this.testDropViewCascade();
        this.testCreateForceView();
        this.testCreateOrReplaceView();
        this.testCreateOrReplaceViewWithNowInvalidDependentViews();
        this.testCreateOrReplaceForceViewWithNowInvalidDependentViews();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testCreateForceView() throws SQLException {
        this.assertThrows(42104, this.stat).execute("create view test_view as select * from test");
        this.stat.execute("create force view test_view as select * from test");
        this.stat.execute("create table test(id int)");
        this.stat.execute("alter view test_view recompile");
        this.stat.execute("select * from test_view");
        this.stat.execute("drop table test_view, test cascade");
        this.stat.execute("create force view test_view as select * from test where 1=0");
        this.stat.execute("create table test(id int)");
        this.stat.execute("alter view test_view recompile");
        this.stat.execute("select * from test_view");
        this.stat.execute("drop table test_view, test cascade");
    }

    private void testDropViewDefaultBehaviour() throws SQLException {
        this.createTestData();
        ResultSet rs = this.stat.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'DROP_RESTRICT'");
        rs.next();
        boolean dropRestrict = rs.getBoolean(1);
        if (dropRestrict) {
            this.assertThrows(90107, this.stat).execute("drop view v1");
        } else {
            this.stat.execute("drop view v1");
            this.checkViewRemainsValid();
        }
    }

    private void testDropViewRestrict() throws SQLException {
        this.createTestData();
        this.assertThrows(90107, this.stat).execute("drop view v1 restrict");
        this.checkViewRemainsValid();
    }

    private void testDropViewCascade() throws SQLException {
        this.createTestData();
        this.stat.execute("drop view v1 cascade");
        this.assertThrows(42102, this.stat).execute("select * from v1");
        this.assertThrows(42102, this.stat).execute("select * from v2");
        this.assertThrows(42102, this.stat).execute("select * from v3");
        this.stat.execute("drop table test");
    }

    private void testCreateOrReplaceView() throws SQLException {
        this.createTestData();
        this.stat.execute("create or replace view v1 as select a as b, b as a, c from test");
        this.checkViewRemainsValid();
    }

    private void testCreateOrReplaceViewWithNowInvalidDependentViews() throws SQLException {
        this.createTestData();
        this.assertThrows(42122, this.stat).execute("create or replace view v1 as select c from test");
        this.checkViewRemainsValid();
    }

    private void testCreateOrReplaceForceViewWithNowInvalidDependentViews() throws SQLException {
        this.createTestData();
        this.stat.execute("create or replace force view v1 as select c from test");
        this.assertThrows(42122, this.stat).executeQuery("select b from v2");
        this.stat.execute("drop table test cascade");
    }

    private void createTestData() throws SQLException {
        this.stat.execute("drop all objects");
        this.stat.execute("create table test(a int, b int, c int)");
        this.stat.execute("insert into test(a, b, c) values (1, 2, 3)");
        this.stat.execute("create view v1 as select a as b, b as a from test");
        this.stat.execute("create view v2 as select * from v1");
        this.stat.execute("create view v3 as select * from v2");
    }

    private void checkViewRemainsValid() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select b from v1");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.stat.executeQuery("select b from v2");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs = this.stat.executeQuery("select b from test");
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertFalse(rs.next());
        this.stat.execute("drop table test cascade");
        ResultSet d = this.conn.getMetaData().getTables(null, null, null, null);
        while (d.next()) {
            this.assertEquals(d.getString(2) + "." + d.getString(3), "INFORMATION_SCHEMA", d.getString(2));
        }
    }
}

