/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;

public class TestCallableStatement
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("callableStatement");
        Connection conn = this.getConnection("callableStatement");
        this.testOutParameter(conn);
        this.testUnsupportedOperations(conn);
        this.testGetters(conn);
        this.testCallWithResultSet(conn);
        this.testPreparedStatement(conn);
        this.testCallWithResult(conn);
        this.testPrepare(conn);
        this.testClassLoader(conn);
        this.testArrayArgument(conn);
        this.testArrayReturnValue(conn);
        conn.close();
        this.deleteDb("callableStatement");
    }

    private void testOutParameter(Connection conn) throws SQLException {
        conn.createStatement().execute("CREATE SEQUENCE SEQ");
        int i = 1;
        while (i < 20) {
            CallableStatement cs = conn.prepareCall("{ ? = CALL NEXT VALUE FOR SEQ}");
            cs.registerOutParameter(1, -5);
            cs.execute();
            long id = cs.getLong(1);
            this.assertEquals((long)i, id);
            cs.close();
            ++i;
        }
        conn.createStatement().execute("DROP SEQUENCE SEQ");
    }

    private void testUnsupportedOperations(Connection conn) throws SQLException {
        CallableStatement call = conn.prepareCall("select 10 as a");
        this.assertThrows(50100, call).getURL(1);
        this.assertThrows(50100, call).getObject(1, Collections.emptyMap());
        this.assertThrows(50100, call).getRef(1);
        this.assertThrows(50100, call).getRowId(1);
        this.assertThrows(50100, call).getURL("a");
        this.assertThrows(50100, call).getObject("a", Collections.emptyMap());
        this.assertThrows(50100, call).getRef("a");
        this.assertThrows(50100, call).getRowId("a");
        this.assertThrows(50100, call).setURL(1, null);
        this.assertThrows(50100, call).setRef(1, null);
        this.assertThrows(50100, call).setRowId(1, null);
        this.assertThrows(50100, call).setURL("a", null);
        this.assertThrows(50100, call).setRowId("a", null);
    }

    private void testCallWithResultSet(Connection conn) throws SQLException {
        CallableStatement call = conn.prepareCall("select 10 as a");
        call.execute();
        ResultSet rs = call.getResultSet();
        rs.next();
        this.assertEquals(10, rs.getInt(1));
    }

    private void testPreparedStatement(Connection conn) throws SQLException {
        CallableStatement call = conn.prepareCall("create table test(id int)");
        call.executeUpdate();
        call = conn.prepareCall("insert into test values(1), (2)");
        this.assertEquals(2, call.executeUpdate());
        call = conn.prepareCall("drop table test");
        call.executeUpdate();
    }

    private void testGetters(Connection conn) throws SQLException {
        CallableStatement call = conn.prepareCall("{?=call ?}");
        call.setLong(2, 1L);
        call.registerOutParameter(1, -5);
        call.execute();
        this.assertEquals(1L, call.getLong(1));
        this.assertEquals(1, call.getByte(1));
        this.assertEquals(1L, (Long)call.getObject(1));
        this.assertEquals(1L, call.getObject(1, Long.class));
        this.assertFalse(call.wasNull());
        call.setFloat(2, 1.1f);
        call.registerOutParameter(1, 7);
        call.execute();
        this.assertEquals(1.1f, call.getFloat(1));
        call.setDouble(2, Math.PI);
        call.registerOutParameter(1, 8);
        call.execute();
        this.assertEquals(Math.PI, call.getDouble(1));
        call.setBytes(2, new byte[11]);
        call.registerOutParameter(1, -2);
        call.execute();
        this.assertEquals(11, call.getBytes(1).length);
        this.assertEquals(11L, call.getBlob(1).length());
        call.setDate(2, Date.valueOf("2000-01-01"));
        call.registerOutParameter(1, 91);
        call.execute();
        this.assertEquals("2000-01-01", call.getDate(1).toString());
        this.assertEquals("2000-01-01", call.getObject(1, LocalDate.class).toString());
        call.setTime(2, Time.valueOf("01:02:03"));
        call.registerOutParameter(1, 92);
        call.execute();
        this.assertEquals("01:02:03", call.getTime(1).toString());
        this.assertEquals("01:02:03", call.getObject(1, LocalTime.class).toString());
        call.setTimestamp(2, Timestamp.valueOf("2001-02-03 04:05:06.789"));
        call.registerOutParameter(1, 93);
        call.execute();
        this.assertEquals("2001-02-03 04:05:06.789", call.getTimestamp(1).toString());
        this.assertEquals("2001-02-03T04:05:06.789", call.getObject(1, LocalDateTime.class).toString());
        call.setBoolean(2, true);
        call.registerOutParameter(1, -7);
        call.execute();
        this.assertEquals(true, call.getBoolean(1));
        call.setShort(2, (short)123);
        call.registerOutParameter(1, 5);
        call.execute();
        this.assertEquals(123, call.getShort(1));
        call.setBigDecimal(2, BigDecimal.TEN);
        call.registerOutParameter(1, 3);
        call.execute();
        this.assertEquals("10", call.getBigDecimal(1).toString());
    }

    private void testCallWithResult(Connection conn) throws SQLException {
        String[] stringArray = new String[]{"{?= call abs(?)}", " { ? = call abs(?)}", " {? = call abs(?)}"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            CallableStatement call = conn.prepareCall(s);
            call.setInt(2, -3);
            call.registerOutParameter(1, 4);
            call.execute();
            this.assertEquals(3, call.getInt(1));
            call.executeUpdate();
            this.assertEquals(3, call.getInt(1));
            ++n2;
        }
    }

    private void testPrepare(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR)");
        CallableStatement call = conn.prepareCall("INSERT INTO TEST VALUES(?, ?)");
        call.setInt(1, 1);
        call.setString(2, "Hello");
        call.execute();
        call = conn.prepareCall("SELECT * FROM TEST", 1003, 1007);
        ResultSet rs = call.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        call = conn.prepareCall("SELECT * FROM TEST", 1003, 1007, 1);
        rs = call.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        stat.execute("CREATE ALIAS testCall FOR '" + this.getClass().getName() + ".testCall'");
        call = conn.prepareCall("{SELECT * FROM testCall(?, ?, ?, ?)}");
        call.setInt("A", 50);
        call.setString("B", "abc");
        long t = System.currentTimeMillis();
        call.setTimestamp("C", new Timestamp(t));
        call.setTimestamp("D", Timestamp.valueOf("2001-02-03 10:20:30.0"));
        call.registerOutParameter(1, 4);
        call.registerOutParameter("B", 12);
        call.executeUpdate();
        this.assertThrows(90008, call).getTimestamp("C");
        call.registerOutParameter(3, 93);
        call.registerOutParameter(4, 93);
        call.executeUpdate();
        this.assertEquals(t + 1L, call.getTimestamp(3).getTime());
        this.assertEquals(t + 1L, call.getTimestamp("C").getTime());
        this.assertEquals("2001-02-03 10:20:30.0", call.getTimestamp(4).toString());
        this.assertEquals("2001-02-03 10:20:30.0", call.getTimestamp("D").toString());
        this.assertEquals("2001-02-03T10:20:30", call.getObject(4, LocalDateTime.class).toString());
        this.assertEquals("2001-02-03T10:20:30", call.getObject("D", LocalDateTime.class).toString());
        this.assertEquals("10:20:30", call.getTime(4).toString());
        this.assertEquals("10:20:30", call.getTime("D").toString());
        this.assertEquals("10:20:30", call.getObject(4, LocalTime.class).toString());
        this.assertEquals("10:20:30", call.getObject("D", LocalTime.class).toString());
        this.assertEquals("2001-02-03", call.getDate(4).toString());
        this.assertEquals("2001-02-03", call.getDate("D").toString());
        this.assertEquals("2001-02-03", call.getObject(4, LocalDate.class).toString());
        this.assertEquals("2001-02-03", call.getObject("D", LocalDate.class).toString());
        this.assertEquals(100, call.getInt(1));
        this.assertEquals(100, call.getInt("A"));
        this.assertEquals(100L, call.getLong(1));
        this.assertEquals(100L, call.getLong("A"));
        this.assertEquals("100", call.getBigDecimal(1).toString());
        this.assertEquals("100", call.getBigDecimal("A").toString());
        this.assertEquals(100.0f, call.getFloat(1));
        this.assertEquals(100.0f, call.getFloat("A"));
        this.assertEquals(100.0, call.getDouble(1));
        this.assertEquals(100.0, call.getDouble("A"));
        this.assertEquals(100, call.getByte(1));
        this.assertEquals(100, call.getByte("A"));
        this.assertEquals(100, call.getShort(1));
        this.assertEquals(100, call.getShort("A"));
        this.assertTrue(call.getBoolean(1));
        this.assertTrue(call.getBoolean("A"));
        this.assertEquals("ABC", call.getString(2));
        Reader r = call.getCharacterStream(2);
        this.assertEquals("ABC", IOUtils.readStringAndClose(r, -1));
        r = call.getNCharacterStream(2);
        this.assertEquals("ABC", IOUtils.readStringAndClose(r, -1));
        this.assertEquals("ABC", call.getString("B"));
        this.assertEquals("ABC", call.getNString(2));
        this.assertEquals("ABC", call.getNString("B"));
        this.assertEquals("ABC", call.getClob(2).getSubString(1L, 3));
        this.assertEquals("ABC", call.getClob("B").getSubString(1L, 3));
        this.assertEquals("ABC", call.getNClob(2).getSubString(1L, 3));
        this.assertEquals("ABC", call.getNClob("B").getSubString(1L, 3));
        this.assertEquals("ABC", call.getSQLXML(2).getString());
        this.assertEquals("ABC", call.getSQLXML("B").getString());
        this.assertThrows(90008, call).getString(100);
        this.assertThrows(90008, call).getString(0);
        this.assertThrows(90008, call).getBoolean("X");
        call.setCharacterStream("B", (Reader)new StringReader("xyz"));
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setCharacterStream("B", (Reader)new StringReader("xyz-"), 3);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setCharacterStream("B", (Reader)new StringReader("xyz-"), 3L);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setAsciiStream("B", (InputStream)new ByteArrayInputStream("xyz".getBytes(StandardCharsets.UTF_8)));
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setAsciiStream("B", (InputStream)new ByteArrayInputStream("xyz-".getBytes(StandardCharsets.UTF_8)), 3);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setAsciiStream("B", (InputStream)new ByteArrayInputStream("xyz-".getBytes(StandardCharsets.UTF_8)), 3L);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setClob("B", (Reader)new StringReader("xyz"));
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setClob("B", (Reader)new StringReader("xyz-"), 3L);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setNClob("B", (Reader)new StringReader("xyz"));
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setNClob("B", (Reader)new StringReader("xyz-"), 3L);
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setString("B", "xyz");
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        call.setNString("B", "xyz");
        call.executeUpdate();
        this.assertEquals("XYZ", call.getString("B"));
        SQLXML xml = conn.createSQLXML();
        xml.setString("<x>xyz</x>");
        call.setSQLXML("B", xml);
        call.executeUpdate();
        this.assertEquals("<X>XYZ</X>", call.getString("B"));
        call.close();
        this.assertThrows(90007, call).executeUpdate();
        this.assertThrows(90007, call).registerOutParameter(1, 4);
        this.assertThrows(90007, call).getString("X");
    }

    private void testClassLoader(Connection conn) throws SQLException {
        TestClassFactory myFactory = new TestClassFactory();
        JdbcUtils.addClassFactory(myFactory);
        try {
            Statement stat = conn.createStatement();
            stat.execute("CREATE ALIAS T_CLASSLOADER FOR 'TestClassFactory.testClassF'");
            ResultSet rs = stat.executeQuery("SELECT T_CLASSLOADER(true)");
            this.assertTrue(rs.next());
            this.assertEquals(false, rs.getBoolean(1));
        }
        finally {
            JdbcUtils.removeClassFactory(myFactory);
        }
    }

    private void testArrayArgument(Connection connection) throws SQLException {
        Array array = connection.createArrayOf("Int", new Object[]{0, 1, 2});
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet;
                Object var10_18;
                Throwable throwable2;
                CallableStatement callableStatement;
                statement.execute("CREATE ALIAS getArrayLength FOR '" + this.getClass().getName() + ".getArrayLength'");
                Throwable throwable3 = null;
                Object var7_11 = null;
                try {
                    callableStatement = connection.prepareCall("{call getArrayLength(?)}");
                    try {
                        callableStatement.setArray(1, array);
                        this.assertTrue(callableStatement.execute());
                        throwable2 = null;
                        var10_18 = null;
                        try {
                            resultSet = callableStatement.getResultSet();
                            try {
                                this.assertTrue(resultSet.next());
                                this.assertEquals(3, resultSet.getInt(1));
                                this.assertFalse(resultSet.next());
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable3 == null) {
                        throwable3 = throwable5;
                    } else if (throwable3 != throwable5) {
                        throwable3.addSuppressed(throwable5);
                    }
                    throw throwable3;
                }
                throwable3 = null;
                var7_11 = null;
                try {
                    callableStatement = connection.prepareCall("{call getArrayLength(?)}");
                    try {
                        callableStatement.setObject(1, (Object)array);
                        this.assertTrue(callableStatement.execute());
                        throwable2 = null;
                        var10_18 = null;
                        try {
                            resultSet = callableStatement.getResultSet();
                            try {
                                this.assertTrue(resultSet.next());
                                this.assertEquals(3, resultSet.getInt(1));
                                this.assertFalse(resultSet.next());
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (callableStatement != null) {
                            callableStatement.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                    } else if (throwable3 != throwable7) {
                        throwable3.addSuppressed(throwable7);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        finally {
            array.free();
        }
    }

    private void testArrayReturnValue(Connection connection) throws SQLException {
        Integer[][] integerArrayArray = new Integer[3][];
        integerArrayArray[0] = new Integer[]{0, 1, 2};
        integerArrayArray[1] = new Integer[]{0, 1, 2};
        Integer[] integerArray = new Integer[3];
        integerArray[0] = 0;
        integerArray[2] = 2;
        integerArrayArray[2] = integerArray;
        Integer[][] arraysToTest = integerArrayArray;
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE ALIAS arrayIdentiy FOR '" + this.getClass().getName() + ".arrayIdentiy'");
            Integer[][] integerArrayArray2 = arraysToTest;
            int n = arraysToTest.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] arrayToTest = integerArrayArray2[n2];
                Array sqlInputArray = connection.createArrayOf("INTEGER", arrayToTest);
                try {
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (CallableStatement callableStatement = connection.prepareCall("{call arrayIdentiy(?)}");){
                        callableStatement.setArray(1, sqlInputArray);
                        this.assertTrue(callableStatement.execute());
                        Throwable throwable3 = null;
                        Object var15_20 = null;
                        try (ResultSet resultSet = callableStatement.getResultSet();){
                            this.assertTrue(resultSet.next());
                            Array sqlReturnArray = resultSet.getArray(1);
                            try {
                                this.assertEquals((Object[])sqlInputArray.getArray(), (Object[])sqlReturnArray.getArray());
                            }
                            finally {
                                sqlReturnArray.free();
                            }
                            sqlReturnArray = resultSet.getObject(1, Array.class);
                            try {
                                this.assertEquals((Object[])sqlInputArray.getArray(), (Object[])sqlReturnArray.getArray());
                            }
                            finally {
                                sqlReturnArray.free();
                            }
                            this.assertFalse(resultSet.next());
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    sqlInputArray.free();
                }
                ++n2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static Boolean testClassF(Boolean b) {
        return b == false;
    }

    public static int getArrayLength(Integer[] array) {
        return array == null ? 0 : array.length;
    }

    public static Integer[] arrayIdentiy(Integer[] array) {
        return array;
    }

    public static ResultSet testCall(Connection conn, int a, String b, Timestamp c, Timestamp d) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("A", 4, 0, 0);
        rs.addColumn("B", 12, 0, 0);
        rs.addColumn("C", 93, 0, 0);
        rs.addColumn("D", 93, 0, 0);
        if ("jdbc:columnlist:connection".equals(conn.getMetaData().getURL())) {
            return rs;
        }
        rs.addRow(a * 2, b.toUpperCase(), new Timestamp(c.getTime() + 1L), d);
        return rs;
    }

    static class TestClassFactory
    implements Utils.ClassFactory {
        TestClassFactory() {
        }

        @Override
        public boolean match(String name) {
            return name.equals("TestClassFactory");
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return TestCallableStatement.class;
        }
    }
}

