/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestCancel
extends TestDb {
    private static int lastVisited;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testQueryTimeoutInTransaction();
        this.testReset();
        this.testMaxQueryTimeout();
        this.testQueryTimeout();
        this.testJdbcQueryTimeout();
        this.testCancelStatement();
        this.deleteDb("cancel");
    }

    private void testReset() throws SQLException {
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        stat.execute("set query_timeout 1");
        this.assertThrows(57014, stat).execute("select count(*) from system_range(1, 1000000), system_range(1, 1000000)");
        stat.execute("set query_timeout 0");
        stat.execute("select count(*) from system_range(1, 1000), system_range(1, 1000)");
        conn.close();
    }

    private void testQueryTimeoutInTransaction() throws SQLException {
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT)");
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(1)");
        Savepoint sp = conn.setSavepoint();
        stat.execute("INSERT INTO TEST VALUES(2)");
        stat.setQueryTimeout(1);
        conn.rollback(sp);
        conn.commit();
        conn.close();
    }

    private void testJdbcQueryTimeout() throws SQLException {
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        this.assertEquals(0, stat.getQueryTimeout());
        stat.setQueryTimeout(1);
        this.assertEquals(1, stat.getQueryTimeout());
        Statement s2 = conn.createStatement();
        this.assertEquals(1, s2.getQueryTimeout());
        ResultSet rs = s2.executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'QUERY_TIMEOUT'");
        rs.next();
        this.assertEquals(1000, rs.getInt(1));
        this.assertThrows(57014, stat).executeQuery("SELECT MAX(RAND()) FROM SYSTEM_RANGE(1, 100000000)");
        stat.setQueryTimeout(0);
        stat.execute("SET QUERY_TIMEOUT 1100");
        this.assertEquals(0, stat.getQueryTimeout());
        conn.close();
    }

    private void testQueryTimeout() throws SQLException {
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        stat.execute("SET QUERY_TIMEOUT 10");
        this.assertThrows(57014, stat).executeQuery("SELECT MAX(RAND()) FROM SYSTEM_RANGE(1, 100000000)");
        conn.close();
    }

    private void testMaxQueryTimeout() throws SQLException {
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel;MAX_QUERY_TIMEOUT=10");
        Statement stat = conn.createStatement();
        this.assertThrows(57014, stat).executeQuery("SELECT MAX(RAND()) FROM SYSTEM_RANGE(1, 100000000)");
        conn.close();
    }

    public static int visit(int x) {
        lastVisited = x;
        return x;
    }

    private void testCancelStatement() throws Exception {
        if (this.config.lazy && this.config.networked) {
            return;
        }
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE  ALIAS VISIT FOR '" + this.getClass().getName() + ".visit'");
        stat.execute("CREATE  MEMORY TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        this.trace("insert");
        int len = this.getSize(10, 1000);
        int i = 0;
        while (i < len) {
            prep.setInt(1, i);
            prep.setString(2, "hi");
            prep.execute();
            ++i;
        }
        this.trace("inserted");
        i = 1;
        while (true) {
            Statement query = conn.createStatement();
            CancelThread cancel = new CancelThread(query, i);
            TestCancel.visit(0);
            cancel.start();
            try {
                Thread.yield();
                this.assertThrows(57014, query, "SELECT VISIT(ID), (SELECT SUM(X) FROM SYSTEM_RANGE(1, 100000) WHERE X<>ID) FROM TEST ORDER BY ID");
            }
            finally {
                cancel.stopNow();
                cancel.join();
            }
            if (lastVisited != 0) break;
            i += 10;
        }
        conn.close();
    }

    static class CancelThread
    extends Thread {
        private final Statement cancel;
        private final int wait;
        private volatile boolean stop;

        CancelThread(Statement cancel, int wait) {
            this.cancel = cancel;
            this.wait = wait;
        }

        public void stopNow() {
            this.stop = true;
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(this.wait);
                    this.cancel.cancel();
                    Thread.yield();
                }
                catch (SQLException sQLException) {
                }
                catch (Exception e) {
                    TestBase.logError("sleep", e);
                }
            }
        }
    }
}

