/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestDatabaseEventListener
extends TestDb {
    static boolean calledOpened;
    static boolean calledClosingDatabase;
    static boolean calledScan;
    static boolean calledCreateIndex;
    static boolean calledStatementStart;
    static boolean calledStatementEnd;
    static boolean calledStatementProgress;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testInit();
        this.testIndexRebuiltOnce();
        this.testIndexNotRebuilt();
        this.testCalled();
        this.testCloseLog0(false);
        this.testCloseLog0(true);
        this.testCalledForStatement();
        this.deleteDb("databaseEventListener");
    }

    private void testInit() throws SQLException {
        if (this.config.cipher != null || this.config.memory) {
            return;
        }
        this.deleteDb("databaseEventListener");
        Object url = this.getURL("databaseEventListener", true);
        url = (String)url + ";DATABASE_EVENT_LISTENER='" + Init.class.getName() + "'";
        Connection conn = DriverManager.getConnection((String)url, "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("select * from test");
        conn.close();
    }

    private void testIndexRebuiltOnce() throws SQLException {
        Statement stat;
        Connection conn;
        if (this.config.memory) {
            return;
        }
        this.deleteDb("databaseEventListener");
        String url = this.getURL("databaseEventListener", true);
        String user = this.getUser();
        String password = this.getPassword();
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", password);
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            conn = DriverManager.getConnection(url, p);
            try {
                stat = conn.createStatement();
                stat.execute("create table old(id identity) as select 1");
                stat.execute("create table test(id identity) as select 1");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_8 = null;
        try {
            conn = DriverManager.getConnection(url, p);
            try {
                stat = conn.createStatement();
                stat.execute("drop table old");
                stat.execute("insert into test values(2)");
                stat.execute("checkpoint sync");
                stat.execute("shutdown immediately");
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var7_8 = null;
        try {
            conn = DriverManager.getConnection(url, p);
            if (conn != null) {
                conn.close();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        calledCreateIndex = false;
        p.put("DATABASE_EVENT_LISTENER", MyDatabaseEventListener.class.getName());
        throwable = null;
        var7_8 = null;
        try {
            conn = Driver.load().connect(url, p);
            if (conn != null) {
                conn.close();
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        this.assertFalse(calledCreateIndex);
    }

    private void testIndexNotRebuilt() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("databaseEventListener");
        String url = this.getURL("databaseEventListener", true);
        String user = this.getUser();
        String password = this.getPassword();
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", password);
        Connection conn = DriverManager.getConnection(url, p);
        Statement stat = conn.createStatement();
        stat.execute("create table old(id identity) as select 1");
        stat.execute("create table test(id identity) as select 1");
        conn.close();
        conn = DriverManager.getConnection(url, p);
        stat = conn.createStatement();
        stat.execute("drop table old");
        stat.execute("truncate table test");
        stat.execute("insert into test select 1");
        conn.close();
        calledCreateIndex = false;
        p.put("DATABASE_EVENT_LISTENER", MyDatabaseEventListener.class.getName());
        conn = Driver.load().connect(url, p);
        conn.close();
        this.assertFalse(calledCreateIndex);
    }

    private void testCloseLog0(boolean shutdown) throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("databaseEventListener");
        String url = this.getURL("databaseEventListener", true);
        String user = this.getUser();
        String password = this.getPassword();
        Properties p = new Properties();
        p.setProperty("user", user);
        p.setProperty("password", password);
        Connection conn = DriverManager.getConnection(url, p);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("insert into test select x, space(1000) from system_range(1,1000)");
        if (shutdown) {
            stat.execute("shutdown");
        }
        conn.close();
        calledOpened = false;
        calledScan = false;
        p.put("DATABASE_EVENT_LISTENER", MyDatabaseEventListener.class.getName());
        conn = Driver.load().connect(url, p);
        conn.close();
        if (calledOpened) {
            this.assertFalse(calledScan);
        }
    }

    private void testCalled() throws SQLException {
        Properties p = new Properties();
        p.setProperty("user", "sa");
        p.setProperty("password", "sa");
        calledOpened = false;
        calledClosingDatabase = false;
        p.put("DATABASE_EVENT_LISTENER", MyDatabaseEventListener.class.getName());
        Driver.load();
        String url = "jdbc:h2:mem:databaseEventListener";
        Connection conn = Driver.load().connect(url, p);
        conn.close();
        this.assertTrue(calledOpened);
        this.assertTrue(calledClosingDatabase);
    }

    private void testCalledForStatement() throws SQLException {
        Properties p = new Properties();
        p.setProperty("user", "sa");
        p.setProperty("password", "sa");
        calledStatementStart = false;
        calledStatementEnd = false;
        calledStatementProgress = false;
        p.put("DATABASE_EVENT_LISTENER", MyDatabaseEventListener.class.getName());
        Driver.load();
        String url = "jdbc:h2:mem:databaseEventListener";
        Connection conn = Driver.load().connect(url, p);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("select * from test");
        conn.close();
        this.assertTrue(calledStatementStart);
        this.assertTrue(calledStatementEnd);
        this.assertTrue(calledStatementProgress);
    }

    public static class Init
    implements DatabaseEventListener {
        private String databaseUrl;

        @Override
        public void init(String url) {
            this.databaseUrl = url;
        }

        @Override
        public void opened() {
            try {
                Properties prop = new Properties();
                prop.setProperty("user", "sa");
                prop.setProperty("password", "sa");
                Connection conn = Driver.load().connect(this.databaseUrl, prop);
                Statement stat = conn.createStatement();
                stat.execute("create table if not exists test(id int)");
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class MyDatabaseEventListener
    implements DatabaseEventListener {
        @Override
        public void closingDatabase() {
            calledClosingDatabase = true;
        }

        @Override
        public void opened() {
            calledOpened = true;
        }

        @Override
        public void setProgress(int state, String name, long x, long max) {
            if (state == 0) {
                calledScan = true;
            }
            if (state == 1 && !name.startsWith("SYS:")) {
                calledCreateIndex = true;
            }
            if (state == 5 && name.equals("select * from test")) {
                calledStatementStart = true;
            }
            if (state == 6 && name.equals("select * from test")) {
                calledStatementEnd = true;
            }
            if (state == 7 && name.equals("select * from test")) {
                calledStatementProgress = true;
            }
        }
    }
}

