/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.Driver;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestDriver
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testSettingsAsProperties();
        this.testDriverObject();
        this.testURLs();
    }

    private void testSettingsAsProperties() throws Exception {
        Properties prop = new Properties();
        prop.put("user", this.getUser());
        prop.put("password", this.getPassword());
        prop.put("max_compact_time", "1234");
        prop.put("unknown", "1234");
        String url = this.getURL("jdbc:h2:mem:driver", true);
        Connection conn = DriverManager.getConnection(url, prop);
        ResultSet rs = conn.createStatement().executeQuery("SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'MAX_COMPACT_TIME'");
        rs.next();
        this.assertEquals(1234, rs.getInt(1));
        conn.close();
    }

    private void testDriverObject() throws Exception {
        Driver instance = Driver.load();
        this.assertTrue(DriverManager.getDriver("jdbc:h2:~/test") == instance);
        Driver.unload();
        this.assertThrows(SQLException.class, () -> DriverManager.getDriver("jdbc:h2:~/test"));
        Driver.load();
        this.assertTrue(DriverManager.getDriver("jdbc:h2:~/test") == instance);
    }

    private void testURLs() throws Exception {
        Driver instance = Driver.load();
        ((java.sql.Driver)this.assertThrows(90046, instance)).acceptsURL(null);
        ((java.sql.Driver)this.assertThrows(90046, instance)).connect(null, null);
        this.assertNull(instance.connect("jdbc:unknown", null));
    }
}

