/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestGetGeneratedKeys
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("getGeneratedKeys");
        Connection conn = this.getConnection("getGeneratedKeys");
        this.testBatchAndMergeInto(conn);
        this.testPrimaryKey(conn);
        this.testInsertWithSelect(conn);
        this.testUpdate(conn);
        this.testMergeUsing(conn);
        this.testWrongStatement(conn);
        this.testMultithreaded(conn);
        this.testNameCase(conn);
        this.testColumnNotFound(conn);
        this.testPrepareStatement_Execute(conn);
        this.testPrepareStatement_ExecuteBatch(conn);
        this.testPrepareStatement_ExecuteLargeBatch(conn);
        this.testPrepareStatement_ExecuteLargeUpdate(conn);
        this.testPrepareStatement_ExecuteUpdate(conn);
        this.testPrepareStatement_int_Execute(conn);
        this.testPrepareStatement_int_ExecuteBatch(conn);
        this.testPrepareStatement_int_ExecuteLargeBatch(conn);
        this.testPrepareStatement_int_ExecuteLargeUpdate(conn);
        this.testPrepareStatement_int_ExecuteUpdate(conn);
        this.testPrepareStatement_intArray_Execute(conn);
        this.testPrepareStatement_intArray_ExecuteBatch(conn);
        this.testPrepareStatement_intArray_ExecuteLargeBatch(conn);
        this.testPrepareStatement_intArray_ExecuteLargeUpdate(conn);
        this.testPrepareStatement_intArray_ExecuteUpdate(conn);
        this.testPrepareStatement_StringArray_Execute(conn);
        this.testPrepareStatement_StringArray_ExecuteBatch(conn);
        this.testPrepareStatement_StringArray_ExecuteLargeBatch(conn);
        this.testPrepareStatement_StringArray_ExecuteLargeUpdate(conn);
        this.testPrepareStatement_StringArray_ExecuteUpdate(conn);
        this.testStatementExecute(conn);
        this.testStatementExecute_int(conn);
        this.testStatementExecute_intArray(conn);
        this.testStatementExecute_StringArray(conn);
        this.testStatementExecuteLargeUpdate(conn);
        this.testStatementExecuteLargeUpdate_int(conn);
        this.testStatementExecuteLargeUpdate_intArray(conn);
        this.testStatementExecuteLargeUpdate_StringArray(conn);
        this.testStatementExecuteUpdate(conn);
        this.testStatementExecuteUpdate_int(conn);
        this.testStatementExecuteUpdate_intArray(conn);
        this.testStatementExecuteUpdate_StringArray(conn);
        conn.close();
        this.deleteDb("getGeneratedKeys");
    }

    private void testBatchAndMergeInto(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID BIGINT AUTO_INCREMENT, UID UUID DEFAULT RANDOM_UUID(), V INT)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (?), (?)", 1);
        prep.setInt(1, 1);
        prep.setInt(2, 2);
        prep.addBatch();
        prep.setInt(1, 3);
        prep.setInt(1, 4);
        prep.addBatch();
        prep.executeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals("BIGINT", meta.getColumnTypeName(1));
        this.assertEquals("UUID", meta.getColumnTypeName(2));
        rs.next();
        this.assertEquals(1L, rs.getLong(1));
        UUID u1 = (UUID)rs.getObject(2);
        this.assertNotNull(u1);
        rs.next();
        this.assertEquals(2L, rs.getLong(1));
        UUID u2 = (UUID)rs.getObject(2);
        this.assertNotNull(u2);
        rs.next();
        this.assertEquals(3L, rs.getLong(1));
        UUID u3 = (UUID)rs.getObject(2);
        this.assertNotNull(u3);
        rs.next();
        this.assertEquals(4L, rs.getLong(1));
        UUID u4 = (UUID)rs.getObject(2);
        this.assertNotNull(u4);
        this.assertFalse(rs.next());
        this.assertFalse(u1.equals(u2));
        this.assertFalse(u2.equals(u3));
        this.assertFalse(u3.equals(u4));
        prep = conn.prepareStatement("MERGE INTO TEST(ID, V) KEY(ID) VALUES (?, ?)", 1);
        prep.setInt(1, 2);
        prep.setInt(2, 10);
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(u2, rs.getObject(2));
        this.assertFalse(rs.next());
        prep.setInt(1, 5);
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        rs.next();
        this.assertEquals(Long.class, rs.getObject(1).getClass());
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
    }

    private void testPrimaryKey(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID BIGINT PRIMARY KEY, V INT)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(ID, V) VALUES (?, ?)", 1);
        prep.setLong(1, 10L);
        prep.setInt(2, 100);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        rs.next();
        this.assertEquals(10L, rs.getLong(1));
        this.assertFalse(rs.next());
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testInsertWithSelect(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT, V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) SELECT 10", 1);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertTrue(rs.next());
        this.assertEquals(1L, rs.getLong(1));
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT, V INT NOT NULL)");
        stat.execute("INSERT INTO TEST(V) VALUES 10");
        PreparedStatement prep = conn.prepareStatement("UPDATE TEST SET V = ? WHERE V = ?", 1);
        prep.setInt(1, 20);
        prep.setInt(2, 10);
        this.assertEquals(1, prep.executeUpdate());
        ResultSet rs = prep.getGeneratedKeys();
        this.assertTrue(rs.next());
        this.assertEquals(1L, rs.getLong(1));
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testMergeUsing(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE SOURCE (ID BIGINT PRIMARY KEY AUTO_INCREMENT, UID INT NOT NULL UNIQUE, V INT NOT NULL)");
        stat.execute("CREATE TABLE DESTINATION (ID BIGINT PRIMARY KEY AUTO_INCREMENT, UID INT NOT NULL UNIQUE, V INT NOT NULL)");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO SOURCE(UID, V) VALUES (?, ?)");
        int i = 1;
        while (i <= 100) {
            ps.setInt(1, i);
            ps.setInt(2, i * 10 + 5);
            ps.executeUpdate();
            ++i;
        }
        ps = conn.prepareStatement("INSERT INTO DESTINATION(UID, V) VALUES (?, ?)");
        i = 1;
        while (i <= 50) {
            ps.setInt(1, i);
            ps.setInt(2, i * 10);
            ps.executeUpdate();
            ++i;
        }
        ps = conn.prepareStatement("MERGE INTO DESTINATION USING SOURCE ON (DESTINATION.UID = SOURCE.UID) WHEN MATCHED THEN UPDATE SET V = SOURCE.V WHEN NOT MATCHED THEN INSERT (UID, V) VALUES (SOURCE.UID, SOURCE.V)", 1);
        this.assertEquals(100, ps.executeUpdate());
        ResultSet rs = ps.getGeneratedKeys();
        int i2 = 1;
        while (i2 <= 100) {
            this.assertTrue(rs.next());
            this.assertEquals((long)i2, rs.getLong(1));
            ++i2;
        }
        this.assertFalse(rs.next());
        rs.close();
        rs = stat.executeQuery("SELECT ID, UID, V FROM DESTINATION ORDER BY ID");
        i2 = 1;
        while (i2 <= 100) {
            this.assertTrue(rs.next());
            this.assertEquals((long)i2, rs.getLong(1));
            this.assertEquals(i2, rs.getInt(2));
            this.assertEquals(i2 * 10 + 5, rs.getInt(3));
            ++i2;
        }
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE SOURCE");
        stat.execute("DROP TABLE DESTINATION");
    }

    private void testWrongStatement(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT, V INT)");
        stat.execute("INSERT INTO TEST(V) VALUES 10, 20, 30");
        stat.execute("DELETE FROM TEST WHERE V = 10", 1);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("TRUNCATE TABLE TEST", 1);
        rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testMultithreaded(final Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT, V INT NOT NULL)");
        int count = 4;
        int iterations = 10000;
        Thread[] threads = new Thread[4];
        final long[] keys = new long[40000];
        int i = 0;
        while (i < 4) {
            final int num = i++;
            threads[num] = new Thread("getGeneratedKeys-" + num){

                @Override
                public void run() {
                    try {
                        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (?)", 1);
                        int i = 0;
                        while (i < 10000) {
                            int value = 10000 * num + i;
                            prep.setInt(1, value);
                            prep.execute();
                            ResultSet rs = prep.getGeneratedKeys();
                            rs.next();
                            keys[value] = rs.getLong(1);
                            rs.close();
                            ++i;
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            };
        }
        i = 0;
        while (i < 4) {
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < 4) {
            threads[i].join();
            ++i;
        }
        ResultSet rs = stat.executeQuery("SELECT V, ID FROM TEST ORDER BY V");
        int i2 = 0;
        while (i2 < keys.length) {
            this.assertTrue(rs.next());
            this.assertEquals(i2, rs.getInt(1));
            this.assertEquals(keys[i2], rs.getLong(2));
            ++i2;
        }
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testNameCase(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,\"id\" UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[]{"id", "ID"});
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("id", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(1L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("ALTER TABLE TEST DROP COLUMN \"id\"");
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"id"});
        this.testNameCase1(prep, 2L, true);
        stat.execute("ALTER TABLE TEST ALTER COLUMN ID RENAME TO \"id\"");
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"ID"});
        this.testNameCase1(prep, 3L, false);
        stat.execute("DROP TABLE TEST");
    }

    private void testNameCase1(PreparedStatement prep, long id, boolean upper) throws SQLException {
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals(upper ? "ID" : "id", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(id, rs.getLong(1));
        this.assertFalse(rs.next());
        rs.close();
    }

    private void testColumnNotFound(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT, V INT NOT NULL)");
        this.assertThrows(42122, stat).execute("INSERT INTO TEST(V) VALUES (1)", new int[1]);
        this.assertThrows(42122, stat).execute("INSERT INTO TEST(V) VALUES (1)", new int[]{3});
        this.assertThrows(42122, stat).execute("INSERT INTO TEST(V) VALUES (1)", new String[]{"X"});
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_Execute(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)");
        prep.execute();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_ExecuteBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)");
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_ExecuteLargeBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)");
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_ExecuteLargeUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)");
        prep.executeLargeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_ExecuteUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)");
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_int_Execute(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", 2);
        prep.execute();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", 1);
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_int_ExecuteBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", 2);
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", 1);
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(3L, rs.getLong("ID"));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertEquals(UUID.class, rs.getObject("UID").getClass());
        this.assertEquals(UUID.class, rs.getObject("UID", UUID.class).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(4L, rs.getLong("ID"));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertEquals(UUID.class, rs.getObject("UID").getClass());
        this.assertEquals(UUID.class, rs.getObject("UID", UUID.class).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_int_ExecuteLargeBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", 2);
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", 1);
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(3L, rs.getLong("ID"));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertEquals(UUID.class, rs.getObject("UID").getClass());
        this.assertEquals(UUID.class, rs.getObject("UID", UUID.class).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(4L, rs.getLong("ID"));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertEquals(UUID.class, rs.getObject("UID").getClass());
        this.assertEquals(UUID.class, rs.getObject("UID", UUID.class).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_int_ExecuteLargeUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", 2);
        prep.executeLargeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", 1);
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_int_ExecuteUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", 2);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", 1);
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_intArray_Execute(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        prep.execute();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_intArray_ExecuteBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(5L, rs.getLong(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(6L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_intArray_ExecuteLargeBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(5L, rs.getLong(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(6L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_intArray_ExecuteLargeUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        prep.executeLargeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_intArray_ExecuteUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_StringArray_Execute(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        prep.execute();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_StringArray_ExecuteBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(5L, rs.getLong(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(6L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_StringArray_ExecuteLargeBatch(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(3L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(4L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(5L, rs.getLong(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(6L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        prep.addBatch();
        prep.addBatch();
        prep.executeLargeBatch();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_StringArray_ExecuteLargeUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        prep.executeLargeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        prep.executeLargeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testPrepareStatement_StringArray_ExecuteUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        prep.executeUpdate();
        ResultSet rs = prep.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        prep = conn.prepareStatement("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        prep.executeUpdate();
        rs = prep.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecute(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.execute("INSERT INTO TEST(V) VALUES (10)");
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecute_int(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        stat.execute("INSERT INTO TEST(V) VALUES (10)", 2);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (20)", 1);
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecute_intArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.execute("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecute_StringArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.execute("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteLargeUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (10)");
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteLargeUpdate_int(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (10)", 2);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (20)", 1);
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteLargeUpdate_intArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteLargeUpdate_StringArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.executeLargeUpdate("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteUpdate(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (10)");
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteUpdate_int(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL, OTHER INT DEFAULT 0)");
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (10)", 2);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (20)", 1);
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteUpdate_intArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (10)", new int[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (20)", new int[]{1, 2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (30)", new int[]{2, 1});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (40)", new int[]{2});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }

    private void testStatementExecuteUpdate_StringArray(Connection conn) throws Exception {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST (ID BIGINT PRIMARY KEY AUTO_INCREMENT,UID UUID NOT NULL DEFAULT RANDOM_UUID(), V INT NOT NULL)");
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (10)", new String[0]);
        ResultSet rs = stat.getGeneratedKeys();
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (20)", new String[]{"ID", "UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("ID", rs.getMetaData().getColumnName(1));
        this.assertEquals("UID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(2L, rs.getLong(1));
        this.assertEquals(UUID.class, rs.getObject(2).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (30)", new String[]{"UID", "ID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(2, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertEquals("ID", rs.getMetaData().getColumnName(2));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertEquals(3L, rs.getLong(2));
        this.assertFalse(rs.next());
        rs.close();
        stat.executeUpdate("INSERT INTO TEST(V) VALUES (40)", new String[]{"UID"});
        rs = stat.getGeneratedKeys();
        this.assertEquals(1, rs.getMetaData().getColumnCount());
        this.assertEquals("UID", rs.getMetaData().getColumnName(1));
        this.assertTrue(rs.next());
        this.assertEquals(UUID.class, rs.getObject(1).getClass());
        this.assertFalse(rs.next());
        rs.close();
        stat.execute("DROP TABLE TEST");
    }
}

