/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.api.JavaObjectSerializer;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.JdbcUtils;

public class TestJavaObjectSerializer
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestJavaObjectSerializer.createCaller().init();
        test.config.traceTest = true;
        test.config.memory = true;
        test.config.networked = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("javaSerializer");
        this.testStaticGlobalSerializer();
        this.testDbLevelJavaObjectSerializer();
        this.deleteDb("javaSerializer");
    }

    private void testStaticGlobalSerializer() throws Exception {
        JdbcUtils.serializer = new JavaObjectSerializer(){

            @Override
            public byte[] serialize(Object obj) throws Exception {
                TestJavaObjectSerializer.this.assertEquals(100500, (int)((Integer)obj));
                return new byte[]{1, 2, 3};
            }

            @Override
            public Object deserialize(byte[] bytes) throws Exception {
                TestJavaObjectSerializer.this.assertEquals(new byte[]{1, 2, 3}, bytes);
                return 100500;
            }
        };
        try {
            this.deleteDb("javaSerializer");
            Connection conn = this.getConnection("javaSerializer");
            Statement stat = conn.createStatement();
            stat.execute("create table t(id identity, val other)");
            PreparedStatement ins = conn.prepareStatement("insert into t(val) values(?)");
            ins.setObject(1, (Object)100500, 2000);
            this.assertEquals(1, ins.executeUpdate());
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery("select val from t");
            this.assertTrue(rs.next());
            this.assertEquals(100500, (int)((Integer)rs.getObject(1)));
            this.assertEquals(new byte[]{1, 2, 3}, rs.getBytes(1));
            conn.close();
            this.deleteDb("javaSerializer");
        }
        finally {
            JdbcUtils.serializer = null;
        }
    }

    public void testDbLevelJavaObjectSerializer() throws Exception {
        DbLevelJavaObjectSerializer.testBaseRef = this;
        try {
            this.deleteDb("javaSerializer");
            Connection conn = this.getConnection("javaSerializer");
            conn.createStatement().execute("SET JAVA_OBJECT_SERIALIZER '" + DbLevelJavaObjectSerializer.class.getName() + "'");
            Statement stat = conn.createStatement();
            stat.execute("create table t1(id identity, val other)");
            PreparedStatement ins = conn.prepareStatement("insert into t1(val) values(?)");
            ins.setObject(1, (Object)100500, 2000);
            this.assertEquals(1, ins.executeUpdate());
            Statement s = conn.createStatement();
            ResultSet rs = s.executeQuery("select val from t1");
            this.assertTrue(rs.next());
            this.assertEquals(100500, (int)((Integer)rs.getObject(1)));
            this.assertEquals(new byte[]{1, 2, 3}, rs.getBytes(1));
            conn.close();
            this.deleteDb("javaSerializer");
        }
        finally {
            DbLevelJavaObjectSerializer.testBaseRef = null;
        }
    }

    public static class DbLevelJavaObjectSerializer
    implements JavaObjectSerializer {
        static TestBase testBaseRef;

        @Override
        public byte[] serialize(Object obj) throws Exception {
            testBaseRef.assertEquals(100500, (int)((Integer)obj));
            return new byte[]{1, 2, 3};
        }

        @Override
        public Object deserialize(byte[] bytes) throws Exception {
            testBaseRef.assertEquals(new byte[]{1, 2, 3}, bytes);
            return 100500;
        }
    }
}

