/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestNativeSQL
extends TestDb {
    private static final String[] PAIRS;
    private Connection conn;

    static {
        String[] stringArray = new String[30];
        stringArray[0] = "CREATE TABLE TEST(ID INT PRIMARY KEY)";
        stringArray[1] = "CREATE TABLE TEST(ID INT PRIMARY KEY)";
        stringArray[2] = "INSERT INTO TEST VALUES(1)";
        stringArray[3] = "INSERT INTO TEST VALUES(1)";
        stringArray[4] = "SELECT '{nothing}' FROM TEST";
        stringArray[5] = "SELECT '{nothing}' FROM TEST";
        stringArray[6] = "SELECT '{fn ABS(1)}' FROM TEST";
        stringArray[7] = "SELECT '{fn ABS(1)}' FROM TEST";
        stringArray[8] = "SELECT {d '2001-01-01'} FROM TEST";
        stringArray[9] = "SELECT  d '2001-01-01'  FROM TEST";
        stringArray[10] = "SELECT {t '20:00:00'} FROM TEST";
        stringArray[11] = "SELECT  t '20:00:00'  FROM TEST";
        stringArray[12] = "SELECT {ts '2001-01-01 20:00:00'} FROM TEST";
        stringArray[13] = "SELECT  ts '2001-01-01 20:00:00'  FROM TEST";
        stringArray[14] = "SELECT {fn CONCAT('{fn x}','{oj}')} FROM TEST";
        stringArray[15] = "SELECT     CONCAT('{fn x}','{oj}')  FROM TEST";
        stringArray[16] = "SELECT * FROM {oj TEST T1 LEFT OUTER JOIN TEST T2 ON T1.ID=T2.ID}";
        stringArray[17] = "SELECT * FROM     TEST T1 LEFT OUTER JOIN TEST T2 ON T1.ID=T2.ID ";
        stringArray[18] = "SELECT * FROM TEST WHERE '{' LIKE '{{' {escape '{'}";
        stringArray[19] = "SELECT * FROM TEST WHERE '{' LIKE '{{'  escape '{' ";
        stringArray[20] = "SELECT * FROM TEST WHERE '}' LIKE '}}' {escape '}'}";
        stringArray[21] = "SELECT * FROM TEST WHERE '}' LIKE '}}'  escape '}' ";
        stringArray[22] = "{call TEST('}')}";
        stringArray[23] = " call TEST('}') ";
        stringArray[24] = "{?= call TEST('}')}";
        stringArray[25] = " ?= call TEST('}') ";
        stringArray[26] = "{? = call TEST('}')}";
        stringArray[27] = " ? = call TEST('}') ";
        stringArray[28] = "{{{{this is a bug}";
        PAIRS = stringArray;
    }

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.deleteDb("nativeSql");
        this.conn = this.getConnection("nativeSql");
        this.testPairs();
        this.testCases();
        this.testRandom();
        this.testQuotes();
        this.conn.close();
        this.assertTrue(this.conn.isClosed());
        this.deleteDb("nativeSql");
    }

    private void testQuotes() throws SQLException {
        Statement stat = this.conn.createStatement();
        Random random = new Random(1L);
        String s = "'\"$/-* \n";
        int i = 0;
        while (i < 200) {
            int j;
            StringBuilder buffQuoted = new StringBuilder();
            StringBuilder buffRaw = new StringBuilder();
            if (random.nextBoolean()) {
                buffQuoted.append("'");
                j = 0;
                while (j < 10) {
                    char c = s.charAt(random.nextInt(s.length()));
                    if (c == '\'') {
                        buffQuoted.append('\'');
                    }
                    buffQuoted.append(c);
                    buffRaw.append(c);
                    ++j;
                }
                buffQuoted.append("'");
            } else {
                buffQuoted.append("$$");
                j = 0;
                while (j < 10) {
                    char c = s.charAt(random.nextInt(s.length()));
                    buffQuoted.append(c);
                    buffRaw.append(c);
                    if (c == '$') {
                        buffQuoted.append(' ');
                        buffRaw.append(' ');
                    }
                    ++j;
                }
                buffQuoted.append("$$");
            }
            String sql = "CALL " + buffQuoted.toString();
            ResultSet rs = stat.executeQuery(sql);
            rs.next();
            String raw = buffRaw.toString();
            this.assertEquals(raw, rs.getString(1));
            ++i;
        }
    }

    private void testRandom() throws SQLException {
        String sql;
        Random random = new Random(1L);
        int i = 0;
        while (i < 100) {
            StringBuilder buff = new StringBuilder("{oj }");
            String s = "{}'\"-/*$ $-";
            int j = random.nextInt(30);
            while (j > 0) {
                buff.append(s.charAt(random.nextInt(s.length())));
                --j;
            }
            sql = buff.toString();
            try {
                this.conn.nativeSQL(sql);
            }
            catch (SQLException e) {
                this.assertKnownException(sql, e);
            }
            ++i;
        }
        String smallest = null;
        int i2 = 0;
        while (i2 < 1000) {
            block25: {
                StringBuilder buff = new StringBuilder("{oj }");
                int j = random.nextInt(10);
                while (j > 0) {
                    switch (random.nextInt(7)) {
                        case 0: {
                            buff.append(" $$");
                            String s = "{}'\"-/* a\n";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("$$");
                            break;
                        }
                        case 1: {
                            buff.append("'");
                            String s = "{}\"-/*$ a\n";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("'");
                            break;
                        }
                        case 2: {
                            buff.append("\"");
                            String s = "{}'-/*$ a\n";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("\"");
                            break;
                        }
                        case 3: {
                            buff.append("/*");
                            String s = "{}'\"-/$ a\n";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("*/");
                            break;
                        }
                        case 4: {
                            buff.append("--");
                            String s = "{}'\"-/$ a";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("\n");
                            break;
                        }
                        case 5: {
                            buff.append("//");
                            String s = "{}'\"-/$ a";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            buff.append("\n");
                            break;
                        }
                        case 6: {
                            String s = " a\n";
                            int k = random.nextInt(5);
                            while (k > 0) {
                                buff.append(s.charAt(random.nextInt(s.length())));
                                --k;
                            }
                            break;
                        }
                    }
                    --j;
                }
                sql = buff.toString();
                try {
                    this.conn.nativeSQL(sql);
                }
                catch (Exception e) {
                    if (smallest != null && sql.length() >= smallest.length()) break block25;
                    smallest = sql;
                }
            }
            ++i2;
        }
        if (smallest != null) {
            this.conn.nativeSQL(smallest);
        }
    }

    private void testPairs() {
        int i = 0;
        while (i < PAIRS.length) {
            this.test(PAIRS[i], PAIRS[i + 1]);
            i += 2;
        }
    }

    private void testCases() throws SQLException {
        this.conn.nativeSQL("TEST");
        this.conn.nativeSQL("TEST--testing");
        this.conn.nativeSQL("TEST--testing{oj }");
        this.conn.nativeSQL("TEST/*{fn }*/");
        this.conn.nativeSQL("TEST//{fn }");
        this.conn.nativeSQL("TEST-TEST/TEST/*TEST*/TEST--\rTEST--{fn }");
        this.conn.nativeSQL("TEST-TEST//TEST");
        this.conn.nativeSQL("'{}' '' \"1\" \"\"\"\"");
        this.conn.nativeSQL("{?= call HELLO{t '10'}}");
        this.conn.nativeSQL("TEST 'test'{OJ OUTER JOIN}'test'{oj OUTER JOIN}");
        this.conn.nativeSQL("{call {ts '2001-01-10'}}");
        this.conn.nativeSQL("call ? { 1: '}' };");
        this.conn.nativeSQL("TEST TEST TEST TEST TEST 'TEST' TEST \"TEST\"");
        this.conn.nativeSQL("TEST TEST TEST  'TEST' TEST \"TEST\"");
        Statement stat = this.conn.createStatement();
        stat.setEscapeProcessing(true);
        stat.execute("CALL {d '2001-01-01'}");
        stat.setEscapeProcessing(false);
        this.assertThrows(42001, stat).execute("CALL {d '2001-01-01'} // this is a test");
        this.assertFalse(this.conn.isClosed());
    }

    private void test(String original, String expected) {
        this.trace("original: <" + original + ">");
        this.trace("expected: <" + expected + ">");
        try {
            String result = this.conn.nativeSQL(original);
            this.trace("result: <" + result + ">");
            this.assertEquals(expected, result);
        }
        catch (SQLException e) {
            this.assertEquals(expected, null);
            this.assertKnownException(e);
            this.trace("got exception, good");
        }
    }
}

