/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.h2.api.Interval;
import org.h2.api.IntervalQualifier;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;

public class TestResultSet
extends TestDb {
    private Connection conn;
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("resultSet");
        this.conn = this.getConnection("resultSet");
        this.stat = this.conn.createStatement();
        this.testUnwrap();
        this.testReuseSimpleResult();
        this.testUnsupportedOperations();
        this.testAmbiguousColumnNames();
        this.testInsertRowWithUpdatableResultSetDefault();
        this.testBeforeFirstAfterLast();
        this.testParseSpecialValues();
        this.testSubstringPrecision();
        this.testSubstringDataType();
        this.testColumnLabelColumnName();
        this.testAbsolute();
        this.testFetchSize();
        this.testOwnUpdates();
        this.testUpdatePrimaryKey();
        this.testFindColumn();
        this.testColumnLength();
        this.testArray();
        this.testRowValue();
        this.testEnum();
        this.testLimitMaxRows();
        this.trace("max rows=" + this.stat.getMaxRows());
        this.stat.setMaxRows(6);
        this.trace("max rows after set to 6=" + this.stat.getMaxRows());
        this.assertTrue(this.stat.getMaxRows() == 6);
        this.testInt();
        this.testSmallInt();
        this.testBigInt();
        this.testVarchar();
        this.testDecimal();
        this.testDoubleFloat();
        this.testDatetime();
        this.testDatetimeWithCalendar();
        this.testInterval();
        this.testInterval8();
        this.testBlob();
        this.testClob();
        this.testAutoIncrement();
        this.conn.close();
        this.deleteDb("resultSet");
    }

    private void testUnwrap() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select 1");
        this.assertTrue(rs.isWrapperFor(Object.class));
        this.assertTrue(rs.isWrapperFor(ResultSet.class));
        this.assertTrue(rs.isWrapperFor(rs.getClass()));
        this.assertFalse(rs.isWrapperFor(Integer.class));
        this.assertTrue(rs == rs.unwrap(Object.class));
        this.assertTrue(rs == rs.unwrap(ResultSet.class));
        this.assertTrue(rs == rs.unwrap(rs.getClass()));
        this.assertThrows(90008, rs).unwrap(Integer.class);
    }

    private void testReuseSimpleResult() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select * from table(x int array=((1)))");
        while (rs.next()) {
            rs.getString(1);
        }
        rs.close();
        rs = this.stat.executeQuery("select * from table(x int array=((1)))");
        while (rs.next()) {
            rs.getString(1);
        }
        rs.close();
    }

    private void testUnsupportedOperations() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select 1 as x from dual");
        this.assertThrows(50100, rs).getUnicodeStream(1);
        this.assertThrows(50100, rs).getUnicodeStream("x");
        this.assertThrows(50100, rs).getObject(1, Collections.emptyMap());
        this.assertThrows(50100, rs).getObject("x", Collections.emptyMap());
        this.assertThrows(50100, rs).getRef(1);
        this.assertThrows(50100, rs).getRef("x");
        this.assertThrows(50100, rs).getURL(1);
        this.assertThrows(50100, rs).getURL("x");
        this.assertThrows(50100, rs).getRowId(1);
        this.assertThrows(50100, rs).getRowId("x");
        this.assertThrows(50100, rs).updateRef(1, null);
        this.assertThrows(50100, rs).updateRef("x", null);
        this.assertThrows(50100, rs).updateRowId(1, null);
        this.assertThrows(50100, rs).updateRowId("x", null);
        this.assertThrows(50100, rs).getCursorName();
        this.assertThrows(50100, rs).setFetchDirection(1001);
    }

    private void testAmbiguousColumnNames() throws SQLException {
        this.stat.execute("create table test(id int)");
        this.stat.execute("insert into test values(1)");
        ResultSet rs = this.stat.executeQuery("select 1 x, 2 x, 3 x, 4 x, 5 x, 6 x from test");
        rs.next();
        this.assertEquals(1, rs.getInt("x"));
        this.stat.execute("drop table test");
    }

    private void testInsertRowWithUpdatableResultSetDefault() throws Exception {
        this.stat.execute("create table test(id int primary key, data varchar(255) default 'Hello')");
        PreparedStatement prep = this.conn.prepareStatement("select * from test", 1004, 1008);
        ResultSet rs = prep.executeQuery();
        int idx = 1;
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        rs.insertRow();
        rs.close();
        rs = this.stat.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertEquals("Hello", rs.getString(2));
        this.assertEquals("Hello", rs.getString("data"));
        this.assertEquals("Hello", rs.getNString(2));
        this.assertEquals("Hello", rs.getNString("data"));
        this.assertEquals("Hello", IOUtils.readStringAndClose(rs.getNCharacterStream(2), -1));
        this.assertEquals("Hello", IOUtils.readStringAndClose(rs.getNCharacterStream("data"), -1));
        this.assertEquals("Hello", IOUtils.readStringAndClose(rs.getNClob(2).getCharacterStream(), -1));
        this.assertEquals("Hello", IOUtils.readStringAndClose(rs.getNClob("data").getCharacterStream(), -1));
        rs = prep.executeQuery();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        rs.updateNString(2, "Hello");
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        rs.updateNString("data", "Hello");
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        Clob c = this.conn.createClob();
        Writer w = c.setCharacterStream(1L);
        w.write("Hello");
        w.close();
        rs.updateClob(2, c);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        c = this.conn.createClob();
        w = c.setCharacterStream(1L);
        w.write("Hello");
        w.close();
        rs.updateClob("data", c);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        NClob nc = this.conn.createNClob();
        w = nc.setCharacterStream(1L);
        w.write("Hello");
        w.close();
        rs.updateNClob(2, nc);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        nc = this.conn.createNClob();
        w = nc.setCharacterStream(1L);
        w.write("Hello");
        w.close();
        rs.updateNClob("data", nc);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        ByteArrayInputStream in = new ByteArrayInputStream("Hello".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream(2, (InputStream)in);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        in = new ByteArrayInputStream("Hello".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream("data", (InputStream)in);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        in = new ByteArrayInputStream("Hello-".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream(2, (InputStream)in, 5);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        in = new ByteArrayInputStream("Hello-".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream("data", (InputStream)in, 5);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        in = new ByteArrayInputStream("Hello-".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream(2, (InputStream)in, 5L);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt(1, idx++);
        in = new ByteArrayInputStream("Hello-".getBytes(StandardCharsets.UTF_8));
        rs.updateAsciiStream("data", (InputStream)in, 5L);
        rs.insertRow();
        rs = this.stat.executeQuery("select * from test");
        int i = 1;
        while (i < idx) {
            this.assertTrue(rs.next());
            this.assertEquals("Hello", rs.getString(2));
            ++i;
        }
        this.assertFalse(rs.next());
        this.stat.execute("drop table test");
    }

    private void testBeforeFirstAfterLast() throws SQLException {
        this.stat.executeUpdate("create table test(id int)");
        this.stat.executeUpdate("insert into test values(1)");
        ResultSet rs = this.stat.executeQuery("select * from test");
        this.assertTrue(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        rs.next();
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        rs.next();
        this.assertFalse(rs.isBeforeFirst());
        this.assertTrue(rs.isAfterLast());
        rs.close();
        rs = this.stat.executeQuery("select * from test where 1 = 2");
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        rs.next();
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        rs.close();
        this.stat.execute("drop table test");
    }

    private void testParseSpecialValues() throws SQLException {
        int i = -10;
        while (i < 10) {
            this.testParseSpecialValue("" + (Integer.MIN_VALUE + (long)i));
            this.testParseSpecialValue("" + (Integer.MAX_VALUE + (long)i));
            BigInteger bi = BigInteger.valueOf(i);
            this.testParseSpecialValue(bi.add(BigInteger.valueOf(Long.MIN_VALUE)).toString());
            this.testParseSpecialValue(bi.add(BigInteger.valueOf(Long.MAX_VALUE)).toString());
            ++i;
        }
    }

    private void testParseSpecialValue(String x) throws SQLException {
        Number expected = new BigDecimal(x);
        try {
            expected = Long.decode(x);
            expected = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResultSet rs = this.stat.executeQuery("call " + x);
        rs.next();
        Object o = rs.getObject(1);
        this.assertEquals(expected.getClass().getName(), o.getClass().getName());
        this.assertTrue(expected.equals(o));
    }

    private void testSubstringDataType() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select substr(x, 1, 1) from system_range(1, 1)");
        rs.next();
        this.assertEquals(12, rs.getMetaData().getColumnType(1));
    }

    private void testColumnLabelColumnName() throws SQLException {
        ResultSet rs = this.stat.executeQuery("select x as y from system_range(1, 1)");
        rs.next();
        rs.getString("x");
        rs.getString("y");
        rs.close();
        rs = this.conn.getMetaData().getColumns(null, null, null, null);
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        String[] columnName = new String[columnCount];
        int i = 1;
        while (i <= columnCount) {
            columnName[i - 1] = meta.getColumnName(i);
            ++i;
        }
        while (rs.next()) {
            i = 0;
            while (i < columnCount) {
                rs.getObject(columnName[i]);
                ++i;
            }
        }
    }

    private void testAbsolute() throws SQLException {
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        this.stat.execute("INSERT INTO TEST SELECT X FROM SYSTEM_RANGE(1, 200)");
        Statement s2 = this.conn.createStatement(1004, 1007);
        ResultSet rs = s2.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int i = 100;
        while (i > 0) {
            rs.absolute(i);
            this.assertEquals(i, rs.getInt(1));
            --i;
        }
        this.stat.execute("DROP TABLE TEST");
    }

    private void testFetchSize() throws SQLException {
        if (!this.config.networked || this.config.memory) {
            return;
        }
        ResultSet rs = this.stat.executeQuery("SELECT * FROM SYSTEM_RANGE(1, 100)");
        int a = this.stat.getFetchSize();
        int b = rs.getFetchSize();
        this.assertEquals(a, b);
        rs.setFetchDirection(1000);
        rs.setFetchSize(b + 1);
        b = rs.getFetchSize();
        this.assertEquals(a + 1, b);
    }

    private void testOwnUpdates() throws SQLException {
        DatabaseMetaData meta = this.conn.getMetaData();
        int i = 0;
        while (i < 3) {
            int type = i == 0 ? 1003 : (i == 1 ? 1004 : 1005);
            this.assertTrue(meta.ownUpdatesAreVisible(type));
            this.assertFalse(meta.ownDeletesAreVisible(type));
            this.assertFalse(meta.ownInsertsAreVisible(type));
            ++i;
        }
        this.stat = this.conn.createStatement(1004, 1008);
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        ResultSet rs = this.stat.executeQuery("SELECT ID, NAME FROM TEST ORDER BY ID");
        rs.next();
        rs.next();
        rs.updateString(2, "Hallo");
        rs.updateRow();
        this.assertEquals("Hallo", rs.getString(2));
        this.stat.execute("DROP TABLE TEST");
    }

    private void testUpdatePrimaryKey() throws SQLException {
        this.stat = this.conn.createStatement(1004, 1008);
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        rs.updateInt(1, 2);
        rs.updateRow();
        rs.updateInt(1, 3);
        rs.updateRow();
        this.stat.execute("DROP TABLE TEST");
    }

    private void checkPrecision(int expected, String sql) throws SQLException {
        ResultSetMetaData meta = this.stat.executeQuery(sql).getMetaData();
        this.assertEquals(expected, meta.getPrecision(1));
    }

    private void testSubstringPrecision() throws SQLException {
        this.trace("testSubstringPrecision");
        this.stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR(10))");
        this.stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'WorldPeace')");
        this.checkPrecision(1, "SELECT SUBSTR(NAME, 12, 4) FROM TEST");
        this.checkPrecision(9, "SELECT SUBSTR(NAME, 2) FROM TEST");
        this.checkPrecision(10, "SELECT SUBSTR(NAME, ID) FROM TEST");
        this.checkPrecision(4, "SELECT SUBSTR(NAME, 2, 4) FROM TEST");
        this.checkPrecision(3, "SELECT SUBSTR(NAME, 8, 4) FROM TEST");
        this.checkPrecision(4, "SELECT SUBSTR(NAME, 7, 4) FROM TEST");
        this.checkPrecision(8, "SELECT SUBSTR(NAME, 3, ID*0) FROM TEST");
        this.stat.execute("DROP TABLE TEST");
    }

    private void testFindColumn() throws SQLException {
        this.trace("testFindColumn");
        this.stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.assertEquals(1, rs.findColumn("ID"));
        this.assertEquals(2, rs.findColumn("NAME"));
        this.assertEquals(1, rs.findColumn("id"));
        this.assertEquals(2, rs.findColumn("name"));
        this.assertEquals(1, rs.findColumn("Id"));
        this.assertEquals(2, rs.findColumn("Name"));
        this.assertEquals(1, rs.findColumn("TEST.ID"));
        this.assertEquals(2, rs.findColumn("TEST.NAME"));
        this.assertEquals(1, rs.findColumn("Test.Id"));
        this.assertEquals(2, rs.findColumn("Test.Name"));
        this.stat.execute("DROP TABLE TEST");
        this.stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR, DATA VARCHAR)");
        rs = this.stat.executeQuery("SELECT * FROM TEST");
        this.assertEquals(1, rs.findColumn("ID"));
        this.assertEquals(2, rs.findColumn("NAME"));
        this.assertEquals(3, rs.findColumn("DATA"));
        this.assertEquals(1, rs.findColumn("id"));
        this.assertEquals(2, rs.findColumn("name"));
        this.assertEquals(3, rs.findColumn("data"));
        this.assertEquals(1, rs.findColumn("Id"));
        this.assertEquals(2, rs.findColumn("Name"));
        this.assertEquals(3, rs.findColumn("Data"));
        this.assertEquals(1, rs.findColumn("TEST.ID"));
        this.assertEquals(2, rs.findColumn("TEST.NAME"));
        this.assertEquals(3, rs.findColumn("TEST.DATA"));
        this.assertEquals(1, rs.findColumn("Test.Id"));
        this.assertEquals(2, rs.findColumn("Test.Name"));
        this.assertEquals(3, rs.findColumn("Test.Data"));
        this.stat.execute("DROP TABLE TEST");
    }

    private void testColumnLength() throws SQLException {
        this.trace("testColumnDisplayLength");
        this.stat.execute("CREATE TABLE one (ID INT, NAME VARCHAR(255))");
        ResultSet rs = this.stat.executeQuery("select * from one");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals("ID", meta.getColumnLabel(1));
        this.assertEquals(11, meta.getColumnDisplaySize(1));
        this.assertEquals("NAME", meta.getColumnLabel(2));
        this.assertEquals(255, meta.getColumnDisplaySize(2));
        this.stat.execute("DROP TABLE one");
        rs = this.stat.executeQuery("select 1, 'Hello' union select 2, 'Hello World!'");
        meta = rs.getMetaData();
        this.assertEquals(11, meta.getColumnDisplaySize(1));
        this.assertEquals(12, meta.getColumnDisplaySize(2));
        rs = this.stat.executeQuery("explain select * from dual");
        meta = rs.getMetaData();
        this.assertEquals(1000000000, meta.getColumnDisplaySize(1));
        this.assertEquals(1000000000, meta.getPrecision(1));
        rs = this.stat.executeQuery("script");
        meta = rs.getMetaData();
        this.assertEquals(1000000000, meta.getColumnDisplaySize(1));
        this.assertEquals(1000000000, meta.getPrecision(1));
        rs = this.stat.executeQuery("select group_concat(table_name) from information_schema.tables");
        rs.next();
        meta = rs.getMetaData();
        this.assertEquals(1000000000, meta.getColumnDisplaySize(1));
        this.assertEquals(1000000000, meta.getPrecision(1));
    }

    private void testLimitMaxRows() throws SQLException {
        this.trace("Test LimitMaxRows");
        this.stat.execute("CREATE TABLE one (C CHARACTER(10))");
        ResultSet rs = this.stat.executeQuery("SELECT C || C FROM one;");
        ResultSetMetaData md = rs.getMetaData();
        this.assertEquals(20, md.getPrecision(1));
        rs = this.stat.executeQuery("SELECT CHAR(10), CONCAT(C,C,C), HEXTORAW(C), RAWTOHEX(C) FROM one");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(1, meta.getPrecision(1));
        this.assertEquals(30, meta.getPrecision(2));
        this.assertEquals(2, meta.getPrecision(3));
        this.assertEquals(40, meta.getPrecision(4));
        this.stat.execute("DROP TABLE one");
    }

    private void testAutoIncrement() throws SQLException {
        this.trace("Test AutoIncrement");
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(ID IDENTITY NOT NULL, NAME VARCHAR NULL)");
        this.stat.execute("INSERT INTO TEST(NAME) VALUES('Hello')", 1);
        ResultSet rs = this.stat.getGeneratedKeys();
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.stat.execute("INSERT INTO TEST(NAME) VALUES('World')", 1);
        rs = this.stat.getGeneratedKeys();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        rs = this.stat.executeQuery("SELECT ID AS I, NAME AS N, ID+1 AS IP1 FROM TEST");
        ResultSetMetaData meta = rs.getMetaData();
        this.assertTrue(meta.isAutoIncrement(1));
        this.assertFalse(meta.isAutoIncrement(2));
        this.assertFalse(meta.isAutoIncrement(3));
        this.assertEquals(0, meta.isNullable(1));
        this.assertEquals(1, meta.isNullable(2));
        this.assertEquals(2, meta.isNullable(3));
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
    }

    private void testInt() throws SQLException {
        this.trace("Test INT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" INT)");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1)");
        this.stat.execute("INSERT INTO TEST VALUES(4,2147483647)");
        this.stat.execute("INSERT INTO TEST VALUES(5,-2147483648)");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(7,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT *, NULL AS N FROM TEST ORDER BY ID");
        this.assertEquals(1, rs.findColumn("TEST.ID"));
        this.assertEquals(2, rs.findColumn("TEST.VALUE"));
        ResultSetMetaData meta = rs.getMetaData();
        this.assertEquals(3, meta.getColumnCount());
        this.assertEquals("resultSet".toUpperCase(), meta.getCatalogName(1));
        this.assertTrue("PUBLIC".equals(meta.getSchemaName(2)));
        this.assertTrue("TEST".equals(meta.getTableName(1)));
        this.assertTrue("ID".equals(meta.getColumnName(1)));
        this.assertTrue("VALUE".equals(meta.getColumnName(2)));
        this.assertFalse(meta.isAutoIncrement(1));
        this.assertTrue(meta.isCaseSensitive(1));
        this.assertTrue(meta.isSearchable(1));
        this.assertFalse(meta.isCurrency(1));
        this.assertTrue(meta.getColumnDisplaySize(1) > 0);
        this.assertTrue(meta.isSigned(1));
        this.assertTrue(meta.isSearchable(2));
        this.assertEquals(0, meta.isNullable(1));
        this.assertFalse(meta.isReadOnly(1));
        this.assertTrue(meta.isWritable(1));
        this.assertFalse(meta.isDefinitelyWritable(1));
        this.assertTrue(meta.getColumnDisplaySize(1) > 0);
        this.assertTrue(meta.getColumnDisplaySize(2) > 0);
        this.assertEquals(Void.class.getName(), meta.getColumnClassName(3));
        this.assertTrue(rs.getRow() == 0);
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[1] = 4;
        this.assertResultSetMeta(rs, 3, new String[]{"ID", "VALUE", "N"}, nArray, new int[]{32, 32, 1}, new int[3]);
        rs.next();
        this.assertEquals(1007, rs.getConcurrency());
        this.assertEquals(1000, rs.getFetchDirection());
        this.trace("default fetch size=" + rs.getFetchSize());
        rs.setFetchSize(0);
        this.assertThrows(90008, rs).setFetchSize(-1);
        this.assertThrows(90008, rs).setFetchSize(100);
        rs.setFetchSize(6);
        this.assertTrue(rs.getRow() == 1);
        this.assertEquals(2, rs.findColumn("VALUE"));
        this.assertEquals(2, rs.findColumn("value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(1, rs.findColumn("ID"));
        this.assertEquals(1, rs.findColumn("id"));
        this.assertEquals(1, rs.findColumn("Id"));
        this.assertEquals(1, rs.findColumn("iD"));
        this.assertTrue(rs.getInt(2) == -1 && !rs.wasNull());
        this.assertTrue(rs.getInt("VALUE") == -1 && !rs.wasNull());
        this.assertTrue(rs.getInt("value") == -1 && !rs.wasNull());
        this.assertTrue(rs.getInt("Value") == -1 && !rs.wasNull());
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Integer);
        this.assertTrue((Integer)o == -1);
        o = rs.getObject("value", Integer.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Integer);
        this.assertTrue((Integer)o == -1);
        o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Integer);
        this.assertTrue((Integer)o == -1);
        o = rs.getObject(2, Integer.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Integer);
        this.assertTrue((Integer)o == -1);
        this.assertTrue(rs.getBoolean("Value"));
        this.assertTrue(rs.getByte("Value") == -1);
        this.assertTrue(rs.getShort("Value") == -1);
        this.assertTrue(rs.getLong("Value") == -1L);
        this.assertTrue((double)rs.getFloat("Value") == -1.0);
        this.assertTrue(rs.getDouble("Value") == -1.0);
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        this.assertTrue(rs.getInt("ID") == 1 && !rs.wasNull());
        this.assertTrue(rs.getInt("id") == 1 && !rs.wasNull());
        this.assertTrue(rs.getInt("Id") == 1 && !rs.wasNull());
        this.assertTrue(rs.getInt(1) == 1 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 2);
        this.assertTrue(rs.getInt(2) == 0 && !rs.wasNull());
        this.assertFalse(rs.getBoolean(2));
        this.assertTrue(rs.getByte(2) == 0);
        this.assertTrue(rs.getShort(2) == 0);
        this.assertTrue(rs.getLong(2) == 0L);
        this.assertTrue((double)rs.getFloat(2) == 0.0);
        this.assertTrue(rs.getDouble(2) == 0.0);
        this.assertTrue(rs.getString(2).equals("0") && !rs.wasNull());
        this.assertTrue(rs.getInt(1) == 2 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 3);
        this.assertTrue(rs.getInt("ID") == 3 && !rs.wasNull());
        this.assertTrue(rs.getInt("VALUE") == 1 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 4);
        this.assertTrue(rs.getInt("ID") == 4 && !rs.wasNull());
        this.assertTrue(rs.getInt("VALUE") == Integer.MAX_VALUE && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 5);
        this.assertTrue(rs.getInt("id") == 5 && !rs.wasNull());
        this.assertTrue(rs.getInt("value") == Integer.MIN_VALUE && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("5") && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 6);
        this.assertTrue(rs.getInt("id") == 6 && !rs.wasNull());
        this.assertTrue(rs.getInt("value") == 0 && rs.wasNull());
        this.assertTrue(rs.getInt(2) == 0 && rs.wasNull());
        this.assertTrue(rs.getInt(1) == 6 && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("6") && !rs.wasNull());
        this.assertTrue(rs.getString(2) == null && rs.wasNull());
        o = rs.getObject(2);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        o = rs.getObject(2, Integer.class);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        this.assertFalse(rs.next());
        this.assertEquals(0, rs.getRow());
        this.stat.execute("DROP TABLE TEST");
        this.stat.setMaxRows(0);
    }

    private void testSmallInt() throws SQLException {
        this.trace("Test SMALLINT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" SMALLINT)");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1)");
        this.stat.execute("INSERT INTO TEST VALUES(4,32767)");
        this.stat.execute("INSERT INTO TEST VALUES(5,-32768)");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT *, NULL AS N FROM TEST ORDER BY ID");
        this.assertEquals(1, rs.findColumn("TEST.ID"));
        this.assertEquals(2, rs.findColumn("TEST.VALUE"));
        this.assertTrue(rs.getRow() == 0);
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[1] = 5;
        this.assertResultSetMeta(rs, 3, new String[]{"ID", "VALUE", "N"}, nArray, new int[]{32, 16, 1}, new int[3]);
        rs.next();
        this.assertTrue(rs.getRow() == 1);
        this.assertEquals(2, rs.findColumn("VALUE"));
        this.assertEquals(2, rs.findColumn("value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(1, rs.findColumn("ID"));
        this.assertEquals(1, rs.findColumn("id"));
        this.assertEquals(1, rs.findColumn("Id"));
        this.assertEquals(1, rs.findColumn("iD"));
        this.assertTrue(rs.getShort(2) == -1 && !rs.wasNull());
        this.assertTrue(rs.getShort("VALUE") == -1 && !rs.wasNull());
        this.assertTrue(rs.getShort("value") == -1 && !rs.wasNull());
        this.assertTrue(rs.getShort("Value") == -1 && !rs.wasNull());
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.assertTrue(o.getClass() == Integer.class);
        this.assertTrue(((Number)o).intValue() == -1);
        o = rs.getObject("value", Short.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Short);
        this.assertTrue((Short)o == -1);
        o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o.getClass() == Integer.class);
        this.assertTrue(((Number)o).intValue() == -1);
        o = rs.getObject(2, Short.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Short);
        this.assertTrue((Short)o == -1);
        this.assertTrue(rs.getBoolean("Value"));
        this.assertTrue(rs.getByte("Value") == -1);
        this.assertTrue(rs.getInt("Value") == -1);
        this.assertTrue(rs.getLong("Value") == -1L);
        this.assertTrue((double)rs.getFloat("Value") == -1.0);
        this.assertTrue(rs.getDouble("Value") == -1.0);
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        this.assertTrue(rs.getShort("ID") == 1 && !rs.wasNull());
        this.assertTrue(rs.getShort("id") == 1 && !rs.wasNull());
        this.assertTrue(rs.getShort("Id") == 1 && !rs.wasNull());
        this.assertTrue(rs.getShort(1) == 1 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 2);
        this.assertTrue(rs.getShort(2) == 0 && !rs.wasNull());
        this.assertFalse(rs.getBoolean(2));
        this.assertTrue(rs.getByte(2) == 0);
        this.assertTrue(rs.getInt(2) == 0);
        this.assertTrue(rs.getLong(2) == 0L);
        this.assertTrue((double)rs.getFloat(2) == 0.0);
        this.assertTrue(rs.getDouble(2) == 0.0);
        this.assertTrue(rs.getString(2).equals("0") && !rs.wasNull());
        this.assertTrue(rs.getShort(1) == 2 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 3);
        this.assertTrue(rs.getShort("ID") == 3 && !rs.wasNull());
        this.assertTrue(rs.getShort("VALUE") == 1 && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 4);
        this.assertTrue(rs.getShort("ID") == 4 && !rs.wasNull());
        this.assertTrue(rs.getShort("VALUE") == Short.MAX_VALUE && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 5);
        this.assertTrue(rs.getShort("id") == 5 && !rs.wasNull());
        this.assertTrue(rs.getShort("value") == Short.MIN_VALUE && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("5") && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 6);
        this.assertTrue(rs.getShort("id") == 6 && !rs.wasNull());
        this.assertTrue(rs.getShort("value") == 0 && rs.wasNull());
        this.assertTrue(rs.getShort(2) == 0 && rs.wasNull());
        this.assertTrue(rs.getShort(1) == 6 && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("6") && !rs.wasNull());
        this.assertTrue(rs.getString(2) == null && rs.wasNull());
        o = rs.getObject(2);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        o = rs.getObject(2, Short.class);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        this.assertFalse(rs.next());
        this.assertEquals(0, rs.getRow());
        this.stat.execute("DROP TABLE TEST");
        this.stat.setMaxRows(0);
    }

    private void testBigInt() throws SQLException {
        this.trace("Test SMALLINT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" BIGINT)");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1)");
        this.stat.execute("INSERT INTO TEST VALUES(4,9223372036854775807)");
        this.stat.execute("INSERT INTO TEST VALUES(5,-9223372036854775808)");
        this.stat.execute("INSERT INTO TEST VALUES(6,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT *, NULL AS N FROM TEST ORDER BY ID");
        this.assertEquals(1, rs.findColumn("TEST.ID"));
        this.assertEquals(2, rs.findColumn("TEST.VALUE"));
        this.assertTrue(rs.getRow() == 0);
        int[] nArray = new int[3];
        nArray[0] = 4;
        nArray[1] = -5;
        this.assertResultSetMeta(rs, 3, new String[]{"ID", "VALUE", "N"}, nArray, new int[]{32, 64, 1}, new int[3]);
        rs.next();
        this.assertTrue(rs.getRow() == 1);
        this.assertEquals(2, rs.findColumn("VALUE"));
        this.assertEquals(2, rs.findColumn("value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(2, rs.findColumn("Value"));
        this.assertEquals(1, rs.findColumn("ID"));
        this.assertEquals(1, rs.findColumn("id"));
        this.assertEquals(1, rs.findColumn("Id"));
        this.assertEquals(1, rs.findColumn("iD"));
        this.assertTrue(rs.getLong(2) == -1L && !rs.wasNull());
        this.assertTrue(rs.getLong("VALUE") == -1L && !rs.wasNull());
        this.assertTrue(rs.getLong("value") == -1L && !rs.wasNull());
        this.assertTrue(rs.getLong("Value") == -1L && !rs.wasNull());
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Long);
        this.assertTrue((Long)o == -1L);
        o = rs.getObject("value", Long.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Long);
        this.assertTrue((Long)o == -1L);
        o = rs.getObject("value", BigInteger.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigInteger);
        this.assertTrue(((BigInteger)o).longValue() == -1L);
        o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Long);
        this.assertTrue((Long)o == -1L);
        o = rs.getObject(2, Long.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Long);
        this.assertTrue((Long)o == -1L);
        o = rs.getObject(2, BigInteger.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigInteger);
        this.assertTrue(((BigInteger)o).longValue() == -1L);
        this.assertTrue(rs.getBoolean("Value"));
        this.assertTrue(rs.getByte("Value") == -1);
        this.assertTrue(rs.getShort("Value") == -1);
        this.assertTrue(rs.getInt("Value") == -1);
        this.assertTrue((double)rs.getFloat("Value") == -1.0);
        this.assertTrue(rs.getDouble("Value") == -1.0);
        this.assertTrue(rs.getString("Value").equals("-1") && !rs.wasNull());
        this.assertTrue(rs.getLong("ID") == 1L && !rs.wasNull());
        this.assertTrue(rs.getLong("id") == 1L && !rs.wasNull());
        this.assertTrue(rs.getLong("Id") == 1L && !rs.wasNull());
        this.assertTrue(rs.getLong(1) == 1L && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 2);
        this.assertTrue(rs.getLong(2) == 0L && !rs.wasNull());
        this.assertFalse(rs.getBoolean(2));
        this.assertTrue(rs.getByte(2) == 0);
        this.assertTrue(rs.getShort(2) == 0);
        this.assertTrue(rs.getInt(2) == 0);
        this.assertTrue((double)rs.getFloat(2) == 0.0);
        this.assertTrue(rs.getDouble(2) == 0.0);
        this.assertTrue(rs.getString(2).equals("0") && !rs.wasNull());
        this.assertTrue(rs.getLong(1) == 2L && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 3);
        this.assertTrue(rs.getLong("ID") == 3L && !rs.wasNull());
        this.assertTrue(rs.getLong("VALUE") == 1L && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 4);
        this.assertTrue(rs.getLong("ID") == 4L && !rs.wasNull());
        this.assertTrue(rs.getLong("VALUE") == Long.MAX_VALUE && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 5);
        this.assertTrue(rs.getLong("id") == 5L && !rs.wasNull());
        this.assertTrue(rs.getLong("value") == Long.MIN_VALUE && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("5") && !rs.wasNull());
        rs.next();
        this.assertTrue(rs.getRow() == 6);
        this.assertTrue(rs.getLong("id") == 6L && !rs.wasNull());
        this.assertTrue(rs.getLong("value") == 0L && rs.wasNull());
        this.assertTrue(rs.getLong(2) == 0L && rs.wasNull());
        this.assertTrue(rs.getLong(1) == 6L && !rs.wasNull());
        this.assertTrue(rs.getString(1).equals("6") && !rs.wasNull());
        this.assertTrue(rs.getString(2) == null && rs.wasNull());
        o = rs.getObject(2);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        o = rs.getObject(2, Long.class);
        this.assertNull(o);
        this.assertTrue(rs.wasNull());
        this.assertFalse(rs.next());
        this.assertEquals(0, rs.getRow());
        this.stat.execute("DROP TABLE TEST");
        this.stat.setMaxRows(0);
    }

    private void testVarchar() throws SQLException {
        this.trace("Test VARCHAR");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" VARCHAR(255))");
        this.stat.execute("INSERT INTO TEST VALUES(1,'')");
        this.stat.execute("INSERT INTO TEST VALUES(2,' ')");
        this.stat.execute("INSERT INTO TEST VALUES(3,'  ')");
        this.stat.execute("INSERT INTO TEST VALUES(4,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(5,'Hi')");
        this.stat.execute("INSERT INTO TEST VALUES(6,' Hi ')");
        this.stat.execute("INSERT INTO TEST VALUES(7,'Joe''s')");
        this.stat.execute("INSERT INTO TEST VALUES(8,'{escape}')");
        this.stat.execute("INSERT INTO TEST VALUES(9,'\\n')");
        this.stat.execute("INSERT INTO TEST VALUES(10,'\\''')");
        this.stat.execute("INSERT INTO TEST VALUES(11,'\\%')");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 12}, new int[]{32, 255}, new int[2]);
        rs.next();
        String value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <>)");
        this.assertTrue(value != null && value.equals("") && !rs.wasNull());
        this.assertTrue(rs.getInt(1) == 1 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: < >)");
        this.assertTrue(rs.getString(2).equals(" ") && !rs.wasNull());
        this.assertTrue(rs.getInt(1) == 2 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <  >)");
        this.assertTrue(rs.getString(2).equals("  ") && !rs.wasNull());
        this.assertTrue(rs.getInt(1) == 3 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <null>)");
        this.assertTrue(rs.getString(2) == null && rs.wasNull());
        this.assertTrue(rs.getInt(1) == 4 && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <Hi>)");
        this.assertTrue(rs.getInt(1) == 5 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("Hi") && !rs.wasNull());
        Object o = rs.getObject("value");
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof String);
        this.assertTrue(o.toString().equals("Hi"));
        o = rs.getObject("value", String.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof String);
        this.assertTrue(o.equals("Hi"));
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: < Hi >)");
        this.assertTrue(rs.getInt(1) == 6 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals(" Hi ") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <Joe's>)");
        this.assertTrue(rs.getInt(1) == 7 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("Joe's") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <{escape}>)");
        this.assertTrue(rs.getInt(1) == 8 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("{escape}") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\n>)");
        this.assertTrue(rs.getInt(1) == 9 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("\\n") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\'>)");
        this.assertTrue(rs.getInt(1) == 10 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("\\'") && !rs.wasNull());
        rs.next();
        value = rs.getString(2);
        this.trace("Value: <" + value + "> (should be: <\\%>)");
        this.assertTrue(rs.getInt(1) == 11 && !rs.wasNull());
        this.assertTrue(rs.getString(2).equals("\\%") && !rs.wasNull());
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testDecimal() throws SQLException {
        this.trace("Test DECIMAL");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" DECIMAL(10,2))");
        this.stat.execute("INSERT INTO TEST VALUES(1,-1)");
        this.stat.execute("INSERT INTO TEST VALUES(2,.0)");
        this.stat.execute("INSERT INTO TEST VALUES(3,1.)");
        this.stat.execute("INSERT INTO TEST VALUES(4,12345678.89)");
        this.stat.execute("INSERT INTO TEST VALUES(6,99999998.99)");
        this.stat.execute("INSERT INTO TEST VALUES(7,-99999998.99)");
        this.stat.execute("INSERT INTO TEST VALUES(8,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int[] nArray = new int[2];
        nArray[1] = 2;
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 3}, new int[]{32, 10}, nArray);
        rs.next();
        this.assertTrue(rs.getInt(1) == 1);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(2) == -1);
        this.assertFalse(rs.wasNull());
        BigDecimal bd = rs.getBigDecimal(2);
        this.assertTrue(bd.compareTo(new BigDecimal("-1.00")) == 0);
        this.assertFalse(rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigDecimal);
        this.assertTrue(((BigDecimal)o).compareTo(new BigDecimal("-1.00")) == 0);
        o = rs.getObject(2, BigDecimal.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigDecimal);
        this.assertTrue(((BigDecimal)o).compareTo(new BigDecimal("-1.00")) == 0);
        rs.next();
        this.assertTrue(rs.getInt(1) == 2);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(2) == 0);
        this.assertFalse(rs.wasNull());
        bd = rs.getBigDecimal(2);
        this.assertTrue(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.assertFalse(rs.wasNull());
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 1, "1.00");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 12345679, "12345678.89");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 99999999, "99999998.99");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, -99999999, "-99999998.99");
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 0, null);
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" DECIMAL(22,2))");
        this.stat.execute("INSERT INTO TEST VALUES(1,-12345678909876543210)");
        this.stat.execute("INSERT INTO TEST VALUES(2,12345678901234567890.12345)");
        rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(new BigDecimal("-12345678909876543210.00"), rs.getBigDecimal(2));
        this.assertEquals(new BigInteger("-12345678909876543210"), rs.getObject(2, BigInteger.class));
        rs.next();
        this.assertEquals(new BigDecimal("12345678901234567890.12"), rs.getBigDecimal(2));
        this.assertEquals(new BigInteger("12345678901234567890"), rs.getObject(2, BigInteger.class));
        this.stat.execute("DROP TABLE TEST");
    }

    private void testDoubleFloat() throws SQLException {
        this.trace("Test DOUBLE - FLOAT");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, D DOUBLE, R REAL, F DECFLOAT)");
        this.stat.execute("INSERT INTO TEST VALUES(1, -1, -1, -1)");
        this.stat.execute("INSERT INTO TEST VALUES(2, .0, .0, .0)");
        this.stat.execute("INSERT INTO TEST VALUES(3, 1., 1., 1.)");
        this.stat.execute("INSERT INTO TEST VALUES(4, 12345678.89, 12345678.89, 12345678.89)");
        this.stat.execute("INSERT INTO TEST VALUES(6, 99999999.99, 99999999.99, 99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(7, -99999999.99, -99999999.99, -99999999.99)");
        this.stat.execute("INSERT INTO TEST VALUES(8, NULL, NULL, NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(9, '-Infinity', '-Infinity', '-Infinity')");
        this.stat.execute("INSERT INTO TEST VALUES(10, 'Infinity', 'Infinity', 'Infinity')");
        this.stat.execute("INSERT INTO TEST VALUES(11, 'NaN', 'NaN', 'NaN')");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertResultSetMeta(rs, 4, new String[]{"ID", "D", "R", "F"}, null, new int[]{32, 53, 24, 100000}, new int[4]);
        ResultSetMetaData md = rs.getMetaData();
        this.assertEquals("INTEGER", md.getColumnTypeName(1));
        this.assertEquals("DOUBLE PRECISION", md.getColumnTypeName(2));
        this.assertEquals("REAL", md.getColumnTypeName(3));
        this.assertEquals("DECFLOAT", md.getColumnTypeName(4));
        rs.next();
        this.assertTrue(rs.getInt(1) == 1);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(2) == -1);
        this.assertTrue(rs.getInt(3) == -1);
        this.assertFalse(rs.wasNull());
        BigDecimal bd = rs.getBigDecimal(2);
        this.assertTrue(bd.compareTo(new BigDecimal("-1.00")) == 0);
        this.assertFalse(rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Double);
        this.assertTrue(((Double)o).compareTo(-1.0) == 0);
        o = rs.getObject(2, Double.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Double);
        this.assertTrue(((Double)o).compareTo(-1.0) == 0);
        o = rs.getObject(3);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Float);
        this.assertTrue(((Float)o).compareTo(Float.valueOf(-1.0f)) == 0);
        o = rs.getObject(3, Float.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Float);
        this.assertTrue(((Float)o).compareTo(Float.valueOf(-1.0f)) == 0);
        o = rs.getObject(4);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigDecimal);
        this.assertEquals(BigDecimal.valueOf(-1L, 0), o);
        o = rs.getObject(4, BigDecimal.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof BigDecimal);
        this.assertEquals(BigDecimal.valueOf(-1L, 0), o);
        rs.next();
        this.assertTrue(rs.getInt(1) == 2);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(2) == 0);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(3) == 0);
        this.assertFalse(rs.wasNull());
        this.assertTrue(rs.getInt(4) == 0);
        this.assertFalse(rs.wasNull());
        bd = rs.getBigDecimal(2);
        this.assertTrue(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.assertFalse(rs.wasNull());
        bd = rs.getBigDecimal(3);
        this.assertTrue(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.assertFalse(rs.wasNull());
        bd = rs.getBigDecimal(4);
        this.assertTrue(bd.compareTo(new BigDecimal("0.00")) == 0);
        this.assertFalse(rs.wasNull());
        rs.next();
        this.assertEquals(1.0, rs.getDouble(2));
        this.assertEquals(1.0f, rs.getFloat(3));
        this.assertEquals(BigDecimal.ONE, rs.getBigDecimal(4));
        rs.next();
        this.assertEquals(1.234567889E7, rs.getDouble(2));
        this.assertEquals(1.2345679E7f, rs.getFloat(3));
        this.assertEquals(BigDecimal.valueOf(1234567889L, 2), rs.getBigDecimal(4));
        rs.next();
        this.assertEquals(9.999999999E7, rs.getDouble(2));
        this.assertEquals(1.0E8f, rs.getFloat(3));
        this.assertEquals(BigDecimal.valueOf(9999999999L, 2), rs.getBigDecimal(4));
        rs.next();
        this.assertEquals(-9.999999999E7, rs.getDouble(2));
        this.assertEquals(-1.0E8f, rs.getFloat(3));
        this.assertEquals(BigDecimal.valueOf(-9999999999L, 2), rs.getBigDecimal(4));
        rs.next();
        this.checkColumnBigDecimal(rs, 2, 0, null);
        this.checkColumnBigDecimal(rs, 3, 0, null);
        this.checkColumnBigDecimal(rs, 4, 0, null);
        rs.next();
        this.assertEquals(Float.NEGATIVE_INFINITY, rs.getFloat(2));
        this.assertEquals(Double.NEGATIVE_INFINITY, rs.getDouble(3));
        this.assertThrows(22018, rs).getBigDecimal(4);
        this.assertThrows(22018, rs).getObject(4);
        this.assertEquals(Double.NEGATIVE_INFINITY, rs.getDouble(4));
        this.assertEquals("-Infinity", rs.getString(4));
        rs.next();
        this.assertEquals(Float.POSITIVE_INFINITY, rs.getFloat(2));
        this.assertEquals(Double.POSITIVE_INFINITY, rs.getDouble(3));
        this.assertThrows(22018, rs).getBigDecimal(4);
        this.assertThrows(22018, rs).getObject(4);
        this.assertEquals(Double.POSITIVE_INFINITY, rs.getDouble(4));
        this.assertEquals("Infinity", rs.getString(4));
        rs.next();
        this.assertEquals(Float.NaN, rs.getFloat(2));
        this.assertEquals(Double.NaN, rs.getDouble(3));
        this.assertThrows(22018, rs).getBigDecimal(4);
        this.assertThrows(22018, rs).getObject(4);
        this.assertEquals(Double.NaN, rs.getDouble(4));
        this.assertEquals("NaN", rs.getString(4));
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testDatetime() throws SQLException {
        this.trace("Test DATETIME");
        ResultSet rs = this.stat.executeQuery("call date '99999-12-23'");
        rs.next();
        this.assertEquals("99999-12-23", rs.getString(1));
        rs = this.stat.executeQuery("call timestamp '99999-12-23 01:02:03.000'");
        rs.next();
        this.assertEquals("99999-12-23 01:02:03", rs.getString(1));
        rs = this.stat.executeQuery("call date '-99999-12-23'");
        rs.next();
        this.assertEquals("-99999-12-23", rs.getString(1));
        rs = this.stat.executeQuery("call timestamp '-99999-12-23 01:02:03.000'");
        rs.next();
        this.assertEquals("-99999-12-23 01:02:03", rs.getString(1));
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" DATETIME)");
        this.stat.execute("INSERT INTO TEST VALUES(1,DATE '2011-11-11')");
        this.stat.execute("INSERT INTO TEST VALUES(2,TIMESTAMP '2002-02-02 02:02:02')");
        this.stat.execute("INSERT INTO TEST VALUES(3,TIMESTAMP '1800-1-1 0:0:0')");
        this.stat.execute("INSERT INTO TEST VALUES(4,TIMESTAMP '9999-12-31 23:59:59')");
        this.stat.execute("INSERT INTO TEST VALUES(5,NULL)");
        rs = this.stat.executeQuery("SELECT 0 ID, TIMESTAMP '9999-12-31 23:59:59' \"VALUE\" FROM TEST ORDER BY ID");
        int[] nArray = new int[2];
        nArray[1] = 9;
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 93}, new int[]{32, 29}, nArray);
        rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int[] nArray2 = new int[2];
        nArray2[1] = 6;
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 93}, new int[]{32, 26}, nArray2);
        rs.next();
        Date date = rs.getDate(2);
        this.assertFalse(rs.wasNull());
        Time time = rs.getTime(2);
        this.assertFalse(rs.wasNull());
        Timestamp ts = rs.getTimestamp(2);
        this.assertFalse(rs.wasNull());
        this.trace("Date: " + date.toString() + " Time:" + time.toString() + " Timestamp:" + ts.toString());
        this.trace("Date ms: " + date.getTime() + " Time ms:" + time.getTime() + " Timestamp ms:" + ts.getTime());
        this.trace("1970 ms: " + Timestamp.valueOf("1970-01-01 00:00:00.0").getTime());
        this.assertEquals(Timestamp.valueOf("2011-11-11 00:00:00.0").getTime(), date.getTime());
        this.assertEquals(Timestamp.valueOf("1970-01-01 00:00:00.0").getTime(), time.getTime());
        this.assertEquals(Timestamp.valueOf("2011-11-11 00:00:00.0").getTime(), ts.getTime());
        this.assertTrue(date.equals(Date.valueOf("2011-11-11")));
        this.assertTrue(time.equals(Time.valueOf("00:00:00")));
        this.assertTrue(ts.equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.assertFalse(rs.wasNull());
        Object o = rs.getObject(2);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Timestamp);
        this.assertTrue(((Timestamp)o).equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.assertFalse(rs.wasNull());
        o = rs.getObject(2, Timestamp.class);
        this.trace(o.getClass().getName());
        this.assertTrue(o instanceof Timestamp);
        this.assertTrue(((Timestamp)o).equals(Timestamp.valueOf("2011-11-11 00:00:00.0")));
        this.assertFalse(rs.wasNull());
        o = rs.getObject(2, java.util.Date.class);
        this.assertTrue(o.getClass() == java.util.Date.class);
        this.assertEquals(((java.util.Date)o).getTime(), Timestamp.valueOf("2011-11-11 00:00:00.0").getTime());
        o = rs.getObject(2, Calendar.class);
        this.assertTrue(o instanceof Calendar);
        this.assertEquals(((Calendar)o).getTimeInMillis(), Timestamp.valueOf("2011-11-11 00:00:00.0").getTime());
        rs.next();
        date = rs.getDate("VALUE");
        this.assertFalse(rs.wasNull());
        time = rs.getTime("VALUE");
        this.assertFalse(rs.wasNull());
        ts = rs.getTimestamp("VALUE");
        this.assertFalse(rs.wasNull());
        this.trace("Date: " + date.toString() + " Time:" + time.toString() + " Timestamp:" + ts.toString());
        this.assertEquals("2002-02-02", date.toString());
        this.assertEquals("02:02:02", time.toString());
        this.assertEquals("2002-02-02 02:02:02.0", ts.toString());
        rs.next();
        this.assertEquals("1800-01-01", rs.getObject("value", LocalDate.class).toString());
        this.assertEquals("00:00:00", rs.getTime("value").toString());
        this.assertEquals("00:00", rs.getObject("value", LocalTime.class).toString());
        this.assertEquals("1800-01-01T00:00", rs.getObject("value", LocalDateTime.class).toString());
        rs.next();
        this.assertEquals("9999-12-31", rs.getDate("Value").toString());
        this.assertEquals("9999-12-31", rs.getObject("Value", LocalDate.class).toString());
        this.assertEquals("23:59:59", rs.getTime("Value").toString());
        this.assertEquals("23:59:59", rs.getObject("Value", LocalTime.class).toString());
        this.assertEquals("9999-12-31 23:59:59.0", rs.getTimestamp("Value").toString());
        this.assertEquals("9999-12-31T23:59:59", rs.getObject("Value", LocalDateTime.class).toString());
        rs.next();
        this.assertTrue(rs.getDate("Value") == null && rs.wasNull());
        this.assertTrue(rs.getTime("vALUe") == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp(2) == null && rs.wasNull());
        this.assertTrue(rs.getObject(2, LocalDateTime.class) == null && rs.wasNull());
        this.assertFalse(rs.next());
        rs = this.stat.executeQuery("SELECT DATE '2001-02-03' D, TIME '14:15:16', TIMESTAMP '2007-08-09 10:11:12.141516171' TS FROM TEST");
        rs.next();
        date = (Date)rs.getObject(1);
        time = (Time)rs.getObject(2);
        ts = (Timestamp)rs.getObject(3);
        this.assertEquals("2001-02-03", date.toString());
        this.assertEquals("14:15:16", time.toString());
        this.assertEquals("2007-08-09 10:11:12.141516171", ts.toString());
        date = rs.getObject(1, Date.class);
        time = rs.getObject(2, Time.class);
        ts = rs.getObject(3, Timestamp.class);
        this.assertEquals("2001-02-03", date.toString());
        this.assertEquals("14:15:16", time.toString());
        this.assertEquals("2007-08-09 10:11:12.141516171", ts.toString());
        this.assertEquals("2001-02-03", rs.getObject(1, LocalDate.class).toString());
        this.assertEquals("14:15:16", rs.getObject(2, LocalTime.class).toString());
        this.assertEquals("2007-08-09T10:11:12.141516171", rs.getObject(3, LocalDateTime.class).toString());
        this.stat.execute("DROP TABLE TEST");
        rs = this.stat.executeQuery("SELECT LOCALTIME, CURRENT_TIME");
        rs.next();
        this.assertEquals(rs.getTime(1), rs.getTime(2));
        rs = this.stat.executeQuery("SELECT LOCALTIMESTAMP, CURRENT_TIMESTAMP");
        rs.next();
        this.assertEquals(rs.getTimestamp(1), rs.getTimestamp(2));
        rs = this.stat.executeQuery("SELECT DATE '-1000000000-01-01', DATE '1000000000-12-31'");
        rs.next();
        this.assertEquals("-999999999-01-01", rs.getObject(1, LocalDate.class).toString());
        this.assertEquals("+999999999-12-31", rs.getObject(2, LocalDate.class).toString());
        rs = this.stat.executeQuery("SELECT TIMESTAMP '-1000000000-01-01 00:00:00', TIMESTAMP '1000000000-12-31 23:59:59.999999999'");
        rs.next();
        this.assertEquals("-999999999-01-01T00:00", rs.getObject(1, LocalDateTime.class).toString());
        this.assertEquals("+999999999-12-31T23:59:59.999999999", rs.getObject(2, LocalDateTime.class).toString());
        rs = this.stat.executeQuery("SELECT TIMESTAMP WITH TIME ZONE '-1000000000-01-01 00:00:00Z', TIMESTAMP WITH TIME ZONE '1000000000-12-31 23:59:59.999999999Z', TIMESTAMP WITH TIME ZONE '-1000000000-01-01 00:00:00+18', TIMESTAMP WITH TIME ZONE '1000000000-12-31 23:59:59.999999999-18'");
        rs.next();
        this.assertEquals("-999999999-01-01T00:00Z", rs.getObject(1, OffsetDateTime.class).toString());
        this.assertEquals("+999999999-12-31T23:59:59.999999999Z", rs.getObject(2, OffsetDateTime.class).toString());
        this.assertEquals("-999999999-01-01T00:00+18:00", rs.getObject(3, OffsetDateTime.class).toString());
        this.assertEquals("+999999999-12-31T23:59:59.999999999-18:00", rs.getObject(4, OffsetDateTime.class).toString());
        this.assertEquals("-999999999-01-01T00:00Z", rs.getObject(1, ZonedDateTime.class).toString());
        this.assertEquals("+999999999-12-31T23:59:59.999999999Z", rs.getObject(2, ZonedDateTime.class).toString());
        this.assertEquals("-999999999-01-01T00:00+18:00", rs.getObject(3, ZonedDateTime.class).toString());
        this.assertEquals("+999999999-12-31T23:59:59.999999999-18:00", rs.getObject(4, ZonedDateTime.class).toString());
        this.assertEquals("-1000000000-01-01T00:00:00Z", rs.getObject(1, Instant.class).toString());
        this.assertEquals("+1000000000-12-31T23:59:59.999999999Z", rs.getObject(2, Instant.class).toString());
        this.assertEquals("-1000000000-01-01T00:00:00Z", rs.getObject(3, Instant.class).toString());
        this.assertEquals("+1000000000-12-31T23:59:59.999999999Z", rs.getObject(4, Instant.class).toString());
        rs = this.stat.executeQuery("SELECT LOCALTIME, CURRENT_TIME");
        rs.next();
        this.assertEquals(rs.getObject(1, LocalTime.class), rs.getObject(2, LocalTime.class));
        this.assertEquals(rs.getObject(1, OffsetTime.class), rs.getObject(2, OffsetTime.class));
        rs = this.stat.executeQuery("SELECT LOCALTIMESTAMP, CURRENT_TIMESTAMP");
        rs.next();
        this.assertEquals(rs.getObject(1, LocalDateTime.class), rs.getObject(2, LocalDateTime.class));
        this.assertEquals(rs.getObject(1, OffsetDateTime.class), rs.getObject(2, OffsetDateTime.class));
    }

    private void testDatetimeWithCalendar() throws SQLException {
        this.trace("Test DATETIME with Calendar");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, D DATE, T TIME, TS TIMESTAMP(9))");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?, ?)");
        GregorianCalendar regular = new GregorianCalendar();
        GregorianCalendar other = null;
        long testTime = Date.valueOf("2001-02-03").getTime();
        String[] stringArray = TimeZone.getAvailableIDs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            TimeZone zone = TimeZone.getTimeZone(s);
            long rawOffsetDiff = regular.getTimeZone().getRawOffset() - zone.getRawOffset();
            if (rawOffsetDiff != 0L && rawOffsetDiff != 86400000L && regular.getTimeZone().getOffset(testTime) != zone.getOffset(testTime)) {
                other = new GregorianCalendar(zone);
                break;
            }
            ++n2;
        }
        this.trace("regular offset = " + regular.getTimeZone().getRawOffset() + " other = " + other.getTimeZone().getRawOffset());
        prep.setInt(1, 0);
        prep.setDate(2, null, regular);
        prep.setTime(3, null, regular);
        prep.setTimestamp(4, null, regular);
        prep.execute();
        prep.setInt(1, 1);
        prep.setDate(2, null, other);
        prep.setTime(3, null, other);
        prep.setTimestamp(4, null, other);
        prep.execute();
        prep.setInt(1, 2);
        prep.setDate(2, Date.valueOf("2001-02-03"), regular);
        prep.setTime(3, Time.valueOf("04:05:06"), regular);
        prep.setTimestamp(4, Timestamp.valueOf("2007-08-09 10:11:12.131415"), regular);
        prep.execute();
        prep.setInt(1, 3);
        prep.setDate(2, Date.valueOf("2101-02-03"), other);
        prep.setTime(3, Time.valueOf("14:05:06"), other);
        prep.setTimestamp(4, Timestamp.valueOf("2107-08-09 10:11:12.131415"), other);
        prep.execute();
        prep.setInt(1, 4);
        prep.setDate(2, Date.valueOf("2101-02-03"));
        prep.setTime(3, Time.valueOf("14:05:06"));
        prep.setTimestamp(4, Timestamp.valueOf("2107-08-09 10:11:12.131415"));
        prep.execute();
        prep.setInt(1, 5);
        prep.setDate(2, Date.valueOf("2101-02-03"), null);
        prep.setTime(3, Time.valueOf("14:05:06"), null);
        prep.setTimestamp(4, Timestamp.valueOf("2107-08-09 10:11:12.131415"), null);
        prep.execute();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        int[] nArray = new int[4];
        nArray[3] = 9;
        this.assertResultSetMeta(rs, 4, new String[]{"ID", "D", "T", "TS"}, new int[]{4, 91, 92, 93}, new int[]{32, 10, 8, 29}, nArray);
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.assertTrue(rs.getDate(2, (Calendar)regular) == null && rs.wasNull());
        this.assertTrue(rs.getTime(3, (Calendar)regular) == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp(3, (Calendar)regular) == null && rs.wasNull());
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertTrue(rs.getDate(2, (Calendar)other) == null && rs.wasNull());
        this.assertTrue(rs.getTime(3, (Calendar)other) == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp(3, (Calendar)other) == null && rs.wasNull());
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("2001-02-03", rs.getDate(2, (Calendar)regular).toString());
        this.assertEquals("04:05:06", rs.getTime(3, (Calendar)regular).toString());
        this.assertFalse(rs.getTime(3, (Calendar)other).toString().equals("04:05:06"));
        this.assertEquals("2007-08-09 10:11:12.131415", rs.getTimestamp(4, (Calendar)regular).toString());
        this.assertFalse(rs.getTimestamp(4, (Calendar)other).toString().equals("2007-08-09 10:11:12.131415"));
        rs.next();
        this.assertEquals(3, rs.getInt("ID"));
        this.assertFalse(rs.getTimestamp("TS", (Calendar)regular).toString().equals("2107-08-09 10:11:12.131415"));
        this.assertEquals("2107-08-09 10:11:12.131415", rs.getTimestamp("TS", (Calendar)other).toString());
        this.assertFalse(rs.getTime("T", (Calendar)regular).toString().equals("14:05:06"));
        this.assertEquals("14:05:06", rs.getTime("T", (Calendar)other).toString());
        rs.next();
        this.assertEquals(4, rs.getInt("ID"));
        this.assertEquals("2107-08-09 10:11:12.131415", rs.getTimestamp("TS").toString());
        this.assertEquals("14:05:06", rs.getTime("T").toString());
        this.assertEquals("2101-02-03", rs.getDate("D").toString());
        rs.next();
        this.assertEquals(5, rs.getInt("ID"));
        this.assertEquals("2107-08-09 10:11:12.131415", rs.getTimestamp("TS").toString());
        this.assertEquals("14:05:06", rs.getTime("T").toString());
        this.assertEquals("2101-02-03", rs.getDate("D").toString());
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testInterval() throws SQLException {
        this.trace("Test INTERVAL");
        ResultSet rs = this.stat.executeQuery("CALL INTERVAL '10' YEAR");
        rs.next();
        this.assertEquals("INTERVAL '10' YEAR", rs.getString(1));
        Interval expected = new Interval(IntervalQualifier.YEAR, false, 10L, 0L);
        this.assertEquals(expected, rs.getObject(1));
        this.assertEquals(expected, rs.getObject(1, Interval.class));
        ResultSetMetaData metaData = rs.getMetaData();
        this.assertEquals(1111, metaData.getColumnType(1));
        this.assertEquals("INTERVAL YEAR", metaData.getColumnTypeName(1));
        this.assertEquals(Interval.class.getName(), metaData.getColumnClassName(1));
        this.assertEquals("INTERVAL '-111222333444555666' YEAR".length(), metaData.getColumnDisplaySize(1));
        this.assertFalse(metaData.isSigned(1));
    }

    private void testInterval8() throws SQLException {
        this.trace("Test INTERVAL 8");
        ResultSet rs = this.stat.executeQuery("CALL INTERVAL '1-2' YEAR TO MONTH");
        rs.next();
        this.assertEquals("INTERVAL '1-2' YEAR TO MONTH", rs.getString(1));
        this.assertEquals(Period.of(1, 2, 0), rs.getObject(1, Period.class));
        this.assertThrows(22018, rs).getObject(1, Duration.class);
        rs = this.stat.executeQuery("CALL INTERVAL '-3.1' SECOND");
        rs.next();
        this.assertEquals("INTERVAL '-3.1' SECOND", rs.getString(1));
        this.assertEquals(Duration.ofSeconds(-4L, 900000000L), rs.getObject(1, Duration.class));
        this.assertThrows(22018, rs).getObject(1, Period.class);
    }

    private void testBlob() throws SQLException {
        this.trace("Test BLOB");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" BLOB)");
        this.stat.execute("INSERT INTO TEST VALUES(1,X'01010101')");
        this.stat.execute("INSERT INTO TEST VALUES(2,X'02020202')");
        this.stat.execute("INSERT INTO TEST VALUES(3,X'00')");
        this.stat.execute("INSERT INTO TEST VALUES(4,X'ffffff')");
        this.stat.execute("INSERT INTO TEST VALUES(5,X'0bcec1')");
        this.stat.execute("INSERT INTO TEST VALUES(6,X'03030303')");
        this.stat.execute("INSERT INTO TEST VALUES(7,NULL)");
        byte[] random = new byte[65536];
        MathUtils.randomBytes(random);
        this.stat.execute("INSERT INTO TEST VALUES(8, X'" + StringUtils.convertBytesToHex(random) + "')");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 2004}, new int[]{32, Integer.MAX_VALUE}, new int[2]);
        rs.next();
        this.assertEqualsWithNull(new byte[]{1, 1, 1, 1}, rs.getBytes(2));
        this.assertFalse(rs.wasNull());
        this.assertEqualsWithNull(new byte[]{1, 1, 1, 1}, rs.getObject(2, byte[].class));
        this.assertFalse(rs.wasNull());
        rs.next();
        this.assertEqualsWithNull(new byte[]{2, 2, 2, 2}, rs.getBytes("value"));
        this.assertFalse(rs.wasNull());
        this.assertEqualsWithNull(new byte[]{2, 2, 2, 2}, rs.getObject("value", byte[].class));
        this.assertFalse(rs.wasNull());
        rs.next();
        this.assertEqualsWithNull(new byte[1], this.readAllBytes(rs.getBinaryStream(2)));
        this.assertFalse(rs.wasNull());
        rs.next();
        this.assertEqualsWithNull(new byte[]{-1, -1, -1}, this.readAllBytes(rs.getBinaryStream("VaLuE")));
        this.assertFalse(rs.wasNull());
        rs.next();
        InputStream in = rs.getBinaryStream("value");
        byte[] b = this.readAllBytes(in);
        this.assertEqualsWithNull(new byte[]{11, -50, -63}, b);
        Blob blob = rs.getObject("value", Blob.class);
        try {
            this.assertNotNull(blob);
            this.assertEqualsWithNull(new byte[]{11, -50, -63}, this.readAllBytes(blob.getBinaryStream()));
            this.assertEqualsWithNull(new byte[]{-50, -63}, this.readAllBytes(blob.getBinaryStream(2L, 2L)));
            this.assertFalse(rs.wasNull());
        }
        finally {
            blob.free();
        }
        this.assertFalse(rs.wasNull());
        rs.next();
        blob = rs.getObject("value", Blob.class);
        try {
            this.assertNotNull(blob);
            this.assertEqualsWithNull(new byte[]{3, 3, 3, 3}, this.readAllBytes(blob.getBinaryStream()));
            this.assertEqualsWithNull(new byte[]{3, 3}, this.readAllBytes(blob.getBinaryStream(2L, 2L)));
            this.assertFalse(rs.wasNull());
            this.assertThrows(90008, blob).getBinaryStream(5L, 1L);
        }
        finally {
            blob.free();
        }
        rs.next();
        this.assertEqualsWithNull(null, this.readAllBytes(rs.getBinaryStream("VaLuE")));
        this.assertTrue(rs.wasNull());
        rs.next();
        blob = rs.getObject("value", Blob.class);
        try {
            this.assertNotNull(blob);
            this.assertEqualsWithNull(random, this.readAllBytes(blob.getBinaryStream()));
            byte[] expected = Arrays.copyOfRange(random, 100, 50102);
            byte[] got = this.readAllBytes(blob.getBinaryStream(101L, 50002L));
            this.assertEqualsWithNull(expected, got);
            this.assertFalse(rs.wasNull());
            this.assertThrows(90008, blob).getBinaryStream(65537L, 1L);
            this.assertThrows(90008, blob).getBinaryStream(65538L, 0L);
        }
        finally {
            blob.free();
        }
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testClob() throws SQLException {
        this.trace("Test CLOB");
        this.stat = this.conn.createStatement(1003, 1008);
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,\"VALUE\" CLOB)");
        this.stat.execute("INSERT INTO TEST VALUES(1,'Test')");
        this.stat.execute("INSERT INTO TEST VALUES(2,'Hello')");
        this.stat.execute("INSERT INTO TEST VALUES(3,'World!')");
        this.stat.execute("INSERT INTO TEST VALUES(4,'Hallo')");
        this.stat.execute("INSERT INTO TEST VALUES(5,'Welt!')");
        this.stat.execute("INSERT INTO TEST VALUES(6,'Test2')");
        this.stat.execute("INSERT INTO TEST VALUES(7,NULL)");
        this.stat.execute("INSERT INTO TEST VALUES(8,NULL)");
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertResultSetMeta(rs, 2, new String[]{"ID", "VALUE"}, new int[]{4, 2005}, new int[]{32, Integer.MAX_VALUE}, new int[2]);
        rs.next();
        Object obj = rs.getObject(2);
        this.assertTrue(obj instanceof Clob);
        String string = rs.getString(2);
        this.assertTrue(string != null && string.equals("Test"));
        this.assertFalse(rs.wasNull());
        rs.next();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(rs.getAsciiStream(2), StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            this.assertTrue(false);
        }
        string = this.readString(reader);
        this.assertFalse(rs.wasNull());
        this.trace(string);
        this.assertTrue(string != null && string.equals("Hello"));
        rs.next();
        try {
            reader = new InputStreamReader(rs.getAsciiStream("value"), StandardCharsets.ISO_8859_1);
        }
        catch (Exception e) {
            this.assertTrue(false);
        }
        string = this.readString(reader);
        this.assertFalse(rs.wasNull());
        this.trace(string);
        this.assertTrue(string != null && string.equals("World!"));
        rs.next();
        string = this.readString(rs.getCharacterStream(2));
        this.assertFalse(rs.wasNull());
        this.trace(string);
        this.assertTrue(string != null && string.equals("Hallo"));
        Clob clob = rs.getClob(2);
        try {
            this.assertEquals("all", this.readString(clob.getCharacterStream(2L, 3L)));
            this.assertThrows(90008, clob).getCharacterStream(6L, 1L);
            this.assertThrows(90008, clob).getCharacterStream(7L, 0L);
        }
        finally {
            clob.free();
        }
        rs.next();
        string = this.readString(rs.getCharacterStream("value"));
        this.assertFalse(rs.wasNull());
        this.trace(string);
        this.assertTrue(string != null && string.equals("Welt!"));
        rs.next();
        clob = rs.getObject("value", Clob.class);
        try {
            this.assertNotNull(clob);
            string = this.readString(clob.getCharacterStream());
            this.assertTrue(string != null && string.equals("Test2"));
            this.assertFalse(rs.wasNull());
        }
        finally {
            clob.free();
        }
        rs.next();
        this.assertNull(rs.getCharacterStream(2));
        this.assertTrue(rs.wasNull());
        rs.next();
        this.assertNull(rs.getAsciiStream("Value"));
        this.assertTrue(rs.wasNull());
        this.assertTrue(rs.getStatement() == this.stat);
        this.assertNull(rs.getWarnings());
        rs.clearWarnings();
        this.assertNull(rs.getWarnings());
        this.assertEquals(1000, rs.getFetchDirection());
        this.assertEquals(1008, rs.getConcurrency());
        rs.next();
        this.stat.execute("DROP TABLE TEST");
    }

    private void testArray() throws SQLException {
        this.trace("Test ARRAY");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, \"VALUE\" INTEGER ARRAY)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        prep.setInt(1, 1);
        prep.setObject(2, new Object[]{1, 2});
        prep.execute();
        prep.setInt(1, 2);
        prep.setObject(2, new Object[]{11, 12});
        prep.execute();
        prep.setInt(1, 3);
        prep.setObject(2, new Object[0]);
        prep.execute();
        prep.close();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertEquals("INTEGER ARRAY", rs.getMetaData().getColumnTypeName(2));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        Object[] list = (Object[])((Array)rs.getObject(2)).getArray();
        this.assertEquals(1, (int)((Integer)list[0]));
        this.assertEquals(2, (int)((Integer)list[1]));
        Array array = rs.getArray(2);
        Object[] list2 = (Object[])array.getArray();
        this.assertEquals(1, (int)((Integer)list2[0]));
        this.assertEquals(2, (int)((Integer)list2[1]));
        list2 = (Object[])array.getArray(2L, 1);
        this.assertEquals(2, (int)((Integer)list2[0]));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        list = (Object[])((Array)rs.getObject(2)).getArray();
        this.assertEquals(11, (int)((Integer)list[0]));
        this.assertEquals(12, (int)((Integer)list[1]));
        array = rs.getArray("VALUE");
        list2 = (Object[])array.getArray();
        this.assertEquals(11, (int)((Integer)list2[0]));
        this.assertEquals(12, (int)((Integer)list2[1]));
        list2 = (Object[])array.getArray(2L, 1);
        this.assertEquals(12, (int)((Integer)list2[0]));
        list2 = (Object[])array.getArray(Collections.emptyMap());
        this.assertEquals(11, (int)((Integer)list2[0]));
        this.assertEquals(4, array.getBaseType());
        this.assertEquals("INTEGER", array.getBaseTypeName());
        this.assertTrue(array.toString().endsWith(": ARRAY [11, 12]"));
        rs.next();
        this.assertEquals(3, rs.getInt(1));
        list = (Object[])((Array)rs.getObject(2)).getArray();
        this.assertEquals(0, list.length);
        array = rs.getArray("VALUE");
        list2 = (Object[])array.getArray();
        this.assertEquals(0, list2.length);
        list2 = (Object[])array.getArray(1L, 0);
        this.assertEquals(0, list2.length);
        list2 = (Object[])array.getArray(1L, 1);
        this.assertEquals(0, list2.length);
        list2 = (Object[])array.getArray(Collections.emptyMap());
        this.assertEquals(0, list2.length);
        this.assertTrue(array.toString().endsWith(": ARRAY []"));
        array.free();
        this.assertEquals("null", array.toString());
        this.assertThrows(90007, array).getBaseType();
        this.assertThrows(90007, array).getBaseTypeName();
        this.assertThrows(90007, array).getResultSet();
        this.assertFalse(rs.next());
        Throwable throwable = null;
        Object var7_8 = null;
        try (Statement s = this.conn.createStatement(1003, 1008);){
            rs = s.executeQuery("SELECT * FROM TEST ORDER BY ID");
            this.assertTrue(rs.next());
            this.assertEquals(1, rs.getInt(1));
            rs.updateArray(2, this.conn.createArrayOf("INT", new Object[]{10, 20}));
            rs.updateRow();
            this.assertTrue(rs.next());
            rs.updateArray("VALUE", this.conn.createArrayOf("INT", new Object[]{11, 22}));
            rs.updateRow();
            this.assertTrue(rs.next());
            this.assertFalse(rs.next());
            rs.moveToInsertRow();
            rs.updateInt(1, 4);
            rs.updateArray(2, null);
            rs.insertRow();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(new Object[]{10, 20}, (Object[])((Array)rs.getObject(2)).getArray());
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(new Object[]{11, 22}, (Object[])((Array)rs.getObject(2)).getArray());
        this.assertTrue(rs.next());
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(new Object[0], (Object[])((Array)rs.getObject(2)).getArray());
        this.assertTrue(rs.next());
        this.assertEquals(4, rs.getInt(1));
        this.assertNull(rs.getObject(2));
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testRowValue() throws SQLException {
        this.trace("Test ROW value");
        ResultSet rs = this.stat.executeQuery("SELECT (1, 'test')");
        this.assertEquals("ROW(\"C1\" INTEGER, \"C2\" CHARACTER VARYING(4))", rs.getMetaData().getColumnTypeName(1));
        rs.next();
        this.testRowValue((ResultSet)rs.getObject(1));
        ResultSet rowAsResultSet = rs.getObject(1, ResultSet.class);
        this.testRowValue(rowAsResultSet);
    }

    private void testRowValue(ResultSet rowAsResultSet) throws SQLException {
        ResultSetMetaData md = rowAsResultSet.getMetaData();
        this.assertEquals(2, md.getColumnCount());
        this.assertEquals("C1", md.getColumnLabel(1));
        this.assertEquals("C1", md.getColumnName(1));
        this.assertEquals("C2", md.getColumnLabel(2));
        this.assertEquals("C2", md.getColumnName(2));
        this.assertEquals(4, md.getColumnType(1));
        this.assertEquals(12, md.getColumnType(2));
        this.assertTrue(rowAsResultSet.next());
        this.assertEquals(1, rowAsResultSet.getInt(1));
        this.assertEquals("test", rowAsResultSet.getString(2));
        this.assertFalse(rowAsResultSet.next());
    }

    private void testEnum() throws SQLException {
        this.trace("Test ENUM");
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, \"VALUE\" ENUM('A', 'B', 'C', 'D', 'E', 'F', 'G'))");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        prep.setInt(1, 1);
        prep.setString(2, "A");
        prep.executeUpdate();
        prep.setInt(1, 2);
        prep.setObject(2, "B");
        prep.executeUpdate();
        prep.setInt(1, 3);
        prep.setInt(2, 3);
        prep.executeUpdate();
        prep.setInt(1, 4);
        prep.setObject(2, (Object)"D", 12);
        prep.executeUpdate();
        prep.setInt(1, 5);
        prep.setObject(2, (Object)"E", 1111);
        prep.executeUpdate();
        prep.setInt(1, 6);
        prep.setObject(2, (Object)6, 1111);
        prep.executeUpdate();
        prep.setInt(1, 7);
        prep.setObject(2, (Object)7, 4);
        prep.executeUpdate();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertEquals("ENUM('A', 'B', 'C', 'D', 'E', 'F', 'G')", rs.getMetaData().getColumnTypeName(2));
        this.testEnumResult(rs, 1, "A", 1);
        this.testEnumResult(rs, 2, "B", 2);
        this.testEnumResult(rs, 3, "C", 3);
        this.testEnumResult(rs, 4, "D", 4);
        this.testEnumResult(rs, 5, "E", 5);
        this.testEnumResult(rs, 6, "F", 6);
        this.testEnumResult(rs, 7, "G", 7);
        this.assertFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
    }

    private void testEnumResult(ResultSet rs, int id, String name, int ordinal) throws SQLException {
        this.assertTrue(rs.next());
        this.assertEquals(id, rs.getInt(1));
        this.assertEquals(name, rs.getString(2));
        this.assertEquals((Object)name, rs.getObject(2));
        this.assertEquals(name, rs.getObject(2, String.class));
        this.assertEquals(ordinal, rs.getInt(2));
        this.assertEquals((Integer)ordinal, rs.getObject(2, Integer.class));
    }

    private byte[] readAllBytes(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            this.assertTrue(false);
            return null;
        }
    }

    private void assertEqualsWithNull(byte[] expected, byte[] got) {
        if (got == null || expected == null) {
            this.assertTrue(got == expected);
        } else {
            this.assertEquals(got, expected);
        }
    }

    private void checkColumnBigDecimal(ResultSet rs, int column, int i, String bd) throws SQLException {
        BigDecimal bd1 = rs.getBigDecimal(column);
        int i1 = rs.getInt(column);
        if (bd == null) {
            this.trace("should be: null");
            this.assertTrue(rs.wasNull());
        } else {
            this.trace("BigDecimal i=" + i + " bd=" + bd + " ; i1=" + i1 + " bd1=" + String.valueOf(bd1));
            this.assertFalse(rs.wasNull());
            this.assertTrue(i1 == i);
            this.assertTrue(bd1.compareTo(new BigDecimal(bd)) == 0);
        }
    }
}

