/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestStatement
extends TestDb {
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("statement");
        this.conn = this.getConnection("statement");
        this.testUnwrap();
        this.testUnsupportedOperations();
        this.testTraceError();
        this.testSavepoint();
        this.testConnectionRollback();
        this.testStatement();
        this.testPreparedStatement();
        this.testCloseOnCompletion();
        this.testIdentityMerge();
        this.conn.close();
        this.deleteDb("statement");
        this.testIdentifiers();
        this.deleteDb("statement");
    }

    private void testUnwrap() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertTrue(stat.isWrapperFor(Object.class));
        this.assertTrue(stat.isWrapperFor(Statement.class));
        this.assertTrue(stat.isWrapperFor(stat.getClass()));
        this.assertFalse(stat.isWrapperFor(Integer.class));
        this.assertTrue(stat == stat.unwrap(Object.class));
        this.assertTrue(stat == stat.unwrap(Statement.class));
        this.assertTrue(stat == stat.unwrap(stat.getClass()));
        this.assertThrows(90008, stat).unwrap(Integer.class);
    }

    private void testUnsupportedOperations() throws Exception {
        this.assertTrue(this.conn.getTypeMap().isEmpty());
        this.conn.setTypeMap(null);
        HashMap map = new HashMap();
        this.conn.setTypeMap(map);
        map.put("x", Object.class);
        this.assertThrows(50100, this.conn).setTypeMap(map);
    }

    private void testTraceError() throws Exception {
        if (this.config.memory || this.config.networked || this.config.traceLevelFile != 0) {
            return;
        }
        Statement stat = this.conn.createStatement();
        String fileName = this.getBaseDir() + "/statement.trace.db";
        stat.execute("DROP TABLE TEST IF EXISTS");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        stat.execute("INSERT INTO TEST VALUES(1)");
        try {
            stat.execute("ERROR");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        long lengthBefore = FileUtils.size(fileName);
        try {
            stat.execute("ERROR");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        long error = FileUtils.size(fileName);
        this.assertSmaller(lengthBefore, error);
        lengthBefore = error;
        try {
            stat.execute("INSERT INTO TEST VALUES(1)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        error = FileUtils.size(fileName);
        this.assertEquals(lengthBefore, error);
        stat.execute("DROP TABLE TEST IF EXISTS");
    }

    private void testConnectionRollback() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.conn.setAutoCommit(false);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.conn.rollback();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        this.conn.setAutoCommit(true);
    }

    private void testSavepoint() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(0, 'Hi')");
        Savepoint savepoint1 = this.conn.setSavepoint();
        int id1 = savepoint1.getSavepointId();
        this.assertThrows(90064, savepoint1).getSavepointName();
        stat.execute("DELETE FROM TEST");
        this.conn.rollback(savepoint1);
        stat.execute("UPDATE TEST SET NAME='Hello'");
        Savepoint savepoint2a = this.conn.setSavepoint();
        Savepoint savepoint2 = this.conn.setSavepoint();
        this.conn.releaseSavepoint(savepoint2a);
        this.assertThrows(90063, savepoint2a).getSavepointId();
        int id2 = savepoint2.getSavepointId();
        this.assertTrue(id1 != id2);
        stat.execute("UPDATE TEST SET NAME='Hallo' WHERE NAME='Hello'");
        Savepoint savepointTest = this.conn.setSavepoint("Joe's");
        this.assertTrue(savepointTest.toString().endsWith("name=Joe's"));
        stat.execute("DELETE FROM TEST");
        this.assertEquals(savepointTest.getSavepointName(), "Joe's");
        this.assertThrows(90065, savepointTest).getSavepointId();
        this.conn.rollback(savepointTest);
        this.conn.commit();
        ResultSet rs = stat.executeQuery("SELECT NAME FROM TEST");
        rs.next();
        String name = rs.getString(1);
        this.assertEquals(name, "Hallo");
        this.assertFalse(rs.next());
        this.assertThrows(90063, this.conn).rollback(savepoint2);
        stat.execute("DROP TABLE TEST");
        this.conn.setAutoCommit(true);
    }

    private void testStatement() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertEquals(1, this.conn.getHoldability());
        this.conn.setHoldability(2);
        this.assertEquals(2, this.conn.getHoldability());
        this.assertFalse(stat.isPoolable());
        stat.setPoolable(true);
        this.assertFalse(stat.isPoolable());
        stat.setCursorName("x");
        this.assertEquals(stat.getFetchDirection(), 1000);
        stat.setFetchDirection(1001);
        stat.setMaxFieldSize(100);
        this.assertEquals(SysProperties.SERVER_RESULT_SET_FETCH_SIZE, stat.getFetchSize());
        stat.setFetchSize(10);
        this.assertEquals(10, stat.getFetchSize());
        stat.setFetchSize(0);
        this.assertEquals(SysProperties.SERVER_RESULT_SET_FETCH_SIZE, stat.getFetchSize());
        this.assertEquals(1003, stat.getResultSetType());
        Statement stat2 = this.conn.createStatement(1005, 1007, 1);
        this.assertEquals(1005, stat2.getResultSetType());
        this.assertEquals(1, stat2.getResultSetHoldability());
        this.assertEquals(1007, stat2.getResultSetConcurrency());
        this.assertEquals(0, stat.getMaxFieldSize());
        this.assertFalse(stat2.isClosed());
        stat2.close();
        this.assertTrue(stat2.isClosed());
        stat.execute("CREATE TABLE TEST(ID INT)");
        stat.execute("SELECT * FROM TEST");
        stat.execute("DROP TABLE TEST");
        this.conn.getTypeMap();
        this.assertEquals(1, stat.getResultSetHoldability());
        this.assertEquals(1007, stat.getResultSetConcurrency());
        stat.cancel();
        stat.setQueryTimeout(10);
        this.assertTrue(stat.getQueryTimeout() == 10);
        stat.setQueryTimeout(0);
        this.assertTrue(stat.getQueryTimeout() == 0);
        this.assertThrows(90008, stat).setQueryTimeout(-1);
        this.assertTrue(stat.getQueryTimeout() == 0);
        this.trace("executeUpdate");
        int count = stat.executeUpdate("CREATE TABLE TEST(ID INT PRIMARY KEY,V VARCHAR(255))");
        this.assertEquals(0, count);
        count = stat.executeUpdate("INSERT INTO TEST VALUES(1,'Hello')");
        this.assertEquals(1, count);
        count = stat.executeUpdate("INSERT INTO TEST(V,ID) VALUES('JDBC',2)");
        this.assertEquals(1, count);
        count = stat.executeUpdate("UPDATE TEST SET V='LDBC' WHERE ID=2 OR ID=1");
        this.assertEquals(2, count);
        count = stat.executeUpdate("UPDATE TEST SET V='\\LDBC\\' WHERE V LIKE 'LDBC' ");
        this.assertEquals(2, count);
        count = stat.executeUpdate("UPDATE TEST SET V='LDBC' WHERE V LIKE '\\\\LDBC\\\\'");
        this.trace("count:" + count);
        this.assertEquals(2, count);
        count = stat.executeUpdate("DELETE FROM TEST WHERE ID=-1");
        this.assertEquals(0, count);
        count = stat.executeUpdate("DELETE FROM TEST WHERE ID=2");
        this.assertEquals(1, count);
        long largeCount = stat.executeLargeUpdate("DELETE FROM TEST WHERE ID=-1");
        this.assertEquals(0L, largeCount);
        this.assertEquals(0L, stat.getLargeUpdateCount());
        largeCount = stat.executeLargeUpdate("INSERT INTO TEST(V,ID) VALUES('JDBC',2)");
        this.assertEquals(1L, largeCount);
        this.assertEquals(1L, stat.getLargeUpdateCount());
        largeCount = stat.executeLargeUpdate("DELETE FROM TEST WHERE ID=2");
        this.assertEquals(1L, largeCount);
        this.assertEquals(1L, stat.getLargeUpdateCount());
        this.assertThrows(90001, stat).executeUpdate("SELECT * FROM TEST");
        count = stat.executeUpdate("DROP TABLE TEST");
        this.assertTrue(count == 0);
        this.trace("execute");
        boolean result = stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,V VARCHAR(255))");
        this.assertFalse(result);
        result = stat.execute("INSERT INTO TEST VALUES(1,'Hello')");
        this.assertFalse(result);
        result = stat.execute("INSERT INTO TEST(V,ID) VALUES('JDBC',2)");
        this.assertFalse(result);
        result = stat.execute("UPDATE TEST SET V='LDBC' WHERE ID=2");
        this.assertFalse(result);
        result = stat.execute("DELETE FROM TEST WHERE ID=3");
        this.assertFalse(result);
        result = stat.execute("SELECT * FROM TEST");
        this.assertTrue(result);
        result = stat.execute("DROP TABLE TEST");
        this.assertFalse(result);
        this.assertThrows(90002, stat).executeQuery("CREATE TABLE TEST(ID INT PRIMARY KEY,V VARCHAR(255))");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,V VARCHAR(255))");
        this.assertThrows(90002, stat).executeQuery("INSERT INTO TEST VALUES(1,'Hello')");
        this.assertThrows(90002, stat).executeQuery("UPDATE TEST SET V='LDBC' WHERE ID=2");
        this.assertThrows(90002, stat).executeQuery("DELETE FROM TEST WHERE ID=3");
        stat.executeQuery("SELECT * FROM TEST");
        this.assertThrows(90002, stat).executeQuery("DROP TABLE TEST");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        this.assertFalse(stat.getMoreResults());
        this.assertThrows(90007, rs).next();
        this.assertTrue(stat.getUpdateCount() == -1);
        count = stat.executeUpdate("DELETE FROM TEST");
        this.assertFalse(stat.getMoreResults());
        this.assertTrue(stat.getUpdateCount() == -1);
        stat.execute("DROP TABLE TEST");
        stat.executeUpdate("DROP TABLE IF EXISTS TEST");
        this.assertNull(stat.getWarnings());
        stat.clearWarnings();
        this.assertNull(stat.getWarnings());
        this.assertTrue(this.conn == stat.getConnection());
        stat.close();
    }

    private void testCloseOnCompletion() throws SQLException {
        Statement stat = this.conn.createStatement();
        this.assertFalse(stat.isCloseOnCompletion());
        ResultSet rs = stat.executeQuery("VALUES 1");
        this.assertFalse(stat.isCloseOnCompletion());
        stat.closeOnCompletion();
        this.assertTrue(stat.isCloseOnCompletion());
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        rs.close();
        this.assertTrue(stat.isClosed());
        this.assertThrows(90007, stat).isCloseOnCompletion();
        this.assertThrows(90007, stat).closeOnCompletion();
        stat = this.conn.createStatement();
        stat.closeOnCompletion();
        rs = stat.executeQuery("VALUES 1");
        ResultSet rs2 = stat.executeQuery("VALUES 2");
        rs.close();
        this.assertFalse(stat.isClosed());
        rs2.close();
        this.assertTrue(stat.isClosed());
    }

    private void testIdentityMerge() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("drop table if exists test1");
        stat.execute("create table test1(id identity, x int)");
        stat.execute("drop table if exists test2");
        stat.execute("create table test2(id identity, x int)");
        stat.execute("merge into test1(x) key(x) values(5)", 1);
        ResultSet keys = stat.getGeneratedKeys();
        keys.next();
        this.assertEquals(1, keys.getInt(1));
        stat.execute("insert into test2(x) values(10), (11), (12)");
        stat.execute("merge into test1(x) key(x) values(5)", 1);
        keys = stat.getGeneratedKeys();
        keys.next();
        this.assertEquals(1, keys.getInt(1));
        this.assertFalse(keys.next());
        stat.execute("merge into test1(x) key(x) values(6)", 1);
        keys = stat.getGeneratedKeys();
        keys.next();
        this.assertEquals(2, keys.getInt(1));
        stat.execute("drop table test1, test2");
    }

    private void testPreparedStatement() throws SQLException {
        Statement stat = this.conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar(255))");
        stat.execute("insert into test values(1, 'Hello')");
        stat.execute("insert into test values(2, 'World')");
        PreparedStatement ps = this.conn.prepareStatement("select name from test where id in (select id from test where name REGEXP ?)");
        ps.setString(1, "Hello");
        ResultSet rs = ps.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("Hello", rs.getString("name"));
        this.assertFalse(rs.next());
        ps.setString(1, "World");
        rs = ps.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("World", rs.getString("name"));
        this.assertFalse(rs.next());
        stat.execute("create index t_id on test(name)");
        ps.setString(1, "Hello");
        rs = ps.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("Hello", rs.getString("name"));
        this.assertFalse(rs.next());
        ps.setString(1, "World");
        rs = ps.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals("World", rs.getString("name"));
        this.assertFalse(rs.next());
        ps = this.conn.prepareStatement("insert into test values(?, ?)");
        ps.setInt(1, 3);
        ps.setString(2, "v3");
        ps.addBatch();
        ps.setInt(1, 4);
        ps.setString(2, "v4");
        ps.addBatch();
        this.assertTrue(Arrays.equals(new int[]{1, 1}, ps.executeBatch()));
        ps.setInt(1, 5);
        ps.setString(2, "v5");
        ps.addBatch();
        ps.setInt(1, 6);
        ps.setString(2, "v6");
        ps.addBatch();
        this.assertTrue(Arrays.equals(new long[]{1L, 1L}, ps.executeLargeBatch()));
        ps.setInt(1, 7);
        ps.setString(2, "v7");
        this.assertEquals(1, ps.executeUpdate());
        this.assertEquals(1, ps.getUpdateCount());
        ps.setInt(1, 8);
        ps.setString(2, "v8");
        this.assertEquals(1L, ps.executeLargeUpdate());
        this.assertEquals(1L, ps.getLargeUpdateCount());
        stat.execute("drop table test");
    }

    private void testIdentifiers() throws SQLException {
        Connection conn = this.getConnection("statement");
        Statement stat = conn.createStatement();
        this.assertEquals("SOME_ID", stat.enquoteIdentifier("SOME_ID", false));
        this.assertEquals("\"SOME ID\"", stat.enquoteIdentifier("SOME ID", false));
        this.assertEquals("\"SOME_ID\"", stat.enquoteIdentifier("SOME_ID", true));
        this.assertEquals("\"FROM\"", stat.enquoteIdentifier("FROM", false));
        this.assertEquals("\"Test\"", stat.enquoteIdentifier("Test", false));
        this.assertEquals("\"test\"", stat.enquoteIdentifier("test", false));
        this.assertEquals("\"TOP\"", stat.enquoteIdentifier("TOP", false));
        this.assertEquals("\"Test\"", stat.enquoteIdentifier("\"Test\"", false));
        this.assertEquals("\"Test\"", stat.enquoteIdentifier("\"Test\"", true));
        this.assertEquals("\"\"\"Test\"", stat.enquoteIdentifier("\"\"\"Test\"", true));
        this.assertEquals("\"\"", stat.enquoteIdentifier("", false));
        this.assertEquals("\"\"", stat.enquoteIdentifier("", true));
        this.assertEquals("U&\"\"", stat.enquoteIdentifier("U&\"\"", false));
        this.assertEquals("U&\"\"", stat.enquoteIdentifier("U&\"\"", true));
        this.assertEquals("U&\"\b0\"", stat.enquoteIdentifier("U&\"\b0\"", false));
        this.assertEquals("U&\"\b0\"", stat.enquoteIdentifier("U&\"\b0\"", true));
        this.assertThrows(NullPointerException.class, () -> stat.enquoteIdentifier(null, false));
        this.assertThrows(42602, () -> stat.enquoteIdentifier("\"Test", true));
        this.assertThrows(42602, () -> stat.enquoteIdentifier("\"a\"a\"", true));
        this.assertThrows(42602, () -> stat.enquoteIdentifier("U&\"a\"a\"", true));
        this.assertThrows(90095, () -> stat.enquoteIdentifier("U&\"\\111\"", true));
        this.assertEquals("U&\"\\02b0\"", stat.enquoteIdentifier("\u02b0", false));
        this.assertTrue(stat.isSimpleIdentifier("SOME_ID_1"));
        this.assertFalse(stat.isSimpleIdentifier("SOME ID"));
        this.assertFalse(stat.isSimpleIdentifier("FROM"));
        this.assertFalse(stat.isSimpleIdentifier("Test"));
        this.assertFalse(stat.isSimpleIdentifier("test"));
        this.assertFalse(stat.isSimpleIdentifier("TOP"));
        this.assertFalse(stat.isSimpleIdentifier("_"));
        this.assertFalse(stat.isSimpleIdentifier("_1"));
        this.assertFalse(stat.isSimpleIdentifier("\u02b0"));
        conn.close();
        this.deleteDb("statement");
        conn = this.getConnection("statement;DATABASE_TO_LOWER=TRUE");
        Statement stat2 = conn.createStatement();
        this.assertEquals("some_id", stat2.enquoteIdentifier("some_id", false));
        this.assertEquals("\"some id\"", stat2.enquoteIdentifier("some id", false));
        this.assertEquals("\"some_id\"", stat2.enquoteIdentifier("some_id", true));
        this.assertEquals("\"from\"", stat2.enquoteIdentifier("from", false));
        this.assertEquals("\"Test\"", stat2.enquoteIdentifier("Test", false));
        this.assertEquals("\"TEST\"", stat2.enquoteIdentifier("TEST", false));
        this.assertEquals("\"top\"", stat2.enquoteIdentifier("top", false));
        this.assertTrue(stat2.isSimpleIdentifier("some_id"));
        this.assertFalse(stat2.isSimpleIdentifier("some id"));
        this.assertFalse(stat2.isSimpleIdentifier("from"));
        this.assertFalse(stat2.isSimpleIdentifier("Test"));
        this.assertFalse(stat2.isSimpleIdentifier("TEST"));
        this.assertFalse(stat2.isSimpleIdentifier("top"));
        conn.close();
        this.deleteDb("statement");
        conn = this.getConnection("statement;DATABASE_TO_UPPER=FALSE");
        Statement stat3 = conn.createStatement();
        this.assertEquals("SOME_ID", stat3.enquoteIdentifier("SOME_ID", false));
        this.assertEquals("some_id", stat3.enquoteIdentifier("some_id", false));
        this.assertEquals("\"SOME ID\"", stat3.enquoteIdentifier("SOME ID", false));
        this.assertEquals("\"some id\"", stat3.enquoteIdentifier("some id", false));
        this.assertEquals("\"SOME_ID\"", stat3.enquoteIdentifier("SOME_ID", true));
        this.assertEquals("\"some_id\"", stat3.enquoteIdentifier("some_id", true));
        this.assertEquals("\"FROM\"", stat3.enquoteIdentifier("FROM", false));
        this.assertEquals("\"from\"", stat3.enquoteIdentifier("from", false));
        this.assertEquals("Test", stat3.enquoteIdentifier("Test", false));
        this.assertEquals("\"TOP\"", stat3.enquoteIdentifier("TOP", false));
        this.assertEquals("\"top\"", stat3.enquoteIdentifier("top", false));
        this.assertTrue(stat3.isSimpleIdentifier("SOME_ID"));
        this.assertTrue(stat3.isSimpleIdentifier("some_id"));
        this.assertFalse(stat3.isSimpleIdentifier("SOME ID"));
        this.assertFalse(stat3.isSimpleIdentifier("some id"));
        this.assertFalse(stat3.isSimpleIdentifier("FROM"));
        this.assertFalse(stat3.isSimpleIdentifier("from"));
        this.assertTrue(stat3.isSimpleIdentifier("Test"));
        this.assertFalse(stat3.isSimpleIdentifier("TOP"));
        this.assertFalse(stat3.isSimpleIdentifier("top"));
        this.assertThrows(NullPointerException.class, () -> stat3.isSimpleIdentifier(null));
        conn.close();
    }
}

