/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.h2.api.H2Type;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestUpdatableResultSet
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testDetectUpdatable();
        this.testUpdateLob();
        this.testScroll();
        this.testUpdateDeleteInsert();
        this.testUpdateDataType();
        this.testUpdateResetRead();
        this.testUpdateObject();
        this.deleteDb("updatableResultSet");
    }

    private void testDetectUpdatable() throws SQLException {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement(1004, 1008);
        stat.execute("create table test(id int primary key, name varchar)");
        ResultSet rs = stat.executeQuery("select * from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select name from test");
        this.assertEquals(1007, rs.getConcurrency());
        stat.execute("drop table test");
        rs = stat.executeQuery("SELECT");
        this.assertEquals(1007, rs.getConcurrency());
        stat.execute("create table test(a int, b int, name varchar, primary key(a, b))");
        rs = stat.executeQuery("select * from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select a, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select b, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select b, name, a from test");
        this.assertEquals(1008, rs.getConcurrency());
        stat.execute("drop table test");
        stat.execute("create table test(a int, b int, name varchar)");
        stat.execute("create unique index on test(b, a)");
        rs = stat.executeQuery("select * from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select a, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select b, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select b, name, a from test");
        this.assertEquals(1008, rs.getConcurrency());
        stat.execute("drop table test");
        stat.execute("create table test(a int, b int, c int unique, name varchar, primary key(a, b))");
        rs = stat.executeQuery("select * from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select a, name, c from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select b, a, name, c from test");
        this.assertEquals(1008, rs.getConcurrency());
        stat.execute("drop table test");
        stat.execute("create table test(id int primary key, a int, b int, i int, j int, k int, name varchar)");
        stat.execute("create unique index on test(b, a)");
        stat.execute("create unique index on test(i, j)");
        stat.execute("create unique index on test(a, j)");
        rs = stat.executeQuery("select * from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select a, name, b from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select a, name, b from test");
        this.assertEquals(1008, rs.getConcurrency());
        rs = stat.executeQuery("select i, b, k, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select a, i, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select b, i, k, name from test");
        this.assertEquals(1007, rs.getConcurrency());
        rs = stat.executeQuery("select a, k, j, name from test");
        this.assertEquals(1008, rs.getConcurrency());
        stat.execute("drop table test");
        conn.close();
    }

    private void testUpdateLob() throws SQLException {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE object_index (id integer primary key, object other, number integer)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO object_index (id,object)  VALUES (1,?)");
        prep.setObject(1, (Object)"hello", 2000);
        prep.execute();
        ResultSet rs = stat.executeQuery("SELECT object,id,number FROM object_index WHERE id =1");
        rs.next();
        this.assertEquals("hello", rs.getObject(1).toString());
        stat = conn.createStatement(1003, 1008);
        rs = stat.executeQuery("SELECT object,id,number FROM object_index WHERE id =1");
        rs.next();
        this.assertEquals("hello", rs.getObject(1).toString());
        rs.updateInt(2, 1);
        rs.updateRow();
        rs.close();
        stat = conn.createStatement();
        rs = stat.executeQuery("SELECT object,id,number FROM object_index WHERE id =1");
        rs.next();
        this.assertEquals("hello", rs.getObject(1).toString());
        conn.close();
    }

    private void testUpdateResetRead() throws SQLException {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement(1004, 1008);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        rs.updateInt(1, 10);
        rs.updateRow();
        rs.next();
        rs.updateString(2, "Welt");
        rs.cancelRowUpdates();
        rs.updateString(2, "Welt");
        rs.updateRow();
        rs.beforeFirst();
        rs.next();
        this.assertEquals(10, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        rs.next();
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("Welt", rs.getString(2));
        this.assertFalse(rs.isClosed());
        rs.close();
        this.assertTrue(rs.isClosed());
        conn.close();
    }

    private void testScroll() throws SQLException {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement(1004, 1007);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'World'), (3, 'Test')");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertTrue(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        this.assertEquals(0, rs.getRow());
        rs.next();
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(1, rs.getRow());
        rs.next();
        this.assertThrows(90140, rs).insertRow();
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals(2, rs.getRow());
        rs.next();
        this.assertFalse(rs.isBeforeFirst());
        this.assertFalse(rs.isAfterLast());
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(3, rs.getRow());
        this.assertFalse(rs.next());
        this.assertFalse(rs.isBeforeFirst());
        this.assertTrue(rs.isAfterLast());
        this.assertEquals(0, rs.getRow());
        this.assertTrue(rs.first());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals(1, rs.getRow());
        this.assertTrue(rs.last());
        this.assertEquals(3, rs.getInt(1));
        this.assertEquals(3, rs.getRow());
        this.assertTrue(rs.relative(0));
        this.assertEquals(3, rs.getRow());
        this.assertTrue(rs.relative(-1));
        this.assertEquals(2, rs.getRow());
        this.assertTrue(rs.relative(1));
        this.assertEquals(3, rs.getRow());
        this.assertFalse(rs.relative(100));
        this.assertTrue(rs.isAfterLast());
        this.assertFalse(rs.absolute(0));
        this.assertEquals(0, rs.getRow());
        this.assertTrue(rs.absolute(1));
        this.assertEquals(1, rs.getRow());
        this.assertTrue(rs.absolute(2));
        this.assertEquals(2, rs.getRow());
        this.assertTrue(rs.absolute(3));
        this.assertEquals(3, rs.getRow());
        this.assertFalse(rs.absolute(4));
        this.assertEquals(0, rs.getRow());
        this.assertFalse(rs.absolute(0));
        this.assertTrue(rs.absolute(3));
        this.assertEquals(3, rs.getRow());
        if (!this.config.lazy) {
            this.assertTrue(rs.absolute(-1));
            this.assertEquals(3, rs.getRow());
            this.assertTrue(rs.absolute(-2));
            this.assertEquals(2, rs.getRow());
        }
        this.assertFalse(rs.absolute(4));
        this.assertTrue(rs.isAfterLast());
        this.assertFalse(rs.absolute(5));
        this.assertTrue(rs.isAfterLast());
        this.assertTrue(rs.previous());
        this.assertEquals(3, rs.getRow());
        this.assertTrue(rs.previous());
        this.assertEquals(2, rs.getRow());
        conn.close();
    }

    private void testUpdateDataType() throws Exception {
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement(1003, 1008);
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255), DEC DECIMAL(10,2), BOO BIT, BYE TINYINT, BIN VARBINARY(100), D DATE, T TIME, TS TIMESTAMP(9), TSTZ TIMESTAMP(9) WITH TIME ZONE, DB DOUBLE, R REAL, L BIGINT, O_I INT, SH SMALLINT, CL CLOB, BL BLOB)");
        int clobIndex = 16;
        int blobIndex = 17;
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST");
        ResultSetMetaData meta = rs.getMetaData();
        int c = 0;
        this.assertEquals("java.lang.Integer", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.String", meta.getColumnClassName(++c));
        this.assertEquals("java.math.BigDecimal", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Boolean", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Integer", meta.getColumnClassName(++c));
        this.assertEquals("[B", meta.getColumnClassName(++c));
        this.assertEquals("java.sql.Date", meta.getColumnClassName(++c));
        this.assertEquals("java.sql.Time", meta.getColumnClassName(++c));
        this.assertEquals("java.sql.Timestamp", meta.getColumnClassName(++c));
        this.assertEquals("java.time.OffsetDateTime", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Double", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Float", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Long", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Integer", meta.getColumnClassName(++c));
        this.assertEquals("java.lang.Integer", meta.getColumnClassName(++c));
        this.assertEquals("java.sql.Clob", meta.getColumnClassName(++c));
        this.assertEquals("java.sql.Blob", meta.getColumnClassName(++c));
        rs.moveToInsertRow();
        rs.updateInt(1, 0);
        rs.updateNull(2);
        rs.updateNull("DEC");
        this.assertThrows(2000, rs).cancelRowUpdates();
        rs.insertRow();
        rs.moveToInsertRow();
        c = 0;
        rs.updateInt(++c, 1);
        rs.updateString(++c, null);
        rs.updateBigDecimal(++c, null);
        rs.updateBoolean(++c, false);
        rs.updateByte(++c, (byte)0);
        rs.updateBytes(++c, null);
        rs.updateDate(++c, null);
        rs.updateTime(++c, null);
        rs.updateTimestamp(++c, null);
        rs.updateObject(++c, null);
        rs.updateDouble(++c, 0.0);
        rs.updateFloat(++c, 0.0f);
        rs.updateLong(++c, 0L);
        rs.updateObject(++c, null);
        rs.updateShort(++c, (short)0);
        rs.updateCharacterStream(++c, (Reader)new StringReader("test"), 0);
        byte[] byArray = new byte[2];
        byArray[0] = -1;
        rs.updateBinaryStream(++c, (InputStream)new ByteArrayInputStream(byArray), 0);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 2);
        rs.updateString("NAME", "+");
        rs.updateBigDecimal("DEC", new BigDecimal("1.2"));
        rs.updateBoolean("BOO", true);
        rs.updateByte("BYE", (byte)-1);
        byte[] byArray2 = new byte[2];
        byArray2[1] = -1;
        rs.updateBytes("BIN", byArray2);
        rs.updateDate("D", Date.valueOf("2005-09-21"));
        rs.updateTime("T", Time.valueOf("21:46:28"));
        rs.updateTimestamp("TS", Timestamp.valueOf("2005-09-21 21:47:09.567890123"));
        rs.updateObject("TSTZ", (Object)OffsetDateTime.of(LocalDate.of(2005, 9, 21), LocalTime.ofNanoOfDay(81189123456789L), ZoneOffset.ofHours(1)));
        rs.updateDouble("DB", 1.725);
        rs.updateFloat("R", 2.5f);
        rs.updateLong("L", Long.MAX_VALUE);
        rs.updateObject("O_I", (Object)10);
        rs.updateShort("SH", (short)Short.MIN_VALUE);
        rs.updateCharacterStream("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"), 0);
        rs.updateBinaryStream("BL", (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}), 0);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 3);
        rs.updateCharacterStream("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBinaryStream("BL", (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}));
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 4);
        rs.updateCharacterStream(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBinaryStream(17, (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}));
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 5);
        rs.updateClob("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBlob("BL", (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}));
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 6);
        rs.updateClob(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBlob(17, (InputStream)new ByteArrayInputStream(new byte[]{-85, 18}));
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 7);
        rs.updateNClob("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        Blob b = conn.createBlob();
        OutputStream out = b.setBinaryStream(1L);
        out.write(new byte[]{-85, 18});
        out.close();
        rs.updateBlob("BL", b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 8);
        rs.updateNClob(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBlob(17, b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 9);
        rs.updateNClob("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"), -1L);
        rs.updateBlob("BL", b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 10);
        rs.updateNClob(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"), -1L);
        rs.updateBlob(17, b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 11);
        rs.updateNCharacterStream("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"), -1L);
        rs.updateBlob("BL", b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 12);
        rs.updateNCharacterStream(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"), -1L);
        rs.updateBlob(17, b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 13);
        rs.updateNCharacterStream("CL", (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBlob("BL", b);
        rs.insertRow();
        rs.moveToInsertRow();
        rs.updateInt("ID", 14);
        rs.updateNCharacterStream(16, (Reader)new StringReader("\u00ef\u00f6\u00fc"));
        rs.updateBlob(17, b);
        rs.insertRow();
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID NULLS FIRST");
        rs.next();
        c = 0;
        this.assertTrue(rs.getInt(++c) == 0);
        this.assertTrue(rs.getString(++c) == null && rs.wasNull());
        this.assertTrue(rs.getBigDecimal(++c) == null && rs.wasNull());
        this.assertTrue(!rs.getBoolean(++c) && rs.wasNull());
        this.assertTrue(rs.getByte(++c) == 0 && rs.wasNull());
        this.assertTrue(rs.getBytes(++c) == null && rs.wasNull());
        this.assertTrue(rs.getDate(++c) == null && rs.wasNull());
        this.assertTrue(rs.getTime(++c) == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp(++c) == null && rs.wasNull());
        this.assertTrue(rs.getDouble(++c) == 0.0 && rs.wasNull());
        this.assertTrue((double)rs.getFloat(++c) == 0.0 && rs.wasNull());
        this.assertTrue(rs.getLong(++c) == 0L && rs.wasNull());
        this.assertTrue(rs.getObject(++c) == null && rs.wasNull());
        this.assertTrue(rs.getShort(++c) == 0 && rs.wasNull());
        this.assertTrue(rs.getCharacterStream(++c) == null && rs.wasNull());
        this.assertTrue(rs.getBinaryStream(++c) == null && rs.wasNull());
        rs.next();
        c = 0;
        this.assertTrue(rs.getInt(++c) == 1);
        this.assertTrue(rs.getString(++c) == null && rs.wasNull());
        this.assertTrue(rs.getBigDecimal(++c) == null && rs.wasNull());
        this.assertTrue(!rs.getBoolean(++c) && !rs.wasNull());
        this.assertTrue(rs.getByte(++c) == 0 && !rs.wasNull());
        this.assertTrue(rs.getBytes(++c) == null && rs.wasNull());
        this.assertTrue(rs.getDate(++c) == null && rs.wasNull());
        this.assertTrue(rs.getTime(++c) == null && rs.wasNull());
        this.assertTrue(rs.getTimestamp(++c) == null && rs.wasNull());
        this.assertTrue(rs.getObject(++c) == null && rs.wasNull());
        this.assertTrue(rs.getDouble(++c) == 0.0 && !rs.wasNull());
        this.assertTrue((double)rs.getFloat(++c) == 0.0 && !rs.wasNull());
        this.assertTrue(rs.getLong(++c) == 0L && !rs.wasNull());
        this.assertTrue(rs.getObject(++c) == null && rs.wasNull());
        this.assertTrue(rs.getShort(++c) == 0 && !rs.wasNull());
        this.assertEquals("test", rs.getString(++c));
        byte[] byArray3 = new byte[2];
        byArray3[0] = -1;
        this.assertEquals(byArray3, rs.getBytes(++c));
        rs.next();
        c = 0;
        this.assertTrue(rs.getInt(++c) == 2);
        this.assertEquals("+", rs.getString(++c));
        this.assertEquals("1.20", rs.getBigDecimal(++c).toString());
        this.assertTrue(rs.getBoolean(++c));
        this.assertTrue((rs.getByte(++c) & 0xFF) == 255);
        byte[] byArray4 = new byte[2];
        byArray4[1] = -1;
        this.assertEquals(byArray4, rs.getBytes(++c));
        this.assertEquals("2005-09-21", rs.getDate(++c).toString());
        this.assertEquals("21:46:28", rs.getTime(++c).toString());
        this.assertEquals("2005-09-21 21:47:09.567890123", rs.getTimestamp(++c).toString());
        this.assertEquals("2005-09-21T22:33:09.123456789+01:00", rs.getObject(++c).toString());
        this.assertTrue(rs.getDouble(++c) == 1.725);
        this.assertTrue(rs.getFloat(++c) == 2.5f);
        this.assertTrue(rs.getLong(++c) == Long.MAX_VALUE);
        this.assertEquals(10, (int)((Integer)rs.getObject(++c)));
        this.assertTrue(rs.getShort(++c) == Short.MIN_VALUE);
        this.assertEquals("\u00ef\u00f6\u00fc", rs.getString(++c));
        this.assertEquals(new byte[]{-85, 18}, rs.getBytes(++c));
        c = 1;
        rs.updateString(++c, "-");
        rs.updateBigDecimal(++c, new BigDecimal("1.30"));
        rs.updateBoolean(++c, false);
        rs.updateByte(++c, (byte)85);
        rs.updateBytes(++c, new byte[]{1, -2});
        rs.updateDate(++c, Date.valueOf("2005-09-22"));
        rs.updateTime(++c, Time.valueOf("21:46:29"));
        rs.updateTimestamp(++c, Timestamp.valueOf("2005-09-21 21:47:10.111222333"));
        rs.updateObject(++c, (Object)OffsetDateTime.of(LocalDate.of(2005, 9, 22), LocalTime.ofNanoOfDay(10111222333L), ZoneOffset.ofHours(2)));
        rs.updateDouble(++c, 2.25);
        rs.updateFloat(++c, 3.5f);
        rs.updateLong(++c, 0x7FFFFFFFFFFFFFFEL);
        rs.updateInt(++c, 11);
        rs.updateShort(++c, (short)-1000);
        rs.updateString(++c, "ABCD");
        rs.updateBytes(++c, new byte[]{1, 2});
        rs.updateRow();
        int i = 3;
        while (i <= 14) {
            rs.next();
            this.assertEquals(i, rs.getInt(1));
            this.assertEquals("\u00ef\u00f6\u00fc", rs.getString(16));
            this.assertEquals(new byte[]{-85, 18}, rs.getBytes(17));
            ++i;
        }
        this.assertFalse(rs.next());
        rs = stat.executeQuery("SELECT * FROM TEST WHERE ID = 2");
        rs.next();
        c = 0;
        this.assertTrue(rs.getInt(++c) == 2);
        this.assertEquals("-", rs.getString(++c));
        this.assertEquals("1.30", rs.getBigDecimal(++c).toString());
        this.assertFalse(rs.getBoolean(++c));
        this.assertTrue((rs.getByte(++c) & 0xFF) == 85);
        this.assertEquals(new byte[]{1, -2}, rs.getBytes(++c));
        this.assertEquals("2005-09-22", rs.getDate(++c).toString());
        this.assertEquals("21:46:29", rs.getTime(++c).toString());
        this.assertEquals("2005-09-21 21:47:10.111222333", rs.getTimestamp(++c).toString());
        this.assertEquals("2005-09-22T00:00:10.111222333+02:00", rs.getObject(++c).toString());
        this.assertTrue(rs.getDouble(++c) == 2.25);
        this.assertTrue(rs.getFloat(++c) == 3.5f);
        this.assertTrue(rs.getLong(++c) == 0x7FFFFFFFFFFFFFFEL);
        this.assertEquals(11, (int)((Integer)rs.getObject(++c)));
        this.assertTrue(rs.getShort(++c) == -1000);
        this.assertEquals("ABCD", rs.getString(++c));
        this.assertEquals(new byte[]{1, 2}, rs.getBytes(++c));
        this.assertFalse(rs.next());
        stat.execute("DROP TABLE TEST");
        conn.close();
    }

    private void testUpdateDeleteInsert() throws SQLException {
        int id;
        this.deleteDb("updatableResultSet");
        Connection c1 = this.getConnection("updatableResultSet");
        Connection c2 = this.getConnection("updatableResultSet");
        Statement stat = c1.createStatement(1003, 1008);
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        int max = 8;
        int i = 0;
        while (i < max) {
            stat.execute("INSERT INTO TEST VALUES(" + i + ", 'Hello" + i + "')");
            ++i;
        }
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        rs.moveToInsertRow();
        rs.updateInt(1, 100);
        rs.moveToCurrentRow();
        this.assertEquals(0, rs.getInt(1));
        rs = stat.executeQuery("SELECT * FROM TEST");
        int j = max;
        while (rs.next()) {
            id = rs.getInt(1);
            if (id % 2 == 0) {
                Statement s2 = c2.createStatement();
                s2.execute("UPDATE TEST SET NAME = NAME || '+' WHERE ID = " + rs.getInt(1));
                if (id % 4 == 0) {
                    rs.refreshRow();
                }
                rs.updateString(2, "Updated " + rs.getString(2));
                rs.updateRow();
            } else {
                rs.deleteRow();
            }
            this.assertFalse(rs.rowUpdated());
            this.assertFalse(rs.rowInserted());
            this.assertFalse(rs.rowDeleted());
            rs.moveToInsertRow();
            rs.updateString(2, "Inserted " + j);
            rs.updateInt(1, j);
            j += 2;
            rs.insertRow();
            this.assertFalse(rs.rowUpdated());
            this.assertFalse(rs.rowInserted());
            this.assertFalse(rs.rowDeleted());
        }
        rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            id = rs.getInt(1);
            String name = rs.getString(2);
            this.assertEquals(0, id % 2);
            if (id >= max) {
                this.assertEquals("Inserted " + id, rs.getString(2));
            } else if (id % 4 == 0) {
                this.assertEquals("Updated Hello" + id + "+", rs.getString(2));
            } else {
                this.assertEquals("Updated Hello" + id, rs.getString(2));
            }
            this.trace("id=" + id + " name=" + name);
        }
        c2.close();
        c1.close();
        Connection conn = this.getConnection("updatableResultSet");
        int i2 = 0;
        while (i2 < 5) {
            this.testScrollable(conn, i2);
            ++i2;
        }
        conn.close();
    }

    private void testScrollable(Connection conn, int rows) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("DELETE FROM TEST");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int i = 0;
        while (i < rows) {
            prep.setInt(1, i);
            prep.setString(2, "Data " + i);
            prep.execute();
            ++i;
        }
        Statement regular = conn.createStatement();
        this.testScrollResultSet(regular, 1003, rows);
        Statement scroll = conn.createStatement(1004, 1007);
        this.testScrollResultSet(scroll, 1004, rows);
    }

    private void testScrollResultSet(Statement stat, int type, int rows) throws SQLException {
        block15: {
            ResultSet rs;
            boolean error;
            block14: {
                block13: {
                    block12: {
                        error = false;
                        if (type == 1003) {
                            error = true;
                        }
                        rs = stat.executeQuery("SELECT * FROM TEST");
                        this.assertEquals(type, rs.getType());
                        this.assertState(rs, rows > 0, false, false, false);
                        int i = 0;
                        while (i < rows) {
                            rs.next();
                            this.assertState(rs, rows == 0, i == 0, i == rows - 1, rows == 0 || i == rows);
                            ++i;
                        }
                        try {
                            rs.beforeFirst();
                            this.assertState(rs, rows > 0, false, false, false);
                        }
                        catch (SQLException e) {
                            if (error) break block12;
                            throw e;
                        }
                    }
                    try {
                        rs.afterLast();
                        this.assertState(rs, false, false, false, rows > 0);
                    }
                    catch (SQLException e) {
                        if (error) break block13;
                        throw e;
                    }
                }
                try {
                    boolean valid = rs.first();
                    this.assertEquals(rows > 0, valid);
                    if (valid) {
                        this.assertState(rs, false, true, rows == 1, rows == 0);
                    }
                }
                catch (SQLException e) {
                    if (error) break block14;
                    throw e;
                }
            }
            try {
                boolean valid = rs.last();
                this.assertEquals(rows > 0, valid);
                if (valid) {
                    this.assertState(rs, false, rows == 1, true, rows == 0);
                }
            }
            catch (SQLException e) {
                if (error) break block15;
                throw e;
            }
        }
    }

    private void testUpdateObject() throws SQLException {
        int i;
        ResultSet rs;
        this.deleteDb("updatableResultSet");
        Connection conn = this.getConnection("updatableResultSet");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, V INT)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES (?1, ?1)");
        int i2 = 1;
        while (i2 <= 12) {
            prep.setInt(1, i2);
            prep.executeUpdate();
            ++i2;
        }
        prep = conn.prepareStatement("TABLE TEST ORDER BY ID", 1003, 1008);
        Throwable throwable = null;
        Object var5_9 = null;
        try {
            rs = prep.executeQuery();
            try {
                i = 1;
                while (i <= 12) {
                    rs.next();
                    this.assertEquals(i, rs.getInt(1));
                    this.assertEquals(i, rs.getInt(2));
                    TestUpdatableResultSet.testUpdateObjectUpdateRow(rs, i, i * 10);
                    rs.updateRow();
                    ++i;
                }
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_9 = null;
        try {
            rs = prep.executeQuery();
            try {
                i = 1;
                while (i <= 12) {
                    this.assertTrue(rs.next());
                    this.assertEquals(i, rs.getInt(1));
                    this.assertEquals(i * 10, rs.getInt(2));
                    TestUpdatableResultSet.testUpdateObjectUpdateRow(rs, i, null);
                    rs.updateRow();
                    ++i;
                }
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_9 = null;
        try {
            rs = prep.executeQuery();
            try {
                i = 1;
                while (i <= 12) {
                    this.assertTrue(rs.next());
                    this.assertEquals(i, rs.getInt(1));
                    this.assertNull(rs.getObject(2));
                    ++i;
                }
                this.assertFalse(rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        conn.close();
    }

    private static void testUpdateObjectUpdateRow(ResultSet rs, int method, Object value) throws SQLException {
        switch (method) {
            case 1: {
                rs.updateObject(2, value);
                break;
            }
            case 2: {
                rs.updateObject("V", value);
                break;
            }
            case 3: {
                rs.updateObject(2, value, 0);
                break;
            }
            case 4: {
                rs.updateObject(2, value, (SQLType)JDBCType.INTEGER);
                break;
            }
            case 5: {
                rs.updateObject(2, value, (SQLType)H2Type.INTEGER);
                break;
            }
            case 6: {
                rs.updateObject("V", value, 0);
                break;
            }
            case 7: {
                rs.updateObject("V", value, (SQLType)JDBCType.INTEGER);
                break;
            }
            case 8: {
                rs.updateObject("V", value, (SQLType)H2Type.INTEGER);
                break;
            }
            case 9: {
                rs.updateObject(2, value, (SQLType)JDBCType.INTEGER, 0);
                break;
            }
            case 10: {
                rs.updateObject(2, value, (SQLType)H2Type.INTEGER, 0);
                break;
            }
            case 11: {
                rs.updateObject("V", value, (SQLType)JDBCType.INTEGER, 0);
                break;
            }
            case 12: {
                rs.updateObject("V", value, (SQLType)H2Type.INTEGER, 0);
            }
        }
    }

    private void assertState(ResultSet rs, boolean beforeFirst, boolean first, boolean last, boolean afterLast) throws SQLException {
        this.assertEquals(beforeFirst, rs.isBeforeFirst());
        this.assertEquals(first, rs.isFirst());
        this.assertEquals(last, rs.isLast());
        this.assertEquals(afterLast, rs.isAfterLast());
    }
}

