/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbcx;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.h2.util.MathUtils;

public class SimpleXid
implements Xid {
    private static AtomicInteger next = new AtomicInteger();
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;

    private SimpleXid(int formatId, byte[] branchQualifier, byte[] globalTransactionId) {
        this.formatId = formatId;
        this.branchQualifier = branchQualifier;
        this.globalTransactionId = globalTransactionId;
    }

    public static SimpleXid createRandom() {
        int formatId = next.getAndIncrement();
        byte[] bq = new byte[64];
        MathUtils.randomBytes(bq);
        byte[] gt = new byte[64];
        MathUtils.randomBytes(gt);
        return new SimpleXid(formatId, bq, gt);
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public int hashCode() {
        return this.formatId;
    }

    public boolean equals(Object other) {
        Xid xid;
        return other instanceof Xid && (xid = (Xid)other).getFormatId() == this.formatId && Arrays.equals(this.branchQualifier, xid.getBranchQualifier()) && Arrays.equals(this.globalTransactionId, xid.getGlobalTransactionId());
    }

    public String toString() {
        return "xid:" + this.formatId;
    }
}

