/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbcx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestConnectionPool
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("connectionPool");
        this.testShutdown();
        this.testWrongUrl();
        this.testTimeout();
        this.testUncommittedTransaction();
        this.testPerformance();
        this.testKeepOpen();
        this.testConnect();
        this.testThreads();
        this.testUnwrap();
        this.deleteDb("connectionPool");
        this.deleteDb("connectionPool2");
    }

    private void testShutdown() throws SQLException {
        String url = this.getURL("connectionPool2", true);
        String user = this.getUser();
        String password = this.getPassword();
        JdbcConnectionPool cp = JdbcConnectionPool.create(url, user, password);
        StringWriter w = new StringWriter();
        cp.setLogWriter(new PrintWriter(w));
        Connection conn1 = cp.getConnection();
        Connection conn2 = cp.getConnection();
        conn1.close();
        conn2.createStatement().execute("shutdown immediately");
        cp.dispose();
        this.assertTrue(w.toString().length() == 0);
        cp.dispose();
    }

    private void testWrongUrl() {
        JdbcConnectionPool cp = JdbcConnectionPool.create("jdbc:wrong:url", "", "");
        try {
            cp.getConnection();
        }
        catch (SQLException e) {
            this.assertEquals(90046, e.getErrorCode());
        }
        cp.dispose();
    }

    private void testTimeout() throws Exception {
        JdbcConnectionPool man;
        block6: {
            String url = this.getURL("connectionPool", true);
            String user = this.getUser();
            String password = this.getPassword();
            man = JdbcConnectionPool.create(url, user, password);
            man.setLoginTimeout(1);
            this.assertThrows(IllegalArgumentException.class, () -> man.setMaxConnections(-1));
            man.setMaxConnections(2);
            Connection conn = man.getConnection();
            Task t = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        man.setMaxConnections(1);
                        man.setMaxConnections(2);
                    }
                }
            };
            t.execute();
            long time = System.nanoTime();
            Connection conn2 = null;
            try {
                try {
                    conn2 = man.getConnection();
                    man.getConnection();
                    this.fail();
                }
                catch (SQLException e) {
                    if (conn2 != null) {
                        conn2.close();
                    }
                    this.assertContains(e.toString().toLowerCase(), "timeout");
                    time = System.nanoTime() - time;
                    this.assertTrue("timeout after " + TimeUnit.NANOSECONDS.toMillis(time) + " ms", time > TimeUnit.SECONDS.toNanos(1L));
                    conn.close();
                    t.get();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                conn.close();
                t.get();
                throw throwable;
            }
            conn.close();
            t.get();
        }
        man.dispose();
    }

    private void testUncommittedTransaction() throws SQLException {
        String url = this.getURL("connectionPool", true);
        String user = this.getUser();
        String password = this.getPassword();
        JdbcConnectionPool man = JdbcConnectionPool.create(url, user, password);
        this.assertEquals(30, man.getLoginTimeout());
        man.setLoginTimeout(1);
        this.assertEquals(1, man.getLoginTimeout());
        man.setLoginTimeout(0);
        this.assertEquals(30, man.getLoginTimeout());
        this.assertEquals(10, man.getMaxConnections());
        PrintWriter old = man.getLogWriter();
        PrintWriter pw = new PrintWriter(new StringWriter());
        man.setLogWriter(pw);
        this.assertTrue(pw == man.getLogWriter());
        man.setLogWriter(old);
        Connection conn1 = man.getConnection();
        this.assertTrue(conn1.getAutoCommit());
        conn1.setAutoCommit(false);
        conn1.close();
        this.assertTrue(conn1.isClosed());
        Connection conn2 = man.getConnection();
        this.assertTrue(conn2.getAutoCommit());
        conn2.close();
        man.dispose();
    }

    private void testPerformance() throws SQLException {
        String url = this.getURL("connectionPool", true);
        String user = this.getUser();
        String password = this.getPassword();
        JdbcConnectionPool man = JdbcConnectionPool.create(url, user, password);
        Connection conn = man.getConnection();
        int len = 1000;
        long time = System.nanoTime();
        int i = 0;
        while (i < len) {
            man.getConnection().close();
            ++i;
        }
        man.dispose();
        this.trace((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        time = System.nanoTime();
        i = 0;
        while (i < len) {
            DriverManager.getConnection(url, user, password).close();
            ++i;
        }
        this.trace((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time));
        conn.close();
    }

    private void testKeepOpen() throws Exception {
        JdbcConnectionPool man = this.getConnectionPool(1);
        Connection conn = man.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("create local temporary table test(id int)");
        conn.close();
        conn = man.getConnection();
        stat = conn.createStatement();
        stat.execute("select * from test");
        conn.close();
        man.dispose();
    }

    private void testThreads() throws Exception {
        int len = this.getSize(4, 20);
        JdbcConnectionPool man = this.getConnectionPool(len - 2);
        AtomicBoolean stop = new AtomicBoolean();
        Thread[] threads = new Thread[len];
        int i = 0;
        while (i < len) {
            class TestRunner
            implements Runnable {
                private final /* synthetic */ AtomicBoolean val$stop;
                private final /* synthetic */ JdbcConnectionPool val$man;
                private final /* synthetic */ int val$len;

                TestRunner(AtomicBoolean atomicBoolean, JdbcConnectionPool jdbcConnectionPool, int n) {
                    this.val$stop = atomicBoolean;
                    this.val$man = jdbcConnectionPool;
                    this.val$len = n;
                }

                @Override
                public void run() {
                    try {
                        while (!this.val$stop.get()) {
                            Connection conn = this.val$man.getConnection();
                            if (this.val$man.getActiveConnections() >= this.val$len + 1) {
                                throw new Exception("a: " + this.val$man.getActiveConnections() + " is not smaller than b: " + (this.val$len + 1));
                            }
                            Statement stat = conn.createStatement();
                            stat.execute("SELECT 1 FROM DUAL");
                            conn.close();
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            threads[i] = new Thread(new TestRunner(stop, man, len));
            threads[i].start();
            ++i;
        }
        Thread.sleep(1000L);
        stop.set(true);
        i = 0;
        while (i < len) {
            threads[i].join();
            ++i;
        }
        this.assertEquals(0, man.getActiveConnections());
        man.dispose();
    }

    private JdbcConnectionPool getConnectionPool(int poolSize) {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(this.getURL("connectionPool", true));
        ds.setUser(this.getUser());
        ds.setPassword(this.getPassword());
        JdbcConnectionPool pool = JdbcConnectionPool.create(ds);
        pool.setMaxConnections(poolSize);
        return pool;
    }

    private void testConnect() throws SQLException {
        JdbcConnectionPool pool = this.getConnectionPool(3);
        int i = 0;
        while (i < 100) {
            Connection conn = pool.getConnection();
            conn.close();
            ++i;
        }
        pool.dispose();
        JdbcConnectionPool ds = pool;
        ((DataSource)this.assertThrows(IllegalStateException.class, ds)).getConnection();
        ((DataSource)this.assertThrows(UnsupportedOperationException.class, ds)).getConnection(null, null);
    }

    private void testUnwrap() throws SQLException {
        JdbcConnectionPool pool = JdbcConnectionPool.create(new JdbcDataSource());
        this.assertTrue(pool.isWrapperFor(Object.class));
        this.assertTrue(pool.isWrapperFor(DataSource.class));
        this.assertTrue(pool.isWrapperFor(pool.getClass()));
        this.assertFalse(pool.isWrapperFor(Integer.class));
        this.assertTrue(pool == pool.unwrap(Object.class));
        this.assertTrue(pool == pool.unwrap(DataSource.class));
        this.assertTrue(pool == pool.unwrap(pool.getClass()));
        this.assertThrows(90008, () -> pool.unwrap(Integer.class));
    }
}

