/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbcx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.TraceSystem;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestDataSource
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        if (this.config.traceLevelFile > 0) {
            TraceSystem sys = JdbcDataSourceFactory.getTraceSystem();
            sys.setFileName(this.getBaseDir() + "/test/trace");
            sys.setLevelFile(3);
        }
        this.testDataSourceFactory();
        this.testDataSource();
        this.testUnwrap();
        this.testXAConnection();
        JdbcDataSourceFactory.getTraceSystem().close();
        this.deleteDb("dataSource");
    }

    private void testDataSourceFactory() throws Exception {
        JdbcDataSourceFactory factory = new JdbcDataSourceFactory();
        this.assertTrue(factory.getObjectInstance("test", null, null, null) == null);
        Reference ref = new Reference("java.lang.String");
        this.assertTrue(factory.getObjectInstance(ref, null, null, null) == null);
        ref = new Reference(JdbcDataSource.class.getName());
        ref.add(new StringRefAddr("url", "jdbc:h2:mem:"));
        ref.add(new StringRefAddr("user", "u"));
        ref.add(new StringRefAddr("password", "p"));
        ref.add(new StringRefAddr("loginTimeout", "1"));
        ref.add(new StringRefAddr("description", "test"));
        JdbcDataSource ds = (JdbcDataSource)factory.getObjectInstance(ref, null, null, null);
        this.assertEquals(1, ds.getLoginTimeout());
        this.assertEquals("test", ds.getDescription());
        this.assertEquals("jdbc:h2:mem:", ds.getURL());
        this.assertEquals("u", ds.getUser());
        this.assertEquals("p", ds.getPassword());
        Reference ref2 = ds.getReference();
        this.assertEquals(ref.size(), ref2.size());
        this.assertEquals(ref.get("url").getContent().toString(), ref2.get("url").getContent().toString());
        this.assertEquals(ref.get("user").getContent().toString(), ref2.get("user").getContent().toString());
        this.assertEquals(ref.get("password").getContent().toString(), ref2.get("password").getContent().toString());
        this.assertEquals(ref.get("loginTimeout").getContent().toString(), ref2.get("loginTimeout").getContent().toString());
        this.assertEquals(ref.get("description").getContent().toString(), ref2.get("description").getContent().toString());
        ds.setPasswordChars("abc".toCharArray());
        this.assertEquals("abc", ds.getPassword());
    }

    private void testXAConnection() throws Exception {
        this.testXAConnection(false);
        this.testXAConnection(true);
    }

    private void testXAConnection(boolean userInDataSource) throws Exception {
        this.deleteDb("dataSource");
        JdbcDataSource ds = new JdbcDataSource();
        String url = this.getURL("dataSource", true);
        String user = this.getUser();
        ds.setURL(url);
        if (userInDataSource) {
            ds.setUser(user);
            ds.setPassword(this.getPassword());
        }
        if (userInDataSource) {
            this.assertEquals("ds" + ds.getTraceId() + ": url=" + url + " user=" + user, ds.toString());
        } else {
            this.assertEquals("ds" + ds.getTraceId() + ": url=" + url + " user=", ds.toString());
        }
        XAConnection xaConn = userInDataSource ? ds.getXAConnection() : ds.getXAConnection(user, this.getPassword());
        int traceId = ((JdbcXAConnection)xaConn).getTraceId();
        this.assertTrue(xaConn.toString().startsWith("xads" + traceId + ": conn"));
        xaConn.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
            }
        });
        XAResource res = xaConn.getXAResource();
        this.assertFalse(res.setTransactionTimeout(1));
        this.assertEquals(0, res.getTransactionTimeout());
        this.assertTrue(res.isSameRM(res));
        this.assertFalse(res.isSameRM(null));
        Connection conn = xaConn.getConnection();
        this.assertEquals(user.toUpperCase(), conn.getMetaData().getUserName());
        Xid[] list = res.recover(0x1000000);
        this.assertEquals(0, list.length);
        Statement stat = conn.createStatement();
        stat.execute("SELECT * FROM DUAL");
        conn.close();
        xaConn.close();
    }

    private void testDataSource() throws SQLException {
        this.deleteDb("dataSource");
        JdbcDataSource ds = new JdbcDataSource();
        PrintWriter p = new PrintWriter(new StringWriter());
        ds.setLogWriter(p);
        this.assertTrue(p == ds.getLogWriter());
        ds.setURL(this.getURL("dataSource", true));
        ds.setUser(this.getUser());
        ds.setPassword(this.getPassword());
        Connection conn = ds.getConnection();
        Statement stat = conn.createStatement();
        stat.execute("SELECT * FROM DUAL");
        conn.close();
        conn = ds.getConnection(this.getUser(), this.getPassword());
        stat = conn.createStatement();
        stat.execute("SELECT * FROM DUAL");
        conn.close();
    }

    private void testUnwrap() throws SQLException {
        JdbcDataSource ds = new JdbcDataSource();
        this.assertTrue(ds.isWrapperFor(Object.class));
        this.assertTrue(ds.isWrapperFor(DataSource.class));
        this.assertTrue(ds.isWrapperFor(JdbcDataSource.class));
        this.assertFalse(ds.isWrapperFor(String.class));
        this.assertTrue(ds == ds.unwrap(Object.class));
        this.assertTrue(ds == ds.unwrap(DataSource.class));
        this.assertThrows(90008, () -> ds.unwrap(String.class));
    }
}

