/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.mvcc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMvcc1
extends TestDb {
    private Connection c1;
    private Connection c2;
    private Statement s1;
    private Statement s2;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws SQLException {
        this.testCases();
        this.deleteDb("mvcc1");
    }

    private void testCases() throws SQLException {
        Connection c;
        Statement s;
        this.deleteDb("mvcc1");
        this.c1 = this.getConnection("mvcc1;LOCK_TIMEOUT=10");
        this.s1 = this.c1.createStatement();
        this.c2 = this.getConnection("mvcc1;LOCK_TIMEOUT=10");
        this.s2 = this.c2.createStatement();
        this.c1.setAutoCommit(false);
        this.c2.setAutoCommit(false);
        this.assertThrows(42122, this.s1).execute("create table b(primary key(x))");
        this.s1.execute("create table a(id int as 1 unique)");
        this.s1.execute("drop table a");
        this.s1.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR, PRIMARY KEY(ID))");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.c1.commit();
        this.assertResult("Hello", this.s2, "SELECT NAME FROM TEST WHERE ID=1");
        this.s1.execute("UPDATE TEST SET NAME = 'Hallo' WHERE ID=1");
        this.assertResult("Hello", this.s2, "SELECT NAME FROM TEST WHERE ID=1");
        this.assertResult("Hallo", this.s1, "SELECT NAME FROM TEST WHERE ID=1");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("create table a (id integer generated by default as identity, code varchar(10) not null, primary key(id))");
        this.s1.execute("create table b (name varchar(100) not null, a integer, primary key(name), foreign key(a) references a(id))");
        this.s1.execute("insert into a(code) values('one')");
        this.assertThrows(23506, this.s2).execute("insert into b values('un B', 1)");
        this.c2.commit();
        this.c1.rollback();
        this.s1.execute("drop table a, b");
        this.c2.commit();
        this.s1.execute("create table test(id int primary key)");
        this.s1.execute("insert into test values(1)");
        this.assertThrows(50200, this.s2).execute("drop table test");
        this.c1.rollback();
        this.s2.execute("drop table test");
        this.c2.rollback();
        this.s1.execute("create table test(id int, name varchar)");
        this.s1.execute("insert into test values(1, 'A'), (2, 'B')");
        this.c1.commit();
        this.assertResult("2", this.s1, "select count(*) from test where name<>'C'");
        this.s2.execute("update test set name='B2' where id=2");
        this.assertResult("2", this.s1, "select count(*) from test where name<>'C'");
        this.c2.commit();
        this.s2.execute("drop table test");
        this.c2.rollback();
        this.s1.execute("create table test(id int primary key, name varchar(255))");
        this.s1.execute("insert into test values(1, 'y')");
        this.c1.commit();
        this.s2.execute("select * from test where id = 1 for update");
        this.assertThrows(50200, this.s1).execute("delete from test");
        this.c2.rollback();
        this.s1.execute("drop table test");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("create table test(id int primary key, name varchar(255))");
        this.s2.execute("insert into test values(4, 'Hello')");
        this.c2.rollback();
        this.assertResult("0", this.s1, "select count(*) from test where name = 'Hello'");
        this.assertResult("0", this.s2, "select count(*) from test where name = 'Hello'");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("DROP TABLE TEST");
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Test')");
        this.c1.commit();
        this.assertResult("1", this.s1, "select max(id) from test");
        this.s1.execute("INSERT INTO TEST VALUES(2, 'World')");
        this.c1.rollback();
        this.assertResult("1", this.s1, "select max(id) from test");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("DROP TABLE TEST");
        this.s1.execute("create table test as select * from table(id int=(1, 2))");
        this.s1.execute("update test set id=1 where id=1");
        this.s1.execute("select max(id) from test");
        this.assertResult("2", this.s1, "select max(id) from test");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("DROP TABLE TEST");
        this.s1.execute("CREATE TABLE TEST(ID INT)");
        this.s1.execute("INSERT INTO TEST VALUES(1)");
        this.c1.commit();
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST");
        this.s1.executeUpdate("DELETE FROM TEST");
        PreparedStatement p2 = this.c2.prepareStatement("select count(*) from test");
        ResultSet rs = p2.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST");
        this.assertResult("0", this.s1, "SELECT COUNT(*) FROM TEST");
        this.c1.commit();
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST");
        rs = p2.executeQuery();
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("DROP TABLE TEST");
        this.s1.execute("CREATE TABLE TEST(ID INT)");
        this.s1.execute("INSERT INTO TEST VALUES(1)");
        this.c1.commit();
        this.s1.execute("DELETE FROM TEST");
        this.assertResult("0", this.s1, "SELECT COUNT(*) FROM TEST");
        this.c1.commit();
        this.assertResult("0", this.s1, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("INSERT INTO TEST VALUES(1)");
        this.s1.execute("DELETE FROM TEST");
        this.c1.commit();
        this.assertResult("0", this.s1, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("DROP TABLE TEST");
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello'), (2, 'World')");
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST");
        this.c1.commit();
        this.assertResult("2", this.s2, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("INSERT INTO TEST VALUES(3, '!')");
        this.c1.rollback();
        this.assertResult("2", this.s2, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.s1.execute("DELETE FROM TEST");
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST");
        this.c1.commit();
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST(NAME) VALUES('Ruebezahl')");
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST");
        this.assertResult("1", this.s1, "SELECT COUNT(*) FROM TEST");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST(NAME) VALUES('Ruebezahl')");
        this.s1.execute("INSERT INTO TEST(NAME) VALUES('Ruebezahl')");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.c1.commit();
        this.s1.execute("DELETE FROM TEST WHERE ID=1");
        this.c1.rollback();
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        Random random = new Random(1L);
        this.s1.execute("CREATE TABLE TEST(ID INT GENERATED BY DEFAULT AS IDENTITY, NAME VARCHAR)");
        int i = 0;
        while (i < 1000) {
            if (random.nextBoolean()) {
                s = this.s1;
                c = this.c1;
            } else {
                s = this.s2;
                c = this.c2;
            }
            switch (random.nextInt(5)) {
                case 0: {
                    s.execute("INSERT INTO TEST(NAME) VALUES('Hello')");
                    break;
                }
                case 1: {
                    s.execute("UPDATE TEST SET NAME=" + i + " WHERE ID=" + random.nextInt(i));
                    break;
                }
                case 2: {
                    s.execute("DELETE FROM TEST WHERE ID=" + random.nextInt(i));
                    break;
                }
                case 3: {
                    c.commit();
                    break;
                }
                case 4: {
                    c.rollback();
                }
            }
            this.s1.execute("SELECT * FROM TEST ORDER BY ID");
            this.s2.execute("SELECT * FROM TEST ORDER BY ID");
            ++i;
        }
        this.c2.rollback();
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        random = new Random(1L);
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        i = 0;
        while (i < 1000) {
            if (random.nextBoolean()) {
                s = this.s1;
                c = this.c1;
            } else {
                s = this.s2;
                c = this.c2;
            }
            switch (random.nextInt(5)) {
                case 0: {
                    s.execute("INSERT INTO TEST VALUES(" + i + ", 'Hello')");
                    break;
                }
                case 1: {
                    try {
                        s.execute("UPDATE TEST SET NAME=" + i + " WHERE ID=" + random.nextInt(i));
                    }
                    catch (SQLException e) {
                        this.assertEquals(90131, e.getErrorCode());
                    }
                    break;
                }
                case 2: {
                    s.execute("DELETE FROM TEST WHERE ID=" + random.nextInt(i));
                    break;
                }
                case 3: {
                    c.commit();
                    break;
                }
                case 4: {
                    c.rollback();
                }
            }
            this.s1.execute("SELECT * FROM TEST ORDER BY ID");
            this.s2.execute("SELECT * FROM TEST ORDER BY ID");
            ++i;
        }
        this.c2.rollback();
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST WHERE NAME!='X'");
        this.assertResult("1", this.s1, "SELECT COUNT(*) FROM TEST WHERE NAME!='X'");
        this.c1.commit();
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST WHERE NAME!='X'");
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST WHERE NAME!='X'");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.assertResult("0", this.s2, "SELECT COUNT(*) FROM TEST WHERE ID<100");
        this.assertResult("1", this.s1, "SELECT COUNT(*) FROM TEST WHERE ID<100");
        this.c1.commit();
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST WHERE ID<100");
        this.assertResult("1", this.s2, "SELECT COUNT(*) FROM TEST WHERE ID<100");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR, PRIMARY KEY(ID, NAME))");
        this.s1.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        this.c1.commit();
        this.assertResult("Hello", this.s2, "SELECT NAME FROM TEST WHERE ID=1");
        this.s1.execute("UPDATE TEST SET NAME = 'Hallo' WHERE ID=1");
        this.assertResult("Hello", this.s2, "SELECT NAME FROM TEST WHERE ID=1");
        this.assertResult("Hallo", this.s1, "SELECT NAME FROM TEST WHERE ID=1");
        this.s1.execute("DROP TABLE TEST");
        this.c1.commit();
        this.c2.commit();
        this.s1.execute("create table test(id int primary key, name varchar(255))");
        this.s1.execute("insert into test values(1, 'Hello'), (2, 'World')");
        this.c1.commit();
        this.assertThrows(23505, this.s1).execute("update test set id=2 where id=1");
        rs = this.s1.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        rs = this.s2.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("World", rs.getString(2));
        this.assertFalse(rs.next());
        this.s1.execute("drop table test");
        this.c1.commit();
        this.c2.commit();
        this.c1.close();
        this.c2.close();
    }
}

