/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.mvcc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMvcc3
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.testFailedUpdate();
        this.testConcurrentUpdate();
        this.testInsertUpdateRollback();
        this.testCreateTableAsSelect();
        this.testDisableAutoCommit();
        this.testRollback();
        this.deleteDb("mvcc3");
    }

    private void testFailedUpdate() throws SQLException {
        this.deleteDb("mvcc3");
        Connection conn = this.getConnection("mvcc3");
        conn.setAutoCommit(false);
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, a int unique, b int)");
        stat.execute("insert into test values(1, 1, 1)");
        stat.execute("insert into test values(2, 2, 2)");
        this.assertThrows(23505, stat).execute("update test set a = 1 where id = 2");
        ResultSet rs = stat.executeQuery("select * from test where id = 2");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from test where a = 2");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from test where b = 2");
        this.assertTrue(rs.next());
        conn.close();
    }

    private void testConcurrentUpdate() throws SQLException {
        this.deleteDb("mvcc3");
        Connection c1 = this.getConnection("mvcc3");
        c1.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        Connection c2 = this.getConnection("mvcc3");
        c2.setAutoCommit(false);
        Statement s2 = c2.createStatement();
        s1.execute("create table test(id int primary key, name varchar) as select x, x from system_range(1, 2)");
        s1.execute("create unique index on test(name)");
        s1.executeUpdate("update test set name = 100 where id = 1");
        this.assertThrows(SQLException.class, s2).executeUpdate("update test set name = 100 where id = 2");
        ResultSet rs = s1.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("100", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("2", rs.getString(2));
        this.assertFalse(rs.next());
        rs = s2.executeQuery("select * from test order by id");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("1", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("2", rs.getString(2));
        this.assertFalse(rs.next());
        c1.close();
        c2.close();
    }

    private void testInsertUpdateRollback() throws SQLException {
        this.deleteDb("mvcc3");
        Connection c1 = this.getConnection("mvcc3");
        Statement s1 = c1.createStatement();
        Connection c2 = this.getConnection("mvcc3");
        Statement s2 = c2.createStatement();
        s1.execute("create table test(id int primary key, name varchar) as select 0, 'Hello'");
        c1.setAutoCommit(false);
        s1.executeUpdate("update test set name = 'World'");
        this.printRows("after update", s1, s2);
        Savepoint sp1 = c1.setSavepoint();
        s1.executeUpdate("delete from test");
        this.printRows("after delete", s1, s2);
        c1.rollback(sp1);
        this.printRows("after rollback delete", s1, s2);
        c1.rollback();
        this.printRows("after rollback all", s1, s2);
        ResultSet rs = s2.executeQuery("select * from test");
        this.assertTrue(rs.next());
        this.assertFalse(rs.next());
        c1.close();
        c2.close();
    }

    private void printRows(String s, Statement s1, Statement s2) throws SQLException {
        this.trace(s);
        ResultSet rs = s1.executeQuery("select * from test");
        while (rs.next()) {
            this.trace("s1: " + rs.getString(2));
        }
        rs = s2.executeQuery("select * from test");
        while (rs.next()) {
            this.trace("s2: " + rs.getString(2));
        }
    }

    private void testCreateTableAsSelect() throws SQLException {
        this.deleteDb("mvcc3");
        Connection c1 = this.getConnection("mvcc3");
        Statement s1 = c1.createStatement();
        s1.execute("CREATE TABLE TEST AS SELECT X ID, 'Hello' NAME FROM SYSTEM_RANGE(1, 3)");
        Connection c2 = this.getConnection("mvcc3");
        Statement s2 = c2.createStatement();
        ResultSet rs = s2.executeQuery("SELECT NAME FROM TEST WHERE ID=1");
        rs.next();
        this.assertEquals("Hello", rs.getString(1));
        c1.close();
        c2.close();
    }

    private void testRollback() throws SQLException {
        this.deleteDb("mvcc3");
        Connection conn = this.getConnection("mvcc3");
        Statement stat = conn.createStatement();
        stat.executeUpdate("DROP TABLE IF EXISTS TEST");
        stat.executeUpdate("CREATE TABLE TEST (ID NUMBER(2) PRIMARY KEY, VAL VARCHAR(10))");
        stat.executeUpdate("INSERT INTO TEST (ID, VAL) VALUES (1, 'Value')");
        stat.executeUpdate("INSERT INTO TEST (ID, VAL) VALUES (2, 'Value')");
        if (!this.config.memory) {
            conn.close();
            conn = this.getConnection("mvcc3");
        }
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(2);
        Connection conn2 = this.getConnection("mvcc3");
        conn2.setAutoCommit(false);
        conn2.setTransactionIsolation(2);
        conn.createStatement().executeUpdate("UPDATE TEST SET VAL='Updated' WHERE ID = 1");
        conn.rollback();
        ResultSet rs = conn2.createStatement().executeQuery("SELECT * FROM TEST");
        this.assertTrue(rs.next());
        this.assertEquals("Value", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals("Value", rs.getString(2));
        this.assertFalse(rs.next());
        conn.createStatement().executeUpdate("UPDATE TEST SET VAL='Updated' WHERE ID = 1");
        conn.commit();
        rs = conn2.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Updated", rs.getString(2));
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        this.assertEquals("Value", rs.getString(2));
        this.assertFalse(rs.next());
        conn.close();
        conn2.close();
    }

    private void testDisableAutoCommit() throws SQLException {
        this.deleteDb("mvcc3");
        Connection conn = this.getConnection("mvcc3");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        stat.execute("INSERT INTO TEST VALUES(0)");
        conn.setAutoCommit(false);
        stat.execute("INSERT INTO TEST VALUES(1)");
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        conn.close();
    }
}

