/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.mvcc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.concurrent.CountDownLatch;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMvcc4
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.lockTimeout = 20000;
        test.config.memory = true;
        test.testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked;
    }

    @Override
    public void test() throws SQLException {
        this.testSelectForUpdateAndUpdateConcurrency();
    }

    private void testSelectForUpdateAndUpdateConcurrency() throws SQLException {
        this.deleteDb("mvcc4");
        Connection setup = this.getConnection("mvcc4");
        setup.setAutoCommit(false);
        Statement s = setup.createStatement();
        s.executeUpdate("CREATE TABLE test (entity_id VARCHAR(100) NOT NULL PRIMARY KEY, lastUpdated TIMESTAMP NOT NULL)");
        PreparedStatement ps = setup.prepareStatement("INSERT INTO test (entity_id, lastUpdated) VALUES (?, ?)");
        int i22 = 0;
        while (i22 < 2) {
            String id = "" + i22;
            ps.setString(1, id);
            ps.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            ps.executeUpdate();
            ++i22;
        }
        setup.commit();
        Connection c1 = this.getConnection("mvcc4;LOCK_TIMEOUT=10000");
        c1.setAutoCommit(false);
        final CountDownLatch executedUpdate = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet resultSet;
                    Connection c2 = TestMvcc4.this.getConnection("mvcc4");
                    c2.setAutoCommit(false);
                    PreparedStatement ps = c2.prepareStatement("SELECT * FROM test WHERE entity_id = ? FOR UPDATE");
                    ps.setString(1, "1");
                    ps.executeQuery().next();
                    executedUpdate.countDown();
                    PreparedStatement stmt = c2.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.SESSIONS WHERE BLOCKER_ID = SESSION_ID()");
                    while (!(resultSet = stmt.executeQuery()).next()) {
                    }
                    c2.commit();
                    c2.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try {
            executedUpdate.await();
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        PreparedStatement ps2 = c1.prepareStatement("UPDATE test SET lastUpdated = ?");
        ps2.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        this.assertEquals(2, ps2.executeUpdate());
        c1.commit();
        c1.close();
        Connection verify = this.getConnection("mvcc4");
        verify.setAutoCommit(false);
        ps2 = verify.prepareStatement("SELECT COUNT(*) FROM test");
        ResultSet rs = ps2.executeQuery();
        this.assertTrue(rs.next());
        this.assertEquals(2, rs.getInt(1));
        verify.commit();
        verify.close();
        setup.close();
    }
}

