/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.mvcc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.h2.message.DbException;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.IOUtils;

public class TestMvccMultiThreaded2
extends TestDb {
    private static final int TEST_THREAD_COUNT = 100;
    private static final int TEST_TIME_SECONDS = 60;
    private static final boolean DISPLAY_STATS = false;
    private static final String URL = ";LOCK_TIMEOUT=120000";

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.lockTimeout = 120000;
        test.config.memory = true;
        test.testFromMain();
    }

    int getTestDuration() {
        return this.config.big ? 60 : 6;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void test() throws SQLException, InterruptedException {
        this.testSelectForUpdateConcurrency();
    }

    private void testSelectForUpdateConcurrency() throws SQLException, InterruptedException {
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName() + URL);
        conn.setAutoCommit(false);
        String sql = "CREATE TABLE test (entity_id INTEGER NOT NULL PRIMARY KEY, lastUpdated INTEGER NOT NULL)";
        Statement smtm = conn.createStatement();
        smtm.executeUpdate(sql);
        PreparedStatement ps = conn.prepareStatement("INSERT INTO test (entity_id, lastUpdated) VALUES (?, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 100);
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setInt(2, 200);
        ps.executeUpdate();
        conn.commit();
        CountDownLatch latch = new CountDownLatch(101);
        ArrayList<SelectForUpdate> threads = new ArrayList<SelectForUpdate>();
        int i = 0;
        while (i < 100) {
            SelectForUpdate sfu = new SelectForUpdate(latch);
            sfu.setName("Test SelectForUpdate Thread#" + i);
            threads.add(sfu);
            sfu.start();
            ++i;
        }
        latch.countDown();
        int minProcessed = Integer.MAX_VALUE;
        int maxProcessed = 0;
        int totalProcessed = 0;
        boolean allOk = true;
        for (SelectForUpdate sfu : threads) {
            sfu.join();
            allOk &= sfu.ok;
            totalProcessed += sfu.iterationsProcessed;
            if (sfu.iterationsProcessed > maxProcessed) {
                maxProcessed = sfu.iterationsProcessed;
            }
            if (sfu.iterationsProcessed >= minProcessed) continue;
            minProcessed = sfu.iterationsProcessed;
        }
        IOUtils.closeSilently(conn);
        this.deleteDb(this.getTestName());
        this.assertTrue(allOk);
    }

    private class SelectForUpdate
    extends Thread {
        private final CountDownLatch latch;
        public int iterationsProcessed;
        public boolean ok;

        SelectForUpdate(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            boolean done = false;
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (Connection conn = TestMvccMultiThreaded2.this.getConnection(TestMvccMultiThreaded2.this.getTestName() + TestMvccMultiThreaded2.URL);){
                    conn.setAutoCommit(false);
                    this.latch.countDown();
                    this.latch.await();
                    PreparedStatement ps = conn.prepareStatement("SELECT * FROM test WHERE entity_id = ? FOR UPDATE");
                    while (!done) {
                        int value;
                        String id;
                        if ((this.iterationsProcessed & 1) == 0) {
                            id = "1";
                            value = 100;
                        } else {
                            id = "2";
                            value = 200;
                        }
                        ps.setString(1, id);
                        ResultSet rs = ps.executeQuery();
                        TestMvccMultiThreaded2.this.assertTrue(rs.next());
                        TestMvccMultiThreaded2.this.assertTrue(rs.getInt(2) == value);
                        conn.commit();
                        ++this.iterationsProcessed;
                        long now = System.currentTimeMillis();
                        if (now - start <= (long)(1000 * TestMvccMultiThreaded2.this.getTestDuration())) continue;
                        done = true;
                    }
                    this.ok = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (SQLException e) {
                TestBase.logError("SQL error from thread " + this.getName(), e);
                throw DbException.convert(e);
            }
            catch (Exception e) {
                TestBase.logError("General error from thread " + this.getName(), e);
                throw e;
            }
        }
    }
}

