/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Test {
    private String url;
    private Connection conn;
    private Statement stat;
    private PreparedStatement prep;

    private Test() {
    }

    private Test(String driver, String url, String user, String password, boolean writeDelay0) {
        this.url = url;
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(url, user, password);
            this.stat = this.conn.createStatement();
            if (writeDelay0) {
                this.stat.execute("SET WRITE_DELAY 0");
            }
            System.out.println(url + " started");
        }
        catch (Exception e) {
            System.out.println(url + ": " + e.toString());
            return;
        }
        try {
            ResultSet rs = this.stat.executeQuery("SELECT MAX(ID) FROM TEST");
            rs.next();
            System.out.println(url + ": MAX(ID)=" + rs.getInt(1));
            this.stat.execute("DROP TABLE TEST");
        }
        catch (SQLException rs) {
            // empty catch block
        }
        try {
            this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
            this.prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        }
        catch (SQLException e) {
            System.out.println(url + ": " + e.toString());
        }
    }

    private void insert(int id) {
        try {
            if (this.prep != null) {
                this.prep.setInt(1, id);
                this.prep.setString(2, "World " + id);
                this.prep.execute();
            }
        }
        catch (SQLException e) {
            System.out.println(this.url + ": " + e.toString());
        }
    }

    public static void main(String ... args) throws Exception {
        int port = 9099;
        String connect = "192.168.0.3";
        boolean file = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-connect")) {
                connect = args[++i];
            } else if (args[i].equals("-file")) {
                file = true;
            }
            ++i;
        }
        Test.test(connect, port, file);
    }

    private static void test(String connect, int port, boolean file) throws Exception {
        Socket socket = new Socket(connect, port);
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        System.out.println("Connected to " + socket.toString());
        if (file) {
            Test.testFile(out);
        } else {
            Test.testDatabases(out);
        }
    }

    private static void testFile(DataOutputStream out) throws IOException {
        File file = new File("test.txt");
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile write = new RandomAccessFile(file, "rws");
        int fileSize = 0xA00000;
        write.seek(fileSize - 1);
        write.write(0);
        write.seek(0L);
        int i = 0;
        FileDescriptor fd = write.getFD();
        while (write.getFilePointer() < (long)fileSize) {
            write.writeBytes(i + "\r\n");
            fd.sync();
            out.writeInt(i);
            out.flush();
            ++i;
        }
        write.close();
    }

    private static void testDatabases(DataOutputStream out) throws Exception {
        Test[] dbs = new Test[]{new Test("org.h2.Driver", "jdbc:h2:./test1", "sa", "", true), new Test("org.h2.Driver", "jdbc:h2:./test2", "sa", "", false), new Test("org.hsqldb.jdbcDriver", "jdbc:hsqldb:test4", "sa", "", false), new Test("org.postgresql.Driver", "jdbc:postgresql:test", "sa", "sa", false), new Test("org.apache.derby.iapi.jdbc.AutoloadedDriver", "jdbc:derby:test;create=true", "sa", "", false), new Test("org.h2.Driver", "jdbc:h2:./test5", "sa", "", true), new Test("org.h2.Driver", "jdbc:h2:./test6", "sa", "", false)};
        int i = 0;
        while (true) {
            Test[] testArray = dbs;
            int n = dbs.length;
            int n2 = 0;
            while (n2 < n) {
                Test t = testArray[n2];
                t.insert(i);
                ++n2;
            }
            out.writeInt(i);
            out.flush();
            ++i;
        }
    }
}

