/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.InputStream;
import java.util.Random;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.poweroff.TestRecover;
import org.h2.test.synth.OutputCatcher;

public class TestRecoverKillLoop
extends TestBase {
    public static void main(String ... args) throws Exception {
        new TestRecoverKillLoop().runTest(Integer.MAX_VALUE);
    }

    @Override
    public void test() throws Exception {
        this.runTest(3);
    }

    private void runTest(int count) throws Exception {
        FileUtils.deleteRecursive("data/db", false);
        Random random = new Random(1L);
        int i = 0;
        while (i < count) {
            String[] procDef = new String[]{TestRecoverKillLoop.getJVM(), "-cp", this.getClassPath(), "-Dtest.dir=data/db", TestRecover.class.getName()};
            Process p = Runtime.getRuntime().exec(procDef);
            InputStream in = p.getInputStream();
            OutputCatcher catcher = new OutputCatcher(in);
            catcher.start();
            while (true) {
                String s;
                if ((s = catcher.readLine(60000L)) == null) {
                    this.fail("No reply from process");
                    continue;
                }
                if (s.startsWith("testing...")) break;
                if (!s.startsWith("error!")) continue;
                this.fail("Failed: " + s);
            }
            int sleep = random.nextInt(10000);
            Thread.sleep(sleep);
            this.printTime("killing");
            p.destroy();
            p.waitFor();
            ++i;
        }
    }
}

