/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.poweroff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Random;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.utils.FilePathReorderWrites;

public class TestReorderWrites
extends TestBase {
    private static final boolean LOG = false;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testMVStore(false);
        this.testMVStore(true);
        this.testFileSystem(false);
        this.testFileSystem(true);
    }

    private void testMVStore(boolean partialWrite) {
        this.println(String.format("testMVStore(): %s partial write", partialWrite ? "Enable" : "Disable"));
        FilePathReorderWrites.setPartialWrites(partialWrite);
        FilePathReorderWrites fs = FilePathReorderWrites.register();
        String fileName = "reorder:memFS:test.mv";
        try {
            int i = 0;
            while (i < (this.config.big ? 1000 : 100)) {
                MVMap<Integer, Integer> newMap;
                int j;
                TestReorderWrites.log(i + " --------------------------------");
                fs.setPowerOffCountdown(0, 0);
                FileUtils.delete("memFS:test.mv");
                FileUtils.delete("memFS:test.mv.copy");
                MVStore store = new MVStore.Builder().fileName(fileName).autoCommitDisabled().open();
                MVMap<Integer, byte[]> map = store.openMap("data");
                map.put(-1, new byte[1]);
                store.commit();
                store.getFileStore().sync();
                Random r = new Random(i);
                int stop = 4 + r.nextInt(this.config.big ? 150 : 20);
                TestReorderWrites.log("countdown start");
                fs.setPowerOffCountdown(stop, i);
                try {
                    j = 1;
                    while (j < 100) {
                        newMap = store.openMap("d" + j);
                        newMap.put(j, j * 10);
                        int key = r.nextInt(10);
                        int len = 10 * r.nextInt(1000);
                        if (r.nextBoolean()) {
                            map.remove(key);
                        } else {
                            map.put(key, new byte[len]);
                        }
                        TestReorderWrites.log("op " + j + ": ");
                        store.commit();
                        switch (r.nextInt(10)) {
                            case 0: {
                                TestReorderWrites.log("op compact");
                                store.compact(100, 10240);
                                break;
                            }
                            default: {
                                TestReorderWrites.log("op compactMoveChunks");
                                store.compactFile(1000);
                                TestReorderWrites.log("op compactFile done");
                            }
                        }
                        ++j;
                    }
                    this.fail();
                }
                catch (MVStoreException e) {
                    TestReorderWrites.log("stop " + String.valueOf(e) + ", cause: " + String.valueOf(e.getCause()));
                }
                try {
                    store.close();
                }
                catch (MVStoreException e) {
                    store.closeImmediately();
                }
                TestReorderWrites.log("verify");
                fs.setPowerOffCountdown(100, 0);
                store = new MVStore.Builder().fileName(fileName).autoCommitDisabled().open();
                map = store.openMap("data");
                if (!map.containsKey(-1)) {
                    this.fail("key not found, size=" + map.size() + " i=" + i);
                } else {
                    this.assertEquals("i=" + i, 1, ((byte[])map.get(-1)).length);
                }
                j = 0;
                while (j < 100) {
                    newMap = store.openMap("d" + j);
                    newMap.get(j);
                    ++j;
                }
                map.keySet();
                store.close();
                ++i;
            }
        }
        finally {
            FileUtils.delete("memFS:test.mv");
            FileUtils.delete("memFS:test.mv.copy");
        }
    }

    private static void log(String message) {
    }

    private void testFileSystem(boolean partialWrite) throws IOException {
        FilePathReorderWrites fs = FilePathReorderWrites.register();
        FilePathReorderWrites.setPartialWrites(partialWrite);
        this.println(String.format("testFileSystem(): %s partial write", partialWrite ? "Enable" : "Disable"));
        String fileName = "reorder:memFS:test";
        ByteBuffer empty = ByteBuffer.allocate(1024);
        Random r = new Random(1L);
        long minSize = Long.MAX_VALUE;
        long maxSize = 0L;
        int minWritten = Integer.MAX_VALUE;
        int maxWritten = 0;
        int i = 0;
        while (i < 100) {
            fs.setPowerOffCountdown(100, i);
            FileUtils.delete(fileName);
            FileChannel fc = FilePath.get(fileName).open("rw");
            int j = 0;
            while (j < 20) {
                fc.write(empty, j * 1024);
                empty.flip();
                ++j;
            }
            fs.setPowerOffCountdown(4 + r.nextInt(20), i);
            int lastWritten = 0;
            int lastTruncated = 0;
            int j2 = 20;
            while (j2 >= 0) {
                try {
                    byte[] bytes = new byte[1024];
                    Arrays.fill(bytes, (byte)j2);
                    ByteBuffer data = ByteBuffer.wrap(bytes);
                    fc.write(data, 0L);
                    lastWritten = j2;
                }
                catch (IOException e) {
                    break;
                }
                try {
                    fc.truncate(j2 * 1024);
                    lastTruncated = j2 * 1024;
                }
                catch (IOException e) {
                    break;
                }
                --j2;
            }
            if (lastTruncated <= 0 || lastWritten <= 0) {
                this.fail();
            }
            fs.setPowerOffCountdown(100, 0);
            fc = FilePath.get(fileName).open("rw");
            ByteBuffer data = ByteBuffer.allocate(1024);
            fc.read(data, 0L);
            data.flip();
            byte got = data.get();
            long size = fc.size();
            minSize = Math.min(minSize, size);
            maxSize = Math.max(minSize, size);
            minWritten = Math.min(minWritten, got);
            maxWritten = Math.max(maxWritten, got);
            ++i;
        }
        this.assertTrue(minSize < maxSize);
        this.assertTrue(minWritten < maxWritten);
        FileUtils.delete(fileName);
    }
}

