/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.scripts;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.h2.api.ErrorCode;
import org.h2.command.CommandContainer;
import org.h2.command.CommandInterface;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.query.Query;
import org.h2.engine.Mode;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.StringUtils;
import org.h2.value.DataType;

public class TestScript
extends TestDb {
    private static final String BASE_DIR = "org/h2/test/scripts/";
    private static final boolean FIX_OUTPUT = false;
    private static final Field COMMAND;
    private static final Field PREPARED;
    private static boolean CHECK_ORDERING;
    private boolean failFast;
    private ArrayList<String> statements;
    private boolean reconnectOften;
    private Connection conn;
    private Statement stat;
    private String fileName;
    private LineNumberReader in;
    private PrintStream out;
    private final ArrayList<String[]> result = new ArrayList();
    private final ArrayDeque<String> putBack = new ArrayDeque();
    private boolean foundErrors;
    private Random random = new Random(1L);
    private static final Map<Integer, String> ERROR_CODE_TO_NAME;

    static {
        try {
            COMMAND = JdbcPreparedStatement.class.getDeclaredField("command");
            COMMAND.setAccessible(true);
            PREPARED = CommandContainer.class.getDeclaredField("prepared");
            PREPARED.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        ERROR_CODE_TO_NAME = new HashMap<Integer, String>(256);
        try {
            Field[] fieldArray = ErrorCode.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getModifiers() == 25 && field.getAnnotation(Deprecated.class) == null) {
                    ERROR_CODE_TO_NAME.put(field.getInt(null), field.getName());
                }
                ++n2;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String ... a) throws Exception {
        CHECK_ORDERING = true;
        TestBase.createCaller().init().testFromMain();
    }

    public ArrayList<String> getAllStatements(TestAll conf) throws Exception {
        this.config = conf;
        ArrayList<String> result = new ArrayList<String>(4000);
        try {
            this.statements = result;
            this.test();
        }
        finally {
            this.statements = null;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked || !this.config.big;
    }

    @Override
    public void test() throws Exception {
        String s;
        this.reconnectOften = !this.config.memory && this.config.big;
        this.testScript("testScript.sql");
        if (!(this.config.memory || this.config.big || this.config.networked)) {
            this.testScript("testSimple.sql");
        }
        this.testScript("dual.sql");
        this.testScript("indexes.sql");
        this.testScript("information_schema.sql");
        this.testScript("range_table.sql");
        this.testScript("altertable-index-reuse.sql");
        this.testScript("altertable-fk.sql");
        this.testScript("default-and-on_update.sql");
        String[] stringArray = new String[]{"add_months", "compatibility", "group_by", "strict_and_legacy"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("compatibility/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"array", "bigint", "binary", "blob", "boolean", "char", "clob", "date", "decfloat", "double_precision", "enum", "geometry", "identity", "int", "interval", "java_object", "json", "numeric", "real", "row", "smallint", "time-with-time-zone", "time", "timestamp-with-time-zone", "timestamp", "tinyint", "uuid", "varbinary", "varchar", "varchar-ignorecase"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("datatypes/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"alterDomain", "alterTableAdd", "alterTableAlterColumn", "alterTableDropColumn", "alterTableDropConstraint", "alterTableRename", "alterTableRenameConstraint", "analyze", "commentOn", "createAlias", "createConstant", "createDomain", "createIndex", "createSchema", "createSequence", "createSynonym", "createTable", "createTrigger", "createView", "dropAllObjects", "dropDomain", "dropIndex", "dropSchema", "dropTable", "grant", "truncateTable"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("ddl/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"delete", "error_reporting", "execute_immediate", "insert", "insertIgnore", "merge", "mergeUsing", "replace", "script", "show", "update", "with"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("dml/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"any_value", "any", "array_agg", "avg", "bit_and_agg", "bit_or_agg", "bit_xor_agg", "corr", "count", "covar_pop", "covar_samp", "envelope", "every", "histogram", "json_arrayagg", "json_objectagg", "listagg", "max", "min", "mode", "percentile", "rank", "regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy", "stddev_pop", "stddev_samp", "sum", "var_pop", "var_samp"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/aggregate/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"json_array", "json_object"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/json/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"abs", "acos", "asin", "atan", "atan2", "bitand", "bitcount", "bitget", "bitnot", "bitor", "bitxor", "ceil", "compress", "cos", "cosh", "cot", "decrypt", "degrees", "encrypt", "exp", "expand", "floor", "hash", "length", "log", "lshift", "mod", "ora-hash", "pi", "power", "radians", "rand", "random-uuid", "rotate", "round", "roundmagic", "rshift", "secure-rand", "sign", "sin", "sinh", "sqrt", "tan", "tanh", "truncate", "zero"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/numeric/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"array-to-string", "ascii", "bit-length", "btrim", "char", "concat", "concat-ws", "difference", "hextoraw", "insert", "left", "length", "locate", "lower", "lpad", "ltrim", "octet-length", "quote_ident", "rawtohex", "regexp-like", "regex-replace", "regexp-substr", "repeat", "replace", "right", "rpad", "rtrim", "soundex", "space", "stringdecode", "stringencode", "stringtoutf8", "substring", "to-char", "translate", "trim", "upper", "utf8tostring", "xmlattr", "xmlcdata", "xmlcomment", "xmlnode", "xmlstartdoc", "xmltext"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/string/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"array-cat", "array-contains", "array-get", "array-slice", "autocommit", "cancel-session", "casewhen", "cardinality", "cast", "coalesce", "convert", "csvread", "csvwrite", "current_catalog", "current_schema", "current_user", "currval", "data_type_sql", "database-path", "db_object", "decode", "disk-space-used", "file-read", "file-write", "greatest", "h2version", "identity", "ifnull", "last-insert-id", "least", "link-schema", "lock-mode", "lock-timeout", "memory-free", "memory-used", "nextval", "nullif", "nvl2", "readonly", "rownum", "session-id", "table", "transaction-id", "trim_array", "truncate-value", "unnest"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/system/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"current_date", "current_timestamp", "current-time", "dateadd", "datediff", "dayname", "day-of-month", "day-of-week", "day-of-year", "extract", "formatdatetime", "hour", "last_day", "minute", "month", "monthname", "parsedatetime", "quarter", "second", "truncate", "week", "year", "date_trunc"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/timeanddate/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"lead", "nth_value", "ntile", "ratio_to_report", "row_number"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("functions/window/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"at-time-zone", "boolean-test", "case", "concatenation", "conditions", "data-change-delta-table", "field-reference", "help", "invisible", "sequence", "set"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("other/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"comments", "identifiers"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("parser/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"between", "distinct", "in", "like", "null", "quantified-comparison-with-array", "type", "unique"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("predicates/" + s + ".sql");
            ++n2;
        }
        stringArray = new String[]{"derived-column-names", "distinct", "joins", "query-optimisations", "select", "table", "values", "window"};
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.testScript("queries/" + s + ".sql");
            ++n2;
        }
        this.testScript("other/two_phase_commit.sql");
        this.testScript("other/unique_include.sql");
        this.deleteDb("script");
        System.out.flush();
        if (this.foundErrors) {
            throw new Exception("errors in script found");
        }
    }

    private void testScript(String scriptFileName) throws Exception {
        this.deleteDb("script");
        this.conn = null;
        this.stat = null;
        this.fileName = null;
        this.in = null;
        this.out = null;
        this.result.clear();
        this.putBack.clear();
        String outFile = "test.out.txt";
        this.conn = this.getConnection("script");
        this.stat = this.conn.createStatement();
        this.out = new PrintStream(new FileOutputStream(outFile));
        this.testFile(BASE_DIR + scriptFileName);
        this.conn.close();
        this.out.close();
    }

    private String readLine() throws IOException {
        String s = this.putBack.pollFirst();
        return s != null ? s : this.readNextLine();
    }

    private String readNextLine() throws IOException {
        String s;
        boolean comment = false;
        while ((s = this.in.readLine()) != null) {
            if (s.startsWith("--")) {
                this.write(s);
                comment = true;
                continue;
            }
            if (!(s = s.trim()).isEmpty()) break;
            if (!comment) continue;
            this.write("");
            comment = false;
        }
        return s;
    }

    private void putBack(String line) {
        this.putBack.addLast(line);
    }

    private void testFile(String inFile) throws Exception {
        String sql;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(inFile);
        if (is == null) {
            throw new IOException("could not find " + inFile);
        }
        this.fileName = inFile;
        this.in = new LineNumberReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        StringBuilder buff = new StringBuilder();
        boolean allowReconnect = true;
        block14: while ((sql = this.readLine()) != null) {
            block25: {
                if (sql.startsWith("--")) {
                    this.write(sql);
                    continue;
                }
                if (sql.startsWith(">")) {
                    this.addWriteResultError("<command>", sql);
                    continue;
                }
                if (sql.endsWith(";")) {
                    this.write(sql);
                    buff.append(sql, 0, sql.length() - 1);
                    sql = buff.toString();
                    buff.setLength(0);
                    this.process(sql, allowReconnect);
                    continue;
                }
                if (!sql.startsWith("@")) break block25;
                if (buff.length() > 0) {
                    this.addWriteResultError("<command>", sql);
                    continue;
                }
                switch (sql) {
                    case "@reconnect": {
                        this.write(sql);
                        this.write("");
                        if (this.config.memory) continue block14;
                        this.reconnect(this.conn.getAutoCommit());
                        break;
                    }
                    case "@reconnect on": {
                        this.write(sql);
                        this.write("");
                        allowReconnect = true;
                        break;
                    }
                    case "@reconnect off": {
                        this.write(sql);
                        this.write("");
                        allowReconnect = false;
                        break;
                    }
                    case "@autocommit on": {
                        this.conn.setAutoCommit(true);
                        break;
                    }
                    case "@autocommit off": {
                        this.conn.setAutoCommit(false);
                        break;
                    }
                    default: {
                        this.addWriteResultError("<command>", sql);
                        break;
                    }
                }
                continue;
            }
            this.write(sql);
            buff.append(sql);
            buff.append('\n');
        }
    }

    private boolean containsTempTables() throws SQLException {
        ResultSet rs = this.conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
        while (rs.next()) {
            String sql = rs.getString("SQL");
            if (sql == null || !sql.contains("TEMPORARY")) continue;
            return true;
        }
        return false;
    }

    private void process(String sql, boolean allowReconnect) throws Exception {
        boolean autocommit;
        if (allowReconnect && this.reconnectOften && !this.containsTempTables() && ((JdbcConnection)this.conn).getMode().getEnum() == Mode.ModeEnum.REGULAR && this.conn.getSchema().equals("PUBLIC") && (autocommit = this.conn.getAutoCommit()) && this.random.nextInt(10) < 1) {
            this.reconnect(autocommit);
        }
        if (this.statements != null) {
            this.statements.add(sql);
        }
        if (!TestScript.hasParameters(sql)) {
            this.processStatement(sql);
        } else {
            String param = this.readLine();
            this.write(param);
            if (!param.equals("{")) {
                throw new AssertionError((Object)("expected '{', got " + param + " in " + sql));
            }
            try {
                PreparedStatement prep = this.conn.prepareStatement(sql);
                int count = 0;
                while (true) {
                    param = this.readLine();
                    this.write(param);
                    if (param.startsWith("}")) break;
                    count += this.processPrepared(sql, prep, param);
                }
                this.writeResult(sql, "update count: " + count, null);
            }
            catch (SQLException e) {
                this.writeException(sql, e);
            }
        }
        this.write("");
    }

    private static boolean hasParameters(String sql) {
        int index = 0;
        while ((index = sql.indexOf(63, index)) >= 0) {
            int length = sql.length();
            if (++index == length || sql.charAt(index) != '?') {
                return true;
            }
            ++index;
        }
        return false;
    }

    private void reconnect(boolean autocommit) throws SQLException {
        this.conn.close();
        this.conn = this.getConnection("script");
        this.conn.setAutoCommit(autocommit);
        this.stat = this.conn.createStatement();
    }

    private static void setParameter(PreparedStatement prep, int i, String param) throws SQLException {
        if (param.equalsIgnoreCase("null")) {
            param = null;
        }
        prep.setString(i, param);
    }

    private int processPrepared(String sql, PreparedStatement prep, String param) throws Exception {
        block11: {
            try {
                StringBuilder buff = new StringBuilder();
                int index = 0;
                int i = 0;
                while (i < param.length()) {
                    char c = param.charAt(i);
                    if (c == ',') {
                        TestScript.setParameter(prep, ++index, buff.toString());
                        buff.setLength(0);
                    } else if (c == '\"') {
                        while ((c = param.charAt(++i)) != '\"') {
                            buff.append(c);
                        }
                    } else if (c > ' ') {
                        buff.append(c);
                    }
                    ++i;
                }
                if (buff.length() > 0) {
                    TestScript.setParameter(prep, ++index, buff.toString());
                }
                if (!prep.execute()) break block11;
                this.writeResultSet(sql, prep.getResultSet());
                return 0;
            }
            catch (SQLException e) {
                this.writeException(sql, e);
                return 0;
            }
        }
        return prep.getUpdateCount();
    }

    private int processStatement(String sql) throws Exception {
        try {
            Statement s;
            boolean res;
            if (CHECK_ORDERING || this.config.memory && !this.config.lazy && !this.config.networked) {
                PreparedStatement prep = this.conn.prepareStatement(sql);
                res = prep.execute();
                s = prep;
            } else {
                res = this.stat.execute(sql);
                s = this.stat;
            }
            if (res) {
                this.writeResultSet(sql, s.getResultSet());
            } else {
                int count = s.getUpdateCount();
                this.writeResult(sql, (String)(count < 1 ? "ok" : "update count: " + count), null);
            }
        }
        catch (SQLException e) {
            this.writeException(sql, e);
        }
        return 0;
    }

    private static String formatString(String s) {
        String s2;
        if (s == null) {
            return "null";
        }
        s = StringUtils.replaceAll(s, "\r\n", "\n");
        s = s.replace('\n', ' ');
        s = StringUtils.replaceAll(s, "    ", " ");
        while ((s2 = StringUtils.replaceAll(s, "  ", " ")).length() != s.length()) {
            s = s2;
        }
        return s;
    }

    private static String formatBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return StringUtils.convertBytesToHex(new StringBuilder("X'"), b).append('\'').toString();
    }

    private void writeResultSet(String sql, ResultSet rs) throws Exception {
        Boolean ordered;
        Boolean gotOrdered;
        String[] head;
        int[] max;
        block28: {
            CommandInterface ci;
            int i;
            ResultSetMetaData meta = rs.getMetaData();
            int len = meta.getColumnCount();
            max = new int[len];
            this.result.clear();
            while (rs.next()) {
                String[] row = new String[len];
                i = 0;
                while (i < len) {
                    String data = TestScript.readValue(rs, meta, i + 1);
                    if (max[i] < data.length()) {
                        max[i] = data.length();
                    }
                    row[i] = data;
                    ++i;
                }
                this.result.add(row);
            }
            head = new String[len];
            i = 0;
            while (i < len) {
                String label = TestScript.formatString(meta.getColumnLabel(i + 1));
                if (max[i] < label.length()) {
                    max[i] = label.length();
                }
                head[i] = label;
                ++i;
            }
            gotOrdered = null;
            Statement st = rs.getStatement();
            if (st instanceof JdbcPreparedStatement && (ci = (CommandInterface)COMMAND.get(st)) instanceof CommandContainer) {
                Prepared p = (Prepared)PREPARED.get(ci);
                if (p instanceof Query) {
                    gotOrdered = ((Query)p).hasOrder();
                } else if (p instanceof ScriptCommand) {
                    gotOrdered = true;
                }
            }
            rs.close();
            String line = this.readLine();
            this.putBack(line);
            if (line != null && line.startsWith(">> ")) {
                switch (this.result.size()) {
                    case 0: {
                        this.writeResult(sql, "<no result>", null, ">> ");
                        return;
                    }
                    case 1: {
                        String[] row = this.result.get(0);
                        if (row.length == 1) {
                            this.writeResult(sql, row[0], null, ">> ");
                        } else {
                            this.writeResult(sql, "<row with " + row.length + " values>", null, ">> ");
                        }
                        return;
                    }
                }
                this.writeResult(sql, "<" + this.result.size() + " rows>", null, ">> ");
                return;
            }
            do {
                if ((line = this.readNextLine()) == null) {
                    this.addWriteResultError("<row count>", "<eof>");
                    return;
                }
                this.putBack(line);
                if (line.startsWith("> rows: ")) {
                    ordered = false;
                } else {
                    if (!line.startsWith("> rows (ordered): ")) continue;
                    ordered = true;
                }
                break block28;
            } while (!line.startsWith("> rows (partially ordered): "));
            ordered = null;
        }
        if (gotOrdered != null) {
            if (ordered == null || ordered.booleanValue()) {
                if (!gotOrdered.booleanValue()) {
                    this.addWriteResultError("<ordered result set>", "<result set>");
                }
            } else if (gotOrdered.booleanValue()) {
                this.addWriteResultError("<result set>", "<ordered result set>");
            }
        }
        this.writeResult(sql, TestScript.format(head, max), null);
        this.writeResult(sql, TestScript.format(null, max), null);
        String[] array = new String[this.result.size()];
        int i = 0;
        while (i < this.result.size()) {
            array[i] = TestScript.format(this.result.get(i), max);
            ++i;
        }
        if (!Boolean.TRUE.equals(ordered)) {
            TestScript.sort(array);
        }
        i = 0;
        while (i < array.length) {
            this.writeResult(sql, array[i], null);
            ++i;
        }
        this.writeResult(sql, (ordered != null ? (ordered.booleanValue() ? "rows (ordered): " : "rows: ") : "rows (partially ordered): ") + i, null);
    }

    private static String readValue(ResultSet rs, ResultSetMetaData meta, int column) throws SQLException {
        return DataType.isBinaryColumn(meta, column) ? TestScript.formatBinary(rs.getBytes(column)) : TestScript.formatString(rs.getString(column));
    }

    private static String format(String[] row, int[] max) {
        int length = max.length;
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buff.append(' ');
            }
            if (row == null) {
                int j = 0;
                while (j < max[i]) {
                    buff.append('-');
                    ++j;
                }
            } else {
                int len = row[i].length();
                buff.append(row[i]);
                if (i < length - 1) {
                    int j = len;
                    while (j < max[i]) {
                        buff.append(' ');
                        ++j;
                    }
                }
            }
            ++i;
        }
        return buff.toString();
    }

    private void writeException(String sql, SQLException ex) throws Exception {
        this.writeResult(sql, "exception " + ERROR_CODE_TO_NAME.get(ex.getErrorCode()), ex);
    }

    private void writeResult(String sql, String s, SQLException ex) throws Exception {
        this.writeResult(sql, s, ex, "> ");
    }

    private void writeResult(String sql, String s, SQLException ex, String prefix) throws Exception {
        this.assertKnownException(sql, ex);
        s = (prefix + s).trim();
        String compare = this.readLine();
        if (compare != null && compare.startsWith(">")) {
            if (!compare.equals(s)) {
                if (this.reconnectOften && sql.toUpperCase().startsWith("EXPLAIN")) {
                    return;
                }
                this.addWriteResultError(compare, s);
                if (ex != null) {
                    TestBase.logError("script", ex);
                }
                if (this.failFast) {
                    this.conn.close();
                    System.exit(1);
                }
            }
        } else {
            this.addWriteResultError("<nothing>", s);
            if (compare != null) {
                this.putBack(compare);
            }
        }
        this.write(s);
    }

    private void addWriteResultError(String expected, String got) {
        this.foundErrors = true;
        String msg = this.fileName + "\nline: " + this.in.getLineNumber() + "\nexp: " + expected + "\ngot: " + got + "\n";
        TestBase.logErrorMessage(msg);
    }

    private void write(String s) {
        this.out.println(s);
    }

    private static void sort(String[] a) {
        int i = 1;
        int len = a.length;
        while (i < len) {
            String t = a[i];
            int j = i - 1;
            while (j >= 0 && t.compareTo(a[j]) < 0) {
                a[j + 1] = a[j];
                --j;
            }
            a[j + 1] = t;
            ++i;
        }
    }
}

