/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.SortedProperties;

public class TestAutoServer
extends TestDb {
    static final int ITERATIONS = 30;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testUnsupportedCombinations();
        this.testAutoServer(false);
        this.testSocketReadTimeout(false);
        if (!this.config.big) {
            this.testAutoServer(true);
        }
        this.testLinkedLocalTablesWithAutoServerReconnect();
    }

    private void testUnsupportedCombinations() {
        String[] urls;
        String[] stringArray = urls = new String[]{"jdbc:h2:" + this.getTestName() + ";file_lock=no;auto_server=true", "jdbc:h2:" + this.getTestName() + ";file_lock=serialized;auto_server=true", "jdbc:h2:" + this.getTestName() + ";access_mode_data=r;auto_server=true", "jdbc:h2:" + this.getTestName() + ";AUTO_SERVER=TRUE;DB_CLOSE_ON_EXIT=FALSE", "jdbc:h2:mem:" + this.getTestName() + ";AUTO_SERVER=TRUE"};
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            this.assertThrows(SQLException.class, () -> this.getConnection(url));
            try {
                this.getConnection(url);
                this.fail(url);
            }
            catch (SQLException e) {
                this.assertKnownException(e);
            }
            ++n2;
        }
    }

    private void testAutoServer(boolean port) throws Exception {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getURL(this.getTestName() + ";AUTO_SERVER=TRUE", true);
        if (port) {
            url = (String)url + ";AUTO_SERVER_PORT=11111";
        }
        String user = this.getUser();
        String password = this.getPassword();
        Throwable throwable = null;
        Object var6_7 = null;
        try (Connection connServer = this.getConnection((String)url + ";OPEN_NEW=TRUE", user, password);){
            int i = 30;
            while (i > 0) {
                Thread.sleep(100L);
                SortedProperties prop = SortedProperties.loadProperties(this.getBaseDir() + "/" + this.getTestName() + ".lock.db");
                String key = prop.getProperty("id");
                String server = prop.getProperty("server");
                if (server != null) {
                    Object u2 = ((String)url).substring(((String)url).indexOf(59));
                    u2 = "jdbc:h2:tcp://" + server + "/" + key + (String)u2;
                    Connection conn = DriverManager.getConnection((String)u2, user, password);
                    conn.close();
                    int gotPort = Integer.parseInt(server.substring(server.lastIndexOf(58) + 1));
                    if (!port) break;
                    this.assertEquals(11111, gotPort);
                    break;
                }
                --i;
            }
            if (i <= 0) {
                this.fail();
            }
            Throwable throwable2 = null;
            Object var10_13 = null;
            try (Connection conn = this.getConnection((String)url + ";OPEN_NEW=TRUE");){
                Statement stat = conn.createStatement();
                if (this.config.big) {
                    try {
                        stat.execute("SHUTDOWN");
                    }
                    catch (SQLException e) {
                        this.assertKnownException(e);
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.deleteDb("autoServer");
    }

    private void testSocketReadTimeout(boolean port) throws Exception {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb(this.getTestName());
        Object url = this.getURL(this.getTestName() + ";AUTO_SERVER=TRUE", true);
        if (port) {
            url = (String)url + ";AUTO_SERVER_PORT=11111";
        }
        String user = this.getUser();
        String password = this.getPassword();
        Connection connServer = this.getConnection((String)url + ";OPEN_NEW=TRUE", user, password);
        try {
            SortedProperties prop = SortedProperties.loadProperties(this.getBaseDir() + "/" + this.getTestName() + ".lock.db");
            String key = prop.getProperty("id");
            String server = prop.getProperty("server");
            if (server != null) {
                Object u2 = ((String)url).substring(((String)url).indexOf(59));
                u2 = "jdbc:h2:tcp://" + server + "/" + key + (String)u2 + ";NETWORK_TIMEOUT=100";
                Connection conn = DriverManager.getConnection((String)u2, user, password);
                Statement stat = conn.createStatement();
                this.assertThrows(90067, stat).executeQuery("SELECT MAX(RAND()) FROM SYSTEM_RANGE(1, 100000000)");
                conn.close();
                int gotPort = Integer.parseInt(server.substring(server.lastIndexOf(58) + 1));
                if (port) {
                    this.assertEquals(11111, gotPort);
                }
            }
            Connection conn = this.getConnection((String)url + ";OPEN_NEW=TRUE");
            Statement stat = conn.createStatement();
            if (this.config.big) {
                try {
                    stat.execute("SHUTDOWN");
                }
                catch (SQLException e) {
                    this.assertKnownException(e);
                }
            }
            conn.close();
        }
        finally {
            try {
                connServer.createStatement().execute("SHUTDOWN");
                if (this.config.big) {
                    this.fail("server should be down already");
                }
            }
            catch (SQLException e) {
                this.assertTrue(this.config.big);
                this.assertKnownException(e);
            }
            try {
                connServer.close();
            }
            catch (SQLException sQLException) {}
        }
        this.deleteDb("autoServer");
    }

    private void testLinkedLocalTablesWithAutoServerReconnect() throws SQLException {
        if (this.config.memory || this.config.networked) {
            return;
        }
        this.deleteDb(this.getTestName() + "1");
        this.deleteDb(this.getTestName() + "2");
        String url = this.getURL(this.getTestName() + "1;AUTO_SERVER=TRUE", true);
        String urlLinked = this.getURL(this.getTestName() + "2", true);
        String user = this.getUser();
        String password = this.getPassword();
        Connection connLinked = this.getConnection(urlLinked, user, password);
        Statement statLinked = connLinked.createStatement();
        statLinked.execute("CREATE TABLE TEST(ID VARCHAR)");
        Connection connAutoServer1 = this.getConnection(url + ";OPEN_NEW=TRUE", user, password);
        Statement statAutoServer1 = connAutoServer1.createStatement();
        statAutoServer1.execute("CREATE LOCAL TEMPORARY LINKED TABLE T('', '" + urlLinked + "', '" + user + "', '" + password + "', 'TEST')");
        Connection connAutoServer2 = this.getConnection(url + ";OPEN_NEW=TRUE", user, password);
        Statement statAutoServer2 = connAutoServer2.createStatement();
        statAutoServer2.execute("CREATE LOCAL TEMPORARY LINKED TABLE T('', '" + urlLinked + "', '" + user + "', '" + password + "', 'TEST')");
        statAutoServer1.execute("shutdown immediately");
        try {
            connAutoServer1.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statAutoServer2.execute("INSERT INTO T (ID) VALUES('abc')");
        statAutoServer2.execute("drop table t");
        connAutoServer2.close();
        connLinked.createStatement().execute("shutdown immediately");
        try {
            connLinked.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.deleteDb(this.getTestName() + "1");
        this.deleteDb(this.getTestName() + "2");
    }

    public static void halt(int exitValue) {
        Runtime.getRuntime().halt(exitValue);
    }
}

