/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.sql.Connection;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.h2.jdbc.JdbcSQLFeatureNotSupportedException;
import org.h2.jdbc.JdbcSQLNonTransientException;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebServlet;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.server.WebClient;
import org.h2.tools.Server;
import org.h2.util.StringUtils;
import org.h2.util.Task;

public class TestWeb
extends TestDb {
    private static volatile String lastUrl;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testServlet();
        this.testWrongParameters();
        this.testTools();
        this.testAlreadyRunning();
        this.testStartWebServerWithConnection();
        this.testServer();
        this.testWebApp();
        this.testIfExists();
        this.testSpecialAutoComplete();
    }

    private void testServlet() throws Exception {
        WebServlet servlet = new WebServlet();
        final HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("ifExists", "");
        configMap.put("", "");
        ServletConfig config = new ServletConfig(){

            public String getServletName() {
                return "H2Console";
            }

            public Enumeration<String> getInitParameterNames() {
                return new Vector(configMap.keySet()).elements();
            }

            public String getInitParameter(String name) {
                return (String)configMap.get(name);
            }

            public ServletContext getServletContext() {
                return null;
            }
        };
        servlet.init(config);
        TestHttpServletRequest request = new TestHttpServletRequest();
        request.setPathInfo("/");
        TestHttpServletResponse response = new TestHttpServletResponse();
        TestServletOutputStream out = new TestServletOutputStream();
        response.setServletOutputStream(out);
        servlet.doGet(request, response);
        this.assertContains(out.toString(), "location.href = 'login.jsp");
        servlet.destroy();
    }

    private void testWrongParameters() {
        this.assertThrows(50100, () -> Server.createPgServer("-pgPort 8182"));
        this.assertThrows(50100, () -> Server.createTcpServer("-tcpPort 8182"));
        this.assertThrows(50100, () -> Server.createWebServer("-webPort=8182"));
    }

    private void testAlreadyRunning() throws Exception {
        Server server = Server.createWebServer("-webPort", "8182", "-properties", "null");
        server.start();
        try {
            this.assertContains(server.getStatus(), "server running");
            Server server2 = Server.createWebServer("-webPort", "8182", "-properties", "null");
            this.assertEquals("Not started", server2.getStatus());
            try {
                try {
                    server2.start();
                    this.fail();
                }
                catch (Exception e) {
                    this.assertContains(e.toString(), "port may be in use");
                    this.assertContains(server2.getStatus(), "could not be started");
                    server2.stop();
                }
            }
            finally {
                server2.stop();
            }
        }
        finally {
            server.stop();
        }
    }

    private void testTools() throws Exception {
        if (this.config.memory || this.config.cipher != null) {
            return;
        }
        this.deleteDb(this.getTestName());
        Connection conn = this.getConnection(this.getTestName());
        conn.createStatement().execute("create table test(id int) as select 1");
        conn.close();
        String hash = WebServer.encodeAdminPassword("1234567890AB");
        try {
            Server.main("-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101", "-webAdminPassword", hash);
            this.fail("Expected exception");
        }
        catch (JdbcSQLFeatureNotSupportedException jdbcSQLFeatureNotSupportedException) {
            // empty catch block
        }
        Server server = new Server();
        server.setOut(new PrintStream(new ByteArrayOutputStream()));
        try {
            server.runTool("-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101", "-webAdminPassword", "123");
            this.fail("Expected exception");
        }
        catch (JdbcSQLNonTransientException jdbcSQLNonTransientException) {
            // empty catch block
        }
        server.runTool("-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101", "-webAdminPassword", hash);
        try {
            String url = "http://localhost:8182";
            WebClient client = new WebClient();
            String result = client.get(url);
            client.readSessionId(result);
            result = client.get(url, "adminLogin.do?password=1234567890AB");
            result = client.get(url, "tools.jsp");
            FileUtils.delete(this.getBaseDir() + "/backup.zip");
            result = client.get(url, "tools.do?tool=Backup&args=-dir," + this.getBaseDir() + ",-db," + this.getTestName() + ",-file," + this.getBaseDir() + "/backup.zip");
            this.deleteDb(this.getTestName());
            this.assertTrue(FileUtils.exists(this.getBaseDir() + "/backup.zip"));
            result = client.get(url, "tools.do?tool=DeleteDbFiles&args=-dir," + this.getBaseDir() + ",-db," + this.getTestName());
            String fn = this.getBaseDir() + "/" + this.getTestName() + ".mv.db";
            this.assertFalse(FileUtils.exists(fn));
            result = client.get(url, "tools.do?tool=Restore&args=-dir," + this.getBaseDir() + ",-db," + this.getTestName() + ",-file," + this.getBaseDir() + "/backup.zip");
            this.assertTrue(FileUtils.exists(fn));
            FileUtils.delete(this.getBaseDir() + "/web.h2.sql");
            FileUtils.delete(this.getBaseDir() + "/backup.zip");
            result = client.get(url, "tools.do?tool=Recover&args=-dir," + this.getBaseDir() + ",-db," + this.getTestName());
            this.assertTrue(FileUtils.exists(this.getBaseDir() + "/" + this.getTestName() + ".h2.sql"));
            FileUtils.delete(this.getBaseDir() + "/web.h2.sql");
            result = client.get(url, "tools.do?tool=RunScript&args=-script," + this.getBaseDir() + "/" + this.getTestName() + ".h2.sql,-url," + this.getURL(this.getTestName(), true) + ",-user," + this.getUser() + ",-password," + this.getPassword());
            FileUtils.delete(this.getBaseDir() + "/" + this.getTestName() + ".h2.sql");
            this.assertTrue(FileUtils.exists(fn));
            this.deleteDb(this.getTestName());
        }
        finally {
            server.shutdown();
        }
    }

    private void testServer() throws Exception {
        Server server = new Server();
        server.setOut(new PrintStream(new ByteArrayOutputStream()));
        server.runTool("-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101");
        try {
            String url = "http://localhost:8182";
            WebClient client = new WebClient();
            client.setAcceptLanguage("de-de,de;q=0.5");
            String result = client.get(url);
            client.readSessionId(result);
            result = client.get(url, "login.jsp");
            this.assertEquals("text/html", client.getContentType());
            this.assertContains(result, "Einstellung");
            client.get(url, "favicon.ico");
            this.assertEquals("image/x-icon", client.getContentType());
            client.get(url, "ico_ok.gif");
            this.assertEquals("image/gif", client.getContentType());
            client.get(url, "tree.js");
            this.assertEquals("text/javascript", client.getContentType());
            client.get(url, "stylesheet.css");
            this.assertEquals("text/css", client.getContentType());
            client.get(url, "admin.do");
            try {
                client.get(url, "adminShutdown.do");
            }
            catch (IOException e) {
                Thread.sleep(1000L);
            }
        }
        finally {
            server.shutdown();
        }
        server = Server.createTcpServer("-tcpPort", "9101");
        server.start();
        server.stop();
    }

    private void testIfExists() throws Exception {
        Connection conn = this.getConnection("jdbc:h2:mem:" + this.getTestName(), this.getUser(), this.getPassword());
        Server server = new Server();
        server.setOut(new PrintStream(new ByteArrayOutputStream()));
        server.runTool("-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101");
        try {
            String url = "http://localhost:8182";
            WebClient client = new WebClient();
            String result = client.get(url);
            client.readSessionId(result);
            result = client.get(url, "login.jsp");
            result = client.get(url, "test.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "&user=" + this.getUser() + "&password=" + this.getPassword() + "&name=_test_");
            this.assertTrue(result.indexOf("Exception") < 0);
            result = client.get(url, "test.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "Wrong&user=" + this.getUser() + "&password=" + this.getPassword() + "&name=_test_");
            this.assertContains(result, "Exception");
        }
        finally {
            server.shutdown();
            conn.close();
        }
    }

    private void testWebApp() throws Exception {
        Server server = new Server();
        server.setOut(new PrintStream(new ByteArrayOutputStream()));
        server.runTool("-ifNotExists", "-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101");
        try {
            String url = "http://localhost:8182";
            WebClient client = new WebClient();
            String result = client.get(url);
            client.readSessionId(result);
            client.get(url, "login.jsp");
            client.get(url, "adminSave.do");
            result = client.get(url, "index.do?language=de");
            result = client.get(url, "login.jsp");
            this.assertContains(result, "Einstellung");
            result = client.get(url, "index.do?language=en");
            result = client.get(url, "login.jsp");
            this.assertTrue(result.indexOf("Einstellung") < 0);
            result = client.get(url, "test.do?driver=abc&url=jdbc:abc:mem: " + this.getTestName() + "&user=sa&password=sa&name=_test_");
            this.assertContains(result, "Exception");
            result = client.get(url, "test.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "&user=sa&password=sa&name=_test_");
            this.assertTrue(result.indexOf("Exception") < 0);
            result = client.get(url, "login.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "&user=sa&password=sa&name=_test_");
            result = client.get(url, "header.jsp");
            result = client.get(url, "query.do?sql=create table test(id int primary key, name varchar);insert into test values(1, 'Hello')");
            result = client.get(url, "query.do?sql=create sequence test_sequence");
            result = client.get(url, "query.do?sql=create schema test_schema");
            result = client.get(url, "query.do?sql=create view test_view as select * from test");
            result = client.get(url, "tables.do");
            result = client.get(url, "query.jsp");
            result = client.get(url, "query.do?sql=select * from test");
            this.assertContains(result, "Hello");
            result = client.get(url, "query.do?sql=select * from test");
            result = client.get(url, "query.do?sql=@META select * from test");
            this.assertContains(result, "typeName");
            result = client.get(url, "query.do?sql=delete from test");
            result = client.get(url, "query.do?sql=@LOOP 1000 insert into test values(?, 'Hello ' || ?/*RND*/)");
            this.assertContains(result, "1000 * (Prepared)");
            result = client.get(url, "query.do?sql=select * from test");
            result = client.get(url, "query.do?sql=@list select * from test");
            this.assertContains(result, "Row #");
            result = client.get(url, "query.do?sql=@parameter_meta select * from test where id = ?");
            this.assertContains(result, "INTEGER");
            result = client.get(url, "query.do?sql=@edit select * from test");
            this.assertContains(result, "editResult.do");
            result = client.get(url, "query.do?sql=" + StringUtils.urlEncode("select space(100001) a, 1 b"));
            this.assertContains(result, "...");
            result = client.get(url, "query.do?sql=" + StringUtils.urlEncode("call '<&>'"));
            this.assertContains(result, "&lt;&amp;&gt;");
            result = client.get(url, "query.do?sql=@HISTORY");
            result = client.get(url, "getHistory.do?id=4");
            this.assertContains(result, "select * from test");
            result = client.get(url, "query.do?sql=delete from test");
            result = client.get(url, "editResult.do?sql=@edit select * from test&op=1&row=-1&r-1c1=1&r-1c2=Hello");
            this.assertContains(result, "1");
            this.assertContains(result, "Hello");
            result = client.get(url, "editResult.do?sql=@edit select * from test&op=1&row=1&r1c1=1&r1c2=Hallo");
            this.assertContains(result, "1");
            this.assertContains(result, "Hallo");
            result = client.get(url, "query.do?sql=select * from test");
            this.assertContains(result, "1");
            this.assertContains(result, "Hallo");
            result = client.get(url, "editResult.do?sql=@edit select * from test&op=2&row=1");
            result = client.get(url, "query.do?sql=select * from test");
            this.assertContains(result, "no rows");
            result = client.get(url, "autoCompleteList.do?query=select 'abc");
            this.assertContains(StringUtils.urlDecode(result), "'");
            result = client.get(url, "autoCompleteList.do?query=select 'abc''");
            this.assertContains(StringUtils.urlDecode(result), "'");
            result = client.get(url, "autoCompleteList.do?query=select 'abc' ");
            this.assertContains(StringUtils.urlDecode(result), "||");
            result = client.get(url, "autoCompleteList.do?query=select 'abc' |");
            this.assertContains(StringUtils.urlDecode(result), "|");
            result = client.get(url, "autoCompleteList.do?query=select 'abc' || ");
            this.assertContains(StringUtils.urlDecode(result), "'");
            result = client.get(url, "autoCompleteList.do?query=call timestamp '2");
            this.assertContains(result, "20");
            result = client.get(url, "autoCompleteList.do?query=call time '1");
            this.assertContains(StringUtils.urlDecode(result), "12:00:00");
            result = client.get(url, "autoCompleteList.do?query=call timestamp '2001-01-01 12:00:00.");
            this.assertContains(result, "nanoseconds");
            result = client.get(url, "autoCompleteList.do?query=call timestamp '2001-01-01 12:00:00.00");
            this.assertContains(result, "nanoseconds");
            result = client.get(url, "autoCompleteList.do?query=call $$ hello world");
            this.assertContains(StringUtils.urlDecode(result), "$$");
            result = client.get(url, "autoCompleteList.do?query=alter index ");
            this.assertContains(StringUtils.urlDecode(result), "character");
            result = client.get(url, "autoCompleteList.do?query=alter index idx");
            this.assertContains(StringUtils.urlDecode(result), "character");
            result = client.get(url, "autoCompleteList.do?query=alter index \"IDX_");
            this.assertContains(StringUtils.urlDecode(result), "\"");
            result = client.get(url, "autoCompleteList.do?query=alter index \"IDX_\"\"");
            this.assertContains(StringUtils.urlDecode(result), "\"");
            result = client.get(url, "autoCompleteList.do?query=help ");
            this.assertContains(result, "anything");
            result = client.get(url, "autoCompleteList.do?query=help select");
            this.assertContains(result, "anything");
            result = client.get(url, "autoCompleteList.do?query=call ");
            this.assertContains(result, "0x");
            result = client.get(url, "autoCompleteList.do?query=call 0");
            this.assertContains(result, ".");
            result = client.get(url, "autoCompleteList.do?query=se");
            this.assertContains(result, "select");
            this.assertContains(result, "set");
            result = client.get(url, "tables.do");
            this.assertContains(result, "TEST");
            result = client.get(url, "autoCompleteList.do?query=select * from ");
            this.assertContains(result, "test");
            result = client.get(url, "autoCompleteList.do?query=select * from test t where t.");
            this.assertContains(result, "id");
            result = client.get(url, "autoCompleteList.do?query=select id x from test te where t");
            this.assertContains(result, "te");
            result = client.get(url, "autoCompleteList.do?query=select * from test where name = '");
            this.assertContains(StringUtils.urlDecode(result), "'");
            result = client.get(url, "autoCompleteList.do?query=select * from information_schema.columns where columns.");
            this.assertContains(result, "column_name");
            result = client.get(url, "query.do?sql=delete from test");
            result = client.get(url, "query.do?sql=@autocommit_true");
            this.assertContains(result, "Auto commit is now ON");
            result = client.get(url, "query.do?sql=@autocommit_false");
            this.assertContains(result, "Auto commit is now OFF");
            result = client.get(url, "query.do?sql=@cancel");
            this.assertContains(result, "There is currently no running statement");
            result = client.get(url, "query.do?sql=@generated insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<tr><th>ID</th></tr><tr><td>1</td></tr>");
            result = client.get(url, "query.do?sql=@generated(1) insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<tr><th>ID</th></tr><tr><td>2</td></tr>");
            result = client.get(url, "query.do?sql=@generated(1, 1) insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<tr><th>ID</th><th>ID</th></tr><tr><td>3</td><td>3</td></tr>");
            result = client.get(url, "query.do?sql=@generated(id) insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<tr><th>ID</th></tr><tr><td>4</td></tr>");
            result = client.get(url, "query.do?sql=@generated(id, id) insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<tr><th>ID</th><th>ID</th></tr><tr><td>5</td><td>5</td></tr>");
            result = client.get(url, "query.do?sql=@generated() insert into test(id) values(next value for test_sequence)");
            this.assertContains(result, "<table class=\"resultSet\" cellspacing=\"0\" cellpadding=\"0\"><tr></tr></table>");
            result = client.get(url, "query.do?sql=@maxrows 2000");
            this.assertContains(result, "Max rowcount is set");
            result = client.get(url, "query.do?sql=@password_hash user password");
            this.assertContains(result, "501cf5c163c184c26e62e76d25d441979f8f25dfd7a683484995b4a43a112fdf");
            result = client.get(url, "query.do?sql=@sleep 1");
            this.assertContains(result, "Ok");
            result = client.get(url, "query.do?sql=@catalogs");
            this.assertContains(result, "PUBLIC");
            result = client.get(url, "query.do?sql=@column_privileges null null TEST null");
            this.assertContains(result, "PRIVILEGE");
            result = client.get(url, "query.do?sql=@cross_references null null TEST null null TEST");
            this.assertContains(result, "PKTABLE_NAME");
            result = client.get(url, "query.do?sql=@exported_keys null null TEST");
            this.assertContains(result, "PKTABLE_NAME");
            result = client.get(url, "query.do?sql=@imported_keys null null TEST");
            this.assertContains(result, "PKTABLE_NAME");
            result = client.get(url, "query.do?sql=@primary_keys null null TEST");
            this.assertContains(result, "PK_NAME");
            result = client.get(url, "query.do?sql=@procedures null null null");
            this.assertContains(result, "PROCEDURE_NAME");
            result = client.get(url, "query.do?sql=@procedure_columns");
            this.assertContains(result, "PROCEDURE_NAME");
            result = client.get(url, "query.do?sql=@schemas");
            this.assertContains(result, "PUBLIC");
            result = client.get(url, "query.do?sql=@table_privileges");
            this.assertContains(result, "PRIVILEGE");
            result = client.get(url, "query.do?sql=@table_types");
            this.assertContains(result, "BASE TABLE");
            result = client.get(url, "query.do?sql=@type_info");
            this.assertContains(result, "CHARACTER LARGE OBJECT");
            result = client.get(url, "query.do?sql=@version_columns");
            this.assertContains(result, "PSEUDO_COLUMN");
            result = client.get(url, "query.do?sql=@attributes");
            this.assertContains(result, "ATTR_NAME");
            result = client.get(url, "query.do?sql=@super_tables");
            this.assertContains(result, "SUPERTABLE_NAME");
            result = client.get(url, "query.do?sql=@super_types");
            this.assertContains(result, "SUPERTYPE_NAME");
            result = client.get(url, "query.do?sql=@prof_start");
            this.assertContains(result, "Ok");
            result = client.get(url, "query.do?sql=@prof_stop");
            this.assertContains(result, "Top Stack Trace(s)");
            result = client.get(url, "query.do?sql=@best_row_identifier null null TEST");
            this.assertContains(result, "SCOPE");
            this.assertContains(result, "COLUMN_NAME");
            this.assertContains(result, "ID");
            result = client.get(url, "query.do?sql=@udts");
            this.assertContains(result, "CLASS_NAME");
            result = client.get(url, "query.do?sql=@udts null null null 1,2,3");
            this.assertContains(result, "CLASS_NAME");
            result = client.get(url, "query.do?sql=@LOOP 10 @STATEMENT insert into test values(?, 'Hello')");
            result = client.get(url, "query.do?sql=select * from test");
            this.assertContains(result, "8");
            result = client.get(url, "query.do?sql=@EDIT select * from test");
            this.assertContains(result, "editRow");
            result = client.get(url, "query.do?sql=@AUTOCOMMIT TRUE");
            result = client.get(url, "query.do?sql=@AUTOCOMMIT FALSE");
            result = client.get(url, "query.do?sql=@TRANSACTION_ISOLATION");
            result = client.get(url, "query.do?sql=@SET MAXROWS 1");
            result = client.get(url, "query.do?sql=select * from test order by id");
            result = client.get(url, "query.do?sql=@SET MAXROWS 1000");
            result = client.get(url, "query.do?sql=@TABLES");
            this.assertContains(result, "TEST");
            result = client.get(url, "query.do?sql=@COLUMNS null null TEST");
            this.assertContains(result, "ID");
            result = client.get(url, "query.do?sql=@INDEX_INFO null null TEST");
            this.assertContains(result, "PRIMARY");
            result = client.get(url, "query.do?sql=@CATALOG");
            this.assertContains(result, "PUBLIC");
            result = client.get(url, "query.do?sql=@MEMORY");
            this.assertContains(result, "Used");
            result = client.get(url, "query.do?sql=@INFO");
            this.assertContains(result, "getCatalog");
            result = client.get(url, "logout.do");
            result = client.get(url, "login.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "&user=sa&password=sa&name=_test_");
            result = client.get(url, "logout.do");
            result = client.get(url, "settingRemove.do?name=_test_");
            client.get(url, "admin.do");
        }
        finally {
            server.shutdown();
        }
    }

    private void testSpecialAutoComplete() throws Exception {
        Server server = new Server();
        server.setOut(new PrintStream(new ByteArrayOutputStream()));
        server.runTool("-ifNotExists", "-web", "-webPort", "8182", "-properties", "null", "-tcp", "-tcpPort", "9101");
        try {
            String url = "http://localhost:8182";
            WebClient client = new WebClient();
            String result = client.get(url);
            client.readSessionId(result);
            client.get(url, "login.jsp");
            result = client.get(url, "login.do?driver=org.h2.Driver&url=jdbc:h2:mem:" + this.getTestName() + "&user=sa&password=sa&name=_test_");
            result = client.get(url, "header.jsp");
            result = client.get(url, "query.do?sql=create schema test_schema;create schema \"quoted schema\";create table test_schema.test_table(id int primary key, name varchar);insert into test_schema.test_table values(1, 'Hello');create table \"quoted schema\".\"quoted tablename\"(id int primary key, name varchar);");
            result = client.get(url, "query.do?sql=create sequence test_schema.test_sequence");
            result = client.get(url, "query.do?sql=create view test_schema.test_view as select * from test");
            result = client.get(url, "tables.do");
            result = client.get(url, "query.jsp");
            result = client.get(url, "autoCompleteList.do?query=select * from test_schema.test");
            this.assertContains(StringUtils.urlDecode(result), "test_table");
            result = client.get(url, "autoCompleteList.do?query=select * from TEST");
            this.assertContains(StringUtils.urlDecode(result), "test_schema");
            result = client.get(url, "autoCompleteList.do?query=select * from \"TEST");
            this.assertContains(StringUtils.urlDecode(result), "test_schema");
            result = client.get(url, "autoCompleteList.do?query=select * from \"TEST_SCHEMA\".test");
            this.assertContains(StringUtils.urlDecode(result), "test_table");
            result = client.get(url, "autoCompleteList.do?query=select * from \"TEST_SCHEMA\".\"TEST");
            this.assertContains(StringUtils.urlDecode(result), "test_table");
            result = client.get(url, "autoCompleteList.do?query=select * from \"TEST_SCHEMA\".\"test");
            this.assertContains(StringUtils.urlDecode(result), "test_table");
            result = client.get(url, "autoCompleteList.do?query=select * from \"test_schema\".test");
            this.assertNotContaining(StringUtils.urlDecode(result), "test_table");
            result = client.get(url, "autoCompleteList.do?query=select * from \"test_schema\".");
            this.assertEmpty(StringUtils.urlDecode(result));
            result = client.get(url, "autoCompleteList.do?query=select * from \"TEST_SCHEMA\".\"test_table1");
            this.assertEmpty(StringUtils.urlDecode(result));
            result = client.get(url, "autoCompleteList.do?query=select * from \"quoted");
            this.assertContains(StringUtils.urlDecode(result), "quoted schema");
            result = client.get(url, "autoCompleteList.do?query=select * from quoted");
            this.assertContains(StringUtils.urlDecode(result), "quoted schema");
            result = client.get(url, "autoCompleteList.do?query=select * from \"quoted schema\".\"quoted");
            this.assertContains(StringUtils.urlDecode(result), "quoted tablename");
            result = client.get(url, "autoCompleteList.do?query=select * from \"quoted schema\".QUOTED");
            this.assertContains(StringUtils.urlDecode(result), "quoted tablename");
            result = client.get(url, "autoCompleteList.do?query=select * from \"quoted schema\".QUOTED1");
            this.assertNotContaining(StringUtils.urlDecode(result), "quoted tablename");
            result = client.get(url, "logout.do");
        }
        finally {
            server.shutdown();
        }
    }

    private void testStartWebServerWithConnection() throws Exception {
        String old = System.getProperty("h2.browser");
        try {
            System.setProperty("h2.browser", "call:" + TestWeb.class.getName() + ".openBrowser");
            Server.openBrowser("testUrl");
            this.assertEquals("testUrl", lastUrl);
            String oldUrl = lastUrl;
            final Connection conn = this.getConnection(this.getTestName());
            Task t = new Task(){

                @Override
                public void call() throws Exception {
                    Server.startWebServer(conn, true);
                }
            };
            t.execute();
            int i = 0;
            while (lastUrl == oldUrl) {
                if (i > 100) {
                    throw new Exception("Browser not started");
                }
                Thread.sleep(100L);
                ++i;
            }
            String url = lastUrl;
            WebClient client = new WebClient();
            client.readSessionId(url);
            url = client.getBaseUrl(url);
            try {
                client.get(url, "logout.do");
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            t.get();
            conn.close();
        }
        finally {
            if (old != null) {
                System.setProperty("h2.browser", old);
            } else {
                System.clearProperty("h2.browser");
            }
        }
    }

    public static void openBrowser(String url) {
        lastUrl = url;
    }

    static class TestHttpServletRequest
    implements HttpServletRequest {
        private String pathInfo;

        TestHttpServletRequest() {
        }

        void setPathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return new Vector().elements();
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return null;
        }

        public String getParameter(String name) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return null;
        }

        public Enumeration<String> getParameterNames() {
            return new Vector().elements();
        }

        public String[] getParameterValues(String name) {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        @Deprecated
        public String getRealPath(String path) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String name) {
            return null;
        }

        public String getScheme() {
            return "http";
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 80;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object value) {
        }

        public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String x) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return null;
        }

        public Enumeration<String> getHeaders(String name) {
            return null;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public HttpSession getSession(boolean x) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        @Deprecated
        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String x) {
            return false;
        }

        public Collection<Part> getParts() {
            return null;
        }

        public Part getPart(String name) {
            return null;
        }

        public boolean authenticate(HttpServletResponse response) {
            return false;
        }

        public void login(String username, String password) {
        }

        public void logout() {
        }

        public ServletContext getServletContext() {
            return null;
        }

        public AsyncContext startAsync() {
            return null;
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public long getContentLengthLong() {
            return 0L;
        }

        public String changeSessionId() {
            return null;
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
            return null;
        }
    }

    static class TestHttpServletResponse
    implements HttpServletResponse {
        ServletOutputStream servletOutputStream;

        TestHttpServletResponse() {
        }

        void setServletOutputStream(ServletOutputStream servletOutputStream) {
            this.servletOutputStream = servletOutputStream;
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 0;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.servletOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int arg0) {
        }

        public void setCharacterEncoding(String arg0) {
        }

        public void setContentLength(int arg0) {
        }

        public void setContentLengthLong(long arg0) {
        }

        public void setContentType(String arg0) {
        }

        public void setLocale(Locale arg0) {
        }

        public void addCookie(Cookie arg0) {
        }

        public void addDateHeader(String arg0, long arg1) {
        }

        public void addHeader(String arg0, String arg1) {
        }

        public void addIntHeader(String arg0, int arg1) {
        }

        public boolean containsHeader(String arg0) {
            return false;
        }

        public String encodeRedirectURL(String arg0) {
            return null;
        }

        @Deprecated
        public String encodeRedirectUrl(String arg0) {
            return null;
        }

        public String encodeURL(String arg0) {
            return null;
        }

        @Deprecated
        public String encodeUrl(String arg0) {
            return null;
        }

        public void sendError(int arg0) throws IOException {
        }

        public void sendError(int arg0, String arg1) throws IOException {
        }

        public void sendRedirect(String arg0) throws IOException {
        }

        public void setDateHeader(String arg0, long arg1) {
        }

        public void setHeader(String arg0, String arg1) {
        }

        public void setIntHeader(String arg0, int arg1) {
        }

        public void setStatus(int arg0) {
        }

        @Deprecated
        public void setStatus(int arg0, String arg1) {
        }

        public int getStatus() {
            return 0;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }
    }

    static class TestServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream buff = new ByteArrayOutputStream();

        TestServletOutputStream() {
        }

        public void write(int b) throws IOException {
            this.buff.write(b);
        }

        public String toString() {
            return this.buff.toString(StandardCharsets.UTF_8);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

