/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.server;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.h2.util.IOUtils;

public class WebClient {
    private String sessionId;
    private String acceptLanguage;
    private String contentType;

    String get(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod("GET");
        conn.setInstanceFollowRedirects(true);
        if (this.acceptLanguage != null) {
            conn.setRequestProperty("accept-language", this.acceptLanguage);
        }
        conn.connect();
        int code = conn.getResponseCode();
        this.contentType = conn.getContentType();
        if (code != 200) {
            throw new IOException("Result code: " + code);
        }
        InputStream in = conn.getInputStream();
        String result = IOUtils.readStringAndClose(new InputStreamReader(in), -1);
        conn.disconnect();
        return result;
    }

    String upload(String url, String fileName, InputStream in) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Keep-Alive");
        String boundary = UUID.randomUUID().toString();
        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
        conn.connect();
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes("--" + boundary + "--\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"upload\"; filename=\"" + fileName + "\"\r\n\r\n");
        IOUtils.copyAndCloseInput(in, out);
        out.writeBytes("\r\n--" + boundary + "--\r\n");
        out.close();
        int code = conn.getResponseCode();
        if (code != 200) {
            throw new IOException("Result code: " + code);
        }
        in = conn.getInputStream();
        String result = IOUtils.readStringAndClose(new InputStreamReader(in), -1);
        conn.disconnect();
        return result;
    }

    void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    String getContentType() {
        return this.contentType;
    }

    String readSessionId(String url) {
        int idx = url.indexOf("jsessionid=");
        String id = url.substring(idx + "jsessionid=".length());
        int i = 0;
        while (i < id.length()) {
            char ch = id.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                id = id.substring(0, i);
                break;
            }
            ++i;
        }
        this.sessionId = id;
        return id;
    }

    String get(String url, String page) throws IOException {
        if (this.sessionId != null) {
            page = ((String)page).indexOf(63) < 0 ? (String)page + "?" : (String)page + "&";
            page = (String)page + "jsessionid=" + this.sessionId;
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + (String)page;
        return this.get((String)url);
    }

    String getBaseUrl(String url) {
        int idx = url.indexOf("//");
        if ((idx = url.indexOf(47, idx + 2)) >= 0) {
            return url.substring(0, idx);
        }
        return url;
    }
}

