/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.security.AES;

public class CalculateHashConstantLong
implements Runnable {
    private static BitSet primeNumbers = new BitSet();
    private static long[] randomValues;
    private static AtomicInteger high;
    private static Set<Long> candidates;
    private long constant;
    private int[] fromTo = new int[4096];
    private final AES aes = new AES();
    private final byte[] data;

    static {
        high = new AtomicInteger(32);
        candidates = Collections.synchronizedSet(new HashSet());
    }

    public CalculateHashConstantLong() {
        this.aes.setKey("Hello World Hallo Welt".getBytes());
        this.data = new byte[16];
    }

    public static void main(String ... args) throws Exception {
        int i = 0;
        while (i < 65536) {
            if (BigInteger.valueOf(i).isProbablePrime(20)) {
                primeNumbers.set(i);
            }
            ++i;
        }
        randomValues = CalculateHashConstantLong.getRandomValues(1000, 1);
        Random r = new Random(1L);
        int i2 = 0;
        while (i2 < randomValues.length) {
            CalculateHashConstantLong.randomValues[i2] = r.nextInt();
            ++i2;
        }
        CalculateHashConstantLong.printQuality(new CalculateHashConstantLong(){

            @Override
            public long hash(long x) {
                return this.secureHash(x);
            }

            public String toString() {
                return "AES";
            }
        }, randomValues);
        CalculateHashConstantLong.printQuality(new CalculateHashConstantLong(){

            @Override
            public long hash(long x) {
                x = (x ^ x >>> 30) * -4658895280553007687L;
                x = (x ^ x >>> 27) * -7723592293110705685L;
                return x ^ x >>> 31;
            }

            public String toString() {
                return "Test";
            }
        }, randomValues);
        Thread[] threads = new Thread[8];
        int i3 = 0;
        while (i3 < 8) {
            threads[i3] = new Thread(new CalculateHashConstantLong());
            threads[i3].start();
            ++i3;
        }
        i3 = 0;
        while (i3 < 8) {
            threads[i3].join();
            ++i3;
        }
        int finalCount = 10000;
        long[] randomValues = CalculateHashConstantLong.getRandomValues(finalCount, 10);
        CalculateHashConstantLong test = new CalculateHashConstantLong();
        long best = 0L;
        int dist = Integer.MAX_VALUE;
        Iterator<Long> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            long i4;
            test.constant = i4 = iterator.next().longValue();
            System.out.println();
            System.out.println("Constant: 0x" + Long.toHexString(i4));
            int[] minMax = test.getDependencies(test, randomValues);
            System.out.println("Dependencies: " + minMax[0] + ".." + minMax[1]);
            int d = minMax[1] - minMax[0];
            int av = 0;
            int j = 0;
            while (j < 100) {
                av += test.getAvalanche(test, randomValues[j]);
                ++j;
            }
            System.out.println("AvalancheSum: " + av);
            minMax = test.getEffect(test, finalCount * 10, 11);
            System.out.println("Effect: " + minMax[0] + ".." + minMax[1]);
            if ((d += minMax[1] - minMax[0]) >= dist) continue;
            dist = d;
            best = i4;
        }
        System.out.println();
        System.out.println("Best constant: 0x" + Long.toHexString(best));
        test.constant = best;
        long collisions = test.getCollisionCount();
        System.out.println("Collisions: " + collisions);
    }

    private static void printQuality(CalculateHashConstantLong test, long[] randomValues) {
        int finalCount = randomValues.length * 10;
        System.out.println("Quality of " + String.valueOf(test));
        int av = 0;
        int[] minMax = test.getDependencies(test, randomValues);
        System.out.println("Dependencies: " + minMax[0] + ".." + minMax[1]);
        av = 0;
        int j = 0;
        while (j < 100) {
            av += test.getAvalanche(test, randomValues[j]);
            ++j;
        }
        System.out.println("Avalanche: " + av / 100);
        System.out.println("AvalancheSum: " + av);
        minMax = test.getEffect(test, finalCount * 10, 11);
        System.out.println("Effect: " + minMax[0] + ".." + minMax[1]);
        System.out.println("ok=" + test.testCandidate());
    }

    void storeRandomFile() throws Exception {
        File f = new File(System.getProperty("user.home") + "/temp/rand.txt");
        FileOutputStream out = new FileOutputStream(f);
        CalculateHashConstantLong test = new CalculateHashConstantLong();
        byte[] buff = new byte[8];
        int i = 0;
        while (i < 1250000) {
            long y = test.hash(i);
            CalculateHashConstantLong.writeLong(buff, 0, y);
            out.write(buff);
            ++i;
        }
        out.close();
    }

    private static long[] getRandomValues(int count, int seed) {
        long[] values = new long[count];
        Random r = new Random(seed);
        int i = 0;
        while (i < count) {
            values[i] = r.nextLong();
            ++i;
        }
        return values;
    }

    @Override
    public void run() {
        int currentHigh;
        while ((currentHigh = high.getAndIncrement()) <= 65535) {
            System.out.println("testing " + Integer.toHexString(currentHigh) + "....");
            this.addCandidates(currentHigh);
        }
    }

    private void addCandidates(long currentHigh) {
        int low = 0;
        while (low <= 65535) {
            if (primeNumbers.get(low)) {
                long i;
                this.constant = i = currentHigh << 48 | (long)low << 32 | currentHigh << 16 | (long)low;
                if (this.testCandidate()) {
                    System.out.println(Long.toHexString(i) + " hit " + i);
                    candidates.add(i);
                }
            }
            ++low;
        }
    }

    private boolean testCandidate() {
        int av = this.getAvalanche(this, 0L);
        if (Math.abs(av - 32000) > 1000) {
            return false;
        }
        av = this.getAvalanche(this, -1L);
        if (Math.abs(av - 32000) > 1000) {
            return false;
        }
        long es = this.getEffectSquare(this, randomValues);
        if (es > 1100000L) {
            System.out.println("fail at a " + es);
            return false;
        }
        int[] minMax = this.getEffect(this, 10000, 1);
        if (!CalculateHashConstantLong.isWithin(4700, 5300, minMax)) {
            System.out.println("fail at b " + minMax[0] + " " + minMax[1]);
            return false;
        }
        minMax = this.getDependencies(this, randomValues);
        if (!CalculateHashConstantLong.isWithin(14500, 17000, minMax)) {
            System.out.println("fail at c " + minMax[0] + " " + minMax[1]);
            return false;
        }
        return true;
    }

    long getCollisionCount() {
        return 0L;
    }

    private static boolean isWithin(int min, int max, int[] range) {
        return range[0] >= min && range[1] <= max;
    }

    int[] getDependencies(CalculateHashConstantLong h, long[] values) {
        Arrays.fill(this.fromTo, 0);
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long x = lArray[n2];
            int shift = 0;
            while (shift < 64) {
                long x1 = h.hash(x);
                long x2 = h.hash(x ^ 1L << shift);
                long x3 = x1 ^ x2;
                int s = 0;
                while (s < 64) {
                    if ((x3 & 1L << s) != 0L) {
                        int s2 = 0;
                        while (s2 < 64) {
                            if (s != s2 && (x3 & 1L << s2) != 0L) {
                                int n3 = s * 64 + s2;
                                this.fromTo[n3] = this.fromTo[n3] + 1;
                            }
                            ++s2;
                        }
                    }
                    ++s;
                }
                ++shift;
            }
            ++n2;
        }
        int a = Integer.MAX_VALUE;
        int b = Integer.MIN_VALUE;
        int[] nArray = this.fromTo;
        int n4 = this.fromTo.length;
        n = 0;
        while (n < n4) {
            int x = nArray[n];
            if (x != 0) {
                if (x < a) {
                    a = x;
                }
                if (x > b) {
                    b = x;
                }
            }
            ++n;
        }
        return new int[]{a, b};
    }

    int getAvalanche(CalculateHashConstantLong h, long value) {
        int changedBitsSum = 0;
        int i = 0;
        while (i < 64) {
            long x = value ^ 1L << i;
            int shift = 0;
            while (shift < 64) {
                long x1 = h.hash(x);
                long x2 = h.hash(x ^ 1L << shift);
                long x3 = x1 ^ x2;
                changedBitsSum += Long.bitCount(x3);
                ++shift;
            }
            ++i;
        }
        return changedBitsSum * 1000 / 64 / 64;
    }

    long getEffectSquare(CalculateHashConstantLong h, long[] values) {
        Arrays.fill(this.fromTo, 0);
        int total = 0;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long x = lArray[n2];
            int shift = 0;
            while (shift < 64) {
                long x1 = h.hash(x);
                long x2 = h.hash(x ^ 1L << shift);
                long x3 = x1 ^ x2;
                int s = 0;
                while (s < 64) {
                    if ((x3 & 1L << s) != 0L) {
                        int n3 = shift * 64 + s;
                        this.fromTo[n3] = this.fromTo[n3] + 1;
                        ++total;
                    }
                    ++s;
                }
                ++shift;
            }
            ++n2;
        }
        long sqDist = 0L;
        int expected = total / 64 / 64;
        int[] nArray = this.fromTo;
        int n4 = this.fromTo.length;
        int n5 = 0;
        while (n5 < n4) {
            int x = nArray[n5];
            int dist = Math.abs(x - expected);
            sqDist += (long)(dist * dist);
            ++n5;
        }
        return sqDist;
    }

    int[] getEffect(CalculateHashConstantLong h, int count, int seed) {
        Random r = new Random();
        r.setSeed(seed);
        Arrays.fill(this.fromTo, 0);
        int i = 0;
        while (i < count) {
            long x = r.nextLong();
            int shift = 0;
            while (shift < 64) {
                long x1 = h.hash(x);
                long x2 = h.hash(x ^ 1L << shift);
                long x3 = x1 ^ x2;
                int s = 0;
                while (s < 64) {
                    if ((x3 & 1L << s) != 0L) {
                        int n = shift * 64 + s;
                        this.fromTo[n] = this.fromTo[n] + 1;
                    }
                    ++s;
                }
                ++shift;
            }
            ++i;
        }
        int a = Integer.MAX_VALUE;
        int b = Integer.MIN_VALUE;
        int[] nArray = this.fromTo;
        int n = this.fromTo.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            if (x < a) {
                a = x;
            }
            if (x > b) {
                b = x;
            }
            ++n2;
        }
        return new int[]{a, b};
    }

    long hash(long x) {
        x = (x >>> 32 ^ x) * this.constant;
        x = (x >>> 32 ^ x) * this.constant;
        x = x >>> 32 ^ x;
        return x;
    }

    long secureHash(long x) {
        CalculateHashConstantLong.writeLong(this.data, 0, x);
        this.aes.encrypt(this.data, 0, 16);
        return CalculateHashConstantLong.readLong(this.data, 0);
    }

    private static void writeLong(byte[] buff, int pos, long x) {
        CalculateHashConstantLong.writeInt(buff, pos, (int)(x >>> 32));
        CalculateHashConstantLong.writeInt(buff, pos + 4, (int)x);
    }

    private static void writeInt(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)x;
    }

    private static long readLong(byte[] buff, int pos) {
        return (long)CalculateHashConstantLong.readInt(buff, pos) << 32 | (long)CalculateHashConstantLong.readInt(buff, pos + 4) & 0xFFFFFFFFL;
    }

    private static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }
}

