/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.ArrayList;
import java.util.List;
import org.h2.mvstore.DataUtils;
import org.h2.util.MathUtils;

public class FreeSpaceList {
    private final int firstFreeBlock;
    private final int blockSize;
    private List<BlockRange> freeSpaceList = new ArrayList<BlockRange>();

    public FreeSpaceList(int firstFreeBlock, int blockSize) {
        this.firstFreeBlock = firstFreeBlock;
        if (Integer.bitCount(blockSize) != 1) {
            throw DataUtils.newIllegalArgumentException("Block size is not a power of 2", new Object[0]);
        }
        this.blockSize = blockSize;
        this.clear();
    }

    public synchronized void clear() {
        this.freeSpaceList.clear();
        this.freeSpaceList.add(new BlockRange(this.firstFreeBlock, Integer.MAX_VALUE - this.firstFreeBlock));
    }

    public synchronized long allocate(int length) {
        int required = this.getBlockCount(length);
        for (BlockRange pr : this.freeSpaceList) {
            if (pr.length < required) continue;
            int result = pr.start;
            this.markUsed(pr.start * this.blockSize, length);
            return result * this.blockSize;
        }
        throw DataUtils.newMVStoreException(3, "Could not find a free page to allocate", new Object[0]);
    }

    public synchronized void markUsed(long pos, int length) {
        int start = (int)(pos / (long)this.blockSize);
        int required = this.getBlockCount(length);
        BlockRange found = null;
        int i = 0;
        for (BlockRange pr : this.freeSpaceList) {
            if (start >= pr.start && start < pr.start + pr.length) {
                found = pr;
                break;
            }
            ++i;
        }
        if (found == null) {
            throw DataUtils.newMVStoreException(3, "Cannot find spot to mark as used in free list", new Object[0]);
        }
        if (start + required > found.start + found.length) {
            throw DataUtils.newMVStoreException(3, "Runs over edge of free space", new Object[0]);
        }
        if (found.start == start) {
            found.start += required;
            found.length -= required;
            if (found.length == 0) {
                this.freeSpaceList.remove(i);
            }
        } else if (found.start + found.length == start + required) {
            found.length -= required;
        } else {
            int length1 = start - found.start;
            int start2 = start + required;
            int length2 = found.start + found.length - start - required;
            found.length = length1;
            BlockRange newRange = new BlockRange(start2, length2);
            this.freeSpaceList.add(i + 1, newRange);
        }
    }

    public synchronized void free(long pos, int length) {
        BlockRange previous;
        int start = (int)(pos / (long)this.blockSize);
        int required = this.getBlockCount(length);
        BlockRange found = null;
        int i = 0;
        for (BlockRange pr : this.freeSpaceList) {
            if (pr.start > start) {
                found = pr;
                break;
            }
            ++i;
        }
        if (found == null) {
            throw DataUtils.newMVStoreException(3, "Cannot find spot to mark as unused in free list", new Object[0]);
        }
        if (start + required == found.start) {
            found.start = start;
            found.length += required;
            if (i > 0) {
                previous = this.freeSpaceList.get(i - 1);
                if (previous.start + previous.length == found.start) {
                    previous.length += found.length;
                    this.freeSpaceList.remove(i);
                }
            }
            return;
        }
        if (i > 0) {
            previous = this.freeSpaceList.get(i - 1);
            if (previous.start + previous.length == start) {
                previous.length += required;
                return;
            }
        }
        BlockRange newRange = new BlockRange(start, required);
        this.freeSpaceList.add(i, newRange);
    }

    private int getBlockCount(int length) {
        if (length <= 0) {
            throw DataUtils.newMVStoreException(3, "Free space invalid length", new Object[0]);
        }
        return MathUtils.roundUpInt(length, this.blockSize) / this.blockSize;
    }

    public String toString() {
        return this.freeSpaceList.toString();
    }

    private static final class BlockRange {
        int start;
        int length;

        public BlockRange(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public String toString() {
            if (this.start + this.length == Integer.MAX_VALUE) {
                return Integer.toHexString(this.start) + "-";
            }
            return Integer.toHexString(this.start) + "-" + Integer.toHexString(this.start + this.length - 1);
        }
    }
}

