/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.h2.dev.cache.CacheLIRS;
import org.h2.test.TestBase;

public class TestCacheLIRS
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testCache();
    }

    private void testCache() {
        TestCacheLIRS.testRandomSmallCache();
        this.testEdgeCases();
        this.testSize();
        this.testClear();
        this.testGetPutPeekRemove();
        this.testPruneStack();
        this.testLimitHot();
        this.testLimitNonResident();
        this.testBadHashMethod();
        this.testLimitMemory();
        this.testScanResistance();
        this.testRandomOperations();
    }

    private static void testRandomSmallCache() {
        Random r = new Random(1L);
        int i = 0;
        while (i < 10000) {
            int j = 0;
            StringBuilder buff = new StringBuilder();
            CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(1 + r.nextInt(10));
            while (j < 30) {
                int key = r.nextInt(5);
                switch (r.nextInt(3)) {
                    case 0: {
                        int memory = r.nextInt(5) + 1;
                        buff.append("add ").append(key).append(' ').append(memory).append('\n');
                        test.put(key, j, memory);
                        break;
                    }
                    case 1: {
                        buff.append("remove ").append(key).append('\n');
                        test.remove(key);
                        break;
                    }
                    case 2: {
                        buff.append("get ").append(key).append('\n');
                        test.get(key);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void testEdgeCases() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(1);
        test.put(1, 10, 100);
        this.assertEquals(0, test.size());
        this.assertThrows(NullPointerException.class, () -> test.put(null, 10, 100));
        this.assertThrows(NullPointerException.class, () -> test.put(1, null, 100));
        this.assertThrows(IllegalArgumentException.class, () -> test.setMaxMemory(0L));
    }

    private void testSize() {
        this.verifyMapSize(7, 16);
        this.verifyMapSize(13, 32);
        this.verifyMapSize(25, 64);
        this.verifyMapSize(49, 128);
        this.verifyMapSize(97, 256);
        this.verifyMapSize(193, 512);
        this.verifyMapSize(385, 1024);
        this.verifyMapSize(769, 2048);
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(1000);
        int j = 0;
        while (j < 2000) {
            test.put(j, j);
            ++j;
        }
        this.assertEquals(62, test.size() - test.sizeHot());
        this.assertEquals(968, test.sizeNonResident());
    }

    private void verifyMapSize(int elements, int expectedMapSize) {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(elements - 1);
        int i = 0;
        while (i < elements - 1) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertTrue(test.sizeMapArray() + "<" + expectedMapSize, test.sizeMapArray() < expectedMapSize);
        test = TestCacheLIRS.createCache(elements);
        i = 0;
        while (i < elements + 1) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertEquals(expectedMapSize, test.sizeMapArray());
        test = TestCacheLIRS.createCache(elements * 2);
        i = 0;
        while (i < elements * 2) {
            test.put(i, i * 10);
            ++i;
        }
        this.assertTrue(test.sizeMapArray() + ">" + expectedMapSize, test.sizeMapArray() > expectedMapSize);
    }

    private void testGetPutPeekRemove() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(4);
        test.put(1, 10);
        test.put(2, 20);
        test.put(3, 30);
        this.assertNull(test.peek(4));
        this.assertNull(test.get(4));
        test.put(4, 40);
        this.verify(test, "mem: 4 stack: 4 3 2 1 cold: non-resident:");
        this.assertEquals(30, (int)((Integer)test.get(3)));
        this.assertEquals(20, (int)((Integer)test.get(2)));
        this.assertEquals(20, (int)((Integer)test.peek(2)));
        this.assertEquals(20, (int)((Integer)test.get(2)));
        this.assertEquals(10, (int)((Integer)test.peek(1)));
        this.assertEquals(10, (int)((Integer)test.get(1)));
        this.verify(test, "mem: 4 stack: 1 2 3 4 cold: non-resident:");
        test.put(3, 30);
        this.verify(test, "mem: 4 stack: 3 1 2 4 cold: non-resident:");
        test.put(5, 50);
        this.verify(test, "mem: 4 stack: 5 3 1 2 cold: 5 non-resident: 4");
        this.assertEquals(1, test.getMemory(1));
        this.assertEquals(1, test.getMemory(5));
        this.assertEquals(0, test.getMemory(4));
        this.assertEquals(0, test.getMemory(100));
        this.assertNull(test.peek(4));
        this.assertNull(test.get(4));
        this.assertEquals(10, (int)((Integer)test.get(1)));
        this.assertEquals(20, (int)((Integer)test.get(2)));
        this.assertEquals(30, (int)((Integer)test.get(3)));
        this.verify(test, "mem: 4 stack: 3 2 1 cold: 5 non-resident: 4");
        this.assertEquals(50, (int)((Integer)test.get(5)));
        this.verify(test, "mem: 4 stack: 5 3 2 1 cold: 5 non-resident: 4");
        this.assertEquals(50, (int)((Integer)test.get(5)));
        this.verify(test, "mem: 4 stack: 5 3 2 cold: 1 non-resident: 4");
        this.assertEquals(50, (int)((Integer)test.remove(5)));
        this.assertNull(test.remove(5));
        this.verify(test, "mem: 3 stack: 3 2 1 cold: non-resident: 4");
        this.assertNull(test.remove(4));
        this.verify(test, "mem: 3 stack: 3 2 1 cold: non-resident:");
        this.assertNull(test.remove(4));
        this.verify(test, "mem: 3 stack: 3 2 1 cold: non-resident:");
        test.put(4, 40);
        test.put(5, 50);
        this.verify(test, "mem: 4 stack: 5 4 3 2 cold: 5 non-resident: 1");
        test.get(5);
        test.get(2);
        test.get(3);
        test.get(4);
        this.verify(test, "mem: 4 stack: 4 3 2 5 cold: 2 non-resident: 1");
        this.assertEquals(50, (int)((Integer)test.remove(5)));
        this.verify(test, "mem: 3 stack: 4 3 2 cold: non-resident: 1");
        this.assertEquals(20, (int)((Integer)test.remove(2)));
        this.assertFalse(test.containsKey(1));
        this.assertNull(test.remove(1));
        this.assertFalse(test.containsKey(1));
        this.verify(test, "mem: 2 stack: 4 3 cold: non-resident:");
        test.put(1, 10);
        test.put(2, 20);
        this.verify(test, "mem: 4 stack: 2 1 4 3 cold: non-resident:");
        test.get(1);
        test.get(3);
        test.get(4);
        this.verify(test, "mem: 4 stack: 4 3 1 2 cold: non-resident:");
        this.assertEquals(10, (int)((Integer)test.remove(1)));
        this.verify(test, "mem: 3 stack: 4 3 2 cold: non-resident:");
        test.remove(2);
        test.remove(3);
        test.remove(4);
        test.clear();
        this.verify(test, "mem: 0 stack: cold: non-resident:");
        test.put(1, 10);
        test.put(2, 20);
        test.put(3, 30);
        test.put(4, 40);
        test.put(5, 50);
        this.assertTrue(test.containsValue(50));
        this.verify(test, "mem: 4 stack: 5 4 3 2 cold: 5 non-resident: 1");
        test.put(1, 10);
        this.verify(test, "mem: 4 stack: 1 5 4 3 2 cold: 1 non-resident: 5");
        this.assertFalse(test.containsValue(50));
        test.remove(2);
        test.remove(3);
        test.remove(4);
        this.verify(test, "mem: 1 stack: 1 cold: non-resident: 5");
        this.assertTrue(test.containsKey(1));
        test.remove(1);
        this.assertFalse(test.containsKey(1));
        this.verify(test, "mem: 0 stack: cold: non-resident: 5");
        this.assertFalse(test.containsKey(5));
        this.assertTrue(test.isEmpty());
        test.clear();
        test.put(1, 10);
        test.put(2, 20);
        test.put(3, 30);
        test.put(4, 40);
        test.put(5, 50);
        test.get(4);
        test.get(3);
        this.verify(test, "mem: 4 stack: 3 4 5 2 cold: 5 non-resident: 1");
        test.put(6, 60);
        this.verify(test, "mem: 4 stack: 6 3 4 5 2 cold: 6 non-resident: 5 1");
        test.get(6);
        this.verify(test, "mem: 4 stack: 6 3 4 cold: 2 non-resident: 5 1");
    }

    private void testPruneStack() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(5);
        int i = 0;
        while (i < 7) {
            test.put(i, i * 10);
            ++i;
        }
        this.verify(test, "mem: 5 stack: 6 5 4 3 2 1 cold: 6 non-resident: 5 0");
        test.get(4);
        test.get(3);
        test.get(2);
        this.verify(test, "mem: 5 stack: 2 3 4 6 5 1 cold: 6 non-resident: 5 0");
        test.remove(1);
        this.verify(test, "mem: 4 stack: 2 3 4 6 cold: non-resident: 5 0");
        test.put(0, 0);
        test.put(1, 10);
        this.verify(test, "mem: 5 stack: 1 0 2 3 4 cold: 1 non-resident: 6 5");
    }

    private void testClear() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(40);
        int i = 0;
        while (i < 5) {
            test.put(i, 10 * i, 9);
            ++i;
        }
        this.verify(test, "mem: 36 stack: 4 3 2 1 cold: 4 non-resident: 0");
        for (Map.Entry e : test.entrySet()) {
            this.assertTrue((Integer)e.getKey() >= 1 && (Integer)e.getKey() <= 4);
            this.assertTrue((Integer)e.getValue() >= 10 && (Integer)e.getValue() <= 40);
        }
        Iterator iterator = test.values().iterator();
        while (iterator.hasNext()) {
            int x = (Integer)((Object)iterator.next());
            this.assertTrue(x >= 10 && x <= 40);
        }
        iterator = test.keySet().iterator();
        while (iterator.hasNext()) {
            int x = (Integer)((Object)iterator.next());
            this.assertTrue(x >= 1 && x <= 4);
        }
        this.assertEquals(40L, test.getMaxMemory());
        this.assertEquals(36L, test.getUsedMemory());
        this.assertEquals(4, test.size());
        this.assertEquals(3, test.sizeHot());
        this.assertEquals(1, test.sizeNonResident());
        this.assertFalse(test.isEmpty());
        test.setMaxMemory(10L);
        this.assertEquals(10L, test.getMaxMemory());
        test.setMaxMemory(40L);
        this.verify(test, "mem: 36 stack: 4 3 2 1 cold: 4 non-resident: 0");
        test.putAll(test);
        this.verify(test, "mem: 4 stack: 4 3 2 1 cold: non-resident: 0");
        test.clear();
        this.verify(test, "mem: 0 stack: cold: non-resident:");
        this.assertEquals(40L, test.getMaxMemory());
        this.assertEquals(0L, test.getUsedMemory());
        this.assertEquals(0, test.size());
        this.assertEquals(0, test.sizeHot());
        this.assertEquals(0, test.sizeNonResident());
        this.assertTrue(test.isEmpty());
    }

    private void testLimitHot() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(100);
        int i = 0;
        while (i < 300) {
            test.put(i, 10 * i);
            ++i;
        }
        this.assertEquals(100, test.size());
        this.assertEquals(99, test.sizeNonResident());
        this.assertEquals(93, test.sizeHot());
    }

    private void testLimitNonResident() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(4);
        int i = 0;
        while (i < 20) {
            test.put(i, 10 * i);
            ++i;
        }
        this.verify(test, "mem: 4 stack: 19 18 17 16 3 2 1 cold: 19 non-resident: 18 17 16");
    }

    private void testBadHashMethod() {
        int size = 4;
        class BadHash {
            int x;

            BadHash(int x) {
                this.x = x;
            }

            public int hashCode() {
                return (this.x & 1) * 4 * 2;
            }

            public boolean equals(Object o) {
                return ((BadHash)o).x == this.x;
            }

            public String toString() {
                return "" + this.x;
            }
        }
        CacheLIRS<BadHash, Integer> test = TestCacheLIRS.createCache(8);
        int i = 0;
        while (i < 4) {
            test.put(new BadHash(i), i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (i % 3 == 0) {
                this.assertEquals(i, (int)((Integer)test.remove(new BadHash(i))));
                this.assertNull(test.remove(new BadHash(i)));
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (i % 3 == 0) {
                this.assertNull(test.get(new BadHash(i)));
            } else {
                this.assertEquals(i, (int)((Integer)test.get(new BadHash(i))));
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            test.put(new BadHash(i), i);
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (i % 3 == 0) {
                this.assertEquals(i, (int)((Integer)test.remove(new BadHash(i))));
                this.assertNull(test.remove(new BadHash(i)));
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (i % 3 == 0) {
                this.assertNull(test.get(new BadHash(i)));
            } else {
                this.assertEquals(i, (int)((Integer)test.get(new BadHash(i))));
            }
            ++i;
        }
    }

    private void testLimitMemory() {
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(4);
        int i = 0;
        while (i < 5) {
            test.put(i, 10 * i, 1);
            ++i;
        }
        this.verify(test, "mem: 4 stack: 4 3 2 1 cold: 4 non-resident: 0");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= 4L);
        test.put(6, 60, 3);
        this.verify(test, "mem: 4 stack: 6 3 cold: 6 non-resident:");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= 4L);
        test.put(7, 70, 3);
        this.verify(test, "mem: 4 stack: 7 6 3 cold: 7 non-resident: 6");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= 4L);
        test.put(8, 80, 4);
        this.verify(test, "mem: 4 stack: 8 cold: non-resident:");
        this.assertTrue("" + test.getUsedMemory(), test.getUsedMemory() <= 4L);
    }

    private void testScanResistance() {
        Integer x;
        boolean log = false;
        int size = 20;
        CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(size / 2 + 1);
        int i = 0;
        while (i < size) {
            test.put(-i, -i * 10);
            ++i;
        }
        this.verify(test, null);
        i = 0;
        while (i < size / 2) {
            test.put(i, i * 10);
            test.get(i);
            if (log) {
                System.out.println("get " + i + " -> " + String.valueOf(test));
            }
            ++i;
        }
        this.verify(test, null);
        i = 0;
        while (i < size) {
            x = (Integer)test.get(i);
            Integer y = (Integer)test.peek(i);
            if (i < size / 2) {
                this.assertNotNull("i: " + i, x);
                this.assertNotNull("i: " + i, y);
                this.assertEquals(i * 10, (int)x);
                this.assertEquals(i * 10, (int)y);
            } else {
                this.assertNull(x);
                this.assertNull(y);
                test.put(i, i * 10);
                this.assertEquals(i * 10, (int)((Integer)test.peek(i)));
            }
            if (log) {
                System.out.println("get " + i + " -> " + String.valueOf(test));
            }
            this.verify(test, null);
            ++i;
        }
        i = 0;
        while (i < size) {
            x = (Integer)test.get(i);
            if (i < size / 2 || i == size - 1) {
                this.assertNotNull("i: " + i, x);
                this.assertEquals(i * 10, (int)x);
            } else {
                this.assertNull(x);
            }
            this.verify(test, null);
            ++i;
        }
    }

    private void testRandomOperations() {
        boolean log = false;
        int size = 10;
        Random r = new Random(1L);
        int j = 0;
        while (j < 100) {
            CacheLIRS<Integer, Integer> test = TestCacheLIRS.createCache(size / 2);
            HashMap<Integer, Integer> good = new HashMap<Integer, Integer>();
            int i = 0;
            while (i < 10000) {
                int key = r.nextInt(size);
                int value = r.nextInt();
                switch (r.nextInt(3)) {
                    case 0: {
                        if (log) {
                            System.out.println(i + " put " + key + " " + value);
                        }
                        good.put(key, value);
                        test.put(key, value);
                        break;
                    }
                    case 1: {
                        if (log) {
                            System.out.println(i + " get " + key);
                        }
                        Integer a = (Integer)good.get(key);
                        Integer b = (Integer)test.get(key);
                        if (a == null) {
                            this.assertNull(b);
                            break;
                        }
                        if (b == null) break;
                        this.assertEquals(a, b);
                        break;
                    }
                    case 2: {
                        if (log) {
                            System.out.println(i + " remove " + key);
                        }
                        good.remove(key);
                        test.remove(key);
                    }
                }
                if (log) {
                    System.out.println(" -> " + TestCacheLIRS.toString(test));
                }
                ++i;
            }
            this.verify(test, null);
            ++j;
        }
    }

    private static <K, V> String toString(CacheLIRS<K, V> cache) {
        StringBuilder buff = new StringBuilder();
        buff.append("mem: " + cache.getUsedMemory());
        buff.append(" stack:");
        for (K k : cache.keys(false, false)) {
            buff.append(' ').append(k);
        }
        buff.append(" cold:");
        for (K k : cache.keys(true, false)) {
            buff.append(' ').append(k);
        }
        buff.append(" non-resident:");
        for (K k : cache.keys(true, true)) {
            buff.append(' ').append(k);
        }
        return buff.toString();
    }

    private <K, V> void verify(CacheLIRS<K, V> cache, String expected) {
        if (expected != null) {
            String got = TestCacheLIRS.toString(cache);
            this.assertEquals(expected, got);
        }
        int mem = 0;
        for (K k : cache.keySet()) {
            mem += cache.getMemory(k);
        }
        this.assertEquals((long)mem, cache.getUsedMemory());
        List<K> stack = cache.keys(false, false);
        List<K> cold = cache.keys(true, false);
        List<K> nonResident = cache.keys(true, true);
        this.assertEquals(nonResident.size(), cache.sizeNonResident());
        HashSet<K> hot = new HashSet<K>(stack);
        hot.removeAll(cold);
        hot.removeAll(nonResident);
        this.assertEquals(hot.size(), cache.sizeHot());
        this.assertEquals(hot.size() + cold.size(), cache.size());
        if (stack.size() > 0) {
            K lastStack = stack.get(stack.size() - 1);
            this.assertTrue(hot.contains(lastStack));
        }
    }

    private static <K, V> CacheLIRS<K, V> createCache(int maxSize) {
        return new CacheLIRS(maxSize, 1, 0);
    }
}

