/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.WriteBuffer;
import org.h2.test.TestBase;

public class TestDataUtils
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testParse();
        TestDataUtils.testWriteBuffer();
        this.testEncodeLength();
        this.testFletcher();
        this.testMap();
        this.testMapRandomized();
        this.testMaxShortVarIntVarLong();
        this.testVarIntVarLong();
        this.testCheckValue();
        this.testPagePos();
    }

    private static void testWriteBuffer() {
        WriteBuffer buff = new WriteBuffer();
        buff.put(new byte[1500000]);
        buff.put(new byte[1900000]);
    }

    private void testFletcher() {
        byte[] data = new byte[10000];
        int i = 0;
        while (i < 10000) {
            this.assertEquals(-1, DataUtils.getFletcher32(data, 0, i));
            i += 1000;
        }
        Arrays.fill(data, (byte)-1);
        i = 0;
        while (i < 10000) {
            this.assertEquals(-1, DataUtils.getFletcher32(data, 0, i));
            i += 1000;
        }
        i = 0;
        while (i < 1000) {
            int j = 0;
            while (j < 255) {
                Arrays.fill(data, 0, i, (byte)j);
                data[i] = 0;
                int a = DataUtils.getFletcher32(data, 0, i);
                if (i % 2 == 1) {
                    int b = DataUtils.getFletcher32(data, 0, i + 1);
                    this.assertEquals(a, b);
                }
                data[i] = 10;
                int c = DataUtils.getFletcher32(data, 0, i);
                this.assertEquals(a, c);
                ++j;
            }
            ++i;
        }
        long last = 0L;
        int i2 = 1;
        while (i2 < 255) {
            Arrays.fill(data, (byte)i2);
            int j = 0;
            while (j < 10) {
                int x = DataUtils.getFletcher32(data, 0, j);
                this.assertTrue((long)x != last);
                last = x;
                j += 2;
            }
            ++i2;
        }
        Arrays.fill(data, (byte)10);
        this.assertEquals(0x1E1E1414, DataUtils.getFletcher32(data, 0, 10000));
        this.assertEquals(507488237, DataUtils.getFletcher32("Fletcher32".getBytes(), 0, 10));
        this.assertEquals(507488237, DataUtils.getFletcher32("XFletcher32".getBytes(), 1, 10));
    }

    private void testMap() {
        StringBuilder buff = new StringBuilder();
        DataUtils.appendMap(buff, "", "");
        DataUtils.appendMap(buff, "a", "1");
        DataUtils.appendMap(buff, "b", ",");
        DataUtils.appendMap(buff, "c", "1,2");
        DataUtils.appendMap(buff, "d", "\"test\"");
        DataUtils.appendMap(buff, "e", "}");
        DataUtils.appendMap(buff, "name", "1:1\",");
        String encoded = buff.toString();
        this.assertEquals(":,a:1,b:\",\",c:\"1,2\",d:\"\\\"test\\\"\",e:},name:\"1:1\\\",\"", encoded);
        HashMap<String, String> m = DataUtils.parseMap(encoded);
        this.assertEquals(7, m.size());
        this.assertEquals("", m.get(""));
        this.assertEquals("1", m.get("a"));
        this.assertEquals(",", m.get("b"));
        this.assertEquals("1,2", m.get("c"));
        this.assertEquals("\"test\"", m.get("d"));
        this.assertEquals("}", m.get("e"));
        this.assertEquals("1:1\",", m.get("name"));
        this.assertEquals("1:1\",", DataUtils.getMapName(encoded));
        buff.setLength(0);
        DataUtils.appendMap(buff, "1", "1");
        DataUtils.appendMap(buff, "name", "2");
        DataUtils.appendMap(buff, "3", "3");
        encoded = buff.toString();
        this.assertEquals("2", DataUtils.parseMap(encoded).get("name"));
        this.assertEquals("2", DataUtils.getMapName(encoded));
        buff.setLength(0);
        DataUtils.appendMap(buff, "name", "xx");
        encoded = buff.toString();
        this.assertEquals("xx", DataUtils.parseMap(encoded).get("name"));
        this.assertEquals("xx", DataUtils.getMapName(encoded));
    }

    private void testMapRandomized() {
        Random r = new Random(1L);
        String chars = "a_1,\\\":";
        int i = 0;
        while (i < 1000) {
            StringBuilder buff = new StringBuilder();
            int j = 0;
            while (j < 20) {
                buff.append(chars.charAt(r.nextInt(chars.length())));
                ++j;
            }
            try {
                HashMap<String, String> map = DataUtils.parseMap(buff.toString());
                this.assertNotNull(map);
            }
            catch (MVStoreException mVStoreException) {
                // empty catch block
            }
            ++i;
        }
    }

    private void testMaxShortVarIntVarLong() {
        ByteBuffer buff = ByteBuffer.allocate(100);
        DataUtils.writeVarInt(buff, 0x1FFFFF);
        this.assertEquals(3, buff.position());
        buff.rewind();
        DataUtils.writeVarInt(buff, 0x200000);
        this.assertEquals(4, buff.position());
        buff.rewind();
        DataUtils.writeVarLong(buff, 0x1FFFFFFFFFFFFL);
        this.assertEquals(7, buff.position());
        buff.rewind();
        DataUtils.writeVarLong(buff, 0x2000000000000L);
        this.assertEquals(8, buff.position());
        buff.rewind();
    }

    private void testVarIntVarLong() {
        ByteBuffer buff = ByteBuffer.allocate(100);
        long x = 0L;
        while (x < 1000L) {
            this.testVarIntVarLong(buff, x);
            this.testVarIntVarLong(buff, -x);
            ++x;
        }
        x = Long.MIN_VALUE;
        long i = 0L;
        while (i < 1000L) {
            this.testVarIntVarLong(buff, x);
            ++x;
            ++i;
        }
        x = Long.MAX_VALUE;
        i = 0L;
        while (i < 1000L) {
            this.testVarIntVarLong(buff, x);
            --x;
            ++i;
        }
        int shift = 0;
        while (shift < 64) {
            long x2 = 250L;
            while (x2 < 260L) {
                this.testVarIntVarLong(buff, x2 << shift);
                this.testVarIntVarLong(buff, -(x2 << shift));
                ++x2;
            }
            ++shift;
        }
        int i2 = 0;
        while (i2 < 50) {
            buff.put((byte)-1);
            ++i2;
        }
        buff.flip();
        this.assertEquals(-1, DataUtils.readVarInt(buff));
        this.assertEquals(5, buff.position());
        buff.rewind();
        this.assertEquals(-1L, DataUtils.readVarLong(buff));
        this.assertEquals(10, buff.position());
        buff.clear();
        this.testVarIntVarLong(buff, 0x1FFFFFL);
        this.testVarIntVarLong(buff, 0x200000L);
        this.testVarIntVarLong(buff, 0x1FFFFFFFFFFFFL);
        this.testVarIntVarLong(buff, 0x2000000000000L);
    }

    private void testVarIntVarLong(ByteBuffer buff, long x) {
        byte[] data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataUtils.writeVarLong(out, x);
            data = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataUtils.writeVarLong(buff, x);
        int len = buff.position();
        this.assertEquals(data.length, len);
        byte[] data2 = new byte[len];
        buff.position(0);
        buff.get(data2);
        this.assertEquals(data2, data);
        buff.flip();
        long y = DataUtils.readVarLong(buff);
        this.assertEquals(y, x);
        this.assertEquals(len, buff.position());
        this.assertEquals(len, DataUtils.getVarLongLen(x));
        buff.clear();
        int intX = (int)x;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataUtils.writeVarInt(out, intX);
            data = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DataUtils.writeVarInt(buff, intX);
        len = buff.position();
        this.assertEquals(data.length, len);
        data2 = new byte[len];
        buff.position(0);
        buff.get(data2);
        this.assertEquals(data2, data);
        buff.flip();
        int intY = DataUtils.readVarInt(buff);
        this.assertEquals(intY, intX);
        this.assertEquals(len, buff.position());
        this.assertEquals(len, DataUtils.getVarIntLen(intX));
        buff.clear();
    }

    private void testCheckValue() {
        this.assertEquals(0, DataUtils.getCheckValue(0));
        this.assertEquals(0, DataUtils.getCheckValue(-1));
        this.assertEquals(-1, DataUtils.getCheckValue(65535));
        this.assertEquals(-1, DataUtils.getCheckValue(-65536));
        this.assertEquals(Short.MIN_VALUE, DataUtils.getCheckValue(32768));
        this.assertEquals(Short.MIN_VALUE, DataUtils.getCheckValue(Integer.MIN_VALUE));
    }

    private void testParse() {
        long i = -1L;
        while (i != 0L) {
            String x = Long.toHexString(i);
            this.assertEquals(i, DataUtils.parseHexLong(x));
            x = Long.toHexString(-i);
            this.assertEquals(-i, DataUtils.parseHexLong(x));
            int j = (int)i;
            x = Integer.toHexString(j);
            this.assertEquals(j, DataUtils.parseHexInt(x));
            j = (int)(-i);
            x = Integer.toHexString(j);
            this.assertEquals(j, DataUtils.parseHexInt(x));
            i >>>= 1;
        }
    }

    private void testPagePos() {
        this.assertEquals(0, 0);
        this.assertEquals(1, 1);
        long max = DataUtils.composePagePos(0x3FFFFFF, Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        String hex = Long.toHexString(max);
        this.assertEquals(max, DataUtils.parseHexLong(hex));
        this.assertEquals(0x3FFFFFF, DataUtils.getPageChunkId(max));
        this.assertEquals(Integer.MAX_VALUE, DataUtils.getPageOffset(max));
        this.assertEquals(0x200000, DataUtils.getPageMaxLength(max));
        this.assertEquals(1, DataUtils.getPageType(max));
        long overflow = DataUtils.composePagePos(0x4000000, Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
        this.assertTrue(0x4000000 != DataUtils.getPageChunkId(overflow));
        int i = 0;
        while (i < 0x3FFFFFF) {
            long pos = DataUtils.composePagePos(i, 3, 128, 1);
            this.assertEquals(i, DataUtils.getPageChunkId(pos));
            this.assertEquals(3, DataUtils.getPageOffset(pos));
            this.assertEquals(128, DataUtils.getPageMaxLength(pos));
            this.assertEquals(1, DataUtils.getPageType(pos));
            ++i;
        }
        int type = 0;
        while (type <= 1) {
            int chunkId = 0;
            while (chunkId < 0x3FFFFFF) {
                long offset = 0L;
                while (offset < Integer.MAX_VALUE) {
                    int length = 0;
                    while (length < 2000000) {
                        long pos = DataUtils.composePagePos(chunkId, (int)offset, length, type);
                        this.assertEquals(chunkId, DataUtils.getPageChunkId(pos));
                        this.assertEquals(offset, (long)DataUtils.getPageOffset(pos));
                        this.assertTrue(DataUtils.getPageMaxLength(pos) >= length);
                        this.assertTrue(DataUtils.getPageType(pos) == type);
                        length += 200000;
                    }
                    offset += 21474836L;
                }
                chunkId += 671088;
            }
            ++type;
        }
    }

    private void testEncodeLength() {
        int code;
        int lastCode = 0;
        this.assertEquals(0, DataUtils.encodeLength(32));
        this.assertEquals(1, DataUtils.encodeLength(33));
        this.assertEquals(1, DataUtils.encodeLength(48));
        this.assertEquals(2, DataUtils.encodeLength(49));
        this.assertEquals(2, DataUtils.encodeLength(64));
        this.assertEquals(3, DataUtils.encodeLength(65));
        this.assertEquals(30, DataUtils.encodeLength(0x100000));
        this.assertEquals(31, DataUtils.encodeLength(0x100001));
        this.assertEquals(31, DataUtils.encodeLength(Integer.MAX_VALUE));
        int[] maxLengthForIndex = new int[]{32, 48, 64, 96, 128, 192, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096, 6144, 8192, 12288, 16384, 24576, 32768, 49152, 65536, 98304, 131072, 196608, 262144, 393216, 524288, 786432, 0x100000};
        int i = 0;
        while (i < maxLengthForIndex.length) {
            this.assertEquals(i, DataUtils.encodeLength(maxLengthForIndex[i]));
            this.assertEquals(i + 1, DataUtils.encodeLength(maxLengthForIndex[i] + 1));
            ++i;
        }
        i = 0x100001;
        while (i < 0x6400000) {
            code = DataUtils.encodeLength(i);
            this.assertEquals(31, code);
            i += 1024;
        }
        i = 0;
        while (i < 0x200000) {
            int max;
            code = DataUtils.encodeLength(i);
            this.assertTrue(code <= 31 && code >= 0);
            this.assertTrue(code >= lastCode);
            if (code > lastCode) {
                lastCode = code;
            }
            this.assertTrue((max = DataUtils.getPageMaxLength(code << 1)) >= i && max >= 32);
            ++i;
        }
    }
}

